C +++
C
C Source: src/source/id/rw_undul.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: rw_undul.F
C Revision 1.7  1992/12/22  20:21:52  cwelnak
C D to C. 6000 trying to read lines commented
C with D.
C
C Revision 1.6  1992/02/12  13:44:34  cwelnak
C loop unrolling for undulator (sun)
C
C Revision 1.5  92/01/21  17:25:23  cwelnak
C 6000 changes
C 
C Revision 1.4  91/07/06  20:03:58  khan
C Grenoble and after. Minor changes
C 
C Revision 1.3  90/10/30  00:01:41  khan
C Fix Ultrix -> VMS things that got screwed up in VMS -> Ultrix.
C 
C Revision 1.2  90/07/17  23:04:53  khan
C Fixed STATUS=NEW in OPEN statements to UNKNOWN for Unix.
C Substitue pre_rad.blk for PRE_RAD.BLK
C 
C Revision 1.1  90/07/17  15:36:36  khan
C Initial revision
C 
C 
C ---

C+++
C
C	SUBROUTINE 		RW_UNDUL
C
C	PURPOSE			Specifies format to write output files for 
C				source generation using SHADOW.
C
C	INPUT			none
C
C	OUTPUT			A file containing CDF's and POLARIZATION
C				or RN's
C---

	SUBROUTINE RW_UNDUL ( NP,NT,NE, UPHI, UTHETA, UENER,
     $       ZERO, ONE, TWO, POL_DEG,
     $       FNAME, ITYPE, IANGLE)

	IMPLICIT REAL*8		(A-H,O-Z)
	DIMENSION		ZERO(31,31,51),ONE(31,51),TWO(51)
	DIMENSION		POL_DEG(31,31,51)
	DIMENSION		UPHI(31,31,51),UTHETA(31,51),UENER(51)
	CHARACTER*80		FNAME

#if vms
	   OPEN (31,FILE=FNAME,STATUS='NEW', FORM='UNFORMATTED')
#else
	   OPEN (31,FILE=FNAME,STATUS='UNKNOWN', FORM='UNFORMATTED')
	   REWIND (31)
#endif
C		IF (ITYPE.EQ.2) THEN		!cartesian for SHADOW
	   	  WRITE(31) NE,NT,NP,IANGLE

		  DO 15 K = 1,NE
15	   	     WRITE(31) UENER(K)
		  DO 25 K = 1,NE
		     DO 25 J = 1,NT
25	   	        WRITE(31) UTHETA(J,K)
		  DO 35 K = 1, NE
		     DO 35 J = 1,NT
			DO 35 I = 1,NP
35	   	           WRITE(31) UPHI(I,J,K)

		  DO 45 K = 1,NE
45	   	     WRITE(31) TWO(K)
		  DO 55 K = 1,NE
		     DO 55 J = 1,NT
55	   	        WRITE(31) ONE(J,K)
		  DO 65 K = 1,NE
		     DO 65 J = 1,NT
			DO 65 I = 1,NP
65	   	           WRITE(31) ZERO(I,J,K)

		  DO 75 K = 1,NE
		     DO 75 J = 1,NT
			DO 75 I = 1,NP
75	   	           WRITE(31) POL_DEG(I,J,K)

C	   	  WRITE(31) (UENER(K), K = 1,NE)
C	   	  WRITE(31) ((UTHETA(J,K), J = 1,NT), K = 1,NE)
C	   	  WRITE(31) (((UPHI(I,J,K), I = 1,NP), 
C     $			J = 1,NT), K = 1,NE)
C
C	   	  WRITE(31) (TWO(K), K = 1,NE)
C	   	  WRITE(31) ((ONE(J,K), J = 1,NT), K = 1,NE)
C	   	  WRITE(31) (((ZERO(I,J,K), I = 1,NP), 
C     $			J = 1,NT), K = 1,NE)
C
C	   	  WRITE(31) (((POL_DEG(I,J,K), I = 1,NP),
C     $			 J = 1,NT), K = 1,NE)

C		ELSE IF (ITYPE.EQ.1) THEN
C		    DO KC = 1,NE
C			WRITE (40,*) UENER(KC),TWO(KC)
C		    END DO
C	   	  WRITE(31) ZERO
C	   	  WRITE(31) ONE
C	   	  WRITE(31) TWO
C		END IF
	   CLOSE(31)

	RETURN
	END
