C +++
C
C Source: src/source/id/report.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: report.F
C Revision 1.4  1991/07/06  20:03:58  khan
C Grenoble and after. Minor changes
C
C Revision 1.3  90/10/30  00:01:39  khan
C Fix Ultrix -> VMS things that got screwed up in VMS -> Ultrix.
C 
C Revision 1.2  90/07/17  23:10:22  khan
C Use preprocessor directives to avoid using CPUTIM for Unix. Someday
C I'll write one just like the VMS one. 
C 
C Revision 1.1  90/07/17  15:36:35  khan
C Initial revision
C 
C 
C ---

C+++
C	SUBROUTINE	REPORT
C
C	PURPOSE		To update the screen with progress reports
C
C---
     	SUBROUTINE	REPORT 	(E,T,P,TT,PERC,IVAL)
     	IMPLICIT	REAL*8	(A-H,O-Z)
     	IF (IVAL.LT.0) THEN
C
#ifdef vms
     	  CALL LIB$ERASE_PAGE (1,1)
#elif defined(unix) || defined(__CYGWIN32__)
	  CALL SYSTEM ('clear')
#else
C # error report.F: Define system("clear") for this system
#endif
C
     	  WRITE (6,1010) 'Phi / Horz: ', 'Theta / Vert : ', 
     $'Energy: ','CPU Time: ','% Completed: '
     	ELSE
#ifdef vms
     	  CALL LIB$SET_CURSOR (2,1)
#endif
     	  WRITE (6,1000)	P, T, E, TT, PERC
     	END IF
1000	FORMAT	(1X,G10.3,T15,G10.3,T30,G10.3,T45,G10.3,T60,F9.2)
1010	FORMAT	(1X,A    ,T15,A    ,T30,A    ,T45,A    ,T60,A)
     	RETURN
     	END
