C +++
C
C Source: src/source/id/epath.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: epath.F
C Revision 1.6  1991/07/06  20:03:47  khan
C Elliptical Undulator by Sylvia Difonzo
C
C Revision 1.6  91/06/18  12:20:15  di fonzo - singh 
C Added option for elliptical wiggler
C
C Revision 1.5  91/03/25  13:41:01  khan
C DO WHILE to GOTO's
C 
C Revision 1.4  90/10/30  00:01:12  khan
C Fix Ultrix -> VMS things that got screwed up in VMS -> Ultrix.
C 
C Revision 1.3  90/07/18  19:39:47  khan
C Using Unix environment variable SHADOW_ENV_FILE and others to communicate
C with the shell script. 
C 
C Revision 1.2  90/07/17  23:06:18  khan
C Fix File OPEN STATUS=UNKNWON.
C VMS version Uses LOGICALS to communicate with the driver script. I'm
C using EXIT codes to do the same. Not as nice, but works as well. The
C script, of course, has to know the particular exit codes returned.
C 
C Revision 1.1  90/07/17  15:39:25  khan
C Initial revision
C 
C 
C ---

C+++
C	PROGRAM		EPATH
C
C	PURPOSE		To compute the trajectory of an electron through
C			a wiggler/undulator. Uses only one period.
C
C	ALGORITHM	Uses Simpson rule as implementesd in QSF
C
C	COMMENTS	Notice that z is along the axis of the undulator,
C			y is vertical.
C
C	CREATION DATE	7/87
C
C--
	PROGRAM		EPATH
	IMPLICIT REAL*8	(A-H,O-Z)
	CHARACTER *80 	RSTRING,OUTFILE,UNOUTFILE,PARFILE,TRAJFILE
     	CHARACTER *80	UNEXAM
	DIMENSION 	XOFZ(1001),Z(1001),TOFZ(1001),YOFZ(1001)
	DIMENSION 	BETAX(1001), BETAZ(1001),BETAY(1001)
	DIMENSION	YX(1001),YT(1001),CURV(1001),YY(1001)
C	DIMENSION	TZ(1001),TBETAX(1001),TBETAZ(1001)
C	DIMENSION	TYT(1001),TTOFZ(1001)
	DIMENSION	EXOFZ(1001),EZ(1001),ETOFZ(1001)
	DIMENSION	EBETAX(1001),EBETAZ(1001)
        DIMENSION       VEL(3),ACC(3)
        DIMENSION       B(3),EN(3),T(3)
        DIMENSION       TAUX(1001),TAUY(1001),TAUZ(1001)
        DIMENSION       ENX(1001),ENY(1001),ENZ(1001)
        DIMENSION       BX(1001),BY(1001),BZ(1001)
C
C     	
     	DATA	PI     	/  3.1415 92653 58979 32384 62643 D0 /
     	DATA	PIHALF 	/  1.5707 96326 79489 66192 31322 D0 /
     	DATA	TWOPI 	/  6.2831 85307 17958 64769 25287 D0 /
     	DATA	TODEG 	/ 57.2957 79513 08232 08767 98155 D0 /
     	DATA	TORAD	/  0.0174 53292 51994 32957 69237 D0 /
	DATA	TOCM	/  1.239 852	D-4		     /
	DATA	TOANGS 	/  1.239 852    D+4		     /
C
C For unix, we cannot set symbol for the parent process to communicate
C as in VMS, so we pull the classic BSD kludge of writing the environment
C strings to a temporary file and then source'ing the file in the driver
C to script to export to the parent environment. The temporary file is
C given by SHADOW_ENV_FILE environment variable, and must be set before
C this program is called. This is usually set in the driver script that
C calls this program.
C
#ifndef vms
	CHARACTER*133	ENV_FILE
#endif
C
	c  = 2.998D8		!speed of light, m/s
	rm = 9.109D-31		!electron rest mass  kg
	e  = 1.602D-19		!electron charge, C
	h  = 6.626D-34		!Planck's constant   joules*sec
	c2 = e/(TWOPI*rm*c)	!unit(coul*sec/(kg*m))
c
c	Specify Undulator
c
#ifdef vms
     	call lib$erase_page(1,1)
#elif defined(unix) || defined(__CYGWIN32__)
     	call system ("clear")
#else
C # warning epath.F: Needs system("clear") function
#endif
     	WRITE(6,*) ' '
     	WRITE(6,*) '-------------------------------------------',
     $'---------------------------'
     	WRITE(6,*) ' '
     	WRITE(6,*) 'Type of Insertion Device.'
     	WRITE(6,*) 'Enter: '
     	WRITE(6,*) 'for wiggler   (large K)      [ 1 ]'
     	WRITE(6,*) 'for undulator (small K)      [ 2 ]'
     	I_DEVICE = IRINT ('Then ? ')
C
C Set the symbol DEVICE for communicating to the command procedure.
C	
#ifdef vms
	IF (I_DEVICE.EQ.1) THEN
	  IRET	= LIB$SET_SYMBOL	('DEVICE','WIGGLER')
	ELSE IF (I_DEVICE.EQ.2) THEN
	  IRET	= LIB$SET_SYMBOL	('DEVICE','UNDULATOR')
	END IF
#else
C
C Write the environment strings to a file, so the driver script can source
C it. If tset can use this kludge, so can I.
C                **GROSS HACK ALERT**
C
	CALL	GETENV ('SHADOW_ENV_FILE', ENV_FILE)
	IF (ENV_FILE(1:10).EQ.'          ') THEN
	    WRITE (*,*) 
     $     'Must set SHADOW_ENV_FILE environment string'
	    CALL EXIT (1)
	ENDIF
	OPEN (11, FILE=ENV_FILE, STATUS='UNKNOWN')
	REWIND (11)
#if !defined(_WIN32)
	call chmod (ENV_FILE, '666')
#endif
	IF (I_DEVICE.EQ.1) THEN
	  WRITE (11,*) 'setenv SHADOW_ID_DEV  WIGGLER'
	ELSE IF (I_DEVICE.EQ.2) THEN
	  WRITE (11,*) 'setenv SHADOW_ID_DEV  UNDULATOR'
	ELSE
	  WRITE (*,*) 'Illegal device chosen: ', I_DEVICE
	  CALL EXIT (I_DEVICE)
	END IF
	CLOSE (11)
#endif
C
     	WRITE(6,*) ' '
     	WRITE(6,*) '-------------------------------------------',
     $'---------------------------'
     	WRITE(6,*) ' '
     	WRITE(6,*) ' '
     	WRITE(6,*) 'Define Insertion Device parameters:'
     	WRITE(6,*) ' '
     	if (i_device.eq.1) then
	  n0  	=  irint  ('Enter number of periods : ')
C
C       (I_WIG.EQ.1) implies normal wiggler
C       (I_WIG.EQ.2) implies elliptical wiggler
C
	WRITE(6,*) ' '
	WRITE(6,*) 'Type of Wiggler.'
	WRITE(6,*) 'Enter: '
	WRITE(6,*) 'for normal wiggler     [1]'
	WRITE(6,*) 'for elliptical wiggler [2]'
        I_WIG = IRINT ('Then ? ')
	end if
	rlau = rnumber('      wavelength of insertion device (m) : ')
       if (i_wig.eq.2) then
	RK   	=  rnumber
     $('   deflection parameter KY for the vertical field conponent: ')
	RKX     =  rnumber
     $('   deflection parameter KX for the horizontal field ' //
     $'conponent: ')
       else
	RK   	=  rnumber('      deflection parameter K : ')
       end if
	ener   	=  rnumber('      electron energy (GeV) : ')
	WRITE(6,*) '      Enter the number of points to be used in',
     $ ' the trajectory calculation.'
	np   	=  irint  ('      ( max = 1001, suggested 101 ) : ')
	Rb0	=  rnumber('End correction field factor (0-1) : ')
c	Electron Trajectory Parameters
c
     	WRITE(6,*) ' '
     	WRITE(6,*) '-------------------------------------------',
     $'---------------------------'
     	WRITE(6,*) ' '
	WRITE(6,*) 'Two files will be created. One will contain a ',
     $' record of the parameters used in the calculation, the other',
     $' the trajectory itself. The names of the files can be specified',
     $' by the user, e.g., MYFILE.PAR and MYFILE.TRJ.'
     	WRITE(6,*) ' '
     	WRITE(6,*) 'Output files specification:'
     	WRITE(6,*) ' '
     	parfile	  = rstring('      Name for parameter file: ')
     	if (i_device.eq.1) then
	TRAJFILE  = RSTRING('      Name for WIGGLER trajectory file: ')
     	else
	  unoutfile = rstring
     $	   	   ('      Name for UNDULATOR trajectory file: ')
	  nfile     = 
     $ IYES('      Do you want a plottable file [ Y/N ] ? ')
     	 if (nfile.eq.1) unexam = rstring 
     $ ('      Name for plottable file: ')
	END IF
     	WRITE(6,*) ' '
     	WRITE(6,*) '-------------------------------------------',
     $'---------------------------'
     	WRITE(6,*) ' '
c
c
c	Compute General Parameters
c
c	n0	number of periods
c	rlau	wavelength of undulator	(m)
c	energy1 fundamental energy (joule)
c	rla1	fundamental wavelength (m)
c	rk	deflection parameter
c	rkx     deflection parameter in the x direction (i_wig.eq.2)
c	rlen    length of undulator along z (m)
c	ener	electron energy (joule)	
c	b0	peak magnetic field (Tesla)
c       b0x     trasverse peak magnetic field (Tesla)(i_wig.eq.2)
c
c	in the following we will be using the PEAK value of B0 explicitely.
c
     	OLDENER = ENER			!GeV
	ENER    = E*ENER*1.0D9		!CHANGE UNITS (TO JOULE)
	GA0     = ENER/RM/C**2		!Gamma_0, in electron rest mass
     					!energy (mc^2) units,
     					!adimensional
	RLEN   = N0*RLAU
	BETA02 = 1.0D0 - (RM*C**2/ENER)**2
	BETA0  = SQRT(BETA02)
	B0     = RK*(TWOPI*RM*C*BETA0)/E/RLAU
       if (i_wig.eq.2) then
        B0X    = RKX*(TWOPI*RM*C*BETA0)/E/RLAU
       end if
C	RK     = E/(TWOPI*RM*C*BETA0)*B0*RLAU !As defined by S.Krinsky; reduces
C					      !to simpler form when v ~ c
	RLA1   = RLAU/(2*GA0**2)*(1.D0 +(RK**2)/2)
	ENERGY1= H*C/RLA1		!units (joules)
	emc = e/(ga0*rm*c)		!units ( coul*sec/(kg*m) )
	betaxmax  = -emc*b0*rlau/twopi	!constant used in external function
	betaymax  = -emc*b0x*rlau/twopi	!constant used in external function
	U_KVEC  = twopi/rlau		!   "			"
	RLEN_PI  = pi*rlen/rlau		!   "			"
	betax0 = 0.0d0 
       if (i_wig.eq.2) then
        betay0 = 0.0d0
       end if
	betaz0 = sqrt (beta02)
C
C np must be an odd number for Simpson rule.
C
	i 	= np/2
	np 	= i*2 + 1
C
C Write out parameter file
C
#ifdef vms
     	OPEN	(20, FILE=PARFILE, STATUS='NEW',CARRIAGECONTROL='LIST')
#else
     	OPEN	(20, FILE=PARFILE, STATUS='UNKNOWN')
	REWIND  (20)
#endif
     	 WRITE (20,*) 'Parameters used for run creating'
     	IF (I_DEVICE.EQ.1) THEN
     	 WRITE (20,*) 'WIGGLER case. Trajectory stored in:'
     	 WRITE (20,*) TRAJFILE
     	 WRITE (20,*) 'Number of periods               = ',N0
     	ELSE
     	 WRITE (20,*) 'UNDULATOR case. Trajectory stored in:'
     	 WRITE (20,*) UNOUTFILE
     	 if (nfile.eq.1) then
     	 WRITE (20,*) 'and in (formatted file): '
     	 WRITE (20,*) UNEXAM
     	 end if
     	 WRITE (20,*) 'The UNDULATOR case uses 1 period only.'
     	END IF
     	 WRITE (20,*) '------   INPUT    ---------'
     	 WRITE (20,*) 'Insertion device  Wavel.  [ m ] = ',RLAU
     	 WRITE (20,*) 'Beam Energy             [ GeV ] = ',OLDENER
     	 WRITE (20,*) 'K                               = ',RK
        IF (I_WIG.EQ.2) THEN
         WRITE (20,*) 'KX                              = ',RKX
        END IF
	 WRITE (20,*) 'Field correction factor         = ',rb0
     	 WRITE (20,*) '------   OUTPUT    ---------'
     	 WRITE (20,*) 'Gamma                           = ',GA0
        IF (I_WIG.EQ.2) THEN
     	 WRITE (20,*) 'Vertical Peak Magnetic field   [ Tesla ] = ',B0
         WRITE (20,*) 'Horizontal Peak Magnetic Field [ Tesla ] = ',B0X
        ELSE 
     	 WRITE (20,*) 'Peak Magnetic field   [ Tesla ] = ',B0
        END IF
     	 WRITE (20,*) 'Fundamental              [ Ev ] = ',ENERGY1/E
     	 WRITE (20,*) 'Fundamental       [ Angstroms ] = ',RLA1*1.0d10
     	 XTEMP	=  186.0D0/(10.D0*B0*OLDENER**2)
     	 WRITE (20,*) 'Equivalent SR C.W.     [ Angs ] = ',XTEMP
     	 WRITE (20,*) '              C.E.       [ eV ] = ',TOANGS/XTEMP
     	CLOSE (20)
C
C	Calculate x, y, t as functions of z
C       Initial values of parameters for both wiggler cases.
C
		if (i_device.eq.1) then			!Wiggler
C
      	Z(1)	 = 0.0D0
       if (i_wig.eq.2) then                  !Elliptical Wiggler
        BETAX(1) = BETAX0
        BETAY(1) = BETAYMAX
        BETAZ(1) = SQRT(BETA0**2-BETAX(1)**2-BETAY(1)**2)
        XOFZ(1)  =0.0D0
        YOFZ(1)  =0.0D0
        TOFZ(1)  =0.0D0
        YX(1)    = BETAX(1)/BETAZ(1)
        YY(1)    = BETAY(1)/BETAZ(1)
        YT(1)    = 1/BETAZ(1)
        DXDZ     = BETAX(1)/BETAZ(1)
        DYDZ     = BETAY(1)/BETAZ(1)
        D2XDZ2   = BETAZ(1)**4
        D2DXD2DY = (BETAZ(1)*BETAY(1))**2
        DNUM     = SQRT(D2XDZ2+D2DXD2DY)*EMC*B0/(BETAZ(1)**3)
        CURV(1)  = DNUM/(1.0D0+DXDZ**2+DYDZ**2)**1.5D0
	VEL(1)   = DXDZ
	VEL(2)   = DYDZ
	VEL(3)   = 1.0D0
	CALL NORM (VEL,T)
	TAUX(1)  = T(1)
	TAUY(1)  = T(2)
	TAUZ(1)  = T(3)
	ACC(1)   = -EMC*B0*BETAZ(1)
	ACC(2)   = 0.0D0 
	ACC(3)   = 0.0D0
	CALL CROSS (VEL,ACC,B)
	CALL NORM (B,B)
	BX(1)    = B(1)
	BY(1)    = B(2)
	BZ(1)    = B(3)
	CALL CROSS (B,T,EN)
	ENX(1)    = EN(1)
	ENY(1)    = EN(2)
	ENZ(1)    = EN(3)
       ELSE                    !Normal Wiggler
C        BETAX(1) = 0.0D0
        BETAX(1) = BETAX0
	BETAZ(1) = SQRT(BETA0**2-BETAX(1)**2)
     	XOFZ(1)  = 0.0D0
     	TOFZ(1)  = 0.0D0
	YX(1)	 = BETAX(1)/BETAZ(1)
	YT(1)	 = 1/BETAZ(1)
	DXDZ     = BETAX(1)/BETAZ(1)
	D2XDZ2   = BETA0**2/(BETAZ(1)**3)*EMC*B0
	CURV(1)  = D2XDZ2/(1.0D0+DXDZ**2)**1.5D0
       END IF
C
C  Loop generates trajectory from Z=0 to rlau.
C  The base vectors T, B, and N of the edges of a trihedron
C  moving along the trajectory define the coordinate system for
C  the cross field wiggler.
C
    	ZSTEP = RLAU/(NP-1)
	WRITE(6,*) ' '
     	WRITE(6,*) 'Trajectory Calculations begins.'
	WRITE(6,*) ' '
	DO 19 I  = 2,NP
	   Z(I) = Z(1) + (I-1)*ZSTEP
C
C  Calculate betax, betay, betaz as functions of z (here z is the 
C  direction of propagation).
C
          IF (I_WIG.EQ.2)  THEN
           BETAX(I) = BETAXMAX*SIN(U_KVEC*Z(I)) + BETAX0
           BETAY(I) = BETAYMAX*COS(U_KVEC*Z(I)) + BETAY0
           BETAZ(I) = SQRT(BETA0**2-BETAX(I)**2-BETAY(I)**2)
           YX(I)    = BETAX(I)/BETAZ(I)
           YY(I)    = BETAY(I)/BETAZ(I)
           YT(I)    = 1.0D0/BETAZ(I)
           DXDZ     = BETAX(I)/BETAZ(I)
           DYDZ     = BETAY(I)/BETAZ(I)
           D2XDZ2   = (BETAZ(I)*B0*COS(TWOPI*Z(I)/RLAU))**2
           D2YDZ2   = (BETAZ(I)*B0X*SIN(TWOPI*Z(I)/RLAU))**2
           D2DXD2DY = (BETAX(I)*B0X*SIN(TWOPI*Z(I)/RLAU)+BETAY(I)*B0*
     $     COS(TWOPI*Z(I)/RLAU))**2
           DNUM     = SQRT(D2XDZ2+D2YDZ2+D2DXD2DY)/(BETAZ(I)**2)*EMC
           CURV(I)  = DNUM/(1.0D0+DXDZ**2+DYDZ**2)**1.5D0
      	   VEL(1)   = DXDZ
	   VEL(2)   = DYDZ
	   VEL(3)   = 1.0D0
	   CALL NORM (VEL,T)
	   TAUX(I)  = T(1)
	   TAUY(I)  = T(2)
	   TAUZ(I)  = T(3)
	   ACC(1)   = -EMC*B0*BETAZ(I)*COS(TWOPI*Z(I)/RLAU)/BETAZ(I)
	   ACC(2)   = EMC*B0*BETAZ(I)*SIN(TWOPI*Z(I)/RLAU)/BETAZ(I) 
	   ACC(3)   = 0.0D0
	   CALL CROSS (VEL,ACC,B)
	   CALL NORM (B,B)
	   BX(I)    = B(1)
	   BY(I)    = B(2)
	   BZ(I)    = B(3)
	   CALL CROSS (B,T,EN)
	   ENX(I)    = EN(1)
	   ENY(I)    = EN(2)
	   ENZ(I)    = EN(3)
C          TAU=SQRT(TAUX(I)**2+TAUY(I)**2+TAUZ(I)**2)
C           BI=SQRT(BX(I)**2+BY(I)**2+BZ(I)**2)
C          ENNE=SQRT(ENX(I)**2+ENY(I)**2+ENZ(I)**2)
C
          ELSE
	   BETAX(I) = BETAXMAX*SIN(U_KVEC*Z(I)) + BETAX0
	   BETAZ(I) = SQRT(BETA0**2-BETAX(I)**2)
	   YX(I)    = BETAX(I)/BETAZ(I)
	   YT(I)    = 1.0D0/BETAZ(I)
	   DXDZ	    = BETAX(I)/BETAZ(I)
	   D2XDZ2   = BETA0**2/(BETAZ(I)**3)*EMC*B0*COS(TWOPI*Z(I)/RLAU)
	   CURV(I)  = D2XDZ2/(1.0D0+DXDZ**2)**1.5D0
	  ENDIF
19	CONTINUE
C
	IF (I_WIG.EQ.2) THEN 
	   CALL QSF ( ZSTEP,YX,XOFZ,NP)
	   CALL QSF ( ZSTEP,YY,YOFZ,NP)
           CALL QSF ( ZSTEP,YT,TOFZ,NP)
	ELSE
     	   CALL QSF ( ZSTEP,YX,XOFZ,NP)
     	   CALL QSF ( ZSTEP,YT,TOFZ,NP)
	END IF
C
C Write out trajectory file in SHADOW's frame. To transform to SHADOW frame, 
C -X -> X, Y -> Z, Z -> Y. All periods are written out.
C
	WRITE(6,*) ' '
     	WRITE(6,*) 'Calculation Completed. File out results.'     	
	WRITE(6,*) ' '
     	WRITE(6,*) ' '
     	WRITE(6,*) '-------------------------------------------',
     $'---------------------------'
     	WRITE(6,*) ' '
	WRITE(6,*) ' '
     	WRITE(6,*) 'Files:'
	WRITE(6,*) ' '
     	WRITE(6,*) TRAJFILE
#ifdef vms
	   OPEN	(40,FILE=TRAJFILE,STATUS='NEW')
#else
	   OPEN	(40,FILE=TRAJFILE,STATUS='UNKNOWN')
	   REWIND (40)
#endif
	   DO 49 J = 1, N0
	     START_LEN	= ((J-1)-N0*0.5D0)*RLAU
	     DO 59 I = 1, NP-1
          IF (I_WIG.EQ.2) THEN
               WRITE    (40,*)
     $          -XOFZ(I),Z(I)+START_LEN,YOFZ(I),
     $          -BETAX(I),BETAZ(I),BETAY(I),CURV(I)
           ELSE
	       WRITE	(40,*)	
     $		-XOFZ(I),Z(I)+START_LEN,0.0d0,
     $		-BETAX(I),BETAZ(I),0.0d0,CURV(I)
          ENDIF
59	     CONTINUE
49	   CONTINUE
          IF (I_WIG.EQ.2) THEN
               WRITE    (40,*)
     $          -XOFZ(NP),Z(NP)+START_LEN,YOFZ(NP),
     $          -BETAX(NP),BETAZ(NP),BETAY(NP),CURV(NP)
           ELSE
	       WRITE	(40,*)	
     $		-XOFZ(NP),Z(NP)+START_LEN,0.0d0,
     $		-BETAX(NP),BETAZ(NP),0.0d0,CURV(NP)
          ENDIF
	   CLOSE	(40)
	WRITE(6,*) ' '
     	WRITE(6,*) 'Written to disk.'
     	WRITE(6,*) ' '
     	WRITE(6,*) 'All Done. Trajectory computed and stored on Disk.'
     	WRITE(6,*) '-------------------------------------------',
     $'---------------------------'
     	WRITE(6,*) ' '

	STOP
C
		else if (i_device.eq.2) then		!Undulator
C
C	write to file for use in ERAD
C
#ifdef vms
	 OPEN (32,FILE=UNOUTFILE,STATUS='NEW',FORM='UNFORMATTED')
#else
	 OPEN (32,FILE=UNOUTFILE,STATUS='UNKNOWN',FORM='UNFORMATTED')
	 REWIND (32)
#endif
	 WRITE(32) N0,RLAU,ENERGY1
	 WRITE(32) RLA1,RK,GA0,BETA0
	 WRITE(32) BETAX0,BETAY0,BETAZ0
	 WRITE(32) B0,ENER,RLEN,NP,rb0
	 WRITE(32) PHI_E,THE_E
C
C (N-1) periods assume ideal sinusoidal field and trajectory.
C
	c3	= -e/(ga0*rm*c)*rlau/twopi
	Z0	= RLAU/2.0D0
	ZSTEP	= RLAU/(NP-1)
C
	DO 95 I	= 1,NP
	   Z(I)	= (I-1)*ZSTEP

	   BETAX(I) = C3*B0*SIN(U_KVEC*Z(I))
C
	   BETAZ(I) = SQRT(BETA0**2-BETAX(I)**2)
	   YT(I)    = 1/BETAZ(I)
	   YX(I)    = BETAX(I)/BETAZ(I)
95	CONTINUE
C
	CALL QSF (ZSTEP,YX,XOFZ,NP)
	CALL QSF (ZSTEP,YT,TOFZ,NP)

	TAU = (TOFZ(NP) - TOFZ(1))/C
C
C The two ends of the undulator are combined into the remaining (one)
C period, with the length of RLAU (1+sqrt(2)).
C

	c3	= -e/(ga0*rm*c)*rlau/twopi
	ZF      = RLAU/4.0D0
	ZCORR	= SQRT(2.0D0)*RLAU/4.0D0
	EZ0	= ZF + ZCORR
	EZSTEP  = 2*EZ0/(NP-1)
	BF      = -B0/SQRT(2.0D0)
C
	PHIF     = U_KVEC*ZF
C
	DO 29 I  = 1,NP
	   EZ(I)  = -EZ0 + ( I-1 )*EZSTEP
C
C include modifications for fringe field.
C
	   PHI = U_KVEC*EZ(I)
	   IF (ABS(EZ(I)).GT.ZF) THEN
		con = c3*b0/2.0d0
		B1X = C3*BF/SQRT(2.0D0)*
     $			( -COS(SQRT(2.0D0)*(ABS(PHI)-PHIF)) ) + con
		IF (EZ(I).LT.0.0)	B1X = -B1X
		B2X = C3*B0*SIN(U_KVEC*EZ(I))

		IF (ABS(EZ(I)).GT.(2.0D0*ZF)) THEN
		   EBETAX(I)	= RB0*B1X
		ELSE
		   EBETAX(I)	= RB0*B1X + (1.0D0-RB0)*B2X
		ENDIF

	   ELSE
		EBETAX(I) = C3*B0*SIN( U_KVEC*EZ(I) )
	   END IF
C
	   EBETAZ(I) = SQRT(BETA0**2-EBETAX(I)**2)
	   YT(I)    = 1/EBETAZ(I)
	   YX(I)    = EBETAX(I)/EBETAZ(I)
29	CONTINUE
C
     	   CALL QSF ( EZSTEP,YX,EXOFZ,NP)
     	   CALL QSF ( EZSTEP,YT,ETOFZ,NP)
	   
	   ETAU = ( ETOFZ(NP) - ETOFZ(1) )/C
	   NC	= (NP+1)/2.0D0
	   XMAX = EXOFZ(NC)		! maximum fluctuation in X.
C
	WRITE(6,*) ' '
     	WRITE(6,*) 'Calculation Completed. File out results.'     	
	WRITE(6,*) ' '
     	WRITE(6,*) ' '
     	WRITE(6,*) '-------------------------------------------',
     $'---------------------------'
     	WRITE(6,*) ' '
	WRITE(6,*) ' '
     	WRITE(6,*) 'Files:'
	WRITE(6,*) ' '
     	WRITE(6,*) UNOUTFILE
	   WRITE(32) TAU,Z0,ZSTEP
	  DO 69 I = 1, NP
	   WRITE(32) XOFZ(I)+XMAX,0.0d0,Z(I)
	   WRITE(32) BETAX(I),0.0d0,BETAZ(I)
	   WRITE(32) TOFZ(I)/C,1.0D0 -BETAZ(I)
69	  CONTINUE
     	 WRITE(6,*) parfile
	  
	  WRITE(32) ETAU,EZ0,EZSTEP,NC
C
C The first RLAU/2 (approx.) of the undulator:
C
	DO 25 I = 1,NC
	  WRITE(32) EXOFZ(I),0.0D0,EZ(I)	!X,Y,Z
	  WRITE(32) EBETAX(I),0.0D0,EBETAZ(I)	!BETAX,BETAY,BETAZ
	  WRITE(32) ETOFZ(I)/C-0.5D0*ETAU,1.0D0-EBETAZ(I)
25	CONTINUE
C
C The last RLAU/2 (approx.) of the undulator:
C
	DO 35 I = NC,NP
	  WRITE(32) EXOFZ(I),0.0D0,EZ(I)	!X,Y,Z
	  WRITE(32) EBETAX(I),0.0D0,EBETAZ(I)	!BETAX,BETAY,BETAZ
	  WRITE(32) ETOFZ(I)/C-0.D05*ETAU,1.0D0-EBETAZ(I)
35	CONTINUE
C
	  IF (NFILE.EQ.1) THEN
     	 WRITE(6,*) unexam
#ifdef vms
    	    open (33, file=unexam, status='new')
#else
     	    open (33, file=unexam, status='unknown')
	    rewind(33)
#endif
		DO 79 I = 1, NP
     	      TTT = ETOFZ(I)/C
     	      BBB = 1.0D0 - EBETAZ(I)
	      WRITE(33,1010) EXOFZ(I), EBETAX(I), EZ(I), BBB, TTT
79	        CONTINUE
	  END IF
	WRITE(6,*) ' '
     	WRITE(6,*) 'Written to disk.'
     	WRITE(6,*) ' '
     	WRITE(6,*) 'All Done. Trajectory computed and stored on Disk.'
     	WRITE(6,*) '-------------------------------------------',
     $'---------------------------'
     	WRITE(6,*) ' '
     	END IF
	CLOSE(33)
	CLOSE(32)
1000	FORMAT (4(1X,G19.12))
1010	FORMAT (5(1X,G19.12))
1070	FORMAT (7(1X,G19.12))
1090    FORMAT (9(1X,G19.12))
	CALL EXIT (0)
	END
