C +++
C
C Source: src/source/gauss.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: gauss.F
C Revision 1.9  1991/07/06  19:59:53  khan
C Elliptical Undulator by Sylvia Difonzo
C
C Revision 1.8  91/04/05  14:03:27  cwelnak
C changed quotes on #include
C 
C Revision 1.7  91/03/20  16:44:39  cwelnak
C SUN version -- changes INCLUDE to #include
C 
C Revision 1.6  91/03/15  15:36:34  khan
C Getting ready for Sun port...
C 
C Revision 1.5  91/02/21  14:39:56  khan
C Replaced RAN with WRAN (wrapper for RAN that checks for 0.0D0 return)
C 
C Revision 1.4  90/11/09  14:13:22  khan
C Added SAVE statements...
C 
C Revision 1.3  90/07/19  20:52:32  khan
C Put Preprocessor/conditionals to make it work on both VMS and Ultrix.
C 
C Revision 1.2  90/07/14  22:39:12  khan
C All global include files (common.blk, etc) are now in ./../include/ dir.
C 
C Revision 1.1  90/07/10  14:56:09  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE	GAUSS
C
C	PURPOSE		Generate a bivariate normal distribution with
C			indipendent sigmas and a correlation.
C			This will simulate a SR source of given emittance
C			specified by the two sigmas. If dist < > 0, then
C			the outputs will be correlated.
C
C	INPUT		sigma1, sigma2, distance
C
C	OUTPUT		X,X1 two binormal variate
C
C	ALGORITHM	As described by R.H.Rubinstein, in Simulation and
C			the MonteCarlo method, Wiley, NY 1981
C
C
C---
	SUBROUTINE	GAUSS	( S, SPRIM, DD, X, XPRIM, IS)
	IMPLICIT	REAL*8		(A-H,O-Z)
     	DATA	TWOPI 	/  6.2831 85307 17958 64679 25287 D0 /
C
C Initialize by computing the covariance matrix
C
10	C11	=   SQRT (DD**2*SPRIM**2+S**2)
	IF (C11.NE.0.0D0) THEN
	  C21	=   DD*SPRIM**2/C11
	  C22	=   S*SPRIM/C11
	ELSE
	  C21	= 0.0D0
	  C22	= 0.0D0
	END IF
C
C Entry for computation 
C Generates first the two normal variates with sigma=1 (Box & Muller)
C
20	CONTINUE
	R1	=   WRAN(IS)
	R2	=   WRAN(IS)
	Z1	=   SQRT(-2*LOG(R1))*COS(TWOPI*R2)
	Z2	=   SQRT(-2*LOG(R1))*SIN(TWOPI*R2)
D	WRITE	(33,*) Z1,Z2
C
C generates now the new varaites
C
	X	=   Z1*C11
	XPRIM	=   Z1*C21 + Z2*C22
C
C Completed
C
	RETURN
	END
