C +++
C
C Source: src/source/bm/srfunc.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	srfunc.F
C Revision 1.3  90/11/13  14:00:48  khan
C Cleanup and SAVE statements
C 
C Revision 1.2  90/07/18  19:15:58  khan
C Using SHADOW_SR_DIR environment string to find the files SRS* and G0UNF,
C as opposed to VMS's use of the LOGICALS for the file names.
C 
C Revision 1.1  90/07/11  10:45:10  khan
C Initial revision
C 
C 
C ---

C+++
C	PROGRAM		SRFUNC
C
C	PURPOSE		Generate a table of values of functions frequently
C			used in Synchrotron Radiation calculations.
C			
C			Bessel Functions of order 1/2, 3/2, 5/2
C
C			Green's G0 and H0 functions
C
C	RANGE		from 100*lam_c to 10**-5 lam_c
C                       [Note change from 10*lam_c Mon Apr 28 19:45:17 1997]
C
C---
	PROGRAM		SRFUNC
	IMPLICIT 	REAL*8 		(A-H,O-Z)
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
	INCLUDE		'SHADOW$INC:DIM.PAR/LIST'
#endif
C	DIMENSION 	ARRX(10000),ARR(10000,3),G0(10000)
	DIMENSION 	ARR(10000,3)
     	DIMENSION 	PPAR(1000),PPER(1000),PTOT(1000),ANGARR(1000)
	REAL*8		EX_LOW,EX_UPP,ARRX(N_DIM),G0(N_DIM)
C
	PI=3.141592653589793238D0
C
     	ORD23	=  2.0D0/3.0D0
     	ORD13	=  1.0D0/3.0D0
C
     	NP	=  1001
     	EX_LOW	=  -5.0D0
     	EX_UPP  =   2.0D0
     	EX_STEP =  (EX_UPP - EX_LOW)/(NP - 1)
     	DO 99 I=1,NP
     	  X_EX 	=  EX_UPP - EX_STEP*(I-1)
     	  X 	=  10.0D0**X_EX
     	 CALL	BSKM(X,BK,1,ORD13)
	  ARR(I,1)=BK
	 CALL	BSKM(X,BK,2,ORD23)
	  ARR(I,2)=BK
C
C Added the 5/3 case by recursion formula -- Nov 26 1983
C						F.C.
C
     	  ARR(I,3) = ARR(I,1) + ARR(I,2)*4/X/3
	  ARRX(I)=X
 99  	CONTINUE
C
#if vms
	OPEN	(2, FILE='BSKM', STATUS='NEW')
#else
	OPEN	(2, FILE='BSKM', STATUS='UNKNOWN')
	REWIND (2)
#endif
	WRITE	(2,1000)
1000	FORMAT	(1X,' MODIFIED BESSEL FUNCTION OF ORDER N ',//)
	WRITE	(2,1100)
1100 	FORMAT	(1X,' X= ',T20,' N=1/3 ',T40,' N=2/3 ',T60,' N=5/3 ',//)
	WRITE	(2,1200) (ARRX(I),(ARR(I,KL),KL=1,3),I=1,NP)
1200	FORMAT	(1X,G14.7,T20,G14.7,T40,G14.7,T60,G14.7)
	CLOSE	(2)
C
C Function G0 -- April 1984, F.C.
C Use a trapezoidal integration.
C
#if vms
     	OPEN 	(22, FILE='G0FUNC', STATUS='NEW')
#else
     	OPEN 	(22, FILE='G0FUNC', STATUS='UNKNOWN')
	REWIND (22)
#endif
     	G0(1)	=  ARR(1,3)
     	X_J	=  10.0D0**EX_UPP
     	WRITE (22,*)	X_J,G0(1)
     	ARRX(1)	=	X_J
     	DO 199 J=2,NP
     	  X_J1 	=  EX_UPP - EX_STEP*(J-1)
     	  X_J 	=  EX_UPP - EX_STEP*(J-2)
     	  X_J1 	=  10.0D0**X_J1
     	  X_J	=  10.0D0**X_J
     	  XSTEP =  ABS(X_J1 - X_J)
     	  G0(J) =  G0(J-1) + ( ARR(J-1,3) + ARR(J,3) )*0.5D0*XSTEP
     	  WRITE (22,*)	X_J1,G0(J)
     	  ARRX(J)	=   X_J1
 199 	CONTINUE
     	CLOSE 	(22)
C
C This is the unformatted file that will eventually contain the
C whole synchrotron radiation spectrum.
C
#if vms
     	OPEN 	(23, FILE='G0UNF', STATUS='NEW', FORM='UNFORMATTED')
#else
     	OPEN 	(23, FILE='G0UNF', STATUS='UNKNOWN', 
     $		FORM='UNFORMATTED')
	REWIND (23)
#endif
     	  WRITE (23)	NP,EX_LOW,EX_UPP
     	 DO 299 J=1,NP
     	  WRITE (23)	ARRX(J),G0(J)
 299 	 CONTINUE
     	CLOSE	(23)
	END
