C +++
C
C Source: src/source/bm/srcomp.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	srcomp.F
C Revision 1.5  90/11/13  14:00:47  khan
C Cleanup and SAVE statements
C 
C Revision 1.4  90/10/16  00:34:25  khan
C Change SRCOMP.DAT -> SRCOMP.
C 
C Revision 1.3  90/07/18  19:46:10  khan
C Minor bug fix. DO ... END DO => DO ... CONTINUE.
C 
C Revision 1.2  90/07/18  19:20:58  khan
C Using SHADOW_SR_DIR environment string to find the files SRS* and G0UNF,
C as opposed to VMS's use of the LOGICALS for the file names.
C 
C Revision 1.1  90/07/11  10:45:07  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	PROGRAM		SRCOMP
C
C	PURPOSE		To scale to a specific storage ring the universal
C			curves computed by SRFULL (Formula taken from 
C			C. K. Green's report).
C
C	INPUT		SRFULL.DAT, Machine parameters.
C
C	OUTPUT		1. Total flux.
C			2. Angular flux
C			3. A plottable file
C
C---
     	PROGRAM		SRCOMP
C test of implicit statement ...
	IMPLICIT REAL*8 (A-H,O-Z)
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
	INCLUDE		'SHADOW$INC:DIM.PAR/LIST'
#endif
     	DATA	PI	/3.141592653589793238D0	/
     	DIMENSION	OUT(2,10000)
     	CHARACTER*80	TOPLIN,TITLE, NAME *20
C	REAL*8		EX_LOW,EX_UPP,ARRX(N_DIM),G0(N_DIM)
	DIMENSION	ARRX(N_DIM),G0(N_DIM)
	CHARACTER*132	G0UNF

C
C Get the data file path using either SHADOW$DATA or Unix SHADOW_DATA_DIR
C environment variable. Also, check for existence in the routine itself.
C
	IFLAG = 1
	CALL DATAPATH ('G0UNF', G0UNF, IFLAG) 
	IF (IFLAG.NE.0) THEN
	    CALL LEAVE ('SRCOMP', 'G0UNF file not found', IFLAG)
	ENDIF
C
     	DO 99 I=1,80
     	  TOPLIN(I:I) = '-'
 99    	CONTINUE
     	WRITE(6,*)'Machine name ?'
     	READ (5,1000)	NAME
     	WRITE(6,*)'Title ?'
     	READ (5,1000)   TITLE
1000	FORMAT	(A)
     	WRITE(6,*)'Machine Radius [ m ] and Beam Energy [ GeV ] ?'
     	READ(5,*)RAD,BENER
     	WRITE(6,*)
     $		'Current [ A ] and milliradians of orbit (horizontal) ?'
     	READ(5,*)CURR,ORBIT
     	WRITE(6,*)'Minimum photon energy, maximum, step :'
     	READ(5,*)PMIN,PMAX,PSTEP
     	WRITE(6,*)'Spectrum type:'
     	WRITE(6,*)'dE = constant    0    [ Photons/sec/eV ]'
     	WRITE(6,*)'dL = constant    1    [ Photons/sec/Angs ]'
     	WRITE(6,*)'dL/L = constant  2    [ Photons/sec/%bandwidth ]'
	WRITE(6,*)'dE/E = constant  3    [ Photons/sec/%bandwidth ]'
     	WRITE(6,*)'Power dL=const   4    [ Watt/Angs ]'
     	WRITE(6,*)'Power dE=const   5    [ Watt/eV ]'
     	ISPEC = IRINT ('Then ? ')
     	IF (ISPEC.EQ.2.OR.ISPEC.EQ.3) THEN
     	  WRITE(6,*)'Bandpass ( % ) ?'
     	  READ(5,*)BPASS
     	  BPASS	=   BPASS/100
     	END IF
	IVERT = 
     $	  IYES('Do you want to specify the vertical acceptance ? ')
	IF (IVERT.EQ.1) THEN
	  V_ACCP = RNUMBER ('Total acceptance in milliradians ? ')
	  V_ACCP = V_ACCP * 1.0D-3 / 2.0D0	! half-acceptance in radians
C
C Get the spline for angular distribution ready.
C
	  CALL	RCDF	(BENER,RAD,PMIN,PMAX)
	END IF
#ifdef vms
     	OPEN	(20, FILE=G0UNF, STATUS='OLD', READONLY,
     $			FORM = 'UNFORMATTED')
#else
     	OPEN	(20, FILE=G0UNF, STATUS='OLD', 
     $			FORM = 'UNFORMATTED')
	REWIND 	(20)
#endif
     	  READ	(20)	NP,EX_LOW,EX_UPP
     	 DO 199 I=1,NP
     	   READ	(20)	ARRX(I),G0(I)
 199   	 CONTINUE
     	CLOSE	(20)
     	WRITE(6,*)'Read ',NP,' records.'
C
C Starts computing the spectrum
C
     	GAMMA	=   1957*BENER
     	R_LAM	=   4*PI*RAD/3.0D0/GAMMA**3		!Meters
     	R_LAM	=   R_LAM*1.0D10			!Angstroms
     	C_PHOT	=   12398.52D0/R_LAM
     	TESLA	=   1704*GAMMA/RAD/1.0D6
     	PWR	=   88.5D0*BENER**4/RAD
 	PWRTOT  =   PWR*CURR
     	PWRRD	=   PWRTOT/2.0D0/PI
     	PWRT	=   PWRRD*ORBIT
#ifdef vms
     	OPEN  (24, FILE='MACHINE', STATUS='NEW')
#else
     	OPEN  (24, FILE='MACHINE', STATUS='UNKNOWN')
	REWIND (24)
#endif
     	WRITE (24,*) TOPLIN
     	WRITE (24,*) TITLE
     	WRITE (24,*) 'Parameters of ',NAME
     	WRITE (24,*) TOPLIN
     	WRITE (24,*) 'Magnetic Radius    : ',RAD  ,' meters'
     	WRITE (24,*) 'Beam energy        : ',BENER,' GeV'
     	WRITE (24,*) 'Gamma              : ',GAMMA
     	WRITE (24,*) 'Magnetic Field     : ',TESLA,' tesla'
     	WRITE (24,*) TOPLIN
     	WRITE (24,*) 'Critical ENERGY    : ',C_PHOT,' eV'
     	WRITE (24,*) '         WAVELENGTH: ',R_LAM ,' Angstroms'
     	WRITE (24,*) 'Power/Amp          : ',PWR   ,' kilowatts/amp'
     	WRITE (24,*) 'Total Power        : ',PWRTOT,' kilowatts'
     	WRITE (24,*) '     at current of : ',CURR,  ' Amperes.'
     	WRITE (24,*) 'Total Power/mrad   : ',PWRRD, ' watts/mrad'
	IF (IVERT.EQ.1) 
     $	WRITE (24,*) 'Vert. acceptance   : ',V_ACCP*2*1000,' mrads'
	WRITE (24,*) 'For unlimited vertical acceptance,'
     	WRITE (24,*) '  power accepted   : ',PWRT,  ' watts'
     	WRITE (24,*) '  hori. acceptance : ',ORBIT, ' mrads'
     	WRITE (24,*) TOPLIN
     	CLOSE (24)
     	IF (ISPEC.EQ.0) THEN
     	  COEFF	=   1.013D6*R_LAM*GAMMA*CURR*1000*ORBIT
     	ELSE IF (ISPEC.EQ.1) THEN
     	  COEFF =   2.998D-1*GAMMA**4/RAD*CURR*1000*ORBIT
     	ELSE IF (ISPEC.EQ.2) THEN
     	  COEFF =   1.256D10*BPASS*GAMMA*CURR*1000*ORBIT
	ELSE IF (ISPEC.EQ.3) THEN
     	  COEFF =   1.256D10*BPASS*GAMMA*CURR*1000*ORBIT
     	ELSE IF (ISPEC.EQ.4) THEN
     	  COEFF =   1.421D-26*GAMMA**7/RAD**2*CURR*1000*ORBIT
     	ELSE IF (ISPEC.EQ.5) THEN
     	  COEFF	=   1.641D-13*R_LAM*GAMMA*CURR*1000*ORBIT
     	END IF
     	NPHOT	=   (PMAX - PMIN)/PSTEP + 1
     	EX_STEP =  (EX_UPP - EX_LOW)/(NP - 1)
     	DO 299 I=1,NPHOT
     	  PHOT	=   PMIN + (I-1)*PSTEP
     	  YVAL	=   PHOT/C_PHOT
C
C Interpolates for photon energy with a quadratic formula
C
C     	  X_EX 	=  EX_UPP - EX_STEP*(I-1)
C     	  X 	=  10.0D0**X_EX
C    	  XVAL	=   ALOG10 (YVAL)
     	  XVAL	=   DLOG10 (YVAL)
	IF (XVAL.GT.EX_UPP) THEN
	  WRITE(6,*)
     $	    'Warning!',PHOT,' eV is too large.  Flux set to zero.'
	  G0_I	=   0.0D0
	ELSE IF (XVAL.LT.EX_LOW) THEN
	  WRITE(6,*)
     $	    'Warning!',PHOT,' eV is too small.  Flux set to zero.'
	  G0_I	=   0.0D0
	ELSE
     	  INDEX =   (EX_UPP - XVAL)/EX_STEP + 1
     	  DEL_X	=   (YVAL - ARRX(INDEX))/(ARRX(INDEX+1)-ARRX(INDEX))
     	  G0_I	=   (G0(INDEX+1) - G0(INDEX))*DEL_X + G0(INDEX)
	END IF
C
C Account for vertical acceptance if desired.
C
	IF (IVERT.EQ.1) THEN
	  CALL	ICDF	(YVAL,V_ACCP,RATIO)
	  G0_I	= G0_I * RATIO
	END IF
     	 IF (ISPEC.EQ.0) THEN
     	   OUT(2,I)		=   G0_I*COEFF
     	   OUT(1,I)		=   PHOT
     	 ELSE IF (ISPEC.EQ.1) THEN
     	   OUT(2,NPHOT-I+1)	=   G0_I*COEFF*YVAL**2
     	   OUT(1,NPHOT-I+1)	=   12398.52D0/PHOT
     	 ELSE IF (ISPEC.EQ.2) THEN
     	   OUT(2,NPHOT-I+1)	=   G0_I*COEFF*YVAL
     	   OUT(1,NPHOT-I+1)	=   12398.52D0/PHOT
	 ELSE IF (ISPEC.EQ.3) THEN
     	   OUT(2,I)		=   G0_I*COEFF*YVAL
     	   OUT(1,I)		=   PHOT
     	 ELSE IF (ISPEC.EQ.4) THEN
     	   OUT(2,NPHOT-I+1)	=   G0_I*COEFF*YVAL**3
     	   OUT(1,NPHOT-I+1)	=   12398.52D0/PHOT
     	 ELSE IF (ISPEC.EQ.5) THEN
     	   OUT(2,I)		=   G0_I*COEFF*PHOT
     	   OUT(1,I)		=   PHOT
     	 END IF
 299 	CONTINUE
#ifdef vms
     	OPEN (30, FILE='SRCOMP', STATUS='NEW')
#else
     	OPEN (30, FILE='SRCOMP', STATUS='UNKNOWN')
	REWIND (30)
#endif
     	 DO 399 I=1,NPHOT
     	   WRITE (30,*) OUT(1,I),OUT(2,I)
 399 	 CONTINUE
     	CLOSE (30)
     	END
