C +++
C
C Source: src/source/bm/srangplt.f
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	srangplt.f
C Revision 1.1  90/07/11  10:45:05  khan
C Initial revision
C 
C 
C ---

C+++
C
C	PROGRAM		SRANGPLT
C
C	PURPOSE		Plot the SR distribution
C
C---
     	PROGRAM		SRANGPLT
     	DIMENSION	F_PAR(21),F_PER(21),F_TOT(21)
     	DIMENSION	ARRX(1000),G0(1000),XX(1000)
     	WRITE(6,*)'Critical Energy ?'
     	READ(5,*)C_PHOT
     	OPEN (20, FILE='ANGPLT', STATUS='NEW')
     	OPEN (23, FILE='SRSPEC', STATUS='OLD', READONLY,
     $		FORM='UNFORMATTED')
     	 k = 0
     	DO J=1,1000
     	 READ (23,ERR=100) ARRX(J),G0(J),PSIMAX
     	 k = k + 1
     	  STEP = PSIMAX/20
     	 DO I=1,21
     	   READ (23,ERR=100)  F_PAR(I),F_PER(I),F_TOT(I)
     	   Xx(I) = -PSIMAX + (I-1)*STEP
     	 CONTINUE
     	if (k.eq.10) then
     	 do i=1,21
     		x = xx(i)
     	   	U = F_PAR(I)
     		V = F_PER(I)
     		W = F_TOT(I)
     		IF (U.LT.1.0E-8) U =0.0
     		IF (V.LT.1.0E-8) V =0.0
     		IF (W.LT.1.0E-8) W =0.0
     	   WRITE (20,1000) ARRX(J),X,U,V,W
     	  CONTINUE
     	 WRITE (20,*) 'JOIN'
     	 k = 0
     	 end if
     	CONTINUE
100	WRITE(6,*)'That''s it.'
     	STOP
1000	FORMAT (1X,5(1X,E12.5))
     	END
