C +++
C
C Source: src/source/bm/sincradl.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	sincradl.F
C Revision 1.1  90/07/11  10:45:01  khan
C Initial revision
C 
C 
C ---

C**************************************************************
C	THIS PROGRAM COMPUTE THE FLUX DISTRIBUTION VS. ELEVATION
C	ANGLE(PSI). THE BANDPASS IS SPECIFIED BY THE USER.
	IMPLICIT REAL*8 (A-H,O-Z)
	CHARACTER *6 FILSAV,Q
	COMMON/FIRST/PPAR(100,2),PPER(100,2),PTOT(100,2),POL(100)
	COMMON/SECON/PHOT,BENER,THETA,NP,STEP,X,N,BK,IER,GAMM
	COMMON/THIRD/RAD,RLCR,RL,FCT,CONST,ARG,PSIMAX
	COMMON/FOURT/FILSAV,Q
	COMMON/FIFTH/IC,PSI,IDATA,BPASS,CURR
1	CALL INPUT
	CALL SETUP
	CALL COMPUTE
	CALL FILESAVE
	WRITE (6,100)
100	FORMAT(1X,'DONE. ANOTHER RUN (Y/N) ?',$)
	READ(6,110) Q
110	FORMAT(A8)
	IF (Q.EQ.'Y') GO TO 1
	STOP 'SEE YOU LATER !'
	END
C*************************************************************
	SUBROUTINE SETUP
	IMPLICIT REAL*8 (A-H,O-Z)
	CHARACTER *6 FILSAV,Q
	COMMON/FIRST/PPAR(100,2),PPER(100,2),PTOT(100,2),POL(100)
	COMMON/SECON/PHOT,BENER,THETA,NP,STEP,X,N,BK,IER,GAMM
	COMMON/THIRD/RAD,RLCR,RL,FCT,CONST,ARG,PSIMAX
	COMMON/FOURT/FILSAV,Q
	COMMON/FIFTH/IC,PSI,IDATA,BPASS,CURR
	RAD=2.0833D0
	GAMM=1957.0D0*BENER
	CONST=CONST/GAMM**4
	RLCR=5.59D0*RAD/BENER**3
	RL=12398.0D0/PHOT
	PSIMAX=PSIMAX/1000.0D0
	STEP=2*PSIMAX/(NP-1)
	FCT=RLCR/2/RL
	CONST=3.461D+15*GAMM**2*THETA/1000.0D0*(FCT*2)**2
	CONST=CONST*BPASS*CURR
	RETURN
	END
C*******************************************************************
	SUBROUTINE INPUT
	IMPLICIT REAL*8 (A-H,O-Z)
	CHARACTER *6 FILSAV,Q
	COMMON/FIRST/PPAR(100,2),PPER(100,2),PTOT(100,2),POL(100)
	COMMON/SECON/PHOT,BENER,THETA,NP,STEP,X,N,BK,IER,GAMM
	COMMON/THIRD/RAD,RLCR,RL,FCT,CONST,ARG,PSIMAX
	COMMON/FOURT/FILSAV,Q
	COMMON/FIFTH/IC,PSI,IDATA,BPASS,CURR
	WRITE (6,100)
100	FORMAT(1X,'BEAM ENERGY IN GeV = ',$)
	READ(5,*)BENER
	WRITE (6,105)
105	FORMAT(1X,'BEAM CURRENT = ',$)
	READ(5,*)CURR
	WRITE (6,110)
110	FORMAT(1X,'PHOTON ENERGY IN eV =',$)
	READ(5,*)PHOT
	WRITE(6,115)
115	FORMAT(1X,'BANDPASS = ',$)
	READ(5,*)BPASS
	WRITE(6,120)
120	FORMAT(1X,'ACCEPTANCE ANGLE IN mrad = ',$)
	READ(5,*)THETA
	WRITE(6,130)
130	FORMAT(1X,'PSI MAXIMUM IN mrad = ',$)
	READ(5,*) PSIMAX
	WRITE(6,140)
140 	FORMAT(1X,'NUMBER OF POINTS (ODD) = ',$)
	READ(5,*)NP
	WRITE (6,150)
150	FORMAT(1X,'NAME FOR STORAGE = ',$)
	READ(6,160) FILSAV
160 	FORMAT (A6)
	RETURN
	END
C*****************************************************************
	SUBROUTINE COMPUTE
	IMPLICIT REAL*8 (A-H,O-Z)
	CHARACTER *6 FILSAV,Q
	COMMON/FIRST/PPAR(100,2),PPER(100,2),PTOT(100,2),POL(100)
	COMMON/SECON/PHOT,BENER,THETA,NP,STEP,X,N,BK,IER,GAMM
	COMMON/THIRD/RAD,RLCR,RL,FCT,CONST,ARG,PSIMAX
	COMMON/FOURT/FILSAV,Q
	COMMON/FIFTH/IC,PSI,IDATA,BPASS,CURR
	IC=0
	DO 100 PSI=-PSIMAX,PSIMAX,STEP
	ARG=(1+GAMM**2*PSI**2)
	IC=IC+1
	X=ARG**1.5D0*FCT
	IQ=1
	ORD=1.0D0/3.0D0
	CALL BSKM(X,BK,IQ,ORD)
	ARG2=BK**2*ARG*CONST*(ARG-1)
	  PPER(IC,2)=ARG2
	PPER(IC,1)=PSI*1000
	IF(ABS(PSI).LT.1.0E-10) PPER(IC,1)=0.0D0
	IQ=2
	ORD=2/3.0D0
	CALL BSKM(X,BK,IQ,ORD)
	ARG3=BK**2*CONST*ARG**2
	PPAR(IC,2)=ARG3
	PPAR(IC,1)=PSI*1000
	IF (ABS(PSI).LT.1.0E-10) PPAR(IC,1)=0.0D0
	  PTOT(IC,2)=ARG2+ARG3
	PTOT(IC,1)=PSI*1000
	IF (ABS(PSI).LT.1.0E-10) PTOT(IC,1)=0.0D0
	IF (PTOT(IC,2).GT.0.0)THEN
	POL(IC)=(PPAR(IC,2)-PPER(IC,2))/PTOT(IC,2)
	ELSE
	POL(IC)=0.0D0
	END IF
100	CONTINUE
	RETURN
	END
C******************************************************************
	SUBROUTINE FILESAVE
	IMPLICIT REAL*8 (A-H,O-Z)
	CHARACTER *6 FILSAV,Q
	COMMON/FIRST/PPAR(100,2),PPER(100,2),PTOT(100,2),POL(100)
	COMMON/SECON/PHOT,BENER,THETA,NP,STEP,X,N,BK,IER,GAMM
	COMMON/THIRD/RAD,RLCR,RL,FCT,CONST,ARG,PSIMAX
	COMMON/FOURT/FILSAV,Q
	COMMON/FIFTH/IC,PSI,IDATA,BPASS,CURR
	DO 200 IC=1,3
	OPEN(UNIT=20,FILE=FILSAV,STATUS='NEW',DISPOSE='SAVE')
	WRITE(20,112)
	WRITE(20,112)
	WRITE(20,111)
	WRITE(20,112)
	WRITE(20,100) BENER,PHOT,THETA,BPASS,CURR
	WRITE(20,112)
111	FORMAT (10X,'PHOTON DISTRIBUTION VS. ELEVATION ANGLE')
112	FORMAT(//,
     $		'**************************************************',//)
	WRITE(20,113)
100	FORMAT(1X,'B. EN.=',G12.5,' PH. EN.=',G12.5,' THETA= ',G12.5,
     1  ' BPASS.=',G12.5,' CURRENT=',G12.5)
	WRITE(20,*)'      '
	  IF (IC.EQ.1)THEN
	  WRITE(20,110) ((PPAR(I,K), K=1,2), I=1,NP)
		ELSE IF (IC.EQ.2) THEN
		WRITE(20,110) ((PPER(I,K),K=1,2),I=1,NP)
	  ELSE
		WRITE(20,110) ((PTOT(I,K),K=1,2),POL(I),I=1,NP)
	END IF
200	CLOSE(20,DISPOSE='SAVE')
110	FORMAT(T11,G12.5,T31,G12.5,T51,G12.5)
113	FORMAT(T11,'ANGLE MRAD=',T31,'N PHOTON=',T51,'POLARIZATION=',/)
	RETURN 
	END
C**********************************************************************
	  SUBROUTINE BSKM(X,BK,IQ,ORD)
	  IMPLICIT REAL*8 (A-H,O-Z)
	  G13=2.678938534707748D0
	  G23=1.354117939426400D0
	  PI=3.141592653589793238D0
	  K=0
	  BK=0.0D0
	IF (X.LT.10.1) THEN
	IF (IQ.EQ.1)THEN
	  PP=(X/2.D0)**(-ORD)/G23-(X/2.D0)**ORD/G13*3
	GO TO 250
230	DO 240 J=1,K
	  PPP=PPP*(X/2.D0)**2/J/FLOAT(3*J-2)*3.0D0
240	  PPM=PPM*(X/2.D0)**2/J/FLOAT(3*J-1)*3.0D0
	  PPP=PPP/G13*(X/2.D0)**ORD*3.0D0/(3*J-2)
	  PPM=PPM/G23*(X/2.D0)**(-ORD)
	  PP=PPM-PPP
250	  PP=PP*PI/2/SIN(ORD*PI)
	  BK=BK+PP
	  	IF(ABS(PP).LT.1.0D-20) RETURN
	  K=K+1
	  PPP=1.0D0
	  PPM=1.0D0
	GOTO230

	ELSE

	  PP=(X/2.D0)**(-ORD)/G13-(X/2.D0)**ORD/G23*3.0D0/2
	GO TO 350
330	DO 340 J=1,K
	  PPP=PPP*(X/2.D0)**2/J/FLOAT(3*J-1)*3.0D0
340	  PPM=PPM*(X/2.D0)**2/J/FLOAT(3*J-2)*3.0D0
	  PPP=PPP/G23*(X/2.D0)**ORD*3.0D0/(3*J-1)
	  PPM=PPM/G13*(X/2.D0)**(-ORD)
	  PP=PPM-PPP
350	  PP=PP*PI/2/SIN(ORD*PI)
	  BK=BK+PP
	IF(ABS(PP).LT.1.0D-20) RETURN
	  K=K+1
	  PPP=1.0D0
	  PPM=1.0D0
	GO TO 330

	END IF

	ELSE
	  ZZ=8*X
	  BK=1.0D0
	  RMU=4*ORD**2
	  BK=(PI/2/X)**0.5D0*EXP(-X)
	  BK=BK*(1+(RMU-1)/ZZ+(RMU-1)*(RMU-9)/2.0D0/ZZ**2+(RMU-1)*
     $		(RMU-9)*(RMU-25)/6.0D0/ZZ**3)
	END IF
	RETURN
	END
	
	
