C +++
C
C Source: src/source/bm/filesave.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	filesave.F
C Revision 1.1  90/07/18  16:16:32  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE	FILESAVE
C
C	PURPOSE		Write to disk the SR spectrum and flux data
C
C---
	SUBROUTINE FILESAVE

	IMPLICIT 	REAL*8 		(A-H,O-Z)
			CHARACTER *9 	FILSAV(3)
     			CHARACTER *5	VALUE

#if defined(unix) || HAVE_F77_CPP
#       include		"bm.blk"
#elif defined(vms)
	INCLUDE		'bm.blk'
#endif
C
     	IPHOT	=   PHOT

     	WRITE (VALUE,100)  IPHOT
100	FORMAT (I5.5)
	FILSAV(1) = 'SPAR'//VALUE
     	FILSAV(2) = 'SPER'//VALUE
     	FILSAV(3) = 'STOT'//VALUE

	DO 200 IC = 1,3
C	OPEN(UNIT = 20,FILE=FILSAV(IC),STATUS = 'NEW',DISPOSE = 'SAVE')
	OPEN(UNIT = 20,FILE=FILSAV(IC),STATUS = 'UNKNOWN')
	REWIND (20)
	  IF (IC.EQ.1)THEN
	   WRITE(20,110) ((PPAR(I,K), K = 1,2), I = 1,NP,10)
	  ELSE IF (IC.EQ.2) THEN
 	   WRITE(20,110) ((PPER(I,K),K = 1,2),I = 1,NP,10)
	  ELSE
	   WRITE(20,110) ((PTOT(I,K),K = 1,2),I = 1,NP,10)
	  END IF
200	CLOSE(20)
C 200	CLOSE(20,DISPOSE = 'SAVE')
110	FORMAT(1X,G12.5,10X,G12.5)

	RETURN 
	END
 
