C +++
C
C Source: src/source/bm/bend_phot.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	bend_phot.F
C Revision 1.4  90/11/13  14:00:44  khan
C Cleanup and SAVE statements
C 
C Revision 1.3  90/07/23  21:53:00  khan
C Renamed RCDF to be unique for each
C 
C Revision 1.2  90/07/18  19:11:51  khan
C Removed most of the subroutines to BM library (libbm.a) since these are
C called by most of the other programs.
C Also added #if vms ... #elif unix ... to OPEN statements.
C 
C Revision 1.1  90/07/11  10:44:55  khan
C Initial revision
C 
C 
C ---

C+++
C	SUBROUTINE	BEND_PHOT
C
C	PURPOSE		To scale to a specific storage ring the universal
C			curves computed by SRFUNC (Formula taken from 
C			C. K. Green's report).
C
C	INPUT		Machine parameters
C			PHOT, photon energy (eV)
C			THETA, vertical angle (rad)
C			IPOL = 1, parallel polarization
C			       2, perpendicular
C			       3, total	
C			IFLAG < 0, initialization
C			      > 0, calculate the # of photons
C
C	OUTPUT		# of photons/sec/mA/eV/mrad^2
C			IFLAG = 0, normal termination
C			        1, angle THETA out of bounds
C			        2, photon energy PHOT out of bounds
C
C---
	SUBROUTINE	BEND_PHOT	
     $		(RN,THETA,PHOT,GAMMA,C_PHOT,IPOL,IFLAG)
	IMPLICIT	REAL*8	(A-H,O-Z)
     	DATA	PI	/3.141592653589793238D0	/
	IF (IFLAG.LT.0)	THEN
	  CALL 	BEND_RCDF	(GAMMA,IPOL)
	  IFLAG	= 0
	ELSE
	  PE	= PHOT/C_PHOT
	  CALL	BEND_ICDF	(RN,THETA,PE,IFLAG)
	  R_LAM	= 12398.52D0/C_PHOT	
     	  COEFF	=   1.013D6*R_LAM*GAMMA
	  RN	= RN*COEFF*1.0D-3		! per mrad (V)
	END IF
	RETURN
	END
C+++
C	SUBROUTINE	BEND_RCDF
C
C	PURPOSE		To read the unformatted SR angular distribution, 
C			then produce the spline coefficients.
C---
	SUBROUTINE	BEND_RCDF  (GAMMA,IPOL)
	IMPLICIT	REAL*8	(A-H,O-Z)
     	REAL*8		PSI_INT(21,251),PSI(5,21,251),XPHOT(251)
     	REAL*8		WORKG(5,21),WORKY(21)
	REAL*8		EX_LOW,EX_UPP,EX_STEP
	COMMON  /CDFINDEX/	EX_UPP,EX_LOW,EX_STEP,NPHOT,IST
	COMMON	/ARRAY/		PSI,XPHOT	
     	DATA	PI     	/  3.1415 92653 58979 32384 62643 D0 /
     	DATA	TWOPI 	/  6.2831 85307 17958 64769 25287 D0 /
	DATA	TOCM	/  1.239 852	D-4		     /
	DATA	TOANGS 	/  1.239 852    D+4		     /
	CHARACTER*132	SRANG
C
C Get the data file path using either SHADOW$DATA or Unix SHADOW_DATA_DIR
C environment variable. Also, check for existence in the routine itself.
C
	IFLAG = 1
	CALL DATAPATH ('SRANG', SRANG, IFLAG) 
	IF (IFLAG.NE.0) THEN
	    CALL LEAVE ('BEND_RCDF', 'SRANG file not found', IFLAG)
	ENDIF
C
C------------------------------------------------------------------------------
C Now the angular distribution.
C------------------------------------------------------------------------------
200	CONTINUE
#ifdef vms
     	OPEN	(30, FILE=SRANG, STATUS='OLD', 
     $		 READONLY,FORM='UNFORMATTED')
#else
     	OPEN	(30, FILE=SRANG, STATUS='OLD',FORM='UNFORMATTED')
#endif
     	READ	(30)	NPHOT,ICOL,IST
	READ	(30)	EX_UPP,EX_LOW,EX_STEP
C
C Reads in the angle data for the desired polarization
C
	IF (IPOL.EQ.1) THEN
	  DO 99 I = 1, NPHOT
	    READ (30)	XPHOT(I),DUMM,DUMM
	    DO 99 J = 1, 21
	      READ (30)		PSI(1,J,I), PSI_INT(J,I), DUMM, DUMM
 99	  CONTINUE
	ELSE IF (IPOL.EQ.2) THEN
	  DO 199 I = 1, NPHOT
	    READ (30)	XPHOT(I),DUMM,DUMM
	    DO 199 J = 1, 21
	      READ (30)		PSI(1,J,I), DUMM, PSI_INT(J,I), DUMM
 199	  CONTINUE
	ELSE
	  DO 299 I = 1, NPHOT
	    READ (30)	XPHOT(I),DUMM, DUMM
	    DO 299 J = 1, 21
	      READ (30)		PSI(1,J,I), DUMM, DUMM, PSI_INT(J,I) 
 299	  CONTINUE
	END IF
	CLOSE	(30)
C
C For each photon energy (XPHOT), generate the spline on angles
C
	DO 399 I = 1, NPHOT
	  DO 499 J = 1, 21
C
C The vertical is originally stored as GAMMA*PHI, and the # of photons is
C for an 1 GeV machine. They need to be scaled to the machine in interested.
C
	    PSI(1,J,I)	= PSI(1,J,I)/GAMMA		!Radians
	    WORKG(1,J)	= PSI(1,J,I)
	    WORKY(J)	= PSI_INT(J,I)*GAMMA/1957.0D0
 499	  CONTINUE
	    CALL CUBSPL (WORKG,WORKY,21,IER)
	  DO 599 J = 1, 21
	    DO 599 K = 2, 5
	      PSI(K,J,I)	= WORKG(K,J)
 599	  CONTINUE
 399	CONTINUE
	RETURN 
	END	
C+++
C	PROGRAM		BEND_ICDF
C
C	PURPOSE		To interpolate RN for an angle THETA and photon
C			energy PE (normalized to C_PHOT).
C---
	SUBROUTINE	BEND_ICDF	(RN,THETA,PE,IFLAG)
	IMPLICIT	REAL*8	(A-H,O-Z)
	REAL*8		WORKG(5,21),WORKP(4),WORKX(5,4)	
	REAL*8		EX_LOW,EX_UPP,EX_STEP
	REAL*8		PSI(5,21,251),XPHOT(251)
	REAL*8		VIN,RATIO_TRY,PE8,RATIO8
	COMMON  /CDFINDEX/	EX_UPP,EX_LOW,EX_STEP,NPHOT,IST
	COMMON	/ARRAY/		PSI,XPHOT

	IFLAG	= 0
	E_VAL	= LOG10(PE)	
	IF (E_VAL.GT.EX_UPP.OR.E_VAL.LT.EX_LOW) THEN
	  RN	= 0.0D0
	  IFLAG	= 2
	  RETURN
	END IF
C
C First find the indices (ISTART,IEND) of 'neighboring erergy' on XPHOT
C
	IPE	= (EX_UPP - E_VAL)/EX_STEP/IST + 1
	IF (IPE-1.LT.1) THEN
	  ISTART = 1
	  IEND   = 4
	ELSE IF (IPE+2.GT.NPHOT) THEN
	  IEND   = NPHOT
	  ISTART = NPHOT - 3
	ELSE
	  ISTART = IPE - 1
	  IEND   = IPE + 2
	END IF
C
C Interpolate the angles correspond to the four 'neighboring energy'
C
	VIN	= -ABS(THETA) 
	DO 99 I = ISTART, IEND
	  DO 199 J = 1, 21
	    DO 199 K = 1, 5
	      WORKG(K,J) = PSI(K,J,I)
 199	  CONTINUE
	  IF (VIN.LT.WORKG(1,1)) THEN
	    RN_TRY	= 0.0D0
	    IFLAG	= 1
	  ELSE
	    CALL SPL_INT (WORKG,21,VIN,RN_TRY,IER)
	  END IF
	  WORKP(I-ISTART+1)	= RN_TRY
	  WORKX(1,I-ISTART+1)	= XPHOT(I)
 99	CONTINUE
C
C Use the four energy and their corresponding angles to interpolate for 
C the angle at PE
C
	  CALL CUBSPL  (WORKX,WORKP,4,IER)
	  CALL SPL_INT (WORKX,4,PE,RN,IER)
	  IF (RN.LT.0.0D0)	RN = 0.0D0
 	RETURN
	END
