C +++
C
C Source: src/lib/zrpoly.f
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: zrpoly.f
C Revision 1.2  1991/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C
C Revision 1.1  90/07/10  14:57:48  khan
C Initial revision
C 
C 
C ---

C   IMSL ROUTINE NAME   - ZRPOLY                                        ZRPA0010
C                                                                       ZRPA0020
C-----------------------------------------------------------------------ZRPA0030
C                                                                       ZRPA0040
C   COMPUTER            - VAX/DOUBLE                                    ZRPA0050
C                                                                       ZRPA0060
C   LATEST REVISION     - JANUARY 1, 1978                               ZRPA0070
C                                                                       ZRPA0080
C   PURPOSE             - ZEROS OF A POLYNOMIAL WITH DOUBLE PRECISION               ZRPA0090
C                           COEFFICIENTS (JENKINS-TRAUB)                ZRPA0100
C                                                                       ZRPA0110
C   USAGE               - CALL ZRPOLY (A,NDEG,Z,IER)                    ZRPA0120
C                                                                       ZRPA0130
C   ARGUMENTS    A      - INPUT REAL VECTOR OF LENGTH NDEG+1            ZRPA0140
C                           CONTAINING THE COEFFICIENTS IN ORDER OF     ZRPA0150
C                           DECREASING POWERS OF THE VARIABLE.          ZRPA0160
C                NDEG   - INPUT INTEGER DEGREE OF POLYNOMIAL.           ZRPA0170
C                           NDEG MUST BE GREATER THAN 0 AND LESS        ZRPA0180
C                           THAN 101.                                   ZRPA0190
C                Z      - OUTPUT COMPLEX VECTOR OF LENGTH NDEG          ZRPA0200
C                           CONTAINING THE COMPUTED ROOTS OF THE        ZRPA0210
C                           POLYNOMIAL.                                 ZRPA0220
C                         NOTE - THE ROUTINE TREATS Z AS A DOUBLE PRECISION VECTOR  ZRPA0230
C                           OF LENGTH 2*NDEG. AN APPROPRIATE            ZRPA0240
C                           EQUIVALENCE STATEMENT MAY BE REQUIRED.      ZRPA0250
C                           SEE DOCUMENT EXAMPLE.                       ZRPA0260
C                IER    - ERROR PARAMETER. (OUTPUT)                     ZRPA0270
C                         TERMINAL ERROR                                ZRPA0280
C                           IER=129, INDICATES THAT THE DEGREE OF THE   ZRPA0290
C                             POLYNOMIAL IS GREATER THAN 100 OR LESS    ZRPA0300
C                             THAN 1.                                   ZRPA0310
C                           IER=130, INDICATES THAT THE LEADING         ZRPA0320
C                             COEFFICIENT IS ZERO.                      ZRPA0330
C                           IER=131, INDICATES THAT ZRPOLY FOUND FEWER  ZRPA0340
C                             THAN NDEG ZEROS. IF ONLY M ZEROS ARE      ZRPA0350
C                             FOUND, Z(J),J=M+1,...,NDEG ARE SET TO     ZRPA0360
C                             POSITIVE MACHINE INFINITY.                ZRPA0370
C                                                                       ZRPA0380
C   PRECISION/HARDWARE  - SINGLE AND DOUBLE/H32                         ZRPA0390
C                       - SINGLE/H36,H48,H60                            ZRPA0400
C                                                                       ZRPA0410
C   REQD. IMSL ROUTINES - UERTST,UGETIO,ZRPQLB,ZRPQLC,ZRPQLD,ZRPQLE,    ZRPA0420
C                           ZRPQLF,ZRPQLG,ZRPQLH,ZRPQLI                 ZRPA0430
C                                                                       ZRPA0440
C   NOTATION            - INFORMATION ON SPECIAL NOTATION AND           ZRPA0450
C                           CONVENTIONS IS AVAILABLE IN THE MANUAL      ZRPA0460
C                           INTRODUCTION OR THROUGH IMSL ROUTINE UHELP  ZRPA0470
C                                                                       ZRPA0480
C   COPYRIGHT           - 1978 BY IMSL, INC. ALL RIGHTS RESERVED.       ZRPA0490
C                                                                       ZRPA0500
C   WARRANTY            - IMSL WARRANTS ONLY THAT IMSL TESTING HAS BEEN ZRPA0510
C                           APPLIED TO THIS CODE. NO OTHER WARRANTY,    ZRPA0520
C                           EXPRESSED OR IMPLIED, IS APPLICABLE.        ZRPA0530
C                                                                       ZRPA0540
C-----------------------------------------------------------------------ZRPA0550
C                                                                       ZRPA0560
      SUBROUTINE ZRPOLY (A,NDEG,Z,IER)                                  ZRPA0570
C                                  SPECIFICATIONS FOR ARGUMENTS         ZRPA0580
      INTEGER            NDEG,IER                                       ZRPA0590
      DOUBLE PRECISION   A(1),Z(1)                                      ZRPA0600
C                                  SPECIFICATIONS FOR LOCAL VARIABLES   ZRPA0610
      INTEGER            N,NN,J,JJ,I,NM1,ICNT,N2,L,NZ,NPI               ZRPA0620
      DOUBLE PRECISION   ETA,RMRE,RINFP,REPSP,RADIX,RLO,XX,YY,SINR,     ZRPA0630
     1                   COSR,RMAX,RMIN,X,SC,XM,FF,DX,DF,BND,XXX,ARE    ZRPA0640
      DOUBLE PRECISION   PT(101)                                        ZRPA0650
      DOUBLE PRECISION   TEMP(101),P(101),QP(101),RK(101),QK(101),      ZRPA0660
     1                   SVK(101)                                       ZRPA0670
      DOUBLE PRECISION   SR,SI,U,V,RA,RB,C,D,A1,A2,A3,                  ZRPA0680
     1                   A6,A7,E,F,G,H,SZR,SZI,RLZR,RLZI,               ZRPA0690
     2                   T,AA,BB,CC,FACTOR,REPSR1,ZERO,ONE,FN           ZRPA0700
      LOGICAL            ZEROK                                          ZRPA0710
      COMMON /ZRPQLJ/    P,QP,RK,QK,SVK,SR,SI,U,V,RA,RB,C,D,A1,A2,A3,A6,ZRPA0720
     1                   A7,E,F,G,H,SZR,SZI,RLZR,RLZI,ETA,ARE,RMRE,N,NN ZRPA0730
C                                  THE FOLLOWING STATEMENTS SET MACHINE ZRPA0740
C                                    CONSTANTS USED IN VARIOUS PARTS OF ZRPA0750
C                                    THE PROGRAM. THE MEANING OF THE    ZRPA0760
C                                    FOUR CONSTANTS ARE - REPSR1 THE    ZRPA0770
C                                    MAXIMUM RELATIVE REPRESENTATION    ZRPA0780
C                                    ERROR WHICH CAN BE DESCRIBED AS    ZRPA0790
C                                    THE SMALLEST POSITIVE FLOATING     ZRPA0800
C                                    POINT NUMBER SUCH THAT 1.+REPSR1 ISZRPA0810
C                                    GREATER THAN 1                     ZRPA0820
C                                  RINFP THE LARGEST FLOATING-POINT     ZRPA0830
C                                    NUMBER                             ZRPA0840
C                                  REPSP THE SMALLEST POSITIVE          ZRPA0850
C                                    FLOATING-POINT NUMBER IF THE       ZRPA0860
C                                    EXPONENT RANGE DIFFERS IN SINGLE   ZRPA0870
C                                    AND DOUBLE PRECISION THEN REPSP    ZRPA0880
C                                    AND RINFP SHOULD INDICATE THE      ZRPA0890
C                                    SMALLER RANGE                      ZRPA0900
C                                  RADIX THE BASE OF THE FLOATING-POINT ZRPA0910
C                                    NUMBER SYSTEM USED                 ZRPA0920
      DATA               RINFP/1.7E+38/                                 ZRPA0930
      DATA               REPSP/2.9388E-39/                              ZRPA0940
      DATA               RADIX/2.0/                                     ZRPA0950
      DATA               REPSR1/2.775557562D-17/                        ZRPA0960
      DATA               ZERO/0.0D0/,ONE/1.0D0/                         ZRPA0970
C                                  ZRPOLY USES SINGLE PRECISION         ZRPA0980
C                                    CALCULATIONS FOR SCALING, BOUNDS   ZRPA0990
C                                    AND ERROR CALCULATIONS.            ZRPA1000
C                                  FIRST EXECUTABLE STATEMENT           ZRPA1010
      IER = 0                                                           ZRPA1020
      IF (NDEG .GT. 100 .OR. NDEG .LT. 1) GO TO 165                     ZRPA1030
      ETA = REPSR1                                                      ZRPA1040
      ARE = ETA                                                         ZRPA1050
      RMRE = ETA                                                        ZRPA1060
      RLO = REPSP/ETA                                                   ZRPA1070
C                                  INITIALIZATION OF CONSTANTS FOR      ZRPA1080
C                                    SHIFT ROTATION                     ZRPA1090
      XX = .7071068                                                     ZRPA1100
      YY = -XX                                                          ZRPA1110
      SINR = .9975641                                                   ZRPA1120
      COSR = -.06975647                                                 ZRPA1130
      N = NDEG                                                          ZRPA1140
      NN = N+1                                                          ZRPA1150
C                                  ALGORITHM FAILS IF THE LEADING       ZRPA1160
C                                    COEFFICIENT IS ZERO.               ZRPA1170
      IF (A(1).NE.ZERO) GO TO 5                                         ZRPA1180
      IER = 130                                                         ZRPA1190
      GO TO 9000                                                        ZRPA1200
C                                  REMOVE THE ZEROS AT THE ORIGIN IF    ZRPA1210
C                                    ANY                                ZRPA1220
    5 IF (A(NN).NE.ZERO) GO TO 10                                       ZRPA1230
      J = NDEG-N+1                                                      ZRPA1240
      JJ = J+NDEG                                                       ZRPA1250
      Z(J) = ZERO                                                       ZRPA1260
      Z(JJ) = ZERO                                                      ZRPA1270
      NN = NN-1                                                         ZRPA1280
      N = N-1                                                           ZRPA1290
      IF (NN.EQ.1) GO TO 9005                                           ZRPA1300
      GO TO 5                                                           ZRPA1310
C                                  MAKE A COPY OF THE COEFFICIENTS      ZRPA1320
   10 DO 15 I=1,NN                                                      ZRPA1330
         P(I) = A(I)                                                    ZRPA1340
   15 CONTINUE                                                          ZRPA1350
C                                  START THE ALGORITHM FOR ONE ZERO     ZRPA1360
   20 IF (N.GT.2) GO TO 30                                              ZRPA1370
      IF (N.LT.1) GO TO 9005                                            ZRPA1380
C                                  CALCULATE THE FINAL ZERO OR PAIR OF  ZRPA1390
C                                    ZEROS                              ZRPA1400
      IF (N.EQ.2) GO TO 25                                              ZRPA1410
      Z(NDEG) = -P(2)/P(1)                                              ZRPA1420
      Z(NDEG+NDEG) = ZERO                                               ZRPA1430
      GO TO 145                                                         ZRPA1440
   25 CALL ZRPQLI (P(1),P(2),P(3),Z(NDEG-1),Z(NDEG+NDEG-1),Z(NDEG),     ZRPA1450
     1   Z(NDEG+NDEG))                                                  ZRPA1460
      GO TO 145                                                         ZRPA1470
C                                  FIND LARGEST AND SMALLEST MODULI OF  ZRPA1480
C                                    COEFFICIENTS.                      ZRPA1490
   30 RMAX = 0.                                                         ZRPA1500
      RMIN = RINFP                                                      ZRPA1510
      DO 35 I=1,NN                                                      ZRPA1520
         X = ABS(SNGL(P(I)))                                            ZRPA1530
         IF (X.GT.RMAX) RMAX = X                                        ZRPA1540
         IF (X.NE.0..AND.X.LT.RMIN) RMIN = X                            ZRPA1550
   35 CONTINUE                                                          ZRPA1560
C                                  SCALE IF THERE ARE LARGE OR VERY     ZRPA1570
C                                    SMALL COEFFICIENTS COMPUTES A      ZRPA1580
C                                    SCALE FACTOR TO MULTIPLY THE       ZRPA1590
C                                    COEFFICIENTS OF THE POLYNOMIAL.    ZRPA1600
C                                    THE SCALING IS DONE TO AVOID       ZRPA1610
C                                    OVERFLOW AND TO AVOID UNDETECTED   ZRPA1620
C                                    UNDERFLOW INTERFERING WITH THE     ZRPA1630
C                                    CONVERGENCE CRITERION.             ZRPA1640
C                                  THE FACTOR IS A POWER OF THE BASE    ZRPA1650
      SC = RLO/RMIN                                                     ZRPA1660
      IF (SC.GT.1.0) GO TO 40                                           ZRPA1670
      IF (RMAX.LT.10.) GO TO 55                                         ZRPA1680
      IF (SC.EQ.0.) SC = REPSP*RADIX*RADIX                              ZRPA1690
      GO TO 45                                                          ZRPA1700
   40 IF (RINFP/SC.LT.RMAX) GO TO 55                                    ZRPA1710
   45 L = DLOG(SC)/DLOG(RADIX)+.5                                       ZRPA1720
      IF (L .EQ. 0) GO TO 55                                            ZRPA1730
      FACTOR = DBLE(RADIX)**L                                           ZRPA1740
      DO 50 I=1,NN                                                      ZRPA1750
   50 P(I) = FACTOR*P(I)                                                ZRPA1760
C                                  COMPUTE LOWER BOUND ON MODULI OF     ZRPA1770
C                                    ZEROS.                             ZRPA1780
   55 DO 60 I=1,NN                                                      ZRPA1790
   60 PT(I) = ABS(SNGL(P(I)))                                           ZRPA1800
      PT(NN) = -PT(NN)                                                  ZRPA1810
C                                  COMPUTE UPPER ESTIMATE OF BOUND      ZRPA1820
      X = DEXP((DLOG(-PT(NN))-DLOG(PT(1)))/N)                            ZRPA1830
      IF (PT(N).EQ.0.) GO TO 65                                         ZRPA1840
C                                  IF NEWTON STEP AT THE ORIGIN IS      ZRPA1850
C                                    BETTER, USE IT.                    ZRPA1860
      XM = -PT(NN)/PT(N)                                                ZRPA1870
      IF (XM.LT.X) X = XM                                               ZRPA1880
C                                  CHOP THE INTERVAL (0,X) UNTIL FF.LE.0ZRPA1890
   65 XM = X*.1                                                         ZRPA1900
      FF = PT(1)                                                        ZRPA1910
      DO 70 I=2,NN                                                      ZRPA1920
   70 FF = FF*XM+PT(I)                                                  ZRPA1930
      IF (FF.LE.0.) GO TO 75                                            ZRPA1940
      X = XM                                                            ZRPA1950
      GO TO 65                                                          ZRPA1960
   75 DX = X                                                            ZRPA1970
C                                  DO NEWTON ITERATION UNTIL X          ZRPA1980
C                                    CONVERGES TO TWO DECIMAL PLACES    ZRPA1990
   80 IF (ABS(DX/X).LE..005) GO TO 90                                   ZRPA2000
      FF = PT(1)                                                        ZRPA2010
      DF = FF                                                           ZRPA2020
      DO 85 I=2,N                                                       ZRPA2030
         FF = FF*X+PT(I)                                                ZRPA2040
         DF = DF*X+FF                                                   ZRPA2050
   85 CONTINUE                                                          ZRPA2060
      FF = FF*X+PT(NN)                                                  ZRPA2070
      DX = FF/DF                                                        ZRPA2080
      X = X-DX                                                          ZRPA2090
      GO TO 80                                                          ZRPA2100
   90 BND = X                                                           ZRPA2110
C                                  COMPUTE THE DERIVATIVE AS THE INTIAL ZRPA2120
C                                    K POLYNOMIAL AND DO 5 STEPS WITH   ZRPA2130
C                                    NO SHIFT                           ZRPA2140
      NM1 = N-1                                                         ZRPA2150
      FN = ONE/N                                                        ZRPA2160
      DO 95 I=2,N                                                       ZRPA2170
   95 RK(I) = (NN-I)*P(I)*FN                                            ZRPA2180
      RK(1) = P(1)                                                      ZRPA2190
      AA = P(NN)                                                        ZRPA2200
      BB = P(N)                                                         ZRPA2210
      ZEROK = RK(N).EQ.ZERO                                             ZRPA2220
      DO 115 JJ=1,5                                                     ZRPA2230
         CC = RK(N)                                                     ZRPA2240
         IF (ZEROK) GO TO 105                                           ZRPA2250
C                                  USE SCALED FORM OF RECURRENCE IF     ZRPA2260
C                                    VALUE OF K AT 0 IS NONZERO         ZRPA2270
         T = -AA/CC                                                     ZRPA2280
         DO 100 I=1,NM1                                                 ZRPA2290
            J = NN-I                                                    ZRPA2300
            RK(J) = T*RK(J-1)+P(J)                                      ZRPA2310
  100    CONTINUE                                                       ZRPA2320
         RK(1) = P(1)                                                   ZRPA2330
         ZEROK = DABS(RK(N)).LE.DABS(BB)*ETA*10.                        ZRPA2340
         GO TO 115                                                      ZRPA2350
C                                  USE UNSCALED FORM OF RECURRENCE      ZRPA2360
  105    DO 110 I=1,NM1                                                 ZRPA2370
            J = NN-I                                                    ZRPA2380
            RK(J) = RK(J-1)                                             ZRPA2390
  110    CONTINUE                                                       ZRPA2400
         RK(1) = ZERO                                                   ZRPA2410
         ZEROK = RK(N).EQ.ZERO                                          ZRPA2420
  115 CONTINUE                                                          ZRPA2430
C                                  SAVE K FOR RESTARTS WITH NEW SHIFTS  ZRPA2440
      DO 120 I=1,N                                                      ZRPA2450
  120 TEMP(I) = RK(I)                                                   ZRPA2460
C                                  LOOP TO SELECT THE QUADRATIC         ZRPA2470
C                                    CORRESPONDING TO EACH NEW SHIFT    ZRPA2480
      DO 140 ICNT=1,20                                                  ZRPA2490
C                                  QUADRATIC CORRESPONDS TO A DOUBLE    ZRPA2500
C                                    SHIFT TO A NON-REAL POINT AND ITS  ZRPA2510
C                                    COMPLEX CONJUGATE. THE POINT HAS   ZRPA2520
C                                    MODULUS BND AND AMPLITUDE ROTATED  ZRPA2530
C                                    BY 94 DEGREES FROM THE PREVIOUS    ZRPA2540
C                                    SHIFT                              ZRPA2550
         XXX = COSR*XX-SINR*YY                                          ZRPA2560
         YY = SINR*XX+COSR*YY                                           ZRPA2570
         XX = XXX                                                       ZRPA2580
         SR = BND*XX                                                    ZRPA2590
         SI = BND*YY                                                    ZRPA2600
         U = -SR-SR                                                     ZRPA2610
         V = BND*BND                                                    ZRPA2620
C                                  SECOND STAGE CALCULATION, FIXED      ZRPA2630
C                                    QUADRATIC                          ZRPA2640
         CALL ZRPQLB (20*ICNT,NZ)                                       ZRPA2650
         IF (NZ.EQ.0) GO TO 130                                         ZRPA2660
C                                  THE SECOND STAGE JUMPS DIRECTLY TO   ZRPA2670
C                                    ONE OF THE THIRD STAGE ITERATIONS  ZRPA2680
C                                    AND RETURNS HERE IF SUCCESSFUL.    ZRPA2690
C                                  DEFLATE THE POLYNOMIAL, STORE THE    ZRPA2700
C                                    ZERO OR ZEROS AND RETURN TO THE    ZRPA2710
C                                    MAIN ALGORITHM.                    ZRPA2720
         J = NDEG-N+1                                                   ZRPA2730
         JJ = J+NDEG                                                    ZRPA2740
         Z(J) = SZR                                                     ZRPA2750
         Z(JJ) = SZI                                                    ZRPA2760
         NN = NN-NZ                                                     ZRPA2770
         N = NN-1                                                       ZRPA2780
         DO 125 I=1,NN                                                  ZRPA2790
  125    P(I) = QP(I)                                                   ZRPA2800
         IF (NZ.EQ.1) GO TO 20                                          ZRPA2810
         Z(J+1) = RLZR                                                  ZRPA2820
         Z(JJ+1) = RLZI                                                 ZRPA2830
         GO TO 20                                                       ZRPA2840
C                                  IF THE ITERATION IS UNSUCCESSFUL     ZRPA2850
C                                    ANOTHER QUADRATIC IS CHOSEN AFTER  ZRPA2860
C                                    RESTORING K                        ZRPA2870
  130    DO 135 I=1,N                                                   ZRPA2880
  135    RK(I) = TEMP(I)                                                ZRPA2890
  140 CONTINUE                                                          ZRPA2900
C                                  RETURN WITH FAILURE IF NO            ZRPA2910
C                                    CONVERGENCE WITH 20 SHIFTS         ZRPA2920
      IER = 131                                                         ZRPA2930
C                                  CONVERT ZEROS (Z) IN COMPLEX FORM    ZRPA2940
  145 DO 150 I=1,NDEG                                                   ZRPA2950
         NPI= NDEG+I                                                    ZRPA2960
         P(I) = Z(NPI)                                                  ZRPA2970
  150 CONTINUE                                                          ZRPA2980
      N2 = NDEG+NDEG                                                    ZRPA2990
      J = NDEG                                                          ZRPA3000
      DO 155 I=1,NDEG                                                   ZRPA3010
         Z(N2-1) = Z(J)                                                 ZRPA3020
         Z(N2) = P(J)                                                   ZRPA3030
         N2 = N2-2                                                      ZRPA3040
         J = J-1                                                        ZRPA3050
  155 CONTINUE                                                          ZRPA3060
      IF (IER .EQ. 0) GO TO 9005                                        ZRPA3070
C                                  SET UNFOUND ROOTS TO MACHINE INFINITYZRPA3080
      N2 = 2*(NDEG-NN)+3                                                ZRPA3090
      DO 160 I=1,N                                                      ZRPA3100
         Z(N2) = RINFP                                                  ZRPA3110
         Z(N2+1) = RINFP                                                ZRPA3120
         N2 = N2+2                                                      ZRPA3130
  160 CONTINUE                                                          ZRPA3140
      GO TO 9000                                                        ZRPA3150
  165 IER = 129                                                         ZRPA3160
 9000 CONTINUE                                                          ZRPA3170
      CALL UERTST (IER,6HZRPOLY)                                        ZRPA3180
 9005 RETURN                                                            ZRPA3190
      END                                                               ZRPA3200
C   IMSL ROUTINE NAME   - ZRPQLB                                        ZRPB0010
C                                                                       ZRPB0020
C-----------------------------------------------------------------------ZRPB0030
C                                                                       ZRPB0040
C   COMPUTER            - VAX/DOUBLE                                    ZRPB0050
C                                                                       ZRPB0060
C   LATEST REVISION     - JANUARY 1, 1978                               ZRPB0070
C                                                                       ZRPB0080
C   PURPOSE             - NUCLEUS CALLED ONLY BY IMSL SUBROUTINE        ZRPB0090
C                           ZRPOLY                                      ZRPB0100
C                                                                       ZRPB0110
C   PRECISION/HARDWARE  - SINGLE AND DOUBLE/H32                         ZRPB0120
C                       - SINGLE/H36,H48,H60                            ZRPB0130
C                                                                       ZRPB0140
C   REQD. IMSL ROUTINES - ZRPQLC,ZRPQLD,ZRPQLE,ZRPQLF,ZRPQLG,ZRPQLH,    ZRPB0150
C                           ZRPQLI                                      ZRPB0160
C                                                                       ZRPB0170
C   NOTATION            - INFORMATION ON SPECIAL NOTATION AND           ZRPB0180
C                           CONVENTIONS IS AVAILABLE IN THE MANUAL      ZRPB0190
C                           INTRODUCTION OR THROUGH IMSL ROUTINE UHELP  ZRPB0200
C                                                                       ZRPB0210
C   COPYRIGHT           - 1978 BY IMSL, INC. ALL RIGHTS RESERVED.       ZRPB0220
C                                                                       ZRPB0230
C   WARRANTY            - IMSL WARRANTS ONLY THAT IMSL TESTING HAS BEEN ZRPB0240
C                           APPLIED TO THIS CODE. NO OTHER WARRANTY,    ZRPB0250
C                           EXPRESSED OR IMPLIED, IS APPLICABLE.        ZRPB0260
C                                                                       ZRPB0270
C-----------------------------------------------------------------------ZRPB0280
C                                                                       ZRPB0290
      SUBROUTINE ZRPQLB (L2,NZ)                                         ZRPB0300
C                                  SPECIFICATIONS FOR ARGUMENTS         ZRPB0310
      INTEGER            L2,NZ                                          ZRPB0320
C                                  SPECIFICATIONS FOR LOCAL VARIABLES   ZRPB0330
      INTEGER            N,NN,J,ITYPE,I,IFLAG                           ZRPB0340
      DOUBLE PRECISION   ARE,BETAS,BETAV,ETA,OSS,OTS,OTV,OVV,RMRE,SS,   ZRPB0350
     1                   TS,TSS,TV,TVV,VV                               ZRPB0360
      DOUBLE PRECISION   P(101),QP(101),RK(101),QK(101),SVK(101)        ZRPB0370
      DOUBLE PRECISION   SR,SI,U,V,RA,RB,C,D,A1,A2,A3,                  ZRPB0380
     1                   A6,A7,E,F,G,H,SZR,SZI,RLZR,RLZI,               ZRPB0390
     2                   SVU,SVV,UI,VI,S,ZERO                           ZRPB0400
      LOGICAL            VPASS,SPASS,VTRY,STRY                          ZRPB0410
      COMMON /ZRPQLJ/    P,QP,RK,QK,SVK,SR,SI,U,V,RA,RB,C,D,A1,A2,A3,A6,ZRPB0420
     1                   A7,E,F,G,H,SZR,SZI,RLZR,RLZI,ETA,ARE,RMRE,N,NN ZRPB0430
      DATA               ZERO/0.0D0/                                    ZRPB0440
C                                  FIRST EXECUTABLE STATEMENT           ZRPB0450
      NZ = 0                                                            ZRPB0460
C                                  COMPUTES UP TO L2 FIXED SHIFT        ZRPB0470
C                                    K-POLYNOMIALS, TESTING FOR         ZRPB0480
C                                    CONVERGENCE IN THE LINEAR OR       ZRPB0490
C                                    QUADRATIC CASE. INITIATES ONE OF   ZRPB0500
C                                    THE VARIABLE SHIFT ITERATIONS AND  ZRPB0510
C                                    RETURNS WITH THE NUMBER OF ZEROS   ZRPB0520
C                                    FOUND.                             ZRPB0530
C                                  L2 - LIMIT OF FIXED SHIFT STEPS      ZRPB0540
C                                  NZ -NUMBER OF ZEROS FOUND            ZRPB0550
      BETAV = .25                                                       ZRPB0560
      BETAS = .25                                                       ZRPB0570
      OSS = SR                                                          ZRPB0580
      OVV = V                                                           ZRPB0590
C                                  EVALUATE POLYNOMIAL BY SYNTHETIC     ZRPB0600
C                                    DIVISION                           ZRPB0610
      CALL ZRPQLH (NN,U,V,P,QP,RA,RB)                                   ZRPB0620
      CALL ZRPQLE (ITYPE)                                               ZRPB0630
      DO 40 J=1,L2                                                      ZRPB0640
C                                  CALCULATE NEXT K POLYNOMIAL AND      ZRPB0650
C                                    ESTIMATE V                         ZRPB0660
         CALL ZRPQLF (ITYPE)                                            ZRPB0670
         CALL ZRPQLE (ITYPE)                                            ZRPB0680
         CALL ZRPQLG (ITYPE,UI,VI)                                      ZRPB0690
         VV = VI                                                        ZRPB0700
C                                  ESTIMATE S                           ZRPB0710
         SS = 0.                                                        ZRPB0720
         IF (RK(N).NE.ZERO) SS = -P(NN)/RK(N)                           ZRPB0730
         TV = 1.                                                        ZRPB0740
         TS = 1.                                                        ZRPB0750
         IF (J.EQ.1.OR.ITYPE.EQ.3) GO TO 35                             ZRPB0760
C                                  COMPUTE RELATIVE MEASURES OF         ZRPB0770
C                                    CONVERGENCE OF S AND V SEQUENCES   ZRPB0780
         IF (VV.NE.0.) TV = ABS((VV-OVV)/VV)                            ZRPB0790
         IF (SS.NE.0.) TS = ABS((SS-OSS)/SS)                            ZRPB0800
C                                  IF DECREASING, MULTIPLY TWO MOST     ZRPB0810
C                                    RECENT CONVERGENCE MEASURES        ZRPB0820
         TVV = 1.                                                       ZRPB0830
         IF (TV.LT.OTV) TVV = TV*OTV                                    ZRPB0840
         TSS = 1.                                                       ZRPB0850
         IF (TS.LT.OTS) TSS = TS*OTS                                    ZRPB0860
C                                  COMPARE WITH CONVERGENCE CRITERIA    ZRPB0870
         VPASS = TVV.LT.BETAV                                           ZRPB0880
         SPASS = TSS.LT.BETAS                                           ZRPB0890
         IF (.NOT.(SPASS.OR.VPASS)) GO TO 35                            ZRPB0900
C                                  AT LEAST ONE SEQUENCE HAS PASSED THE ZRPB0910
C                                    CONVERGENCE TEST. STORE VARIABLES  ZRPB0920
C                                    BEFORE ITERATING                   ZRPB0930
         SVU = U                                                        ZRPB0940
         SVV = V                                                        ZRPB0950
         DO 5 I=1,N                                                     ZRPB0960
    5    SVK(I) = RK(I)                                                 ZRPB0970
         S = SS                                                         ZRPB0980
C                                  CHOOSE ITERATION ACCORDING TO THE    ZRPB0990
C                                    FASTEST CONVERGING SEQUENCE        ZRPB1000
         VTRY = .FALSE.                                                 ZRPB1010
         STRY = .FALSE.                                                 ZRPB1020
         IF (SPASS.AND.((.NOT.VPASS).OR.TSS.LT.TVV)) GO TO 20           ZRPB1030
   10    CALL ZRPQLC (UI,VI,NZ)                                         ZRPB1040
         IF (NZ.GT.0) RETURN                                            ZRPB1050
C                                  QUADRATIC ITERATION HAS FAILED. FLAG ZRPB1060
C                                    THAT IT HAS BEEN TRIED AND         ZRPB1070
C                                    DECREASE THE CONVERGENCE           ZRPB1080
C                                    CRITERION.                         ZRPB1090
         VTRY = .TRUE.                                                  ZRPB1100
         BETAV = BETAV*.25                                              ZRPB1110
C                                  TRY LINEAR ITERATION IF IT HAS NOT   ZRPB1120
C                                    BEEN TRIED AND THE S SEQUENCE IS   ZRPB1130
C                                    CONVERGING                         ZRPB1140
         IF (STRY.OR.(.NOT.SPASS)) GO TO 25                             ZRPB1150
         DO 15 I=1,N                                                    ZRPB1160
   15    RK(I) = SVK(I)                                                 ZRPB1170
   20    CALL ZRPQLD (S,NZ,IFLAG)                                       ZRPB1180
         IF (NZ.GT.0) RETURN                                            ZRPB1190
C                                  LINEAR ITERATION HAS FAILED. FLAG    ZRPB1200
C                                    THAT IT HAS BEEN TRIED AND         ZRPB1210
C                                    DECREASE THE CONVERGENCE CRITERION ZRPB1220
         STRY = .TRUE.                                                  ZRPB1230
         BETAS = BETAS*.25                                              ZRPB1240
         IF (IFLAG.EQ.0) GO TO 25                                       ZRPB1250
C                                  IF LINEAR ITERATION SIGNALS AN       ZRPB1260
C                                    ALMOST DOUBLE REAL ZERO ATTEMPT    ZRPB1270
C                                    QUADRATIC INTERATION               ZRPB1280
         UI = -(S+S)                                                    ZRPB1290
         VI = S*S                                                       ZRPB1300
         GO TO 10                                                       ZRPB1310
C                                  RESTORE VARIABLES                    ZRPB1320
   25    U = SVU                                                        ZRPB1330
         V = SVV                                                        ZRPB1340
         DO 30 I=1,N                                                    ZRPB1350
   30    RK(I) = SVK(I)                                                 ZRPB1360
C                                  TRY QUADRATIC ITERATION IF IT HAS    ZRPB1370
C                                    NOT BEEN TRIED AND THE V SEQUENCE  ZRPB1380
C                                    IS CONVERGING                      ZRPB1390
         IF (VPASS.AND.(.NOT.VTRY)) GO TO 10                            ZRPB1400
C                                  RECOMPUTE QP AND SCALAR VALUES TO    ZRPB1410
C                                    CONTINUE THE SECOND STAGE          ZRPB1420
         CALL ZRPQLH (NN,U,V,P,QP,RA,RB)                                ZRPB1430
         CALL ZRPQLE (ITYPE)                                            ZRPB1440
   35    OVV = VV                                                       ZRPB1450
         OSS = SS                                                       ZRPB1460
         OTV = TV                                                       ZRPB1470
         OTS = TS                                                       ZRPB1480
   40 CONTINUE                                                          ZRPB1490
      RETURN                                                            ZRPB1500
      END                                                               ZRPB1510
C   IMSL ROUTINE NAME   - ZRPQLC                                        ZRPC0010
C                                                                       ZRPC0020
C-----------------------------------------------------------------------ZRPC0030
C                                                                       ZRPC0040
C   COMPUTER            - VAX/DOUBLE                                    ZRPC0050
C                                                                       ZRPC0060
C   LATEST REVISION     - JANUARY 1, 1978                               ZRPC0070
C                                                                       ZRPC0080
C   PURPOSE             - NUCLEUS CALLED ONLY BY IMSL SUBROUTINE        ZRPC0090
C                           ZRPOLY                                      ZRPC0100
C                                                                       ZRPC0110
C   PRECISION/HARDWARE  - SINGLE AND DOUBLE/H32                         ZRPC0120
C                       - SINGLE/H36,H48,H60                            ZRPC0130
C                                                                       ZRPC0140
C   REQD. IMSL ROUTINES - ZRPQLE,ZRPQLF,ZRPQLG,ZRPQLH,ZRPQLI            ZRPC0150
C                                                                       ZRPC0160
C   NOTATION            - INFORMATION ON SPECIAL NOTATION AND           ZRPC0170
C                           CONVENTIONS IS AVAILABLE IN THE MANUAL      ZRPC0180
C                           INTRODUCTION OR THROUGH IMSL ROUTINE UHELP  ZRPC0190
C                                                                       ZRPC0200
C   COPYRIGHT           - 1978 BY IMSL, INC. ALL RIGHTS RESERVED.       ZRPC0210
C                                                                       ZRPC0220
C   WARRANTY            - IMSL WARRANTS ONLY THAT IMSL TESTING HAS BEEN ZRPC0230
C                           APPLIED TO THIS CODE. NO OTHER WARRANTY,    ZRPC0240
C                           EXPRESSED OR IMPLIED, IS APPLICABLE.        ZRPC0250
C                                                                       ZRPC0260
C-----------------------------------------------------------------------ZRPC0270
C                                                                       ZRPC0280
      SUBROUTINE ZRPQLC (UU,VV,NZ)                                      ZRPC0290
C                                  SPECIFICATIONS FOR ARGUMENTS         ZRPC0300
      INTEGER            NZ                                             ZRPC0310
      DOUBLE PRECISION   UU,VV                                          ZRPC0320
C                                  SPECIFICATIONS FOR LOCAL VARIABLES   ZRPC0330
      INTEGER            N,NN,J,I,ITYPE                                 ZRPC0340
      DOUBLE PRECISION   ARE,EE,ETA,OMP,RELSTP,RMP,RMRE,T,ZM            ZRPC0350
      DOUBLE PRECISION   P(101),QP(101),RK(101),QK(101),SVK(101)        ZRPC0360
      DOUBLE PRECISION   SR,SI,U,V,RA,RB,C,D,A1,A2,A3,                  ZRPC0370
     1                   A6,A7,E,F,G,H,SZR,SZI,RLZR,RLZI,               ZRPC0380
     2                   UI,VI,ZERO,PT01,ONE                            ZRPC0390
      LOGICAL            TRIED                                          ZRPC0400
      COMMON /ZRPQLJ/    P,QP,RK,QK,SVK,SR,SI,U,V,RA,RB,C,D,A1,A2,A3,A6,ZRPC0410
     1                   A7,E,F,G,H,SZR,SZI,RLZR,RLZI,ETA,ARE,RMRE,N,NN ZRPC0420
      DATA               ZERO,PT01,ONE/0.0D0,0.01D0,1.0D0/              ZRPC0430
C                                  FIRST EXECUTABLE STATEMENT           ZRPC0440
      NZ = 0                                                            ZRPC0450
C                                  VARIABLE-SHIFT K-POLYNOMIAL          ZRPC0460
C                                    ITERATION FOR A QUADRATIC FACTOR   ZRPC0470
C                                    CONVERGES ONLY IF THE ZEROS ARE    ZRPC0480
C                                    EQUIMODULAR OR NEARLY SO           ZRPC0490
C                                  UU,VV - COEFFICIENTS OF STARTING     ZRPC0500
C                                    QUADRATIC                          ZRPC0510
C                                  NZ - NUMBER OF ZERO FOUND            ZRPC0520
      TRIED = .FALSE.                                                   ZRPC0530
      U = UU                                                            ZRPC0540
      V = VV                                                            ZRPC0550
      J = 0                                                             ZRPC0560
C                                  MAIN LOOP                            ZRPC0570
    5 CALL ZRPQLI (ONE,U,V,SZR,SZI,RLZR,RLZI)                           ZRPC0580
C                                  RETURN IF ROOTS OF THE QUADRATIC ARE ZRPC0590
C                                    REAL AND NOT CLOSE TO MULTIPLE OR  ZRPC0600
C                                    NEARLY EQUAL AND OF OPPOSITE SIGN  ZRPC0610
      IF ( DABS(DABS(SZR)-DABS(RLZR)).GT.PT01*DABS(RLZR)) RETURN        ZRPC0620
C                                  EVALUATE POLYNOMIAL BY QUADRATIC     ZRPC0630
C                                    SYNTHETIC DIVISION                 ZRPC0640
      CALL ZRPQLH (NN,U,V,P,QP,RA,RB)                                   ZRPC0650
      RMP = DABS(RA-SZR*RB)+DABS(SZI*RB)                                ZRPC0660
C                                  COMPUTE A RIGOROUS BOUND ON THE      ZRPC0670
C                                    ROUNDING ERROR IN EVALUTING P      ZRPC0680
      ZM = SQRT(ABS(SNGL(V)))                                           ZRPC0690
      EE = 2.*ABS(SNGL(QP(1)))                                          ZRPC0700
      T = -SZR*RB                                                       ZRPC0710
      DO 10 I=2,N                                                       ZRPC0720
   10 EE = EE*ZM+ABS(SNGL(QP(I)))                                       ZRPC0730
      EE = EE*ZM+ABS(SNGL(RA)+T)                                        ZRPC0740
      EE = (5.*RMRE+4.*ARE)*EE-(5.*RMRE+2.*ARE)*(ABS(SNGL(RA)+T)+       ZRPC0750
     1     ABS(SNGL(RB))*ZM)+2.*ARE*ABS(T)                              ZRPC0760
C                                  ITERATION HAS CONVERGED SUFFICIENTLY ZRPC0770
C                                    IF THE POLYNOMIAL VALUE IS LESS    ZRPC0780
C                                    THAN 20 TIMES THIS BOUND           ZRPC0790
      IF (RMP.GT.20.*EE) GO TO 15                                       ZRPC0800
      NZ = 2                                                            ZRPC0810
      RETURN                                                            ZRPC0820
   15 J = J+1                                                           ZRPC0830
C                                  STOP ITERATION AFTER 20 STEPS        ZRPC0840
      IF (J.GT.20) RETURN                                               ZRPC0850
      IF (J.LT.2) GO TO 25                                              ZRPC0860
      IF (RELSTP.GT..01.OR.RMP.LT.OMP.OR.TRIED) GO TO 25                ZRPC0870
C                                  A CLUSTER APPEARS TO BE STALLING THE ZRPC0880
C                                    CONVERGENCE. FIVE FIXED SHIFT      ZRPC0890
C                                    STEPS ARE TAKEN WITH A U,V CLOSE   ZRPC0900
C                                    TO THE CLUSTER                     ZRPC0910
      IF (RELSTP.LT.ETA) RELSTP = ETA                                   ZRPC0920
      RELSTP = SQRT(RELSTP)                                             ZRPC0930
      U = U-U*RELSTP                                                    ZRPC0940
      V = V+V*RELSTP                                                    ZRPC0950
      CALL ZRPQLH (NN,U,V,P,QP,RA,RB)                                   ZRPC0960
      DO 20 I=1,5                                                       ZRPC0970
         CALL ZRPQLE (ITYPE)                                            ZRPC0980
         CALL ZRPQLF (ITYPE)                                            ZRPC0990
   20 CONTINUE                                                          ZRPC1000
      TRIED = .TRUE.                                                    ZRPC1010
      J = 0                                                             ZRPC1020
   25 OMP = RMP                                                         ZRPC1030
C                                  CALCULATE NEXT K POLYNOMIAL AND NEW  ZRPC1040
C                                    U AND V                            ZRPC1050
      CALL ZRPQLE (ITYPE)                                               ZRPC1060
      CALL ZRPQLF (ITYPE)                                               ZRPC1070
      CALL ZRPQLE (ITYPE)                                               ZRPC1080
      CALL ZRPQLG (ITYPE,UI,VI)                                         ZRPC1090
C                                  IF VI IS ZERO THE ITERATION IS NOT   ZRPC1100
C                                    CONVERGING                         ZRPC1110
      IF (VI.EQ.ZERO) RETURN                                            ZRPC1120
      RELSTP = DABS((VI-V)/VI)                                          ZRPC1130
      U = UI                                                            ZRPC1140
      V = VI                                                            ZRPC1150
      GO TO 5                                                           ZRPC1160
      END                                                               ZRPC1170
C   IMSL ROUTINE NAME   - ZRPQLD                                        ZRPD0010
C                                                                       ZRPD0020
C-----------------------------------------------------------------------ZRPD0030
C                                                                       ZRPD0040
C   COMPUTER            - VAX/DOUBLE                                    ZRPD0050
C                                                                       ZRPD0060
C   LATEST REVISION     - JANUARY 1, 1978                               ZRPD0070
C                                                                       ZRPD0080
C   PURPOSE             - NUCLEUS CALLED ONLY BY IMSL SUBROUTINE        ZRPD0090
C                           ZRPOLY                                      ZRPD0100
C                                                                       ZRPD0110
C   PRECISION/HARDWARE  - SINGLE AND DOUBLE/H32                         ZRPD0120
C                       - SINGLE/H36,H48,H60                            ZRPD0130
C                                                                       ZRPD0140
C   REQD. IMSL ROUTINES - NONE REQUIRED                                 ZRPD0150
C                                                                       ZRPD0160
C   NOTATION            - INFORMATION ON SPECIAL NOTATION AND           ZRPD0170
C                           CONVENTIONS IS AVAILABLE IN THE MANUAL      ZRPD0180
C                           INTRODUCTION OR THROUGH IMSL ROUTINE UHELP  ZRPD0190
C                                                                       ZRPD0200
C   COPYRIGHT           - 1978 BY IMSL, INC. ALL RIGHTS RESERVED.       ZRPD0210
C                                                                       ZRPD0220
C   WARRANTY            - IMSL WARRANTS ONLY THAT IMSL TESTING HAS BEEN ZRPD0230
C                           APPLIED TO THIS CODE. NO OTHER WARRANTY,    ZRPD0240
C                           EXPRESSED OR IMPLIED, IS APPLICABLE.        ZRPD0250
C                                                                       ZRPD0260
C-----------------------------------------------------------------------ZRPD0270
C                                                                       ZRPD0280
      SUBROUTINE ZRPQLD (SSS,NZ,IFLAG)                                  ZRPD0290
C                                  SPECIFICATIONS FOR ARGUMENTS         ZRPD0300
      INTEGER            NZ,IFLAG                                       ZRPD0310
      DOUBLE PRECISION   SSS                                            ZRPD0320
C                                  SPECIFICATIONS FOR LOCAL VARIABLES   ZRPD0330
      INTEGER            N,NN,J,I                                       ZRPD0340
      DOUBLE PRECISION   ARE,EE,ETA,OMP,RMP,RMS,RMRE                    ZRPD0350
      DOUBLE PRECISION   P(101),QP(101),RK(101),QK(101),SVK(101)        ZRPD0360
      DOUBLE PRECISION   SR,SI,U,V,RA,RB,C,D,A1,A2,A3,                  ZRPD0370
     1                   A6,A7,E,F,G,H,SZR,SZI,RLZR,RLZI,               ZRPD0380
     2                   PV,RKV,T,S,ZERO,PT001                          ZRPD0390
      COMMON /ZRPQLJ/    P,QP,RK,QK,SVK,SR,SI,U,V,RA,RB,C,D,A1,A2,A3,A6,ZRPD0400
     1                   A7,E,F,G,H,SZR,SZI,RLZR,RLZI,ETA,ARE,RMRE,N,NN ZRPD0410
      DATA               ZERO/0.0D0/,PT001/0.001D0/                     ZRPD0420
C                                  VARIABLE-SHIFT H POLYNOMIAL          ZRPD0430
C                                    ITERATION FOR A REAL ZERO SSS -    ZRPD0440
C                                    STARTING ITERATE                   ZRPD0450
C                                  NZ - NUMBER OF ZERO FOUND            ZRPD0460
C                                  IFLAG - FLAG TO INDICATE A PAIR OF   ZRPD0470
C                                    ZEROS NEAR REAL AXIS               ZRPD0480
C                                  FIRST EXECUTABLE STATEMENT           ZRPD0490
      NZ = 0                                                            ZRPD0500
      S = SSS                                                           ZRPD0510
      IFLAG = 0                                                         ZRPD0520
      J = 0                                                             ZRPD0530
C                                  MAIN LOOP                            ZRPD0540
    5 PV = P(1)                                                         ZRPD0550
C                                  EVALUATE P AT S                      ZRPD0560
      QP(1) = PV                                                        ZRPD0570
      DO 10 I=2,NN                                                      ZRPD0580
         PV = PV*S+P(I)                                                 ZRPD0590
         QP(I) = PV                                                     ZRPD0600
   10 CONTINUE                                                          ZRPD0610
      RMP = DABS(PV)                                                    ZRPD0620
C                                  COMPUTE A RIGOROUS BOUND ON THE      ZRPD0630
C                                    ERROR IN EVALUATING P              ZRPD0640
      RMS = DABS(S)                                                     ZRPD0650
      EE = (RMRE/(ARE+RMRE))*ABS(SNGL(QP(1)))                           ZRPD0660
      DO 15 I=2,NN                                                      ZRPD0670
   15 EE = EE*RMS+ABS(SNGL(QP(I)))                                      ZRPD0680
C                                  ITERATION HAS CONVERGED SUFFICIENTLY ZRPD0690
C                                    IF THE POLYNOMIAL VALUE IS LESS    ZRPD0700
C                                    THAN 20 TIMES THIS BOUND           ZRPD0710
      IF (RMP.GT.20.*((ARE+RMRE)*EE-RMRE*RMP)) GO TO 20                 ZRPD0720
      NZ = 1                                                            ZRPD0730
      SZR = S                                                           ZRPD0740
      SZI = ZERO                                                        ZRPD0750
      RETURN                                                            ZRPD0760
   20 J = J+1                                                           ZRPD0770
C                                  STOP ITERATION AFTER 10 STEPS        ZRPD0780
      IF (J.GT.10) RETURN                                               ZRPD0790
      IF (J.LT.2) GO TO 25                                              ZRPD0800
      IF (DABS(T).GT.PT001*DABS(S-T).OR.RMP.LE.OMP) GO TO 25            ZRPD0810
C                                  A CLUSTER OF ZEROS NEAR THE REAL     ZRPD0820
C                                    AXIS HAS BEEN ENCOUNTERED RETURN   ZRPD0830
C                                    WITH IFLAG SET TO INITIATE A       ZRPD0840
C                                    QUADRATIC ITERATION                ZRPD0850
      IFLAG = 1                                                         ZRPD0860
      SSS = S                                                           ZRPD0870
      RETURN                                                            ZRPD0880
C                                  RETURN IF THE POLYNOMIAL VALUE HAS   ZRPD0890
C                                    INCREASED SIGNIFICANTLY            ZRPD0900
   25 OMP = RMP                                                         ZRPD0910
C                                  COMPUTE T, THE NEXT POLYNOMIAL, AND  ZRPD0920
C                                    THE NEW ITERATE                    ZRPD0930
      RKV = RK(1)                                                       ZRPD0940
      QK(1) = RKV                                                       ZRPD0950
      DO 30 I=2,N                                                       ZRPD0960
         RKV = RKV*S+RK(I)                                              ZRPD0970
         QK(I) = RKV                                                    ZRPD0980
   30 CONTINUE                                                          ZRPD0990
      IF (DABS(RKV).LE.DABS(RK(N))*10.*ETA) GO TO 40                    ZRPD1000
C                                  USE THE SCALED FORM OF THE           ZRPD1010
C                                    RECURRENCE IF THE VALUE OF K AT S  ZRPD1020
C                                    IS NONZERO                         ZRPD1030
      T = -PV/RKV                                                       ZRPD1040
      RK(1) = QP(1)                                                     ZRPD1050
      DO 35 I=2,N                                                       ZRPD1060
   35 RK(I) = T*QK(I-1)+QP(I)                                           ZRPD1070
      GO TO 50                                                          ZRPD1080
C                                  USE UNSCALED FORM                    ZRPD1090
   40 RK(1) = ZERO                                                      ZRPD1100
      DO 45 I=2,N                                                       ZRPD1110
   45 RK(I) = QK(I-1)                                                   ZRPD1120
   50 RKV = RK(1)                                                       ZRPD1130
      DO 55 I=2,N                                                       ZRPD1140
   55 RKV = RKV*S+RK(I)                                                 ZRPD1150
      T = ZERO                                                          ZRPD1160
      IF (DABS(RKV).GT.DABS(RK(N))*10.*ETA) T = -PV/RKV                 ZRPD1170
      S = S+T                                                           ZRPD1180
      GO TO 5                                                           ZRPD1190
      END                                                               ZRPD1200
C   IMSL ROUTINE NAME   - ZRPQLE                                        ZRPE0010
C                                                                       ZRPE0020
C-----------------------------------------------------------------------ZRPE0030
C                                                                       ZRPE0040
C   COMPUTER            - VAX/DOUBLE                                    ZRPE0050
C                                                                       ZRPE0060
C   LATEST REVISION     - JANUARY 1, 1978                               ZRPE0070
C                                                                       ZRPE0080
C   PURPOSE             - NUCLEUS CALLED ONLY BY IMSL SUBROUTINE        ZRPE0090
C                           ZRPOLY                                      ZRPE0100
C                                                                       ZRPE0110
C   PRECISION/HARDWARE  - SINGLE AND DOUBLE/H32                         ZRPE0120
C                       - SINGLE/H36,H48,H60                            ZRPE0130
C                                                                       ZRPE0140
C   REQD. IMSL ROUTINES - ZRPQLH                                        ZRPE0150
C                                                                       ZRPE0160
C   NOTATION            - INFORMATION ON SPECIAL NOTATION AND           ZRPE0170
C                           CONVENTIONS IS AVAILABLE IN THE MANUAL      ZRPE0180
C                           INTRODUCTION OR THROUGH IMSL ROUTINE UHELP  ZRPE0190
C                                                                       ZRPE0200
C   COPYRIGHT           - 1978 BY IMSL, INC. ALL RIGHTS RESERVED.       ZRPE0210
C                                                                       ZRPE0220
C   WARRANTY            - IMSL WARRANTS ONLY THAT IMSL TESTING HAS BEEN ZRPE0230
C                           APPLIED TO THIS CODE. NO OTHER WARRANTY,    ZRPE0240
C                           EXPRESSED OR IMPLIED, IS APPLICABLE.        ZRPE0250
C                                                                       ZRPE0260
C-----------------------------------------------------------------------ZRPE0270
C                                                                       ZRPE0280
      SUBROUTINE ZRPQLE (ITYPE)                                         ZRPE0290
C                                  SPECIFICATIONS FOR ARGUMENTS         ZRPE0300
      INTEGER            ITYPE                                          ZRPE0310
C                                  SPECIFICATIONS FOR LOCAL VARIABLES   ZRPE0320
      INTEGER            N,NN                                           ZRPE0330
      DOUBLE PRECISION   ARE,ETA,RMRE                                   ZRPE0340
      DOUBLE PRECISION   P(101),QP(101),RK(101),QK(101),SVK(101)        ZRPE0350
      DOUBLE PRECISION   SR,SI,U,V,RA,RB,C,D,A1,A2,A3,                  ZRPE0360
     1                   A6,A7,E,F,G,H,SZR,SZI,RLZR,RLZI                ZRPE0370
      COMMON /ZRPQLJ/    P,QP,RK,QK,SVK,SR,SI,U,V,RA,RB,C,D,A1,A2,A3,A6,ZRPE0380
     1                   A7,E,F,G,H,SZR,SZI,RLZR,RLZI,ETA,ARE,RMRE,N,NN ZRPE0390
C                                  THIS ROUTINE CALCULATES SCALAR       ZRPE0400
C                                    QUANTITIES USED TO COMPUTE THE     ZRPE0410
C                                    NEXT K POLYNOMIAL AND NEW          ZRPE0420
C                                    ESTIMATES OF THE QUADRATIC         ZRPE0430
C                                    COEFFICIENTS                       ZRPE0440
C                                  ITYPE - INTEGER VARIABLE SET HERE    ZRPE0450
C                                    INDICATING HOW THE CALCULATIONS    ZRPE0460
C                                    ARE NORMALIZED TO AVOID OVERFLOW   ZRPE0470
C                                  SYNTHETIC DIVISION OF K BY THE       ZRPE0480
C                                    QUADRATIC 1,U,V                    ZRPE0490
C                                  FIRST EXECUTABLE STATEMENT           ZRPE0500
      CALL ZRPQLH (N,U,V,RK,QK,C,D)                                     ZRPE0510
      IF (DABS(C).GT.DABS(RK(N))*100.*ETA) GO TO 5                      ZRPE0520
      IF (DABS(D).GT.DABS(RK(N-1))*100.*ETA) GO TO 5                    ZRPE0530
      ITYPE = 3                                                         ZRPE0540
C                                  TYPE=3 INDICATES THE QUADRATIC IS    ZRPE0550
C                                    ALMOST A FACTOR OF K               ZRPE0560
      RETURN                                                            ZRPE0570
    5 IF (DABS(D).LT.DABS(C)) GO TO 10                                  ZRPE0580
      ITYPE = 2                                                         ZRPE0590
C                                  TYPE=2 INDICATES THAT ALL FORMULAS   ZRPE0600
C                                    ARE DIVIDED BY D                   ZRPE0610
      E = RA/D                                                          ZRPE0620
      F = C/D                                                           ZRPE0630
      G = U*RB                                                          ZRPE0640
      H = V*RB                                                          ZRPE0650
      A3 = (RA+G)*E+H*(RB/D)                                            ZRPE0660
      A1 = RB*F-RA                                                      ZRPE0670
      A7 = (F+U)*RA+H                                                   ZRPE0680
      RETURN                                                            ZRPE0690
   10 ITYPE = 1                                                         ZRPE0700
C                                  TYPE=1 INDICATES THAT ALL FORMULAS   ZRPE0710
C                                    ARE DIVIDED BY C                   ZRPE0720
      E = RA/C                                                          ZRPE0730
      F = D/C                                                           ZRPE0740
      G = U*E                                                           ZRPE0750
      H = V*RB                                                          ZRPE0760
      A3 = RA*E+(H/C+G)*RB                                              ZRPE0770
      A1 = RB-RA*(D/C)                                                  ZRPE0780
      A7 = RA+G*D+H*F                                                   ZRPE0790
      RETURN                                                            ZRPE0800
      END                                                               ZRPE0810
C   IMSL ROUTINE NAME   - ZRPQLF                                        ZRPF0010
C                                                                       ZRPF0020
C-----------------------------------------------------------------------ZRPF0030
C                                                                       ZRPF0040
C   COMPUTER            - VAX/DOUBLE                                    ZRPF0050
C                                                                       ZRPF0060
C   LATEST REVISION     - JANUARY 1, 1978                               ZRPF0070
C                                                                       ZRPF0080
C   PURPOSE             - NUCLEUS CALLED ONLY BY IMSL SUBROUTINE        ZRPF0090
C                           ZRPOLY                                      ZRPF0100
C                                                                       ZRPF0110
C   PRECISION/HARDWARE  - SINGLE AND DOUBLE/H32                         ZRPF0120
C                       - SINGLE/H36,H48,H60                            ZRPF0130
C                                                                       ZRPF0140
C   REQD. IMSL ROUTINES - NONE REQUIRED                                 ZRPF0150
C                                                                       ZRPF0160
C   NOTATION            - INFORMATION ON SPECIAL NOTATION AND           ZRPF0170
C                           CONVENTIONS IS AVAILABLE IN THE MANUAL      ZRPF0180
C                           INTRODUCTION OR THROUGH IMSL ROUTINE UHELP  ZRPF0190
C                                                                       ZRPF0200
C   COPYRIGHT           - 1978 BY IMSL, INC. ALL RIGHTS RESERVED.       ZRPF0210
C                                                                       ZRPF0220
C   WARRANTY            - IMSL WARRANTS ONLY THAT IMSL TESTING HAS BEEN ZRPF0230
C                           APPLIED TO THIS CODE. NO OTHER WARRANTY,    ZRPF0240
C                           EXPRESSED OR IMPLIED, IS APPLICABLE.        ZRPF0250
C                                                                       ZRPF0260
C-----------------------------------------------------------------------ZRPF0270
C                                                                       ZRPF0280
      SUBROUTINE ZRPQLF (ITYPE)                                         ZRPF0290
C                                  SPECIFICATIONS FOR ARGUMENTS         ZRPF0300
      INTEGER            ITYPE                                          ZRPF0310
C                                  SPECIFICATIONS FOR LOCAL VARIABLES   ZRPF0320
      INTEGER            N,NN,I                                         ZRPF0330
      DOUBLE PRECISION   ARE,ETA,RMRE                                   ZRPF0340
      DOUBLE PRECISION   P(101),QP(101),RK(101),QK(101),SVK(101)        ZRPF0350
      DOUBLE PRECISION   SR,SI,U,V,RA,RB,C,D,A1,A2,A3,                  ZRPF0360
     1                   A6,A7,E,F,G,H,SZR,SZI,RLZR,RLZI,TEMP,ZERO      ZRPF0370
      COMMON /ZRPQLJ/    P,QP,RK,QK,SVK,SR,SI,U,V,RA,RB,C,D,A1,A2,A3,A6,ZRPF0380
     1                   A7,E,F,G,H,SZR,SZI,RLZR,RLZI,ETA,ARE,RMRE,N,NN ZRPF0390
      DATA               ZERO/0.0D0/                                    ZRPF0400
C                                  COMPUTES THE NEXT K POLYNOMIALS      ZRPF0410
C                                    USING SCALARS COMPUTED IN ZRPQLE   ZRPF0420
C                                  FIRST EXECUTABLE STATEMENT           ZRPF0430
      IF (ITYPE.EQ.3) GO TO 20                                          ZRPF0440
      TEMP = RA                                                         ZRPF0450
      IF (ITYPE.EQ.1) TEMP = RB                                         ZRPF0460
      IF (DABS(A1).GT.DABS(TEMP)*ETA*10.) GO TO 10                      ZRPF0470
C                                  IF A1 IS NEARLY ZERO THEN USE A      ZRPF0480
C                                    SPECIAL FORM OF THE RECURRENCE     ZRPF0490
      RK(1) = ZERO                                                      ZRPF0500
      RK(2) = -A7*QP(1)                                                 ZRPF0510
      DO 5 I=3,N                                                        ZRPF0520
    5 RK(I) = A3*QK(I-2)-A7*QP(I-1)                                     ZRPF0530
      RETURN                                                            ZRPF0540
C                                  USE SCALED FORM OF THE RECURRENCE    ZRPF0550
   10 A7 = A7/A1                                                        ZRPF0560
      A3 = A3/A1                                                        ZRPF0570
      RK(1) = QP(1)                                                     ZRPF0580
      RK(2) = QP(2)-A7*QP(1)                                            ZRPF0590
      DO 15 I=3,N                                                       ZRPF0600
   15 RK(I) = A3*QK(I-2)-A7*QP(I-1)+QP(I)                               ZRPF0610
      RETURN                                                            ZRPF0620
C                                  USE UNSCALED FORM OF THE RECURRENCE  ZRPF0630
C                                    IF TYPE IS 3                       ZRPF0640
   20 RK(1) = ZERO                                                      ZRPF0650
      RK(2) = ZERO                                                      ZRPF0660
      DO 25 I=3,N                                                       ZRPF0670
   25 RK(I) = QK(I-2)                                                   ZRPF0680
      RETURN                                                            ZRPF0690
      END                                                               ZRPF0700
C   IMSL ROUTINE NAME   - ZRPQLG                                        ZRPG0010
C                                                                       ZRPG0020
C-----------------------------------------------------------------------ZRPG0030
C                                                                       ZRPG0040
C   COMPUTER            - VAX/DOUBLE                                    ZRPG0050
C                                                                       ZRPG0060
C   LATEST REVISION     - JANUARY 1, 1978                               ZRPG0070
C                                                                       ZRPG0080
C   PURPOSE             - NUCLEUS CALLED ONLY BY IMSL SUBROUTINE        ZRPG0090
C                           ZRPOLY                                      ZRPG0100
C                                                                       ZRPG0110
C   PRECISION/HARDWARE  - SINGLE AND DOUBLE/H32                         ZRPG0120
C                       - SINGLE/H36,H48,H60                            ZRPG0130
C                                                                       ZRPG0140
C   REQD. IMSL ROUTINES - NONE REQUIRED                                 ZRPG0150
C                                                                       ZRPG0160
C   NOTATION            - INFORMATION ON SPECIAL NOTATION AND           ZRPG0170
C                           CONVENTIONS IS AVAILABLE IN THE MANUAL      ZRPG0180
C                           INTRODUCTION OR THROUGH IMSL ROUTINE UHELP  ZRPG0190
C                                                                       ZRPG0200
C   COPYRIGHT           - 1978 BY IMSL, INC. ALL RIGHTS RESERVED.       ZRPG0210
C                                                                       ZRPG0220
C   WARRANTY            - IMSL WARRANTS ONLY THAT IMSL TESTING HAS BEEN ZRPG0230
C                           APPLIED TO THIS CODE. NO OTHER WARRANTY,    ZRPG0240
C                           EXPRESSED OR IMPLIED, IS APPLICABLE.        ZRPG0250
C                                                                       ZRPG0260
C-----------------------------------------------------------------------ZRPG0270
C                                                                       ZRPG0280
      SUBROUTINE ZRPQLG (ITYPE,UU,VV)                                   ZRPG0290
C                                  SPECIFICATIONS FOR ARGUMENTS         ZRPG0300
      INTEGER            ITYPE                                          ZRPG0310
      DOUBLE PRECISION   UU,VV                                          ZRPG0320
C                                  SPECIFICATIONS FOR LOCAL VARIABLES   ZRPG0330
      INTEGER            N,NN                                           ZRPG0340
      DOUBLE PRECISION               ARE,ETA,RMRE                                   ZRPG0350
      DOUBLE PRECISION   P(101),QP(101),RK(101),QK(101),SVK(101)        ZRPG0360
      DOUBLE PRECISION   SR,SI,U,V,RA,RB,C,D,A1,A2,A3,                  ZRPG0370
     1                   A6,A7,E,F,G,H,SZR,SZI,RLZR,RLZI,               ZRPG0380
     2                   A4,A5,B1,B2,C1,C2,C3,C4,TEMP,ZERO              ZRPG0390
      COMMON /ZRPQLJ/    P,QP,RK,QK,SVK,SR,SI,U,V,RA,RB,C,D,A1,A2,A3,A6,ZRPG0400
     1                   A7,E,F,G,H,SZR,SZI,RLZR,RLZI,ETA,ARE,RMRE,N,NN ZRPG0410
      DATA               ZERO/0.0D0/                                    ZRPG0420
C                                  COMPUTE NEW ESTIMATES OF THE         ZRPG0430
C                                    QUADRATIC COEFFICIENTS USING THE   ZRPG0440
C                                    SCALARS COMPUTED IN ZRPQLE         ZRPG0450
C                                  USE FORMULAS APPROPRIATE TO SETTING  ZRPG0460
C                                    OF TYPE.                           ZRPG0470
C                                  FIRST EXECUTABLE STATEMENT           ZRPG0480
      IF (ITYPE.EQ.3) GO TO 15                                          ZRPG0490
      IF (ITYPE.EQ.2) GO TO 5                                           ZRPG0500
      A4 = RA+U*RB+H*F                                                  ZRPG0510
      A5 = C+(U+V*F)*D                                                  ZRPG0520
      GO TO 10                                                          ZRPG0530
    5 A4 = (RA+G)*F+H                                                   ZRPG0540
      A5 = (F+U)*C+V*D                                                  ZRPG0550
C                                  EVALUATE NEW QUADRATIC COEFFICIENTS. ZRPG0560
C                                                                       ZRPG0570
   10 B1 = -RK(N)/P(NN)                                                 ZRPG0580
      B2 = -(RK(N-1)+B1*P(N))/P(NN)                                     ZRPG0590
      C1 = V*B2*A1                                                      ZRPG0600
      C2 = B1*A7                                                        ZRPG0610
      C3 = B1*B1*A3                                                     ZRPG0620
      C4 = C1-C2-C3                                                     ZRPG0630
      TEMP = A5+B1*A4-C4                                                ZRPG0640
      IF (TEMP.EQ.ZERO) GO TO 15                                        ZRPG0650
      UU = U-(U*(C3+C2)+V*(B1*A1+B2*A7))/TEMP                           ZRPG0660
      VV = V*(1+C4/TEMP)                                                ZRPG0670
      RETURN                                                            ZRPG0680
C                                  IF TYPE=3 THE QUADRATIC IS ZEROED    ZRPG0690
   15 UU = ZERO                                                         ZRPG0700
      VV = ZERO                                                         ZRPG0710
      RETURN                                                            ZRPG0720
      END                                                               ZRPG0730
C   IMSL ROUTINE NAME   - ZRPQLH                                        ZRPH0010
C                                                                       ZRPH0020
C-----------------------------------------------------------------------ZRPH0030
C                                                                       ZRPH0040
C   COMPUTER            - VAX/DOUBLE                                    ZRPH0050
C                                                                       ZRPH0060
C   LATEST REVISION     - JANUARY 1, 1978                               ZRPH0070
C                                                                       ZRPH0080
C   PURPOSE             - NUCLEUS CALLED ONLY BY IMSL SUBROUTINE        ZRPH0090
C                           ZRPOLY                                      ZRPH0100
C                                                                       ZRPH0110
C   PRECISION/HARDWARE  - SINGLE AND DOUBLE/H32                         ZRPH0120
C                       - SINGLE/H36,H48,H60                            ZRPH0130
C                                                                       ZRPH0140
C   REQD. IMSL ROUTINES - NONE REQUIRED                                 ZRPH0150
C                                                                       ZRPH0160
C   NOTATION            - INFORMATION ON SPECIAL NOTATION AND           ZRPH0170
C                           CONVENTIONS IS AVAILABLE IN THE MANUAL      ZRPH0180
C                           INTRODUCTION OR THROUGH IMSL ROUTINE UHELP  ZRPH0190
C                                                                       ZRPH0200
C   COPYRIGHT           - 1978 BY IMSL, INC. ALL RIGHTS RESERVED.       ZRPH0210
C                                                                       ZRPH0220
C   WARRANTY            - IMSL WARRANTS ONLY THAT IMSL TESTING HAS BEEN ZRPH0230
C                           APPLIED TO THIS CODE. NO OTHER WARRANTY,    ZRPH0240
C                           EXPRESSED OR IMPLIED, IS APPLICABLE.        ZRPH0250
C                                                                       ZRPH0260
C-----------------------------------------------------------------------ZRPH0270
C                                                                       ZRPH0280
      SUBROUTINE ZRPQLH (NN,U,V,P,Q,RA,RB)                              ZRPH0290
C                                  SPECIFICATIONS FOR ARGUMENTS         ZRPH0300
      INTEGER            NN                                             ZRPH0310
      DOUBLE PRECISION   P(NN),Q(NN),U,V,RA,RB                          ZRPH0320
C                                  SPECIFICATIONS FOR LOCAL VARIABLES   ZRPH0330
      INTEGER            I                                              ZRPH0340
      DOUBLE PRECISION   C                                              ZRPH0350
C                                  DIVIDES P BY THE QUADRATIC 1,U,V     ZRPH0360
C                                    PLACING THE QUOTIENT IN Q AND THE  ZRPH0370
C                                    REMAINDER IN A,B                   ZRPH0380
C                                  FIRST EXECUTABLE STATEMENT           ZRPH0390
      RB = P(1)                                                         ZRPH0400
      Q(1) = RB                                                         ZRPH0410
      RA = P(2)-U*RB                                                    ZRPH0420
      Q(2) = RA                                                         ZRPH0430
      DO 5 I=3,NN                                                       ZRPH0440
         C = P(I)-U*RA-V*RB                                             ZRPH0450
         Q(I) = C                                                       ZRPH0460
         RB = RA                                                        ZRPH0470
         RA = C                                                         ZRPH0480
    5 CONTINUE                                                          ZRPH0490
      RETURN                                                            ZRPH0500
      END                                                               ZRPH0510
C   IMSL ROUTINE NAME   - ZRPQLI                                        ZRPI0010
C                                                                       ZRPI0020
C-----------------------------------------------------------------------ZRPI0030
C                                                                       ZRPI0040
C   COMPUTER            - VAX/DOUBLE                                    ZRPI0050
C                                                                       ZRPI0060
C   LATEST REVISION     - JANUARY 1, 1978                               ZRPI0070
C                                                                       ZRPI0080
C   PURPOSE             - NUCLEUS CALLED ONLY BY IMSL SUBROUTINE        ZRPI0090
C                           ZRPOLY                                      ZRPI0100
C                                                                       ZRPI0110
C   PRECISION/HARDWARE  - SINGLE AND DOUBLE/H32                         ZRPI0120
C                       - SINGLE/H36,H48,H60                            ZRPI0130
C                                                                       ZRPI0140
C   REQD. IMSL ROUTINES - NONE REQUIRED                                 ZRPI0150
C                                                                       ZRPI0160
C   NOTATION            - INFORMATION ON SPECIAL NOTATION AND           ZRPI0170
C                           CONVENTIONS IS AVAILABLE IN THE MANUAL      ZRPI0180
C                           INTRODUCTION OR THROUGH IMSL ROUTINE UHELP  ZRPI0190
C                                                                       ZRPI0200
C   COPYRIGHT           - 1978 BY IMSL, INC. ALL RIGHTS RESERVED.       ZRPI0210
C                                                                       ZRPI0220
C   WARRANTY            - IMSL WARRANTS ONLY THAT IMSL TESTING HAS BEEN ZRPI0230
C                           APPLIED TO THIS CODE. NO OTHER WARRANTY,    ZRPI0240
C                           EXPRESSED OR IMPLIED, IS APPLICABLE.        ZRPI0250
C                                                                       ZRPI0260
C-----------------------------------------------------------------------ZRPI0270
C                                                                       ZRPI0280
      SUBROUTINE ZRPQLI (RA,B1,C,SR,SI,RLR,RLI)                         ZRPI0290
C                                  SPECIFICATIONS FOR ARGUMENTS         ZRPI0300
      DOUBLE PRECISION   RA,B1,C,SR,SI,RLR,RLI                          ZRPI0310
C                                  SPECIFICATIONS FOR LOCAL VARIABLES   ZRPI0320
      DOUBLE PRECISION   RB,D,E,ZERO,ONE,TWO                            ZRPI0330
      DATA               ZERO,ONE,TWO/0.0D0,1.0D0,2.0D0/                ZRPI0340
C                                  CALCULATE THE ZEROS OF THE QUADRATIC ZRPI0350
C                                    A*Z**2 + B1*Z + C. THE QUADRATIC   ZRPI0360
C                                    FORMULA, MODIFIED TO AVOID         ZRPI0370
C                                    OVERFLOW, IS USED TO FIND THE      ZRPI0380
C                                    LARGER ZERO IF THE ZEROS ARE REAL  ZRPI0390
C                                    AND BOTH ZEROS ARE COMPLEX.        ZRPI0400
C                                  THE SMALLER REAL ZERO IS FOUND       ZRPI0410
C                                    DIRECTLY FROM THE PRODUCT OF THE   ZRPI0420
C                                    ZEROS C/A                          ZRPI0430
C                                  FIRST EXECUTABLE STATEMENT           ZRPI0440
      IF (RA.NE.ZERO) GO TO 10                                          ZRPI0450
      SR = ZERO                                                         ZRPI0460
      IF (B1.NE.ZERO) SR = -C/B1                                        ZRPI0470
      RLR = ZERO                                                        ZRPI0480
    5 SI = ZERO                                                         ZRPI0490
      RLI = ZERO                                                        ZRPI0500
      RETURN                                                            ZRPI0510
   10 IF (C.NE.ZERO) GO TO 15                                           ZRPI0520
      SR = ZERO                                                         ZRPI0530
      RLR = -B1/RA                                                      ZRPI0540
      GO TO 5                                                           ZRPI0550
C                                  COMPUTE DISCRIMINANT AVOIDING        ZRPI0560
C                                    OVERFLOW                           ZRPI0570
   15 RB = B1/TWO                                                       ZRPI0580
      IF (DABS(RB).LT.DABS(C)) GO TO 20                                 ZRPI0590
      E = ONE-(RA/RB)*(C/RB)                                            ZRPI0600
      D = DSQRT(DABS(E))*DABS(RB)                                       ZRPI0610
      GO TO 25                                                          ZRPI0620
   20 E = RA                                                            ZRPI0630
      IF (C.LT.ZERO) E = -RA                                            ZRPI0640
      E = RB*(RB/DABS(C))-E                                             ZRPI0650
      D = DSQRT(DABS(E))*DSQRT(DABS(C))                                 ZRPI0660
   25 IF (E.LT.ZERO) GO TO 30                                           ZRPI0670
C                                  REAL ZEROS                           ZRPI0680
      IF (RB.GE.ZERO) D = -D                                            ZRPI0690
      RLR = (-RB+D)/RA                                                  ZRPI0700
      SR = ZERO                                                         ZRPI0710
      IF (RLR.NE.ZERO) SR = (C/RLR)/RA                                  ZRPI0720
      GO TO 5                                                           ZRPI0730
C                                  COMPLEX CONJUGATE ZEROS              ZRPI0740
   30 SR = -RB/RA                                                       ZRPI0750
      RLR = SR                                                          ZRPI0760
      SI = DABS(D/RA)                                                   ZRPI0770
      RLI = -SI                                                         ZRPI0780
      RETURN                                                            ZRPI0790
      END                                                               ZRPI0800
