C +++
C
C Source: src/lib/RCS/uspkd.f
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: uspkd.f
C Revision 1.2  1991/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C
C Revision 1.1  90/07/10  14:57:37  khan
C Initial revision
C 
C 
C ---

C   IMSL ROUTINE NAME   - USPKD                                         USPK0010
C                                                                       USPK0020
C-----------------------------------------------------------------------USPK0030
C                                                                       USPK0040
C   COMPUTER            - VAX/SINGLE                                    USPK0050
C                                                                       USPK0060
C   LATEST REVISION     - JUNE 1, 1982                                  USPK0070
C                                                                       USPK0080
C   PURPOSE             - NUCLEUS CALLED BY IMSL ROUTINES THAT HAVE     USPK0090
C                           CHARACTER STRING ARGUMENTS                  USPK0100
C                                                                       USPK0110
C   USAGE               - CALL USPKD  (PACKED,NCHARS,UNPAKD,NCHMTB)     USPK0120
C                                                                       USPK0130
C   ARGUMENTS    PACKED - CHARACTER STRING TO BE UNPACKED.(INPUT)       USPK0140
C                NCHARS - LENGTH OF PACKED. (INPUT)  SEE REMARKS.       USPK0150
C                UNPAKD - INTEGER ARRAY TO RECEIVE THE UNPACKED         USPK0160
C                         REPRESENTATION OF THE STRING. (OUTPUT)        USPK0170
C                NCHMTB - NCHARS MINUS TRAILING BLANKS. (OUTPUT)        USPK0180
C                                                                       USPK0190
C   PRECISION/HARDWARE  - SINGLE/ALL                                    USPK0200
C                                                                       USPK0210
C   REQD. IMSL ROUTINES - NONE                                          USPK0220
C                                                                       USPK0230
C   REMARKS  1.  USPKD UNPACKS A CHARACTER STRING INTO AN INTEGER ARRAY USPK0240
C                IN (A1) FORMAT.                                        USPK0250
C            2.  UP TO 129 CHARACTERS MAY BE USED.  ANY IN EXCESS OF    USPK0260
C                THAT ARE IGNORED.                                      USPK0270
C                                                                       USPK0280
C   COPYRIGHT           - 1982 BY IMSL, INC. ALL RIGHTS RESERVED.       USPK0290
C                                                                       USPK0300
C   WARRANTY            - IMSL WARRANTS ONLY THAT IMSL TESTING HAS BEEN USPK0310
C                           APPLIED TO THIS CODE. NO OTHER WARRANTY,    USPK0320
C                           EXPRESSED OR IMPLIED, IS APPLICABLE.        USPK0330
C                                                                       USPK0340
C-----------------------------------------------------------------------USPK0350
      SUBROUTINE USPKD  (PACKED,NCHARS,UNPAKD,NCHMTB)                   USPK0360
C                                  SPECIFICATIONS FOR ARGUMENTS         USPK0370
#if !defined(rs6000) && !defined(G77) && !defined(MICROSOFT)
      INTEGER            NC,NCHARS,NCHMTB                               USPK0380
C                                                                       USPK0390
      INTEGER            UNPAKD(1),IBLANK                               USPK0400
      INTEGER            PACKED(1)                                      USPK0410
      DATA               IBLANK /1H /                                   USPK0420
C                                  INITIALIZE NCHMTB                    USPK0430
      NCHMTB = 0                                                        USPK0440
C                                  RETURN IF NCHARS IS LE ZERO          USPK0450
      IF(NCHARS.LE.0) RETURN                                            USPK0460
C                                  SET NC=NUMBER OF CHARS TO BE DECODED USPK0470
      NC = MIN0 (129,NCHARS)                                            USPK0480
      DECODE (NC,150,PACKED) (UNPAKD(I),I=1,NC)                         USPK0490
  150 FORMAT (129A1)                                                    USPK0500
C                                  CHECK UNPAKD ARRAY AND SET NCHMTB    USPK0510
C                                  BASED ON TRAILING BLANKS FOUND       USPK0520
      DO 200 N = 1,NC                                                   USPK0530
         NN = NC - N + 1                                                USPK0540
         IF(UNPAKD(NN) .NE. IBLANK) GO TO 210                           USPK0550
  200 CONTINUE                                                          USPK0560
  210 NCHMTB = NN                                                       USPK0570
#endif
      RETURN                                                            USPK0580
      END                                                               USPK0590
