C +++
C
C Source: src/lib/rotvector.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: rotvector.F
C Revision 1.4  1991/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C
C Revision 1.3  91/04/05  13:54:38  cwelnak
C changed quotes on #include
C 
C Revision 1.2  91/03/25  10:55:04  cwelnak
C SUN version - INC to #inc
C 
C Revision 1.1  91/01/24  10:41:32  khan
C Initial revision
C 
C 
C ---


#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C
C----------------------------------------------------------
C
C       Rotation a vector VIN an angle ALPHA around an AXIS vector
C
C
     	SUBROUTINE	ROTVECTOR (VIN,AXIS,ALPHA,VOUT)

     	IMPLICIT	REAL*8		(A-H,O-Z)

     	DIMENSION	VIN(3),AXIS(3),VOUT(3)
     	DIMENSION	VCTR0(3),VCTR1(3),VCTR2(3),VCTR3(3)

	CALL DOT (AXIS,AXIS,AXIS_MOD2)
	CALL DOT (VIN,AXIS,ETA)
	ETA	= ETA/AXIS_MOD2
	CALL SCALAR (AXIS,ETA,VCTR0)
	CALL VECTOR (VCTR0,VIN,VCTR1)
	CALL CROSS   (VIN,AXIS,VCTR3)
	SA	= SIN(ALPHA)/SQRT(AXIS_MOD2)
	CA	= COS(ALPHA)
	CALL SCALAR (VCTR3,SA,VCTR3)
	CALL SCALAR (VCTR1,CA,VCTR1)
	CALL SUM (VCTR1,VCTR3,VCTR2)
	CALL SUM (VCTR0,VCTR2,VOUT)
	RETURN
	END 	
