C +++
C
C Source: src/lib/readaxis.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: readaxis.F
C Revision 1.9  1992/01/22  23:31:09  cwelnak
C 6000 changes
C
C Revision 1.8  1991/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C
C Revision 1.7  91/04/05  13:54:36  cwelnak
C changed quotes on #include
C 
C Revision 1.6  91/03/25  10:52:22  cwelnak
C typo...
C 
C Revision 1.5  91/03/25  10:49:40  cwelnak
C SUN version -- INC to #inc
C 
C Revision 1.4  90/11/13  14:05:05  khan
C Cleanup and SAVE statements
C 
C Revision 1.3  90/07/20  22:05:23  khan
C put #if unix ... to make it work also on vms
C 
C Revision 1.2  90/07/15  15:31:08  khan
C All public include files (common.blk, etc) are now in ./../../include dir.
C 
C Revision 1.1  90/07/10  14:56:45  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE	READ_AXIS
C
C	PURPOSE		Reads in an OPTAXIS file
C
C---
      	SUBROUTINE	READ_AXIS (I_MIRROR)
C
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#	include		<common.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
#endif

C
C Find out the name
C
     	CALL	FNAME (FFILE,'optax',I_MIRROR,2)
C
C Open and read the file
C
#if defined(vms)
     	OPEN (UNIT=20, FILE= FFILE, STATUS='OLD', READONLY)
#else
     	OPEN (UNIT=20, FILE= FFILE, STATUS='OLD')
#endif

     	DO 100 I=1,I_MIRROR
     	  READ (20,*) I_DUMM
     	  READ (20,*) ( CENTRAL(I,J), J =  1,3)
     	  READ (20,*) ( CENTRAL(I,J), J =  4,6)
     	  READ (20,*) ( CENTRAL(I,J), J =  7,9)
     	  READ (20,*) ( CENTRAL(I,J), J =10,12)
     	  READ (20,*) ( CENTRAL(I,J), J =13,15)
     	  READ (20,*) ( CENTRAL(I,J), J =16,18)
     	  READ (20,*) ( CENTRAL(I,J), J =19,21)
     	  READ (20,*) ( CENTRAL(I,J), J =22,24)
100	CONTINUE
     	CLOSE (20)
	END
