#if !defined(__CYGWIN32__) && !USE_C_IO

C +++
C
C Source: src/lib/rbeam18.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: rbeam18.F
C Revision 1.8  1991/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C
C Revision 1.7  91/04/05  13:54:35  cwelnak
C changed quotes on #include
C 
C Revision 1.6  91/03/25  10:47:53  cwelnak
C SUN version - INC to #inc
C 
C Revision 1.5  90/11/13  14:05:04  khan
C Cleanup and SAVE statements
C 
C Revision 1.4  90/07/20  22:05:22  khan
C put #if unix ... to make it work also on vms
C 
C Revision 1.3  90/07/15  15:31:07  khan
C All public include files (common.blk, etc) are now in ./../../include dir.
C 
C Revision 1.2  90/07/11  15:51:54  khan
C Fixed bug in reading the 12 column ray file (in implicit DO LOOP).
C 
C Revision 1.1  90/07/10  14:56:44  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE	RBEAM18	(FNAME,RAY,NCOL,NPOINT,IFLAG,IERR)
C
C	purpose		The same as RBEAM, except return everything in
C			one single array RAY(18,N_DIM) instead of three
C			separate arrays.
C
C	Input	:	FNAME	(character*(*))	Input file name
C	
C	Output  :	RAY	Array which contains the 18 columns that
C				defined each ray
C			NCOL	Number of columns for each ray 
C			NPOINT	Number of rays
C			IFLAG	A flag which is stored on the input file
C			IERR = 0, normal return
C			     = 1, error opening file
C			     = 2, error reading file
C
C---
	SUBROUTINE	RBEAM18	(FNAME,RAY,NCOL,NPOINT,IFLAG,IERR)
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defidn(vms)
	INCLUDE		'SHADOW$INC:DIM.PAR/LIST'
#endif
     	CHARACTER*(*)	FNAME
     	REAL*8		RAY(18, N_DIM)
     	IERR 	=  0

#if defined(vms)
     	OPEN (Unit=21, FILE=FNAME, STATUS='OLD', FORM='UNFORMATTED', 
     $		READONLY, IOSTAT=IERR)
#else
     	OPEN (Unit=21, FILE=FNAME, STATUS='OLD', FORM='UNFORMATTED', 
     $		IOSTAT=IERR)
#endif
     	IF (IERR.NE.0) THEN
     	  CALL MSSG ('RBEAM18',
     $		'Error opening image file "' // 
     $		  FNAME(1:IBLANK(FNAME)) // '".',
     $		IERR)
     	  IERR = 1
     	  GO TO 1
     	END IF
	READ 	(21,ERR=10)	NCOL, NPOINT, IFLAG
C
C Check for valid argument of NCOL
C
	IF (NCOL.NE.12.AND.NCOL.NE.13.AND.NCOL.NE.18)
     $	  CALL MSSG ('RBEAM18','Invalid number of columns.',NCOL)

C
C Read in the rays.
C
	DO 99 I = 1, NPOINT
	  READ (21,ERR=10) (RAY(J,I), J = 1,NCOL)
 99	CONTINUE
C
 1	CLOSE (21)
     	RETURN
 10	IERR	= 2
	GO TO 1
     	END

#else /* __CYGWIN32__ || USE_C_IO */
	subroutine rbeam18_fortran_dummy
	return
	end
#endif
