C +++
C
C Source: src/lib/poly.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: poly.F
C Revision 1.9  1994/10/19  19:30:55  cwelnak
C error in 2nd degree, pcoeff(0,2,1)
C
C Revision 1.8  1992/09/22  09:23:44  cwelnak
C Facet changes -- G.J. Chen
C
C Revision 1.7  91/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C 
C Revision 1.6  91/04/05  13:54:33  cwelnak
C changed quotes on #include
C 
C Revision 1.5  91/03/25  10:43:38  cwelnak
C SUN version -- INC to #inc
C changed OPEN statement to lose READONLY if unix
C 
C Revision 1.4  90/11/13  14:05:00  khan
C Cleanup and SAVE statements
C 
C Revision 1.3  90/07/20  22:05:19  khan
C put #if unix ... to make it work also on vms
C 
C Revision 1.2  90/07/15  15:31:04  khan
C All public include files (common.blk, etc) are now in ./../../include dir.
C 
C Revision 1.1  90/07/10  14:56:39  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C	SUBROUTINE	POLY
C
C	PURPOSE		To compute the intercepts with a general
C			polinomial surface of order up to 4. This
C			include as a special case the torus and all
C          		the conics. However, the calculations are more
C			complex here and the simpler conic and torus
C			case should be used whenever possible
C
C	ALGORITHM	Uses ZRPOLY. The coefficient of the distance
C			of the source point to the surface are computed
C			and passed to ZRPOLY.
C
C	INPUT		XIN:	ray origin 
C			VIN:	ray direction
C			I_RES:  -1, ripple case
C				 1, ordinary case
C
C			NDEG is in common blk
C
C	OUTPUT		ANSWER  distance from point to intercept
C			I_RES	flag: 0 successfull
C				     -1 complex
C
C---
     	SUBROUTINE POLY	(XIN, VIN, ANSWER, I_RES)
C
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#	include		<common.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
#endif
C
     	COMPLEX*16	H_OUTPUT(4)
	INTEGER		N_TEST
	DIMENSION	TEST1(4),TEST2(4)
      	DIMENSION	XIN(3), VIN(3)
     	DIMENSION	COEFF(5),TCOEFF(5)
	ANSWER	=   0.0D0
      	X0	= XIN(1)
     	 Y0	= XIN(2)
     	  Z0	= XIN(3)
     	X1	= VIN(1)
     	 Y1	= VIN(2)
     	  Z1	= VIN(3) 
C
     	GO TO (1,2,3,4,5) NDEG+1
5	CONTINUE
C
C This is the 4th degree case
C
     	CTMP	=   0.0D0 
     	CTMP	=   CTMP + PCOEFF(4,0,0) *X1**4
     	CTMP	=   CTMP + PCOEFF(0,4,0) *Y1**4
     	CTMP	=   CTMP + PCOEFF(0,0,4) *Z1**4
     	CTMP	=   CTMP + PCOEFF(0,3,1) *Z1 *Y1**3 
     	CTMP	=   CTMP + PCOEFF(1,0,3) *X1 *Z1**3 
     	CTMP	=   CTMP + PCOEFF(1,3,0) *X1 *Y1**3 
     	CTMP	=   CTMP + PCOEFF(3,0,1) *X1**3 *Z1 
     	CTMP	=   CTMP + PCOEFF(3,1,0) *X1**3 *Y1 
     	CTMP	=   CTMP + PCOEFF(0,1,3) *Y1 *Z1**3 
     	CTMP	=   CTMP + PCOEFF(2,0,2) *X1**2 *Z1**2 
     	CTMP	=   CTMP + PCOEFF(2,2,0) *X1**2 *Y1**2 
     	CTMP	=   CTMP + PCOEFF(0,2,2) *Y1**2 *Z1**2 
     	CTMP	=   CTMP + PCOEFF(1,1,2) *X1 *Y1 *Z1**2 
     	CTMP	=   CTMP + PCOEFF(1,2,1) *X1 *Y1**2 *Z1 
     	CTMP	=   CTMP + PCOEFF(2,1,1) *X1**2 *Y1 *Z1 
C
     	TCOEFF (5) = CTMP
4	CONTINUE
C
C 3th degree
C
     	CTMP	=   0.0D0
     	CTMP	=   CTMP + 4* PCOEFF(4,0,0) *X0 *X1**3 
     	CTMP	=   CTMP + 4* PCOEFF(0,4,0) *Y0 *Y1**3 
     	CTMP	=   CTMP + 4* PCOEFF(0,0,4) *Z0 *Z1**3
     	CTMP	=   CTMP +    PCOEFF(0,0,3) *Z1**3
     	CTMP	=   CTMP +    PCOEFF(0,3,0) *Y1**3
     	CTMP	=   CTMP +    PCOEFF(3,0,0) *X1**3
     	CTMP	=   CTMP +    PCOEFF(0,1,2) *Y1 *Z1**2
     	CTMP	=   CTMP +    PCOEFF(0,1,3) *Y0 *Z1**3
     	CTMP	=   CTMP +    PCOEFF(0,2,1) *Y1**2 *Z1
     	CTMP	=   CTMP +    PCOEFF(0,3,1) *Y1**3 *Z0
     	CTMP	=   CTMP +    PCOEFF(1,0,2) *X1 *Z1**2
     	CTMP	=   CTMP +    PCOEFF(1,0,3) *X0 *Z1**3
     	CTMP	=   CTMP +    PCOEFF(1,2,0) *X1 *Y1**2
     	CTMP	=   CTMP +    PCOEFF(1,3,0) *X0 *Y1**3
     	CTMP	=   CTMP +    PCOEFF(2,0,1) *X1**2 *Z1
     	CTMP	=   CTMP +    PCOEFF(2,1,0) *X1**2 *Y1 
     	CTMP	=   CTMP +    PCOEFF(3,0,1) *X1**3 *Z0
     	CTMP	=   CTMP +    PCOEFF(3,1,0) *X1**3 *Y0
     	CTMP	=   CTMP + 3* PCOEFF(0,1,3) *Y1 *Z0 *Z1**2
     	CTMP	=   CTMP + 2* PCOEFF(0,2,2) *Y1 *Y0 *Z1**2
     	CTMP	=   CTMP + 2* PCOEFF(0,2,2) *Y1**2 *Z0 *Z1
     	CTMP	=   CTMP + 3* PCOEFF(0,3,1) *Y0 *Y1**2 *Z1
     	CTMP	=   CTMP + 3* PCOEFF(1,0,3) *X1 *Z0 *Z1**2
     	CTMP	=   CTMP +    PCOEFF(1,1,1) *X1 *Y1 *Z1
     	CTMP	=   CTMP +    PCOEFF(1,1,2) *X0 *Y1 *Z1**2
     	CTMP	=   CTMP +    PCOEFF(1,1,2) *X1 *Y0 *Z1**2
     	CTMP	=   CTMP +    PCOEFF(1,2,1) *X0 *Y1**2 *Z1
     	CTMP	=   CTMP +    PCOEFF(1,2,1) *X1 *Y1**2 *Z0
     	CTMP	=   CTMP + 3* PCOEFF(1,3,0) *X1 *Y0 *Y1**2
     	CTMP	=   CTMP + 2* PCOEFF(2,0,2) *X0 *X1 *Z1**2
     	CTMP	=   CTMP + 2* PCOEFF(2,0,2) *X1**2 *Z0 *Z1
     	CTMP	=   CTMP +    PCOEFF(2,1,1) *X1**2 *Y0 *Z1
     	CTMP	=   CTMP +    PCOEFF(2,1,1) *X1**2 *Y1 *Z0
     	CTMP	=   CTMP + 2* PCOEFF(2,2,0) *X0 *X1 *Y1**2
     	CTMP	=   CTMP + 2* PCOEFF(2,2,0) *X1**2 *Y0 *Y1
     	CTMP	=   CTMP + 3* PCOEFF(3,0,1) *X0 *X1**2 *Z1
     	CTMP	=   CTMP + 3* PCOEFF(3,1,0) *X0 *X1**2 *Y1
     	CTMP	=   CTMP + 2* PCOEFF(1,1,2) *X1 *Y1 *Z0 *Z1
     	CTMP	=   CTMP + 2* PCOEFF(1,2,1) *X1 *Y0 *Y1 *Z1
     	CTMP	=   CTMP + 2* PCOEFF(2,1,1) *X0 *X1 *Y1 *Z1
C     	
     	TCOEFF (4) = CTMP
3	CONTINUE
C
C 2nd degree
C
     	CTMP	=   0.0D0
     	CTMP	=   CTMP + 6*PCOEFF(4,0,0) *X0**2 *X1**2 
     	CTMP	=   CTMP + 6*PCOEFF(0,4,0) *Y0**2 *Y1**2 
     	CTMP	=   CTMP + 6*PCOEFF(0,0,4) *Z0**2 *Z1**2
     	CTMP	=   CTMP +   PCOEFF(0,0,2) *Z1**2
     	CTMP	=   CTMP +   PCOEFF(0,2,0) *Y1**2
     	CTMP	=   CTMP +   PCOEFF(2,0,0) *X1 *X1
     	CTMP	=   CTMP +   PCOEFF(0,0,3) *3*Z1**2*Z0
     	CTMP	=   CTMP +   PCOEFF(0,1,1) *Y1 *Z1
     	CTMP	=   CTMP +   PCOEFF(0,1,2) *Y0 *Z1**2
     	CTMP	=   CTMP +   PCOEFF(0,2,1) *Y1**2 *Z0
     	CTMP	=   CTMP +   PCOEFF(0,2,2) *Y0**2 *Z1**2
     	CTMP	=   CTMP +   PCOEFF(0,2,2) *Y1**2 *Z0**2
     	CTMP	=   CTMP +   PCOEFF(0,3,0) *3*Y0 *Y1**2
     	CTMP	=   CTMP +   PCOEFF(1,0,1) *X1 *Z1
     	CTMP	=   CTMP +   PCOEFF(1,0,2) *X0 *Z1**2
     	CTMP	=   CTMP +   PCOEFF(1,1,0) *X1 *Y1
     	CTMP	=   CTMP +   PCOEFF(1,2,0) *X0 *Y1**2
     	CTMP	=   CTMP +   PCOEFF(2,0,1) *X1**2 *Z0
     	CTMP	=   CTMP +   PCOEFF(2,0,2) *X0**2 *Z1**2
     	CTMP	=   CTMP +   PCOEFF(2,0,2) *X1**2 *Z0**2
     	CTMP	=   CTMP +   PCOEFF(2,1,0) *X1**2 *Y0
     	CTMP	=   CTMP +   PCOEFF(2,2,0) *X0**2 *Y1**2
     	CTMP	=   CTMP +   PCOEFF(2,2,0) *X1**2 *Y0**2
     	CTMP	=   CTMP +   PCOEFF(3,0,0) *3*X0 *X1**2
     	CTMP	=   CTMP +   PCOEFF(0,1,2) *2*Y1 *Z0 *Z1
     	CTMP	=   CTMP +   PCOEFF(0,1,3) *3*Y0 *Z0 *Z1**2
     	CTMP	=   CTMP +   PCOEFF(0,1,3) *3*Y1 *Z0**2 *Z1
     	CTMP	=   CTMP +   PCOEFF(0,2,1) *2*Y0 *Y1 *Z1
     	CTMP	=   CTMP +   PCOEFF(0,3,1) *3*Y0 *Y1**2 *Z0
     	CTMP	=   CTMP +   PCOEFF(0,3,1) *3*Y0**2 *Y1 *Z1
     	CTMP	=   CTMP +   PCOEFF(1,0,2) *2*X1 *Z0 *Z1
     	CTMP	=   CTMP +   PCOEFF(1,0,3) *3*X0 *Z0 *Z1**2
     	CTMP	=   CTMP +   PCOEFF(1,0,3) *3*X1 *Z0**2 *Z1
     	CTMP	=   CTMP +   PCOEFF(1,1,1) *X0 *Y1 *Z1
     	CTMP	=   CTMP +   PCOEFF(1,1,1) *X1 *Y0 *Z1
     	CTMP	=   CTMP +   PCOEFF(1,1,1) *X1 *Y1 *Z0
     	CTMP	=   CTMP +   PCOEFF(1,1,2) *X0 *Y0 *Z1**2
     	CTMP	=   CTMP +   PCOEFF(1,1,2) *X1 *Y1 *Z0**2
     	CTMP	=   CTMP +   PCOEFF(1,2,0) *2*X1 *Y0 *Y1
     	CTMP	=   CTMP +   PCOEFF(1,2,1) *X0 *Y1**2 *Z0
     	CTMP	=   CTMP +   PCOEFF(1,2,1) *X1 *Y0**2 *Y1
     	CTMP	=   CTMP +   PCOEFF(1,3,0) *3*X0 *Y0 *Y1**2
     	CTMP	=   CTMP +   PCOEFF(1,3,0) *3*X1 *Y0**2 *Y1
     	CTMP	=   CTMP +   PCOEFF(2,0,1) *2*X0 *X1 *Z1
     	CTMP	=   CTMP +   PCOEFF(2,1,0) *2*X0 *X1 *Y1
     	CTMP	=   CTMP +   PCOEFF(2,1,1) *X0**2 *Y1 *Z1
     	CTMP	=   CTMP +   PCOEFF(2,1,1) *X1**2 *Y0 *Z0
     	CTMP	=   CTMP +   PCOEFF(3,0,1) *3*X0 *X1**2 *Z0
     	CTMP	=   CTMP +   PCOEFF(3,0,1) *3*X0**2 *X1 *Z1
     	CTMP	=   CTMP +   PCOEFF(3,1,0) *3*X0 *X1**2 *Y0
     	CTMP	=   CTMP +   PCOEFF(3,1,0) *3*X0**2 *X1 *Y1
     	CTMP	=   CTMP +   PCOEFF(0,2,2) *4*Y0 *Y1 *Z0 *Z1
     	CTMP	=   CTMP +   PCOEFF(1,1,2) *2*X0 *Y1 *Z0 *Z1
     	CTMP	=   CTMP +   PCOEFF(1,1,2) *2*X1 *Y0 *Z0 *Z1
     	CTMP	=   CTMP +   PCOEFF(1,2,1) *2*X0 *Y0 *Y1 *Z1
     	CTMP	=   CTMP +   PCOEFF(1,2,1) *2*X1 *Y0 *Y1 *Z0
     	CTMP	=   CTMP +   PCOEFF(2,0,2) *4*X0 *X1 *Z0 *Z1
     	CTMP	=   CTMP +   PCOEFF(2,1,1) *2*X0 *X1 *Y0 *Z1
     	CTMP	=   CTMP +   PCOEFF(2,1,1) *2*X0 *X1 *Y1 *Z0
     	CTMP	=   CTMP +   PCOEFF(2,2,0) *4*X0 *X1 *Y0 *Y1
C
     	TCOEFF (3) = CTMP
2	CONTINUE
C
C 1st degree
C
     	CTMP	=   0.0D0
     	CTMP	=   CTMP + 4* PCOEFF(4,0,0) *X0**3 *X1 
     	CTMP	=   CTMP + 4* PCOEFF(0,4,0) *Y0**3 *Y1
     	CTMP	=   CTMP + 4* PCOEFF(0,0,4) *Z0**3 *Z1 
     	CTMP	=   CTMP +    PCOEFF(0,0,1) *Z1
     	CTMP	=   CTMP +    PCOEFF(0,1,0) *Y1
     	CTMP	=   CTMP +    PCOEFF(1,0,0) *X1
     	CTMP	=   CTMP + 2* PCOEFF(0,0,2) *Z0 *Z1
     	CTMP	=   CTMP + 3* PCOEFF(0,0,3) *Z0**2 *Z1
     	CTMP	=   CTMP +    PCOEFF(0,1,1) *Y0 *Z1
     	CTMP	=   CTMP +    PCOEFF(0,1,1) *Y1 *Z0
     	CTMP	=   CTMP +    PCOEFF(0,1,2) *Y1 *Z0**2
     	CTMP	=   CTMP +    PCOEFF(0,1,3) *Y0 *Z0**3
     	CTMP	=   CTMP + 2* PCOEFF(0,2,0) *Y0 *Y1
     	CTMP	=   CTMP +    PCOEFF(0,2,1) *Y0**2 *Z1
     	CTMP	=   CTMP + 3* PCOEFF(0,3,0) *Y0**2 *Y1
     	CTMP	=   CTMP +    PCOEFF(0,3,1) *Y0**3 *Z1
     	CTMP	=   CTMP +    PCOEFF(1,0,1) *X0 *Z1
     	CTMP	=   CTMP +    PCOEFF(1,0,1) *X1 *Z0
     	CTMP	=   CTMP +    PCOEFF(1,0,2) *X1 *Z0**2
     	CTMP	=   CTMP +    PCOEFF(1,0,3) *X1 *Z0**3
     	CTMP	=   CTMP +    PCOEFF(1,1,0) *X0 *Y1
     	CTMP	=   CTMP +    PCOEFF(1,1,0) *X1 *Y0
     	CTMP	=   CTMP +    PCOEFF(1,2,0) *X1 *Y0**2
     	CTMP	=   CTMP +    PCOEFF(1,3,0) *X1 *Y0**3
     	CTMP	=   CTMP + 2* PCOEFF(2,0,0) *X0 *X1
     	CTMP	=   CTMP +    PCOEFF(2,0,1) *X0**2 *Z1
     	CTMP	=   CTMP +    PCOEFF(2,1,0) *X0**2 *Y1
     	CTMP	=   CTMP + 3* PCOEFF(3,0,0) *X0**2 *X1
     	CTMP	=   CTMP +    PCOEFF(3,0,1) *X0**3 *Z1
     	CTMP	=   CTMP +    PCOEFF(3,1,0) *X0**3 *Y1
     	CTMP	=   CTMP + 2* PCOEFF(0,1,2) *Y0 *Z0 *Z1
     	CTMP	=   CTMP + 3* PCOEFF(0,1,3) *Y0 *Z0**2 *Z1
     	CTMP	=   CTMP + 2* PCOEFF(0,2,1) *Y0 *Y1 *Z0
     	CTMP	=   CTMP + 2* PCOEFF(0,2,2) *Y0 *Y1 *Z0**2
     	CTMP	=   CTMP + 2* PCOEFF(0,2,2) *Y0**2 *Z0 *Z1
     	CTMP	=   CTMP + 3* PCOEFF(0,3,1) *Y0**2 *Y1 *Z0
     	CTMP	=   CTMP + 2* PCOEFF(1,0,2) *X0 *Z0 *Z1
     	CTMP	=   CTMP + 3* PCOEFF(1,0,3) *X0 *Z0**2 *Z1
     	CTMP	=   CTMP +    PCOEFF(1,1,1) *X0 *Y0 *Z1
     	CTMP	=   CTMP +    PCOEFF(1,1,1) *X0 *Y1 *Z0
     	CTMP	=   CTMP +    PCOEFF(1,1,1) *X1 *Y0 *Z0
     	CTMP	=   CTMP +    PCOEFF(1,1,2) *X0 *Y1 *Z0**2
     	CTMP	=   CTMP +    PCOEFF(1,1,2) *X1 *Y0 *Z0**2
     	CTMP	=   CTMP + 2* PCOEFF(1,2,0) *X0 *Y0 *Y1
     	CTMP	=   CTMP +    PCOEFF(1,2,1) *X0 *Y0**2 *Z1
     	CTMP	=   CTMP +    PCOEFF(1,2,1) *X1 *Y0**2 *Z0
     	CTMP	=   CTMP + 3* PCOEFF(1,3,0) *X0 *Y0**2 *Y1
     	CTMP	=   CTMP + 2* PCOEFF(2,0,1) *X0 *X1 *Z0
     	CTMP	=   CTMP + 2* PCOEFF(2,0,2) *X0 *X1 *Z0**2
     	CTMP	=   CTMP + 2* PCOEFF(2,0,2) *X0**2 *Z0 *Z1
     	CTMP	=   CTMP + 2* PCOEFF(2,1,0) *X0 *X1 *Y0
     	CTMP	=   CTMP +    PCOEFF(2,1,1) *X0**2 *Y0 *Z1
     	CTMP	=   CTMP +    PCOEFF(2,1,1) *X0**2 *Y1 *Z0
     	CTMP	=   CTMP + 2* PCOEFF(2,2,0) *X0 *X1 *Y0**2
     	CTMP	=   CTMP + 2* PCOEFF(2,2,0) *X0**2 *Y0 *Y1
     	CTMP	=   CTMP + 3* PCOEFF(3,0,1) *X0**2 *X1 *Z0
     	CTMP	=   CTMP + 3* PCOEFF(3,1,0) *X0**2 *X1 *Y0
     	CTMP	=   CTMP + 2* PCOEFF(1,1,2) *X0 *Y0 *Z0 *Z1
     	CTMP	=   CTMP + 2* PCOEFF(1,2,1) *X0 *Y0 *Y1 *Z0
     	CTMP	=   CTMP + 2* PCOEFF(2,1,1) *X0 *X1 *Y0 *Z0
C
     	TCOEFF  (2) = CTMP
1	CONTINUE
C
C 0th degree
C
     	CTMP	=   0.0D0
     	CTMP	=   CTMP +   PCOEFF(0,0,0) 
     	CTMP	=   CTMP +   PCOEFF(4,0,0) *X0**4 
     	CTMP	=   CTMP +   PCOEFF(0,4,0) *Y0**4 
     	CTMP	=   CTMP +   PCOEFF(0,0,4) *Z0**4
     	CTMP	=   CTMP +   PCOEFF(0,0,1) *Z0
     	CTMP	=   CTMP +   PCOEFF(0,0,2) *Z0**2
     	CTMP	=   CTMP +   PCOEFF(0,0,3) *Z0**3
     	CTMP	=   CTMP +   PCOEFF(0,1,0) *Y0
     	CTMP	=   CTMP +   PCOEFF(0,2,0) *Y0**2
     	CTMP	=   CTMP +   PCOEFF(0,3,0) *Y0**3
     	CTMP	=   CTMP +   PCOEFF(1,0,0) *X0
     	CTMP	=   CTMP +   PCOEFF(2,0,0) *X0**2
     	CTMP	=   CTMP +   PCOEFF(3,0,0) *X0**3
     	CTMP	=   CTMP +   PCOEFF(0,1,1) *Y0 *Z0
     	CTMP	=   CTMP +   PCOEFF(0,1,2) *Y0 *Z0**2
     	CTMP	=   CTMP +   PCOEFF(0,1,3) *Y0 *Z0**3
     	CTMP	=   CTMP +   PCOEFF(0,2,1) *Y0**2 *Z0
     	CTMP	=   CTMP +   PCOEFF(0,2,2) *Y0**2 *Z0**2
     	CTMP	=   CTMP +   PCOEFF(0,3,1) *Y0**3 *Z0
     	CTMP	=   CTMP +   PCOEFF(1,0,1) *X0 *Z0
     	CTMP	=   CTMP +   PCOEFF(1,0,2) *X0 *Z0**2
     	CTMP	=   CTMP +   PCOEFF(1,0,3) *X0 *Z0**3
     	CTMP	=   CTMP +   PCOEFF(1,1,0) *X0 *Y0
     	CTMP	=   CTMP +   PCOEFF(1,2,0) *X0 *Y0**2
     	CTMP	=   CTMP +   PCOEFF(1,3,0) *X0 *Y0**3
     	CTMP	=   CTMP +   PCOEFF(2,0,1) *X0**2 *Z0
     	CTMP	=   CTMP +   PCOEFF(2,0,2) *X0**2 *Z0**2
     	CTMP	=   CTMP +   PCOEFF(2,1,0) *X0**2 *Y0
     	CTMP	=   CTMP +   PCOEFF(2,2,0) *X0**2 *Y0**2
     	CTMP	=   CTMP +   PCOEFF(3,0,1) *X0**3 *Z0
     	CTMP	=   CTMP +   PCOEFF(3,1,0) *X0**3 *Y0
     	CTMP	=   CTMP +   PCOEFF(1,1,1) *X0 *Y0 *Z0
     	CTMP	=   CTMP +   PCOEFF(1,1,2) *X0 *Y0 *Z0**2
     	CTMP	=   CTMP +   PCOEFF(1,2,1) *X0 *Y0**2 *Z0
     	CTMP	=   CTMP +   PCOEFF(2,1,1) *X0**2 *Y0 *Z0
C
     	TCOEFF (1) = CTMP
D	WRITE(6,*)'TCOEFF = ',TCOEFF
C
C Inverts array for ZRPOLY
C
     	DO 11 I=NDEG+1,1,-1
     	  COEFF(NDEG-I+2) = TCOEFF(I)
11     	CONTINUE
D	WRITE(6,*)COEFF
     	CALL 	ZRPOLY (COEFF,NDEG,H_OUTPUT,IER)
C
C Tests for success;
C
D     	WRITE(6,*)IER
     	IF (IER.EQ.130) THEN
C
C if IER=130 degree declared too large; try again;
C
     	  MOVE = 0
 21    	 IF (IER.NE.0) THEN
     	   MOVE = MOVE + 1
     	  IF (MOVE.EQ.4) CALL LEAVE ('POLY','ERROR IN POLY',0)
     	  DO 31 I=1,NDEG
     	    TCOEFF(I) = COEFF(I+1)
31     	  CONTINUE
     	  DO 41 I=1,NDEG
     	    COEFF(I)=TCOEFF(I)
41     	  CONTINUE
D	WRITE(6,*)'MOVE = ',MOVE,COEFF
     	   CALL 	ZRPOLY (COEFF,NDEG,H_OUTPUT,IER)
D	WRITE(6,*)IER
		 GOTO 21
     	 END IF
     	ELSE IF (IER.EQ.131) THEN
C
C fatal error
C
          CALL LEAVE ('POLY','Fatal error.',0)
     	END IF
C
C Tests for reality of intercepts 
C
     	 CHECK = 1
D	WRITE(6,*)H_OUTPUT
     	DO 51 I=1,NDEG
	  TEST1(I) = DIMAG(H_OUTPUT(I))
     	  CHECK	= CHECK*TEST1(I) 	! Complex part
51     	CONTINUE
     	IF (CHECK.NE.0.0D0) THEN
C
C All the solutions are complex; the beam is completely out of
C of the mirror.
C
     	  I_RES	= -1
     	  RETURN
     	END IF
C
C At least a good ray;
C
	IF (I_RES.LT.0) THEN
C
C Ripple case : take the closest intercept
C
     	  ANSWER	= 1.0D30
     	  DO 61 I=1,NDEG
       	   TEST = ABS (DIMAG(H_OUTPUT(I)))
     	   IF (TEST.LT.1.0E-14) THEN
	     IF (ABS(DREAL(H_OUTPUT(I))).LT.ABS(ANSWER))
     $     	     ANSWER = DREAL ( H_OUTPUT(I) )
     	   END IF
61     	  CONTINUE
	ELSE
C
C Ordinary case : looks for the maximum of the real values; this will set the
C intercept at the fartest sheet of the surface
C
     	  ANSWER	= -1.0D30
     	  DO 71 I=1,NDEG
       	   TEST = ABS (DIMAG(H_OUTPUT(I)))
     	   IF (TEST.LT.1.0E-14) THEN
     	     ANSWER = DMAX1( ANSWER,DREAL ( H_OUTPUT(I) ))
     	   END IF
71     	  CONTINUE
	END IF
	IF (ANSWER.GT.-1.0D30.AND.ANSWER.LT.1.0D30) THEN
	  I_RES	= 0
	ELSE
	  I_RES = -1
	END IF
     	RETURN
     	END
C+++
C	SUBROUTINE	POLY_GRAD
C
C	PURPOSE		To compute the normal to a polinomial surface
C
C	INPUT		P (5,5,5) Polinomial coefficients ( COMMON )
C			POS(3)	  Intercepts 		( Passed )
C
C	OUTPUT		VNOR(3)   Outward gradient; NOT normalized to 1
C
C---
       	SUBROUTINE	POLY_GRAD	(POS, VNOR)
C
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#	include		<common.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
#endif
C
       	DIMENSION	POS (3), VNOR(3)
       	X 	=   POS(1)
       	 Y	=   POS(2)
       	  Z	=   POS(3)
C
C X component
C
       	CTMP	=   0.0D0
       	CTMP	=   CTMP +    PCOEFF(1,0,0) 
       	CTMP	=   CTMP +    PCOEFF(1,0,1) *Z
       	CTMP	=   CTMP +    PCOEFF(1,0,2) *Z**2
       	CTMP	=   CTMP +    PCOEFF(1,0,3) *Z**3
       	CTMP	=   CTMP +    PCOEFF(1,1,0) *Y
       	CTMP	=   CTMP +    PCOEFF(1,2,0) *Y**2
       	CTMP	=   CTMP +    PCOEFF(1,3,0) *Y**3
       	CTMP	=   CTMP + 2* PCOEFF(2,0,0) *X
       	CTMP	=   CTMP + 3* PCOEFF(3,0,0) *X*2
       	CTMP	=   CTMP + 4* PCOEFF(4,0,0) *X**3
       	CTMP	=   CTMP +    PCOEFF(1,1,1) *Y *Z
       	CTMP	=   CTMP +    PCOEFF(1,1,2) *Y *Z**2
       	CTMP	=   CTMP +    PCOEFF(1,2,1) *Y**2 *Z
       	CTMP	=   CTMP + 2* PCOEFF(2,0,1) *X *Z
       	CTMP	=   CTMP + 2* PCOEFF(2,0,2) *X *Z**2
       	CTMP	=   CTMP + 2* PCOEFF(2,1,0) *X *Y
       	CTMP	=   CTMP + 2* PCOEFF(2,2,0) *X *Y**2
       	CTMP	=   CTMP + 3* PCOEFF(3,0,1) *X**2 *Z
       	CTMP	=   CTMP + 3* PCOEFF(3,1,0) *X**2 *Y
       	CTMP	=   CTMP + 2* PCOEFF(2,1,1) *X *Y *Z
       	VNOR(1)	=   CTMP
C
C Y component
C
       	CTMP	=   0.0D0
       	CTMP	=   CTMP +    PCOEFF(0,1,0) 
       	CTMP	=   CTMP +    PCOEFF(0,1,1) *Z
       	CTMP	=   CTMP +    PCOEFF(0,1,2) *Z**2
       	CTMP	=   CTMP +    PCOEFF(0,1,3) *Z**3
       	CTMP	=   CTMP + 2* PCOEFF(0,2,0) *Y
       	CTMP	=   CTMP + 3* PCOEFF(0,3,0) *Y**2
       	CTMP	=   CTMP + 4* PCOEFF(0,4,0) *Y**3
       	CTMP	=   CTMP +    PCOEFF(1,1,0) *X
       	CTMP	=   CTMP +    PCOEFF(2,1,0) *X*2
       	CTMP	=   CTMP +    PCOEFF(3,1,0) *X**3
       	CTMP	=   CTMP + 2* PCOEFF(0,2,1) *Y *Z
       	CTMP	=   CTMP + 2* PCOEFF(0,2,2) *Y *Z**2
       	CTMP	=   CTMP + 3* PCOEFF(0,3,1) *Y**2 *Z
       	CTMP	=   CTMP +    PCOEFF(1,1,1) *X *Z
       	CTMP	=   CTMP +    PCOEFF(1,1,2) *X *Z**2
       	CTMP	=   CTMP + 2* PCOEFF(1,2,0) *X *Y
       	CTMP	=   CTMP + 3* PCOEFF(1,3,0) *X *Y**2
       	CTMP	=   CTMP +    PCOEFF(2,1,1) *X**2 *Z
       	CTMP	=   CTMP + 2* PCOEFF(2,2,0) *X**2 *Y
       	CTMP	=   CTMP + 2* PCOEFF(1,2,1) *X *Y *Z
       	VNOR(2)	=   CTMP
C
C Z component
C
       	CTMP	=   0.0D0
       	CTMP	=   CTMP +    PCOEFF(0,0,1) 
       	CTMP	=   CTMP + 2* PCOEFF(0,0,2) *Z
       	CTMP	=   CTMP + 3* PCOEFF(0,0,3) *Z**2
       	CTMP	=   CTMP + 4* PCOEFF(0,0,4) *Z**3
       	CTMP	=   CTMP +    PCOEFF(0,1,1) *Y
       	CTMP	=   CTMP +    PCOEFF(0,2,1) *Y**2
       	CTMP	=   CTMP +    PCOEFF(0,3,1) *Y**3
       	CTMP	=   CTMP +    PCOEFF(1,0,1) *X
       	CTMP	=   CTMP +    PCOEFF(2,0,1) *X*2
       	CTMP	=   CTMP +    PCOEFF(3,0,1) *X**3
       	CTMP	=   CTMP + 2* PCOEFF(0,1,2) *Y *Z
       	CTMP	=   CTMP + 3* PCOEFF(0,1,3) *Y *Z**2
       	CTMP	=   CTMP + 2* PCOEFF(0,2,2) *Y**2 *Z
       	CTMP	=   CTMP + 2* PCOEFF(1,0,2) *X *Z
       	CTMP	=   CTMP + 3* PCOEFF(1,0,3) *X *Z**2
       	CTMP	=   CTMP +    PCOEFF(1,1,1) *X *Y
       	CTMP	=   CTMP +    PCOEFF(1,2,1) *X *Y**2
       	CTMP	=   CTMP + 2* PCOEFF(2,0,2) *X**2 *Z
       	CTMP	=   CTMP +    PCOEFF(2,1,1) *X**2 *Y
       	CTMP	=   CTMP + 2* PCOEFF(1,1,2) *X *Y *Z
       	VNOR(3)	=   CTMP
C
C All done
C
       	RETURN
       	END

C+++
C	SUBROUTINE	READPOLY
C
C	PURPOSE		To read in ther polinomial coefficents
C
C---
     	SUBROUTINE	READPOLY 	(INFILE, IERR)
C
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#	include		<common.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
#endif
C
     	CHARACTER*80	INFILE
	DO 11 I = 0,4
	  DO 21 J = 0,4
	    DO 31 K = 0,4
	      PCOEFF(I,J,K)	= 0.0D0
31	    CONTINUE
21	  CONTINUE
11	CONTINUE
C
#if defined(vms)
	OPEN (20, FILE=INFILE, STATUS='OLD', READONLY)
#else
     	OPEN (20, FILE=INFILE, STATUS='OLD')
#endif
     	  READ (20,*,ERR=10,END=10)	NDEG
          I = 0
41     	 IF (I.GE.0) THEN
     	   READ (20,*,IOSTAT=IERR) 	I,J,K, PCOEFF(I,J,K)
       	   IF (I.EQ.-1) GO TO 10
		 GOTO 41
     	 END IF
10	CLOSE (20)
       	IERR = 0
       	RETURN
       	END
