C>>>PNP2                                                                PNP2  10
C     ..................................................................PNP2  20
C                                                                       PNP2  30
C        SUBROUTINE PNPOLY                                              PNP2  40
C                                                                       PNP2  50
C        PURPOSE                                                        PNP2  60
C           TO DETERMINE WHETHER A POINT IS INSIDE A POLYGON            PNP2  70
C                                                                       PNP2  80
C        USAGE                                                          PNP2  90
C           CALL PNPOLY (PX, PY, X, Y, N, INOUT )                       PNP2 100
C                                                                       PNP2 110
C        DESCRIPTION OF THE PARAMETERS                                  PNP2 120
C           PX      - X-COORDINATE OF POINT IN QUESTION.                PNP2 130
C           PY      - Y-COORDINATE OF POINT IN QUESTION.                PNP2 140
C           X       - N LONG VECTOR CONTAINING X-COORDINATES OF         PNP2 150
C                     VERTICES OF POLYGON.                              PNP2 160
C           Y       - N LONG VECTOR CONTAINING Y-COORDINATES OF         PNP2 170
C                     VERTICES OF POLYGON.                              PNP2 180
C           N       - NUMBER OF VERTICES IN THE POLYGON.                PNP2 190
C           INOUT   - THE SIGNAL RETURNED:                              PNP2 200
C                     -1 IF THE POINT IS OUTSIDE OF THE POLYGON,        PNP2 210
C                      0 IF THE POINT IS ON AN EDGE OR AT A VERTEX,     PNP2 220
C                      1 IF THE POINT IS INSIDE OF THE POLYGON.         PNP2 230
C                                                                       PNP2 240
C        REMARKS                                                        PNP2 250
C           THE VERTICES MAY BE LISTED IN CLOCKWISE OR ANTICLOCKWISE    PNP2 260
C           ORDER.  FOR THIS SUBROUTINE A POINT IS CONSIDERED INSIDE    PNP2 270
C           THE POLYGON IF IT IS LOCATED IN THE ENCLOSED AREA DEFINED   PNP2 280
C           BY THE LINE FORMING THE POLYGON.                            PNP2 290
C           THE FIRST POINT MAY OPTIONALLY BE REPEATED, IF SO N MAY     PNP2 300
C           OPTIONALLY BE INCREASED BY 1.                               PNP2 310
C           THE INPUT POLYGON MAY BE A COMPOUND POLYGON CONSISTING      PNP2 320
C           OF SEVERAL SEPARATE SUBPOLYGONS. IF SO, THE FIRST VERTEX    PNP2 330
C           OF EACH SUBPOLYGON MUST BE REPEATED, AND WHEN CALCULATING   PNP2 340
C           N, THESE FIRST VERTICES MUST BE COUNTED TWICE.              PNP2 350
C           INOUT IS THE ONLY PARAMETER WHOSE VALUE IS CHANGED.         PNP2 360
C           PNPOLY CAN HANDLE ANY NUMBER OF VERTICES IN THE POLYGON.    PNP2 370
C           WRITTEN BY RANDOLPH FRANKLIN, UNIVERSITY OF OTTAWA, 6/72.   PNP2 380
C                                                                       PNP2 390
C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED                  PNP2 400
C           NONE                                                        PNP2 410
C                                                                       PNP2 420
C        METHOD                                                         PNP2 430
C           A VERTICAL SEMI-INFINITE LINE IS DRAWN UP FROM THE POINT    PNP2 440
C           IN QUESTION. IF IT CROSSES THE POLYGON AN ODD NUMBER OF     PNP2 450
C           TIMES, THEN THE POINT IS INSIDE THE POLYGON.                PNP2 460
C                                                                       PNP2 470
C     ..................................................................PNP2 480
C                                                                       PNP2 490
      SUBROUTINE PNPOLY (PX,PY,X,Y,N,INOUT)                             PNP2 500
      IMPLICIT REAL*8 (A-E,G-H,O-Z)
      IMPLICIT INTEGER*4 (F,I-N)
C
      DIMENSION X(N),Y(N)                                               PNP2 510
      LOGICAL IX,IY,JX,JY,EOR                                           PNP2 520
C     EXCLUSIVE OR FUNCTION.                                            PNP2 530
      EOR(IX,IY)=(IX.OR.IY).AND..NOT.(IX.AND.IY)                        PNP2 540
      INOUT=-1                                                          PNP2 550
      DO 4 I=1,N                                                        PNP2 560
      XI=X(I)-PX                                                        PNP2 570
      YI=Y(I)-PY                                                        PNP2 580
C     CHECK WHETHER THE POINT IN QUESTION IS AT THIS VERTEX.            PNP2 590
      IF (XI.EQ.0.0.AND.YI.EQ.0.0) GO TO 2                              PNP2 600
C     J IS NEXT VERTEX NUMBER OF POLYGON.                               PNP2 610
      J=1+MOD(I,N)                                                      PNP2 620
      XJ=X(J)-PX                                                        PNP2 630
      YJ=Y(J)-PY                                                        PNP2 640
C     IS THIS LINE OF 0 LENGTH ?                                        PNP2 650
      IF (XI.EQ.XJ.AND.YI.EQ.YJ) GO TO 4                                PNP2 660
      IX=XI.GE.0.0                                                      PNP2 670
      IY=YI.GE.0.0                                                      PNP2 680
      JX=XJ.GE.0.0                                                      PNP2 690
      JY=YJ.GE.0.0                                                      PNP2 700
C     CHECK WHETHER (PX,PY) IS ON VERTICAL SIDE OF POLYGON.             PNP2 710
      IF (XI.EQ.0.0.AND.XJ.EQ.0.0.AND.EOR(IY,JY)) GO TO 2               PNP2 720
C     CHECK WHETHER (PX,PY) IS ON HORIZONTAL SIDE OF POLYGON.           PNP2 730
      IF (YI.EQ.0.0.AND.YJ.EQ.0.0.AND.EOR(IX,JX)) GO TO 2               PNP2 740
C     CHECK WHETHER BOTH ENDS OF THIS SIDE ARE COMPLETELY 1) TO RIGHT   PNP2 750
C     OF, 2) TO LEFT OF, OR 3) BELOW (PX,PY).                           PNP2 760
      IF (.NOT.((IY.OR.JY).AND.EOR(IX,JX))) GO TO 4                     PNP2 770
C     DOES THIS SIDE OBVIOUSLY CROSS LINE RISING VERTICALLY FROM (PX,PY)PNP2 780
      IF (.NOT.(IY.AND.JY.AND.EOR(IX,JX))) GO TO 1                      PNP2 790
      INOUT=-INOUT                                                      PNP2 800
      GO TO 4                                                           PNP2 810
1     IF ((YI*XJ-XI*YJ)/(XJ-XI)) 4,2,3                                  PNP2 820
2     INOUT=0                                                           PNP2 830
      RETURN                                                            PNP2 840
3     INOUT=-INOUT                                                      PNP2 850
4     CONTINUE                                                          PNP2 860
      RETURN                                                            PNP2 870
      END                                                               PNP2 880
