C +++
C
C Source: src/lib/normal.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	normal.F
C Revision 1.8  92/09/22  09:29:24  cwelnak
C Facet changes -- G.J. Chen
C 
C Revision 1.7  91/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C 
C Revision 1.6  91/04/05  13:54:31  cwelnak
C changed quotes on #include
C 
C Revision 1.5  91/03/25  10:39:04  cwelnak
C SUN version -- INC to #inc
C 
C Revision 1.4  90/11/13  14:04:59  khan
C Cleanup and SAVE statements
C 
C Revision 1.3  90/07/20  22:05:16  khan
C put #if unix ... to make it work also on vms
C 
C Revision 1.2  90/07/15  15:31:03  khan
C All public include files (common.blk, etc) are now in ./../../include dir.
C 
C Revision 1.1  90/07/10  14:56:36  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE	NORMAL
C
C	PURPOSE		To compute the normal to the mirror surface in
C			a given point.
C
C---
	SUBROUTINE NORMAL (PIN,VOUT)

C
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#include		<common.blk>
#endif
#if defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
#endif
C

	DIMENSION 	PIN(3),VOUT(3)

     	X_IN	= PIN(1)
     	Y_IN	= PIN(2)
     	Z_IN	= PIN(3)

** Computes the normal using the general quadric form;
** remember: the normal is 'outward' for a convex surface.

     	IF (FMIRR.NE.3.AND.FMIRR.NE.9) THEN
** general quadric case.

	  VOUT(1) = 2*CCC(1)*X_IN + 
     $			CCC(4)*Y_IN + CCC(6)*Z_IN + CCC(7)
	  VOUT(2) = 2*CCC(2)*Y_IN + 
     $			CCC(4)*X_IN + CCC(5)*Z_IN + CCC(8)
	  VOUT(3) = 2*CCC(3)*Z_IN + 
     $			CCC(5)*Y_IN + CCC(6)*X_IN + CCC(9)
     	ELSE IF (FMIRR.EQ.3) THEN
** Torus case. The z coordinate is offsetted due to the change in
** ref. frame for this case.
	  IF (F_TORUS.EQ.0) THEN
     	    Z_IN 	= Z_IN - R_MAJ - R_MIN
	  ELSE IF (F_TORUS.EQ.1) THEN
     	    Z_IN 	= Z_IN - R_MAJ + R_MIN
	  ELSE IF (F_TORUS.EQ.2) THEN
     	    Z_IN 	= Z_IN + R_MAJ - R_MIN
	  ELSE IF (F_TORUS.EQ.3) THEN
     	    Z_IN 	= Z_IN + R_MAJ + R_MIN
	  END IF

     	  PART	= X_IN**2 + Y_IN**2 + Z_IN**2

     	  VOUT(1)  = 4*X_IN*(PART + R_MAJ**2 - R_MIN**2)
     	  VOUT(2)  = 4*Y_IN*(PART - (R_MAJ**2 + R_MIN**2))
     	  VOUT(3)  = 4*Z_IN*(PART - (R_MAJ**2 + R_MIN**2))

        TEST=R_MAJ-R_MIN
	 IF (F_FACET.EQ.1.AND.TEST.EQ.0.0D0)  THEN
	  TEST=VOUT(1)**2+VOUT(2)**2+VOUT(3)**2
	    IF(TEST.EQ.0.0D0) THEN
	     VOUT(3)=1.0D0
	    ENDIF
	 ENDIF

       	ELSE IF (FMIRR.EQ.9) THEN
       	  CALL  POLY_GRAD (PIN,VOUT)
     	END IF
     	RETURN
	END
