#if HAVE_DRAND48 || defined(USE_DRAND48) || defined(F2C) || \
    defined(_MSC_VER) || defined(_WIN32)

#include <stdlib.h>

extern double drand48();
extern void srand48(long);

#ifdef _MSC_VER
# define F77Name(name) __stdcall name
#else
# ifndef NO_FORT_UNDERSCORE
#  define F77Name(name) name ## _
# else
#  define F77Name(name) name
# endif
#endif

#ifdef _MSC_VER
# define WRAN F77Name(WRAN)
#else
# define WRAN F77Name(wran)
#endif

double WRAN(int* iseed) {
    static int first = 1;
    int ntries;
    double rand_val;
    if (first) {
	srand48(*iseed);
	first = 0;
    }
    for (ntries = 0; ntries < 10; ++ntries) {
	rand_val = drand48();
	if (rand_val >= 1.0e-20)
	    break;
    }

    if (ntries == 10) {
	printf("ERROR:  Read past end of RANFILE. Aborting.\n");
	exit(1);
    }
    return rand_val;
}

#else /*dummy decls to keep some compilers happy. Stupid!*/

static int dummy_mydrand48_;
#endif
