C +++
C
C Source: src/lib/merfi.f
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: merfi.f
C Revision 1.2  1991/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C
C Revision 1.1  90/07/10  14:56:29  khan
C Initial revision
C 
C 
C ---

C   IMSL ROUTINE NAME   - MERFI                                         MERI0010
C                                                                       MERI0020
C-----------------------------------------------------------------------MERI0030
C                                                                       MERI0040
C   COMPUTER            - VAX/SINGLE                                    MERI0050
C                                                                       MERI0060
C   LATEST REVISION     - JANUARY 1, 1978                               MERI0070
C                                                                       MERI0080
C   PURPOSE             - INVERSE ERROR FUNCTION                        MERI0090
C                                                                       MERI0100
C   USAGE               - CALL MERFI (P,Y,IER)                          MERI0110
C                                                                       MERI0120
C   ARGUMENTS    P      - INPUT VALUE IN THE EXCLUSIVE RANGE (-1.0,1.0) MERI0130
C                Y      - OUTPUT VALUE OF THE INVERSE ERROR FUNCTION    MERI0140
C                IER    - ERROR PARAMETER (OUTPUT)                      MERI0150
C                         TERMINAL ERROR                                MERI0160
C                           IER = 129 INDICATES P LIES OUTSIDE THE LEGALMERI0170
C                             RANGE. PLUS OR MINUS MACHINE INFINITY IS  MERI0180
C                             GIVEN AS THE RESULT (SIGN IS THE SIGN OF  MERI0190
C                             THE FUNCTION VALUE OF THE NEAREST LEGAL   MERI0200
C                             ARGUMENT).                                MERI0210
C                                                                       MERI0220
C   PRECISION/HARDWARE  - SINGLE/ALL                                    MERI0230
C                                                                       MERI0240
C   REQD. IMSL ROUTINES - UERTST,UGETIO                                 MERI0250
C                                                                       MERI0260
C   NOTATION            - INFORMATION ON SPECIAL NOTATION AND           MERI0270
C                           CONVENTIONS IS AVAILABLE IN THE MANUAL      MERI0280
C                           INTRODUCTION OR THROUGH IMSL ROUTINE UHELP  MERI0290
C                                                                       MERI0300
C   COPYRIGHT           - 1978 BY IMSL, INC. ALL RIGHTS RESERVED.       MERI0310
C                                                                       MERI0320
C   WARRANTY            - IMSL WARRANTS ONLY THAT IMSL TESTING HAS BEEN MERI0330
C                           APPLIED TO THIS CODE. NO OTHER WARRANTY,    MERI0340
C                           EXPRESSED OR IMPLIED, IS APPLICABLE.        MERI0350
C                                                                       MERI0360
C-----------------------------------------------------------------------MERI0370
C                                                                       MERI0380
      SUBROUTINE MERFI (P,Y,IER)                                        MERI0390
C                                  SPECIFICATIONS FOR ARGUMENTS         MERI0400
C      REAL               P,Y                                            MERI0410
      IMPLICIT DOUBLE PRECISION (A-H, O-Z)
      INTEGER            IER                                            MERI0420
C                                  SPECIFICATIONS FOR LOCAL VARIABLES   MERI0430
      REAL               A,B,X,Z,W,WI,SN,SD,F,Z2,RINFM,A1,A2,A3,B0,B1,  MERI0440
     *                   B2,B3,C0,C1,C2,C3,D0,D1,D2,E0,E1,E2,E3,F0,F1,  MERI0450
     *                   F2,G0,G1,G2,G3,H0,H1,H2,SIGMA                  MERI0460
      DATA               A1/-.5751703/,A2/-1.896513/,A3/-.5496261E-1/   MERI0470
      DATA               B0/-.1137730/,B1/-3.293474/,B2/-2.374996/      MERI0480
      DATA               B3/-1.187515/                                  MERI0490
      DATA               C0/-.1146666/,C1/-.1314774/,C2/-.2368201/      MERI0500
      DATA               C3/.5073975E-1/                                MERI0510
      DATA               D0/-44.27977/,D1/21.98546/,D2/-7.586103/       MERI0520
      DATA               E0/-.5668422E-1/,E1/.3937021/,E2/-.3166501/    MERI0530
      DATA               E3/.6208963E-1/                                MERI0540
      DATA               F0/-6.266786/,F1/4.666263/,F2/-2.962883/       MERI0550
      DATA               G0/.1851159E-3/,G1/-.2028152E-2/               MERI0560
      DATA               G2/-.1498384/,G3/.1078639E-1/                  MERI0570
      DATA               H0/.9952975E-1/,H1/.5211733/                   MERI0580
      DATA               H2/-.6888301E-1/                               MERI0590
      DATA               RINFM/1.7014E+38/                              MERI0600
C                                  FIRST EXECUTABLE STATEMENT           MERI0610
      IER = 0                                                           MERI0620
      X = P                                                             MERI0630
      SIGMA = SIGN(1.0,X)                                               MERI0640
C                                  TEST FOR INVALID ARGUMENT            MERI0650
      IF (.NOT.(X.GT.-1. .AND. X.LT.1.)) GO TO 30                       MERI0660
      Z = ABS(X)                                                        MERI0670
      IF (Z.LE. .85) GO TO 20                                           MERI0680
      A = 1.-Z                                                          MERI0690
      B = Z                                                             MERI0700
C                                  REDUCED ARGUMENT IS IN (.85,1.),     MERI0710
C                                     OBTAIN THE TRANSFORMED VARIABLE   MERI0720
    5 W = SQRT(-ALOG(A+A*B))                                            MERI0730
      IF (W.LT.2.5) GO TO 15                                            MERI0740
      IF (W.LT.4.) GO TO 10                                             MERI0750
C                                  W GREATER THAN 4., APPROX. F BY A    MERI0760
C                                     RATIONAL FUNCTION IN 1./W         MERI0770
      WI = 1./W                                                         MERI0780
      SN = ((G3*WI+G2)*WI+G1)*WI                                        MERI0790
      SD = ((WI+H2)*WI+H1)*WI+H0                                        MERI0800
      F = W + W*(G0+SN/SD)                                              MERI0810
      GO TO 25                                                          MERI0820
C                                  W BETWEEN 2.5 AND 4., APPROX. F      MERI0830
C                                     BY A RATIONAL FUNCTION IN W       MERI0840
   10 SN = ((E3*W+E2)*W+E1)*W                                           MERI0850
      SD = ((W+F2)*W+F1)*W+F0                                           MERI0860
      F = W + W*(E0+SN/SD)                                              MERI0870
      GO TO 25                                                          MERI0880
C                                  W BETWEEN 1.13222 AND 2.5, APPROX.   MERI0890
C                                     F BY A RATIONAL FUNCTION IN W     MERI0900
   15 SN = ((C3*W+C2)*W+C1)*W                                           MERI0910
      SD = ((W+D2)*W+D1)*W+D0                                           MERI0920
      F = W + W*(C0+SN/SD)                                              MERI0930
      GO TO 25                                                          MERI0940
C                                  Z BETWEEN 0. AND .85, APPROX. F      MERI0950
C                                     BY A RATIONAL FUNCTION IN Z       MERI0960
   20 Z2 = Z*Z                                                          MERI0970
      F = Z+Z*(B0+A1*Z2/(B1+Z2+A2/(B2+Z2+A3/(B3+Z2))))                  MERI0980
C                                  FORM THE SOLUTION BY MULT. F BY      MERI0990
C                                     THE PROPER SIGN                   MERI1000
   25 Y = SIGMA*F                                                       MERI1010
      IER = 0                                                           MERI1020
      GO TO 9005                                                        MERI1030
C                                  ERROR EXIT. SET SOLUTION TO PLUS     MERI1040
C                                     (OR MINUS) INFINITY               MERI1050
   30 IER = 129                                                         MERI1060
      Y = SIGMA * RINFM                                                 MERI1070
 9000 CONTINUE                                                          MERI1080
      CALL UERTST(IER,6HMERFI )                                         MERI1090
 9005 RETURN                                                            MERI1100
      END                                                               MERI1110
C   IMSL ROUTINE NAME   - MERRC=ERFC                                    MESA0010
