C +++
C
C Source: src/lib/icsccu.f
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: icsccu.f
C Revision 1.3  1992/01/23  19:43:04  cwelnak
C 6000 changes
C
C Revision 1.2  1991/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C
C Revision 1.1  90/07/10  14:56:12  khan
C Initial revision
C 
C 
C ---

C   IMSL ROUTINE NAME   - ICSCCU                                        ICAC0010
C                                                                       ICAC0020
C-----------------------------------------------------------------------ICAC0030
C                                                                       ICAC0040
C   COMPUTER            - VAX/DOUBLE                                    ICAC0050
C                                                                       ICAC0060
C   LATEST REVISION     - JUNE 1, 1980                                  ICAC0070
C                                                                       ICAC0080
C   PURPOSE             - CUBIC SPLINE INTERPOLATION                    ICAC0090
C                           (EASY-TO-USE VERSION)                       ICAC0100
C                                                                       ICAC0110
C   USAGE               - CALL ICSCCU (X,Y,NX,C,IC,IER)                 ICAC0120
C                                                                       ICAC0130
C   ARGUMENTS    X      - VECTOR OF LENGTH NX CONTAINING THE ABSCISSAE  ICAC0140
C                           OF THE NX DATA POINTS (X(I),Y(I)) I=1,...,  ICAC0150
C                           NX. (INPUT) X MUST BE ORDERED SO THAT       ICAC0160
C                           X(I) .LT. X(I+1).                           ICAC0170
C                Y      - VECTOR OF LENGTH NX CONTAINING THE ORDINATES  ICAC0180
C                           (OR FUNCTION VALUES) OF THE NX DATA POINTS. ICAC0190
C                           (INPUT)                                     ICAC0200
C                NX     - NUMBER OF ELEMENTS IN X AND Y. (INPUT) NX     ICAC0210
C                           MUST BE .GE. 2.                             ICAC0220
C                C      - SPLINE COEFFICIENTS. (OUTPUT) C IS AN NX-1 BY ICAC0230
C                           3 MATRIX. THE VALUE OF THE SPLINE           ICAC0240
C                           APPROXIMATION AT T IS                       ICAC0250
C                           S(T) = ((C(I,3)*D+C(I,2))*D+C(I,1))*D+Y(I)  ICAC0260
C                           WHERE X(I) .LE. T .LT. X(I+1) AND           ICAC0270
C                           D = T-X(I).                                 ICAC0280
C                IC     - ROW DIMENSION OF MATRIX C EXACTLY AS          ICAC0290
C                           SPECIFIED IN THE DIMENSION STATEMENT IN     ICAC0300
C                           THE CALLING PROGRAM. (INPUT)                ICAC0310
C                IER    - ERROR PARAMETER. (OUTPUT)                     ICAC0320
C                         TERMINAL ERROR                                ICAC0330
C                           IER = 129, IC IS LESS THAN NX-1.            ICAC0340
C                           IER = 130, NX IS LESS THAN 2.               ICAC0350
C                           IER = 131, INPUT ABSCISSA ARE NOT ORDERED   ICAC0360
C                             SO THAT X(1) .LT. X(2) ... .LT. X(NX).    ICAC0370
C                                                                       ICAC0380
C   PRECISION/HARDWARE  - SINGLE AND DOUBLE/H32                         ICAC0390
C                       - SINGLE/H36,H48,H60                            ICAC0400
C                                                                       ICAC0410
C   REQD. IMSL ROUTINES - UERTST,UGETIO                                 ICAC0420
C                                                                       ICAC0430
C   NOTATION            - INFORMATION ON SPECIAL NOTATION AND           ICAC0440
C                           CONVENTIONS IS AVAILABLE IN THE MANUAL      ICAC0450
C                           INTRODUCTION OR THROUGH IMSL ROUTINE UHELP  ICAC0460
C                                                                       ICAC0470
C   COPYRIGHT           - 1980 BY IMSL, INC. ALL RIGHTS RESERVED.       ICAC0480
C                                                                       ICAC0490
C   WARRANTY            - IMSL WARRANTS ONLY THAT IMSL TESTING HAS BEEN ICAC0500
C                           APPLIED TO THIS CODE. NO OTHER WARRANTY,    ICAC0510
C                           EXPRESSED OR IMPLIED, IS APPLICABLE.        ICAC0520
C                                                                       ICAC0530
C-----------------------------------------------------------------------ICAC0540
C                                                                       ICAC0550
      SUBROUTINE ICSCCU (X,Y,NX,C,IC,IER)                               ICAC0560
C                                  SPECIFICATIONS FOR ARGUMENTS         ICAC0570
      INTEGER            NX,IC,IER                                      ICAC0580
      DOUBLE PRECISION   X(NX),Y(NX),C(IC,3)                            ICAC0590
C                                  SPECIFICATIONS FOR LOCAL VARIABLES   ICAC0600
      INTEGER            IM1,I,JJ,J,MM1,MP1,M,NM1,NM2                   ICAC0610
      DOUBLE PRECISION   DIVDF1,DIVDF3,DTAU,G,CNX(3)                    ICAC0620
C                                  FIRST EXECUTABLE STATEMENT           ICAC0630
      NM1 = NX-1                                                        ICAC0640
      IER = 129                                                         ICAC0650
      IF (IC .LT. NM1) GO TO 9000                                       ICAC0660
      IER = 130                                                         ICAC0670
      IF (NX .LT. 2) GO TO 9000                                         ICAC0680
      IER = 131                                                         ICAC0690
      IF (NX .EQ. 2) GO TO 45                                           ICAC0700
C                                  COMPUTE NOT-A-KNOT SPLINE            ICAC0710
      DO 5 M = 2,NM1                                                    ICAC0720
         MM1=M-1                                                        ICAC0730
         C(M,2) = X(M)-X(MM1)                                           ICAC0740
         IF (C(M,2).LE.0.0D0) GO TO 9000                                ICAC0750
         C(M,3) = (Y(M)-Y(MM1))/C(M,2)                                  ICAC0760
    5 CONTINUE                                                          ICAC0770
      CNX(2) = X(NX)-X(NM1)                                             ICAC0780
      IF (CNX(2).LE.0.0D0) GO TO 9000                                   ICAC0790
      CNX(3) = (Y(NX)-Y(NM1))/CNX(2)                                    ICAC0800
      IER = 0                                                           ICAC0810
      NM2 = NX-2                                                        ICAC0820
      IF (NX .GT. 3) GO TO 10                                           ICAC0830
      C(1,3) = CNX(2)                                                   ICAC0840
      C(1,2) = C(2,2)+CNX(2)                                            ICAC0850
      C(1,1) = ((C(2,2)+2.D0*C(1,2))*C(2,3)*CNX(2)+C(2,2)**2*CNX(3))    ICAC0860
     1/C(1,2)                                                           ICAC0870
      GO TO 20                                                          ICAC0880
   10 C(1,3) = C(3,2)                                                   ICAC0890
      C(1,2) = C(2,2)+C(3,2)                                            ICAC0900
      C(1,1) = ((C(2,2)+2.D0*C(1,2))*C(2,3)*C(3,2)+C(2,2)**2*C(3,3))    ICAC0910
     1/C(1,2)                                                           ICAC0920
      DO 15 M=2,NM2                                                     ICAC0930
         MP1=M+1                                                        ICAC0940
         MM1=M-1                                                        ICAC0950
         G = -C(MP1,2)/C(MM1,3)                                         ICAC0960
         C(M,1) = G*C(MM1,1)+3.D0*C(M,2)*C(MP1,3)+3.D0*C(MP1,2)*C(M,3)  ICAC0970
         C(M,3) = G*C(MM1,2)+2.D0*C(M,2)+2.D0*C(MP1,2)                  ICAC0980
   15 CONTINUE                                                          ICAC0990
   20 G = -CNX(2)/C(NM2,3)                                              ICAC1000
      C(NM1,1) = G*C(NM2,1)+3.D0*C(NM1,2)*CNX(3)+3.D0*CNX(2)*C(NM1,3)   ICAC1010
      C(NM1,3) = G*C(NM2,2)+2.D0*C(NM1,2)+2.D0*CNX(2)                   ICAC1020
      IF (NX.GT.3) GO TO 25                                             ICAC1030
      CNX(1)=2.D0*CNX(3)                                                ICAC1040
      CNX(3)=1.D0                                                       ICAC1050
      G=-1.D0/C(NM1,3)                                                  ICAC1060
      GO TO 30                                                          ICAC1070
   25 G = C(NM1,2)+CNX(2)                                               ICAC1080
      CNX(1) = ((CNX(2)+2.D0*G)*CNX(3)*C(NM1,2)+CNX(2)**2*              ICAC1090
     1(Y(NM1)-Y(NX-2))/C(NM1,2))/G                                      ICAC1100
      G = -G/C(NM1,3)                                                   ICAC1110
      CNX(3) = C(NM1,2)                                                 ICAC1120
   30 CNX(3) = G*C(NM1,2)+CNX(3)                                        ICAC1130
      CNX(1) = (G*C(NM1,1)+CNX(1))/CNX(3)                               ICAC1140
      C(NM1,1) = (C(NM1,1)-C(NM1,2)*CNX(1))/C(NM1,3)                    ICAC1150
      DO 35 JJ=1,NM2                                                    ICAC1160
         J = NM1-JJ                                                     ICAC1170
         C(J,1) = (C(J,1)-C(J,2)*C(J+1,1))/C(J,3)                       ICAC1180
   35 CONTINUE                                                          ICAC1190
      DO 40 I=2,NM1                                                     ICAC1200
         IM1 = I-1                                                      ICAC1210
         DTAU = C(I,2)                                                  ICAC1220
         DIVDF1 = (Y(I)-Y(IM1))/DTAU                                    ICAC1230
         DIVDF3 = C(IM1,1)+C(I,1)-2.D0*DIVDF1                           ICAC1240
         C(IM1,2) = (DIVDF1-C(IM1,1)-DIVDF3)/DTAU                       ICAC1250
         C(IM1,3) = DIVDF3/DTAU**2                                      ICAC1260
   40 CONTINUE                                                          ICAC1270
      DTAU = CNX(2)                                                     ICAC1280
      DIVDF1 = (Y(NX)-Y(NM1))/DTAU                                      ICAC1290
      DIVDF3 = C(NM1,1)+CNX(1)-2.D0*DIVDF1                              ICAC1300
      C(NM1,2) = (DIVDF1-C(NM1,1)-DIVDF3)/DTAU                          ICAC1310
      C(NM1,3) = DIVDF3/DTAU**2                                         ICAC1320
      GO TO 9005                                                        ICAC1330
   45 IF (X(1) .GE. X(2)) GO TO 9000                                    ICAC1340
      IER = 0                                                           ICAC1350
      C(1,1) = (Y(2)-Y(1))/(X(2)-X(1))                                  ICAC1360
      C(1,2) = 0.0D0                                                    ICAC1370
      C(1,3) = 0.0D0                                                    ICAC1380
      GO TO 9005                                                        ICAC1390
 9000 CONTINUE                                                          ICAC1400
      CALL UERTST(IER,6HICSCCU)                                         ICAC1410
 9005 RETURN                                                            ICAC1420
      END                                                               ICAC1430
C   IMSL ROUTINE NAME   - ICSEVU                                        ICAE0010
C                                                                       ICAE0020
C-----------------------------------------------------------------------ICAE0030
C                                                                       ICAE0040
C   COMPUTER            - VAX/DOUBLE                                    ICAE0050
C                                                                       ICAE0060
C   LATEST REVISION     - JANUARY 1, 1978                               ICAE0070
C                                                                       ICAE0080
C   PURPOSE             - EVALUATION OF A CUBIC SPLINE                  ICAE0090
C                                                                       ICAE0100
C   USAGE               - CALL ICSEVU(X,Y,NX,C,IC,U,S,M,IER)            ICAE0110
C                                                                       ICAE0120
C   ARGUMENTS    X      - VECTOR OF LENGTH NX CONTAINING THE ABSCISSAE  ICAE0130
C                           OF THE NX DATA POINTS (X(I),Y(I)) I=1,...,  ICAE0140
C                           NX (INPUT). X MUST BE ORDERED SO THAT       ICAE0150
C                           X(I) .LT. X(I+1).                           ICAE0160
C                Y      - VECTOR OF LENGTH NX CONTAINING THE ORDINATES  ICAE0170
C                           (OR FUNCTION VALUES) OF THE NX DATA POINTS  ICAE0180
C                           (INPUT).                                    ICAE0190
C                NX     - NUMBER OF ELEMENTS IN X AND Y (INPUT).        ICAE0200
C                           NX MUST BE .GE. 2.                          ICAE0210
C                C      - SPLINE COEFFICIENTS (INPUT). C IS AN NX-1 BY  ICAE0220
C                           3 MATRIX.                                   ICAE0230
C                IC     - ROW DIMENSION OF MATRIX C EXACTLY AS          ICAE0240
C                           SPECIFIED IN THE DIMENSION STATEMENT        ICAE0250
C                           IN THE CALLING PROGRAM (INPUT).             ICAE0260
C                           IC MUST BE .GE. NX-1.                       ICAE0270
C                U      - VECTOR OF LENGTH M CONTAINING THE ABSCISSAE   ICAE0280
C                           OF THE M POINTS AT WHICH THE CUBIC SPLINE   ICAE0290
C                           IS TO BE EVALUATED (INPUT).                 ICAE0300
C                S      - VECTOR OF LENGTH M (OUTPUT).                  ICAE0310
C                           THE VALUE OF THE SPLINE APPROXIMATION AT    ICAE0320
C                           U(I) IS                                     ICAE0330
C                           S(I) = ((C(J,3)*D+C(J,2))*D+C(J,1))*D+Y(J)  ICAE0340
C                           WHERE X(J) .LE. U(I) .LT. X(J+1) AND        ICAE0350
C                           D = U(I)-X(J).                              ICAE0360
C                M      - NUMBER OF ELEMENTS IN U AND S (INPUT).        ICAE0370
C                IER    - ERROR PARAMETER (OUTPUT).                     ICAE0380
C                         WARNING ERROR                                 ICAE0390
C                           IER = 33, U(I) IS LESS THAN X(1).           ICAE0400
C                           IER = 34, U(I) IS GREATER THAN X(NX).       ICAE0410
C                                                                       ICAE0420
C   PRECISION/HARDWARE  - SINGLE AND DOUBLE/H32                         ICAE0430
C                       - SINGLE/H36,H48,H60                            ICAE0440
C                                                                       ICAE0450
C   REQD. IMSL ROUTINES - UERTST,UGETIO                                 ICAE0460
C                                                                       ICAE0470
C   NOTATION            - INFORMATION ON SPECIAL NOTATION AND           ICAE0480
C                           CONVENTIONS IS AVAILABLE IN THE MANUAL      ICAE0490
C                           INTRODUCTION OR THROUGH IMSL ROUTINE UHELP  ICAE0500
C                                                                       ICAE0510
C   REMARKS  1.  THE ROUTINE ASSUMES THAT THE ABSCISSAE OF THE NX       ICAE0520
C                DATA POINTS ARE ORDERED SUCH THAT X(I) IS LESS THAN    ICAE0530
C                X(I+1) FOR I=1,...,NX-1. NO CHECK OF THIS CONDITION    ICAE0540
C                IS MADE IN THE ROUTINE. UNORDERED ABSCISSAE WILL CAUSE ICAE0550
C                THE ALGORITHM TO PRODUCE INCORRECT RESULTS.            ICAE0560
C            2.  THE ROUTINE GENERATES TWO WARNING ERRORS. ONE ERROR    ICAE0570
C                OCCURS IF U(I) IS LESS THAN X(1), FOR SOME I IN THE    ICAE0580
C                THE INTERVAL (1,M) INCLUSIVELY. THE OTHER ERROR OCCURS ICAE0590
C                IF U(I) IS GREATER THAN X(NX), FOR SOME I IN THE       ICAE0600
C                INTERVAL (1,M) INCLUSIVELY.                            ICAE0610
C            3.  THE ORDINATE Y(NX) IS NOT USED BY THE ROUTINE. FOR     ICAE0620
C                U(K) .GT. X(NX-1), THE VALUE OF THE SPLINE, S(K), IS   ICAE0630
C                GIVEN BY                                               ICAE0640
C                 S(K)=((C(NX-1,3)*D+C(NX-1,2))*D+C(NX-1,1))*D+Y(NX-1)  ICAE0650
C                WHERE D=U(K)-X(NX-1).                                  ICAE0660
C                                                                       ICAE0670
C   COPYRIGHT           - 1978 BY IMSL, INC. ALL RIGHTS RESERVED.       ICAE0680
C                                                                       ICAE0690
C   WARRANTY            - IMSL WARRANTS ONLY THAT IMSL TESTING HAS BEEN ICAE0700
C                           APPLIED TO THIS CODE. NO OTHER WARRANTY,    ICAE0710
C                           EXPRESSED OR IMPLIED, IS APPLICABLE.        ICAE0720
C                                                                       ICAE0730
C-----------------------------------------------------------------------ICAE0740
C                                                                       ICAE0750
      SUBROUTINE ICSEVU  (X,Y,NX,C,IC,U,S,M,IER)                        ICAE0760
C                                  SPECIFICATIONS FOR ARGUMENTS         ICAE0770
      INTEGER            NX,IC,M,IER                                    ICAE0780
      DOUBLE PRECISION   X(NX),Y(NX),C(IC,3),U(M),S(M)                  ICAE0790
C                                  SPECIFICATIONS FOR LOCAL VARIABLES   ICAE0800
      INTEGER            I,JER,KER,NXM1,K                               ICAE0810
      DOUBLE PRECISION   D,DD,ZERO                                      ICAE0820
      DATA               I/1/,ZERO/0.0D0/                               ICAE0830
C                                  FIRST EXECUTABLE STATEMENT           ICAE0840
      JER = 0                                                           ICAE0850
      KER = 0                                                           ICAE0860
      IF (M .LE. 0) GO TO 9005                                          ICAE0870
      NXM1 = NX-1                                                       ICAE0880
      IF (I .GT. NXM1) I = 1                                            ICAE0890
C                                  EVALUATE SPLINE AT M POINTS          ICAE0900
      DO 40 K=1,M                                                       ICAE0910
C                                  FIND THE PROPER INTERVAL             ICAE0920
         D = U(K)-X(I)                                                  ICAE0930
         IF (D) 5,25,15                                                 ICAE0940
    5    IF (I .EQ. 1) GO TO 30                                         ICAE0950
         I = I-1                                                        ICAE0960
         D = U(K)-X(I)                                                  ICAE0970
         IF (D) 5,25,20                                                 ICAE0980
   10    I = I+1                                                        ICAE0990
         D = DD                                                         ICAE1000
   15    IF (I .GE. NX) GO TO 35                                        ICAE1010
         DD = U(K)-X(I+1)                                               ICAE1020
         IF (DD .GE. ZERO) GO TO 10                                     ICAE1030
         IF (D .EQ. ZERO) GO TO 25                                      ICAE1040
C                                  PERFORM EVALUATION                   ICAE1050
   20    S(K) = ((C(I,3)*D+C(I,2))*D+C(I,1))*D+Y(I)                     ICAE1060
         GO TO 40                                                       ICAE1070
   25    S(K) = Y(I)                                                    ICAE1080
         GO TO 40                                                       ICAE1090
C                                  WARNING - U(I) .LT. X(1)             ICAE1100
   30    JER = 33                                                       ICAE1110
         GO TO 20                                                       ICAE1120
C                                  IF U(I) .GT. X(NX) - WARNING         ICAE1130
C
C floating point is a little too good on the 6000. instead of comparing
C to zero, compare the absolute value to 1.0E-18D0.  otherwise every 
C ray will generate an error message for the incoming value of
C +PSIMAX.   
C 1/23/92 decide to keep above change for all machines.
C
   35    IF (DABS(DD).GT.(1.0E-18)) KER = 34                            ICAE1140
         D = U(K)-X(NXM1)                                               ICAE1150
         I = NXM1                                                       ICAE1160
         GO TO 20                                                       ICAE1170
   40 CONTINUE                                                          ICAE1180
      IER = MAX0(JER,KER)                                               ICAE1190
 9000 CONTINUE                                                          ICAE1200
      IF (JER .GT. 0) CALL UERTST(JER,6HICSEVU)                         ICAE1210
      IF (KER .GT. 0) CALL UERTST(KER,6HICSEVU)                         ICAE1220
 9005 RETURN                                                            ICAE1230
      END                                                               ICAE1240
