C +++
C
C Source: src/lib/iblank.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: iblank.F
C Revision 1.6  1991/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C
C Revision 1.5  91/04/05  13:54:21  cwelnak
C changed quotes on #include
C 
C Revision 1.4  91/03/22  12:19:48  cwelnak
C SUN version -- INC to #inc
C 
C Revision 1.3  90/11/13  14:04:52  khan
C Cleanup and SAVE statements
C 
C Revision 1.2  90/07/20  22:05:08  khan
C put #if unix ... to make it work also on vms
C 
C Revision 1.1  90/07/18  17:35:06  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C +++
C 	integer 	function 	iblank
C
C	purpose		Returns the last non-white spot in the string.
C
C	input		a fortran character string.
C	output		Index of the last non-white char in the string.
C			Empty strings return 1.
C	hacked by	Mumit Khan
C ---
	integer function iblank (str)
	implicit 	none
	character*(*) 	str
	integer 	ilen, i
	integer		ASCII_TAB
	parameter	(ASCII_TAB = 9)
	character*1	tabchar
c
c start at the back and work your way back the string until a non-white 
c character is hit or beginning of string (== empty string).
c
	tabchar = char(ASCII_TAB)
	ilen = len(str)
	do 10 i = ilen, 1, -1
	  if (str(i:i).NE.' ' .AND. str(i:i).NE.tabchar) then
	    goto 20
	  endif
 10	continue
c
 20	iblank = i
	return
	end
