C +++
C
C Source: src/lib/get_file.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

#if defined(unix) || defined(__CYGWIN32__)

	subroutine get_file_text (dir_text, filein)
        character*(*)  dir_text
        character*(*)  filein
c
	external getenv
	integer getcwd
	integer retcode
	integer ilen
c
c get the current directory from unix. If fails, report the error and
c simply return '.' as the current directory.
c
c first try to see if CWD env variable is set; if not, then try to get
c it from Unix using getcwd(). CWD is the preferable one since it works
c well with automounted paths.
c
	call getenv('PWD', dir_text)
	if (dir_text(1:1) .eq. ' ') then
	    retcode = getcwd (dir_text)
	    if (retcode .ne. 0) then
		write(*,*) 'Error: No current working directory!'
		dir_text = '.'
	    endif
	endif
c
c now simply append the FILEIN to the CWD.
c
	call despace(dir_text, dir_text, ilen)
	dir_text = dir_text(1:ilen) // '/' // filein
c	
	return
	end

#endif
