C +++
C
C get_env_variable.F: get SHAVOW env variable from env, registry etc
C
C Source: src/lib/get_env_variable.F
C
C Author: Mumit Khan <khan@xraylith.wisc.edu>
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C
C Copyright(c) 1996,1997 Mumit Khan
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

	subroutine get_env_variable (var, value, iflag)
c++
c
c get_file_variable -- returns the value of "var" 
c
c input:
c    var:    the name of the SHADOW variable (eg., "SHADOW_ROOT")
c
c returns: 
c    value:  the returned value. Unmodified if not found (==> iflag = 1)
c    iflag:  0 if ok
c            1 does not exist
c
c--
	implicit 	none
	character*(*)	var, value
	integer		iflag
#if defined(unix) || defined(_WIN32)
	character*1024	tmpstr
#endif
c
c assume not found.
c
	iflag = 1
c
c
#ifdef vms
c
c On VMS, simply return original variable since DCL will the job for us.
c Let's just hope it actually exists! 
c
	iflag = 0
	value = var
	return
c
#elif defined(_WIN32)
c
c for win32 (includes cygwin32), we search the environment first and then
c search registry next.
c
	call getenv (var, tmpstr)
	if (tmpstr(1:1).eq.' ') then
	  call win32_get_registry_value(var, tmpstr)
	endif
	if (tmpstr(1:1).ne.' ') then
	  value = tmpstr
	  iflag = 0
	endif
c
#elif defined(unix)
c
c unix and such OSs with environment variable is trickier, since we want
c better control.
c
	call getenv (var, tmpstr)
	if (tmpstr(1:1).ne.' ') then
	  value = tmpstr
	  iflag = 0
	endif
#else /* not a known system */
c # warning UNKNOWN SYSTEM. REPORT TO SHADOW MAINTAINER. 
c
c on systems we know nothing about, simply return unmodified.
c
	iflag = 0
	return
#endif
c
	end
