C +++
C
C String manipulation routines in FORTRAN.
C
C Source: src/lib/fstring.F
C
C Author: Mumit Khan <khan@xraylith.wisc.edu>
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C
C Copyright(c) 1996 Mumit Khan
C 

C
C Currently implemented routines:
C
C  fstrtrim, fstrtrim_l, fstrtrim_r: White space trimmers
C  fstrchr: C strchr like routine
C  fstrupcase: Upcase a string
C  fstrlocase: Upcase a string
C  fstrfill: Fills a string with whatever character
C  

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

c
c Portability Warning: A better way?
c
#ifndef ASCII_TAB
# define ASCII_TAB	9
#endif

	subroutine fstrtrim (string, index1, index2)
	implicit integer (a-z)
c++
c	subroutine fstrtrim (string, index1, index2)
c
c  Returns the length of the string less any leading & trailing blanks
c
c	string		- input/string
c       index1, index2  - first/last non-white character
c                         -1 if error
c			  if string is blank, returns 0 for both
c
c--
	character*(*) string
c
	call fstrtrim_l(string, index1)
	call fstrtrim_r(string, index2)
	return
	end

c
c
c
	subroutine fstrtrim_l (string, index)
	implicit integer (a-z)
c++
c	subroutine fstrtrim_l (string, index)
c
c  Returns the length of the string less any leading blanks
c
c	string		- input/string
c       index           - index of first non-white character
c                         -1 if error
c			  if string is blank, returns 0
c
c--
	character*(*) string
	character*(1) tabchar
c
	tabchar = char(ASCII_TAB)
c
	l = len(string)
c
	if (l .eq. 0) then
	    i = 0
	    goto 99
	endif
c
	istart = 1
	iend = l
	incr = 1
c
	do 10 i = istart, iend, incr
	    if (string(i:i) .ne. ' ' 
     $	        .and. string(i:i) .ne. tabchar) goto 99
 10     continue
c
c  string is either blank or no leading space
c
	i = 0
c
c  return string length
c
 99	continue
	index = i
	return
	end

	subroutine fstrtrim_r (string, index)
	implicit integer (a-z)
c++
c	subroutine fstrtrim_r (string, index)
c
c  Returns the length of the string less any trailing blanks
c
c	string		- input/string
c       index           - index of last non-white character
c                         -1 if error
c			  if string is blank, returns 0
c
c--
	character*(*) string
	character*(1) tabchar
c
	tabchar = char(ASCII_TAB)
c
	l = len(string)
c
	if (l .eq. 0) then
	    i = 0
	    goto 99
	endif
c
	istart = l
	iend = 1
	incr = -1
c
	do 10 i = istart, iend, incr
	    if (string(i:i) .ne. ' ' 
     $	        .and. string(i:i) .ne. tabchar) goto 99
 10     continue
c
c  string is either blank or no leading space
c
	i = 0
c
c  return string length
c
 99	continue
	index = i
	return
	end

	subroutine fstrupcase (string)
	implicit integer (a-z)
c++
c	subroutine fstrupcase (string)
c
c  Convert string to upper case
c  Warning: Blows up if passed string in read-only memory (literal)
c
c	string		- transput/string
c			  string is converted to uppercase
c--
	character*(*) string
c
	do 101 i = 1, len(string)
	    ival = ichar(string(i:i))
	    if (ival .ge. ichar('a') .and. ival .le. ichar('z')) then
		ival = ival - (ichar('a')-ichar('A'))
		string(i:i) = char(ival)
	    endif
 101	continue
c
	return
	end

	subroutine fstrlocase (string)
	implicit integer (a-z)
c++
c	subroutine fstrlocase (string)
c
c  Convert string to lower case
c  Warning: Blows up if passed string in read-only memory (literal)
c
c	string		- transput/string
c			  string is converted to lowercase
c--
	character*(*) string
c
	do 101 i = 1, len(string)
	    ival = ichar(string(i:i))
	    if (ival .ge. ichar('A') .and. ival .le. ichar('Z')) then
		ival = ival + (ichar('a')-ichar('A'))
		string(i:i) = char(ival)
	    endif
 101	continue
c
	return
	end

	subroutine fstrfill (string, what, iflag)
	implicit integer (a-z)
c++
c fstrfill -- fill a string with the given character
c
c inputs:
c    string -- a character string 
c    what   -- the character to search for (character(1))
c
c outputs:
c    iflag: 0 AOK
c	   -1 if any input is misbehaved!
c
c--
	character*(*) string, what
c
	if (len(what) .ne. 1) then
	    iflag = -1
	    goto 99
	endif
c
	do 10 i = 1, len(string)
	    string(i:i) = what
 10	continue
	iflag = 0
	goto 99
c
 99	continue
 	return
	end

c
c
c
	subroutine fstrchr (string, what, iflag)
	implicit integer (a-z)
c++
c
c
c fstrchr -- a mixture of C version of strchr
c
c inputs:
c    string -- a character string 
c    what   -- the character to search for (character(1))
c
c outputs:
c    iflag: 0 error, ie., not found
c	   -1 if any input is misbehaved!
c	    1 ... len(string) position of the "what" string
c
c--
	character *(*) string, what
c
	len1 = len(string)
	len2 = len(what)
	if (len2 .ne. 1) then
	    iflag = -1
	    goto 99
	endif
c
	do 1 i = 1, len1
 	    if (string(i:i) .eq. what(1:1)) goto 3
 1	continue
 	if (string(i:i) .ne. what(1:1)) then
	    iflag = 0
	    goto 99
	endif
c
 3	continue
 	iflag = i
	goto 99
c
 99	continue
 	return
	end
    
c
