C +++
C
C Source: src/lib/fname.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: fname.F
C Revision 1.7  1991/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C
C Revision 1.6  91/04/05  13:54:20  cwelnak
C changed quotes on #include
C 
C Revision 1.5  91/03/22  12:18:24  cwelnak
C SUN version -- INC to #inc
C 
C Revision 1.4  90/11/13  14:04:51  khan
C Cleanup and SAVE statements
C 
C Revision 1.3  90/07/20  22:05:07  khan
C put #if unix ... to make it work also on vms
C 
C Revision 1.2  90/07/15  15:31:01  khan
C All public include files (common.blk, etc) are now in ./../../include dir.
C 
C Revision 1.1  90/07/10  14:56:07  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE	FNAME
C
C	PURPOSE		To append an integer number to a string. This
C			will be used as a file-name to discriminate 
C			between the element of SHADOW
C
C	INPUT		ALPHA    String
C			INDEX	 Numeric value
C
C	OUTPUT		NAME
C
C---
     	SUBROUTINE	FNAME	(NAME, ALPHA, INDEX, LENGTH)
     	IMPLICIT	REAL*8		(A-E,G-H,O-Z)
     	IMPLICIT	INTEGER*4	(F,I-N)
     	CHARACTER *(*)  NAME, ALPHA
     	CHARACTER*80	TEMP
     	DO  10 I=1,LEN(NAME)
     	  NAME (I:I) = ' '
10   	CONTINUE
     	CALL	DESPACE (ALPHA, TEMP, IWORD)
     	NAME (:IWORD) = TEMP (:IWORD)
	IWORD	= IWORD + 1
	NAME (IWORD:IWORD) = '.'
     	ITOT	=  IWORD + LENGTH
	IF (LENGTH.EQ.2) THEN
		IFORMAT = 1002
		WRITE (NAME(IWORD+1:ITOT),1002,ERR=100) INDEX
	ELSE IF (LENGTH.EQ.4) THEN
		IFORMAT = 1004
		WRITE (NAME(IWORD+1:ITOT),1004,ERR=100) INDEX
	ELSE
		WRITE (*,*) 'INTERNAL ERROR IN FNAME:LENGTH=',LENGTH
		STOP 1
	ENDIF
C     	WRITE (NAME(IWORD+1:ITOT),IFORMAT,ERR=100) INDEX
C1000	FORMAT (I<LENGTH>.<LENGTH>)
1002	FORMAT (I2.2)
1004	FORMAT (I4.4)
     	RETURN
100	NAME	=   'NAMERR'
     	RETURN
     	END
