C +++
C
C Source: src/lib/despace.F
C 
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: despace.F
C Revision 1.6  1991/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C
C Revision 1.5  91/04/05  13:54:18  cwelnak
C changed quotes on #include
C 
C Revision 1.4  91/03/22  12:11:07  cwelnak
C SUN version -- INC to #inc
C 
C Revision 1.3  90/11/13  14:04:49  khan
C Cleanup and SAVE statements
C 
C Revision 1.2  90/07/20  22:05:05  khan
C put #if unix ... to make it work also on vms
C 
C Revision 1.1  90/07/10  14:56:02  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	subroutine	despace
C
C	purpose		to remove leading and trailing spaces from a string
C
C	input		inp(*) the string to be despaced
C
C	out		out(*) the string with all l/t spaces removed
C
C			klen   the length of the new string. 0 if empty
C
C---
     	subroutine	despace	( inp, out, klen)
	implicit none
     	character *(*)	inp, out
        integer klen, istart, iend
c
c find the leading and trailing indices first. istart and iend are both 0
c for blank input string.
c
	call fstrtrim (inp, istart, iend)
c
c return klen = 0 and an emtpy string when the input was empty as well.
c
	if (istart.eq.0 .or. iend.eq.0) then
	  out = ' '
	  klen = 0
	  return
	endif

c
c FIXME/CHECK: should check for enough space in "out" or not to hold new
c string.
c
	klen = iend - istart + 1
	out(1:klen) = inp(istart:iend)
     	return
     	end
