C +++
C
C Source: src/lib/dbcevl.f
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: dbcevl.f
C Revision 1.2  1991/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C
C Revision 1.1  90/07/10  14:56:01  khan
C Initial revision
C 
C 
C ---

C   IMSL ROUTINE NAME   - DBCEVL                                        DBEL0010
C                                                                       DBEL0020
C-----------------------------------------------------------------------DBEL0030
C                                                                       DBEL0040
C   COMPUTER            - VAX/DOUBLE                                    DBEL0050
C                                                                       DBEL0060
C   LATEST REVISION     - JUNE 1, 1982                                  DBEL0070
C                                                                       DBEL0080
C   PURPOSE             - BICUBIC SPLINE MIXED PARTIAL DERIVATIVE       DBEL0090
C                           EVALUATOR                                   DBEL0100
C                                                                       DBEL0110
C   USAGE               - CALL DBCEVL (X,NX,Y,NY,C,IC,XL,YL,PDS,IER)    DBEL0120
C                                                                       DBEL0130
C   ARGUMENTS    X      - VECTOR OF LENGTH NX. (INPUT) X MUST BE        DBEL0140
C                           ORDERED SO THAT X(I) .LT. X(I+1) FOR        DBEL0150
C                           I=1,...,NX-1.                               DBEL0160
C                NX     - NUMBER OF ELEMENTS IN X. (INPUT) NX MUST BE   DBEL0170
C                           .GE. 2.                                     DBEL0180
C                Y      - VECTOR OF LENGTH NY. (INPUT) Y MUST BE        DBEL0190
C                           ORDERED SO THAT Y(J) .LT. Y(J+1) FOR        DBEL0200
C                           J=1,...,NY-1.                               DBEL0210
C                NY     - NUMBER OF ELEMENTS IN Y. (INPUT) NY MUST BE   DBEL0220
C                           .GE. 2.                                     DBEL0230
C                         NOTE - THE COORDINATE PAIRS (X(I),Y(J)), FOR  DBEL0240
C                           I=1,...,NX AND J=1,...,NY, GIVE THE POINTS  DBEL0250
C                           WHERE THE FUNCTION VALUES ARE DEFINED.      DBEL0260
C                C      - ARRAY OF SPLINE COEFFICIENTS. (INPUT)         DBEL0270
C                           C IS OF DIMENSION 2 BY NX BY 2 BY NY.       DBEL0280
C                           THE SPLINE COEFFICIENTS CAN BE COMPUTED BY  DBEL0290
C                           IMSL SUBROUTINE IBCCCU.                     DBEL0300
C                           (NOTE - C IS TREATED INTERNALLY AS A        DBEL0310
C                            2 BY NX BY 2*NY ARRAY BECAUSE CERTAIN      DBEL0320
C                            ENVIRONMENTS DO NOT PERMIT QUADRUPLY-      DBEL0330
C                            DIMENSIONED ARRAYS.  IN THESE              DBEL0340
C                            ENVIRONMENTS THE CALLING PROGRAM MAY       DBEL0350
C                            DIMENSION C IN THE SAME MANNER.)           DBEL0360
C                IC     - SECOND DIMENSION OF ARRAY C EXACTLY AS        DBEL0370
C                           SPECIFIED IN THE DIMENSION STATEMENT        DBEL0380
C                           (INPUT).  IC MUST BE .GE. NX.               DBEL0390
C                XL,YL  - (XL,YL) IS THE POINT AT WHICH THE MIXED       DBEL0400
C                           PARTIAL DERIVATIVES OF THE SPLINE ARE TO BE DBEL0410
C                           EVALUATED. (INPUT)                          DBEL0420
C                PDS    - VECTOR OF LENGTH 6 CONTAINING THE PARTIAL     DBEL0430
C                           DERIVATIVES OF THE BICUBIC SPLINE, S(X,Y),  DBEL0440
C                           EVALUATED AT X=XL AND Y=YL. (OUTPUT)        DBEL0450
C                             PDS(1) = S(XL,YL)                         DBEL0460
C                             PDS(2) = DS/DX                            DBEL0470
C                             PDS(3) = DS/DY                            DBEL0480
C                             PDS(4) = D(DS/DX)/DY                      DBEL0490
C                             PDS(5) = D(DS/DX)/DX                      DBEL0500
C                             PDS(6) = D(DS/DY)/DY.                     DBEL0510
C                IER    - ERROR PARAMETER. (OUTPUT)                     DBEL0520
C                         WARNING ERROR                                 DBEL0530
C                           IER = 33, XL IS LESS THAN X(1).             DBEL0540
C                           IER = 34, YL IS LESS THAN Y(1).             DBEL0550
C                           IER = 35, XL IS GREATER THAN X(NX).         DBEL0560
C                           IER = 36, YL IS GREATER THAN Y(NY).         DBEL0570
C                                                                       DBEL0580
C   PRECISION/HARDWARE  - SINGLE AND DOUBLE/H32                         DBEL0590
C                       - SINGLE/H36,H48,H60                            DBEL0600
C                                                                       DBEL0610
C   REQD. IMSL ROUTINES - UERTST,UGETIO                                 DBEL0620
C                                                                       DBEL0630
C   NOTATION            - INFORMATION ON SPECIAL NOTATION AND           DBEL0640
C                           CONVENTIONS IS AVAILABLE IN THE MANUAL      DBEL0650
C                           INTRODUCTION OR THROUGH IMSL ROUTINE UHELP  DBEL0660
C                                                                       DBEL0670
C   COPYRIGHT           - 1982 BY IMSL, INC. ALL RIGHTS RESERVED.       DBEL0680
C                                                                       DBEL0690
C   WARRANTY            - IMSL WARRANTS ONLY THAT IMSL TESTING HAS BEEN DBEL0700
C                           APPLIED TO THIS CODE. NO OTHER WARRANTY,    DBEL0710
C                           EXPRESSED OR IMPLIED, IS APPLICABLE.        DBEL0720
C                                                                       DBEL0730
C-----------------------------------------------------------------------DBEL0740
C                                                                       DBEL0750
      SUBROUTINE DBCEVL (X,NX,Y,NY,C,IC,XL,YL,PDS,IER)                  DBEL0760
C                                  SPECIFICATIONS FOR ARGUMENTS         DBEL0770
      INTEGER            NX,NY,IC,IER                                   DBEL0780
      DOUBLE PRECISION   X(1),Y(1),C(2,IC,1),XL,YL,PDS(6)               DBEL0790
C                                  SPECIFICATIONS FOR LOCAL VARIABLES   DBEL0800
      INTEGER            I,J,K,KM1,KP1,KP2,LXPL,LX,LY,L,LXP1            DBEL0810
      DOUBLE PRECISION   HX,HY,SUX(2),SUY(2),SU(2),SVX(2),SV(2),SXY(2), DBEL0820
     *                   U,V,SPLN0,SPLN1,SPLN2,S0,SH,SP0,SPH,H,D        DBEL0830
      SPLN0(S0,SH,SP0,SPH,H,D) = S0+D*(H*SP0+D*(3.D0*(SH-S0)-           DBEL0840
     * (SPH+2.D0*SP0)*H+D*(2.D0*(S0-SH)+(SPH+SP0)*H)))                  DBEL0850
      SPLN1(S0,SH,SP0,SPH,H,D) = SP0+D*(6.D0*(SH-S0)/H-2.D0*            DBEL0860
     * (SPH+2.D0*SP0)+3.D0*D*(2.D0*(S0-SH)/H+(SPH+SP0)))                DBEL0870
      SPLN2(S0,SH,SP0,SPH,H,D) = 6.D0*(SH-S0)/H**2-2.D0*                DBEL0880
     * (SPH+2.D0*SP0)/H+D*(2.D0*(S0-SH)/H**2+(SPH+SP0)/H)*6.D0          DBEL0890
C                                  FIRST EXECUTABLE STATEMENT           DBEL0900
      IER = 0                                                           DBEL0910
      IF (XL.LT.X(1)) IER = 33                                          DBEL0920
      DO 5 I=2,NX                                                       DBEL0930
         LX = I-1                                                       DBEL0940
         IF (XL.LE.X(I)) GO TO 10                                       DBEL0950
    5 CONTINUE                                                          DBEL0960
      IER = 35                                                          DBEL0970
   10 IF (YL.LT.Y(1)) IER = 34                                          DBEL0980
      DO 15 J=2,NY                                                      DBEL0990
         LY = J-1                                                       DBEL1000
         IF (YL.LE.Y(J)) GO TO 20                                       DBEL1010
   15 CONTINUE                                                          DBEL1020
      IER = 36                                                          DBEL1030
   20 LXP1 = LX+1                                                       DBEL1040
      HX = X(LXP1)-X(LX)                                                DBEL1050
      HY = Y(LY+1)-Y(LY)                                                DBEL1060
      U = (XL-X(LX))/HX                                                 DBEL1070
      V = (YL-Y(LY))/HY                                                 DBEL1080
      K = 2*LY                                                          DBEL1090
      KP1 = K+1                                                         DBEL1100
      KP2 = K+2                                                         DBEL1110
      KM1 = K-1                                                         DBEL1120
      DO 25 L=1,2                                                       DBEL1130
         LXPL = LX-1+L                                                  DBEL1140
         I = 2*(LY-1+L)                                                 DBEL1150
         J = I-1                                                        DBEL1160
         SUX(L) = SPLN1(C(1,LX,J),C(1,LXP1,J),C(2,LX,J),                DBEL1170
     *   C(2,LXP1,J),HX,U)                                              DBEL1180
         SXY(L) = SPLN1(C(1,LX,I),C(1,LXP1,I),C(2,LX,I),                DBEL1190
     *   C(2,LXP1,I),HX,U)                                              DBEL1200
         SU(L) = SPLN0(C(1,LX,J),C(1,LXP1,J),C(2,LX,J),                 DBEL1210
     *   C(2,LXP1,J),HX,U)                                              DBEL1220
         SUY(L) = SPLN0(C(1,LX,I),C(1,LXP1,I),C(2,LX,I),                DBEL1230
     *   C(2,LXP1,I),HX,U)                                              DBEL1240
         SV(L) = SPLN0(C(1,LXPL,KM1),C(1,LXPL,KP1),C(1,LXPL,K),         DBEL1250
     *   C(1,LXPL,KP2),HY,V)                                            DBEL1260
         SVX(L) = SPLN0(C(2,LXPL,KM1),C(2,LXPL,KP1),C(2,LXPL,K),        DBEL1270
     *   C(2,LXPL,KP2),HY,V)                                            DBEL1280
   25 CONTINUE                                                          DBEL1290
      PDS(1) = SPLN0(SV(1),SV(2),SVX(1),SVX(2),HX,U)                    DBEL1300
      PDS(2) = SPLN1(SV(1),SV(2),SVX(1),SVX(2),HX,U)                    DBEL1310
      PDS(3) = SPLN1(SU(1),SU(2),SUY(1),SUY(2),HY,V)                    DBEL1320
      PDS(4) = SPLN1(SUX(1),SUX(2),SXY(1),SXY(2),HY,V)                  DBEL1330
      PDS(5) = SPLN2(SV(1),SV(2),SVX(1),SVX(2),HX,U)                    DBEL1340
      PDS(6) = SPLN2(SU(1),SU(2),SUY(1),SUY(2),HY,V)                    DBEL1350
      IF (IER.GT.0) CALL UERTST(IER,6HDBCEVL)                           DBEL1360
      RETURN                                                            DBEL1370
      END                                                               DBEL1380
