C +++
C
C Source: src/utils/post/sysplot.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: sysplot.F
C Revision 1.6  1992/01/16  11:27:42  cwelnak
C 6000 changes
C
C Revision 1.5  91/07/06  19:43:52  khan
C Grenoble Changes ...
C 
C Revision 1.4  91/04/05  15:51:02  cwelnak
C changed quotes in #includes
C 
C Revision 1.3  91/03/25  15:56:43  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.2  91/01/25  16:48:05  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/08  17:03:51  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

***********************************************************************
* This program will plot the whole optical system, in a suitable scale*
* The inputs consist of a source starting point, in the standard format
* of a BEGIN.DAT or STAR.xx file. Also, OPTAXIS.xx is used to deter.*
* the physical location of the elements in the lab. reference frame.  *
* The program uses CALCOMP calls. 				      *
***********************************************************************
     	PROGRAM		SYSPLOT
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
        INCLUDE	        'SHADOW$INC:DIM.PAR/LIST'
#endif
     	DIMENSION	AXIS (20,24),UVEC(3),VVEC(3),WVEC(3)
     	REAL *8		DATA (12,N_DIM),PHASE(3,N_DIM),AP(3,N_DIM)
      	DIMENSION	VERSOR(20,3,3),RAY(20,500,4),OLD (20,500,4)

     	CHARACTER *20	FILES(25),FILESOUR,FILEIMAGE,FILEAXIS,TEMP

     	WRITE(6,*)'File [ 0 ]  or tt [ 1 ] ? '
     	READ(5,*)IMODE
     	IF (IMODE.EQ.1) THEN
	WRITE(6,*)'UNIX: Choose 2-D only for Primvs file'
     	WRITE(6,*)'Bidimensional [ 0 ] or 3d plot [ 1 ] ?'
     	READ(5,*)KDIM
     	WRITE(6,*)'How many mirrors ?'
     	READ(5,*)NMIRR
     	WRITE(6,*)'How many rays [ suggest no more than 200 (500 max) ] ?'
     	READ(5,*)NPOINT
     	WRITE(6,*)'Optaxis file ?'
     	READ (5,1000)	FILEAXIS
     	WRITE(6,*)'Source file and (final) image file ?'
     	READ (5,1000)	FILESOUR,FILEIMAGE
     	DO 10 I=1,NMIRR
     	WRITE(6,*)'Mirror N. ',I,' ?'
     	READ (5,1000)	FILES(I)
10     	CONTINUE
      	IFLAG	=  IYES ('Plot all the losses too [ Y/N ] ? ' )
     	IF (KDIM.EQ.0) THEN
     	WRITE(6,*)'Columns to plot out (first is horizontal) ?'
     	READ(5,*)KX,KY
     	ELSE
   	KX	=  1
     	KY	=  2
     	KZ	=  3
     	END IF
     	ELSE
#ifdef vms
     	OPEN	(20, FILE='SYSPLOT.STR', STATUS='OLD', READONLY)
#else
     	OPEN	(20, FILE='SYSPLOT.STR', STATUS='OLD')
#endif
     	 READ (20,*) KDIM
     	 READ (20,*) NMIRR
     	 READ (20,*) NPOINT,IFLAG
     	 READ (20,1000) FILEAXIS
C  DELETE 1 LEADING BLANK SPACE FROM FILENAME
         TEMP = FILEAXIS
         FILEAXIS = TEMP(2: )
     	 READ (20,1000) FILESOUR
         TEMP = FILESOUR
         FILESOUR = TEMP(2: )
     	 READ (20,1000) FILEIMAGE
         TEMP = FILEIMAGE
         FILEIMAGE = TEMP(2: )
     	  DO 20 I=1,NMIRR
     	    READ (20,1000) FILES(I)
            TEMP = FILES(I)
            FILES(I) = TEMP(2: )
20     	  CONTINUE
     	 IF (KDIM.EQ.1) THEN
     	   READ (20,*) KX,KY,KZ
     	 ELSE
     	   READ (20,*) KX,KY
     	 END IF
     	CLOSE (20)
     	END IF
	IF (NPOINT.GT.500) NPOINT = 500
#ifdef vms
     	OPEN (20,FILE=FILEAXIS,STATUS='OLD',READONLY)
#else
     	OPEN (20,FILE=FILEAXIS,STATUS='OLD')
#endif
     	DO 30 I=1,NMIRR
     	READ (20,*)	I1
     	READ (20,*)	(AXIS (I,J),J=1,3)
     	READ (20,*)	(AXIS (I,J),J=4,6)
     	READ (20,*)	(AXIS (I,J),J=7,9)
     	READ (20,*)	(AXIS (I,J),J=10,12)
5	READ (20,*)	(AXIS (I,J),J=13,15)
	READ (20,*)	(AXIS (I,J),J=16,18)
	READ (20,*)	(AXIS (I,J),J=19,21)
30	READ (20,*)	(AXIS (I,J),J=22,24)

     	CLOSE (20)

     	CALL	RBEAM	(FILESOUR,DATA,PHASE,AP,NCOL,NP,IFL,IERR)
	IF (IERR.NE.0)	STOP	'Error in reading source file.'

     	DO 22 I=1,NPOINT
     	OLD (1,I,1)	=   DATA (1,I)
     	OLD (1,I,2)	=   DATA (2,I)
	OLD (1,I,3)	=   DATA (3,I)
22	OLD (1,I,4)	=   1.0

     	CALL	RBEAM	(FILEIMAGE,DATA,PHASE,AP,NCOL,NP,IFL,IERR)
	IF (IERR.NE.0)	STOP	'Error in reading image file.'

     	LAST	=   NMIRR + 2

     	DO 32 I=1,NPOINT
     	OLD (LAST,I,1)	=   DATA (1,I)
     	OLD (LAST,I,2)	=   DATA (2,I)
	OLD (LAST,I,3)	=   DATA (3,I)
     	IF (IFLAG.EQ.0) THEN
	  OLD (LAST,I,4)	=   DATA (10,I)
     	ELSE
     	 IF (DATA(10,I).GT.-1000000) THEN
     	  OLD (LAST,I,4)	=   1
     	 END IF
     	END IF
32	CONTINUE

     	DO 40 J=1,NMIRR

     	CALL	RBEAM	(FILES(J),DATA,PHASE,AP,NCOL,NP,IFL,IERR)
	IF (IERR.NE.0)	STOP	'Error in reading intermediate ray file.'

     	DO 40 I=1,NPOINT
     	OLD (J+1,I,1)	=   DATA (1,I)
     	OLD (J+1,I,2)	=   DATA (2,I)
     	OLD (J+1,I,3)	=   DATA (3,I)
     	IF (IFLAG.EQ.0) THEN
	  OLD (J+1,I,4)	=   DATA (10,I)
     	ELSE
     	 IF (DATA(10,I).GT.-1000000) THEN
     	  OLD (J+1,I,4)  =  1
     	 END IF
     	END IF
40	CONTINUE

** Computes now the set of versor to describe the ray in real space

     	DO 100	I=1,NMIRR

     	VERSOR (I,1,1)	=   AXIS (I,10)	! UVECT
     	VERSOR (I,1,2)	=   AXIS (I,11)
     	VERSOR (I,1,3)	=   AXIS (I,12)
     	VERSOR (I,2,1)	=   AXIS (I,13)	! VVEC
     	VERSOR (I,2,2)	=   AXIS (I,14)
     	VERSOR (I,2,3)	=   AXIS (I,15)
     	VERSOR (I,3,1)	=   AXIS (I,16)	! WVEC
     	VERSOR (I,3,2)	=   AXIS (I,17)
100	VERSOR (I,3,3)	=   AXIS (I,18)

** Generates now the set of plotting points, from the source to each
** mirror.

     	DO 200 I=1,NPOINT

     	RAY (1,I,1)	=   OLD (1,I,1)
     	RAY (1,I,2)	=   OLD (1,I,2)
     	RAY (1,I,3)	=   OLD (1,I,3)
	RAY (1,I,4)	=   OLD (1,I,4)

     	DO 200 J=1,NMIRR
	ITEST	=   -11000*J

     	RAY (J+1,I,1)	=   AXIS (J,4) +
     $		OLD (J+1,I,1)*VERSOR (J,1,1) + 
     $		OLD (J+1,I,2)*VERSOR (J,2,1) +
     $		OLD (J+1,I,3)*VERSOR (J,3,1)

     	RAY (J+1,I,2)	=   AXIS (J,5) +
     $		OLD (J+1,I,1)*VERSOR (J,1,2) +
     $		OLD (J+1,I,2)*VERSOR (J,2,2) +
     $		OLD (J+1,I,3)*VERSOR (J,3,2)

     	RAY (J+1,I,3)	=   AXIS (J,6) +
     $		OLD (J+1,I,1)*VERSOR (J,1,3) +
     $		OLD (J+1,I,2)*VERSOR (J,2,3) +
     $		OLD (J+1,I,3)*VERSOR (J,3,3)

	ICHECK	=   OLD(J+1,I,4)
      	IF (IFLAG.EQ.0) THEN
	 IF (ICHECK.GE.0) THEN
	   RAY (J+1,I,4)	=  1.0
	 ELSE IF (ICHECK.LT.-1000000) THEN
          IF (RAY (J,I,4).GT.0.0) THEN
	    RAY (J+1,I,4)	= - 1.0
     	  ELSE
     	    RAY (J+1,I,4)	= - 2.0
     	  END IF
	 ELSE IF (ITEST.EQ.ICHECK) THEN
	   RAY (J+1,I,4)	= - 1.0
	 ELSE IF (ITEST.GT.ICHECK.AND.ITEST.LT.0) THEN
	   RAY (J+1,I,4)	= -2.0
	 END IF
      	ELSE
     	 IF (ICHECK.GT.-1000000) THEN
	  RAY (J+1,I,4)	=  1.0
     	 ELSE
     	  RAY(J+1,I,4) = -1.0
     	 END IF
      	END IF

200	CONTINUE

** Computes the last set of rays, to the final image point.
     	UVEC (1)	=   AXIS (NMIRR,10)	! UVEC >> X
     	UVEC (2)	=   AXIS (NMIRR,11)
     	UVEC (3)	=   AXIS (NMIRR,12)
     	VVEC (1)	=   AXIS (NMIRR,19)	! VREF >> Y
     	VVEC (2)	=   AXIS (NMIRR,20)
     	VVEC (3)	=   AXIS (NMIRR,21)
     	WVEC (1)	=   AXIS (NMIRR,22)	! WREF >> Z
     	WVEC (2)	=   AXIS (NMIRR,23)
     	WVEC (3)	=   AXIS (NMIRR,24)

     	DO 300 I=1,NPOINT
     	RAY (LAST,I,1)	=   AXIS (NMIRR,7) +
     $		OLD (LAST,I,1)*UVEC(1) +
     $		OLD (LAST,I,2)*VVEC(1) +
     $		OLD (LAST,I,3)*WVEC(1)
     	RAY (LAST,I,2)	=   AXIS (NMIRR,8) +
     $		OLD (LAST,I,1)*UVEC(2) +
     $		OLD (LAST,I,2)*VVEC(2) +
     $		OLD (LAST,I,3)*WVEC(2) 
     	RAY (LAST,I,3)	=   AXIS (NMIRR,9) +
     $		OLD (LAST,I,1)*UVEC(3) +
     $		OLD (LAST,I,2)*VVEC(3) +
     $		OLD (LAST,I,3)*WVEC(3)
     	RAY (LAST,I,4)	=   OLD (LAST,I,4)
300	CONTINUE

** The array is now ready for plotting.
#ifdef vms
     	OPEN (34,FILE='SYSPLOT.DAT',STATUS='NEW')
#else
     	OPEN (34,FILE='SYSPLOT.DAT',STATUS='UNKNOWN')
	REWIND (34)
#endif
     	DO 400 I=1,NPOINT
     	DO 410 J=1,NMIRR + 2
     	XP	=   RAY (J,I,KX)
     	YP	=   RAY (J,I,KY)
     	ZP	=   RAY (J,I,KZ)
	IF (ABS(XP).LT.1.0E-10)	XP	=  0.0
	IF (ABS(YP).LT.1.0E-10)	YP	=  0.0
	IF (ABS(ZP).LT.1.0E-10)	ZP	=  0.0
     	IF (KDIM.EQ.0) THEN
	 IF (RAY (J,I,4).GE.0.0)  THEN
#ifdef vms
      	   WRITE (34,*)	XP,YP
#else
	   IF (J.EQ.1) THEN
	     WRITE (34,*) 'line(',XP,',',YP,',',XP,',',YP,')'
	     XPP = XP
	     YPP = YP
	   ELSE
	     WRITE (34,*) 'line(',XPP,',',YPP,',',XP,',',YP,')'
	     XPP = XP
	     YPP = YP
	   ENDIF
#endif
      	 ELSE 
      	   GO TO 400
      	 END IF
     	ELSE
	 IF (RAY (J,I,4).GE.0.0)  THEN
      	   WRITE (34,*)	XP,YP,ZP
      	 ELSE
      	   GO TO 400
      	 END IF
     	END IF
410	CONTINUE
#ifdef vms
400	WRITE (34,*)	'JOIN 1 '
#else
400	WRITE (34,*) ' '
#endif
     	CLOSE (34)
     	IF (IMODE.EQ.1) THEN
#ifdef vms
     	OPEN	(20, FILE='SYSPLOT.STR', STATUS='NEW')
#else
     	OPEN	(20, FILE='SYSPLOT.STR', STATUS='UNKNOWN')
	REWIND  (20)
#endif
     	 WRITE (20,*) KDIM
     	 WRITE (20,*) NMIRR
     	 WRITE (20,*) NPOINT,IFLAG
     	 WRITE (20,1010) FILEAXIS
     	 WRITE (20,1010) FILESOUR
     	 WRITE (20,1010) FILEIMAGE
     	  DO 70 I=1,NMIRR
     	    WRITE (20,1010) FILES(I)
70     	  CONTINUE
     	 IF (KDIM.EQ.1) THEN
     	   WRITE (20,*) KX,KY,KZ
     	 ELSE
     	   WRITE (20,*) KX,KY
     	 END IF
     	CLOSE (20)
     	END IF
     	STOP
1000	FORMAT (A)
1010	FORMAT (1X,A)
     	END
