C +++
C
C Source: src/utils/post/RCS/pspread.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: pspread.F
C Revision 1.8  1992/01/24  19:21:31  cwelnak
C stupid mistake.
C
C Revision 1.7  1992/01/16  09:54:14  cwelnak
C 6000 changes
C
C Revision 1.6  1991/07/06  19:43:52  khan
C Grenoble Changes ...
C
C Revision 1.5  91/04/05  15:50:51  cwelnak
C changed quotes in #includes
C 
C Revision 1.4  91/03/25  15:56:21  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.3  91/03/15  16:04:54  khan
C Getting  ready for sun port...
C 
C Revision 1.2  91/01/25  16:47:44  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/08  17:03:47  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	program		PSPREAD
C
C	purpose		this program will generate an histogram of the
C			energy of the rays as a function of the radial
C			distance.
C
C	input		a RAY file from SHADOW
C
C	output		a plottable file
C
C	Link using GRA:GRALIB.LNK or GRA:TDSHARE.LNK
C---

     	PROGRAM		PSPREAD

	IMPLICIT REAL*8 (A-H,O-Z)
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
        INCLUDE	        'SHADOW$INC:DIM.PAR/LIST'
#endif
	CHARACTER *80	FILEIN,FILEIN2,RSTRING,TEXT
#ifndef vms
	CHARACTER * 512		PRIMVS
	CHARACTER * 512		PRIMVSPATH
#endif

     	REAL*8		RAY(18,N_DIM),VAL,TCONV
     	REAL*8		RAY2(18,N_DIM)
	REAL*8		RADIUS(N_DIM)	
     	DIMENSION	XARRAY(100),YARRAY(100)
	REAL*4		XGRA(500),YGRA(500)
C	DIMENSION	XGRA(500),YGRA(500)
     	
     	DATA	PI     	/  3.1415 92653 58979 32384 62643 D0 /
     	DATA	PIHALF 	/  1.5707 96326 79489 66192 31322 D0 /
     	DATA	TWOPI 	/  6.2831 85307 17958 64769 25287 D0 /
     	DATA	TODEG 	/ 57.2957 79513 08232 08767 98155 D0 /
     	DATA	TORAD	/  0.0174 53292 51994 32957 69237 D0 /
	DATA	TOCM	/  1.239 852	D-4		     /
	DATA	TOANGS 	/  1.239 852    D+4		     /

1	FILEIN	= RSTRING('File for analysis ? ')

     	CALL	RBEAM18	(FILEIN,RAY,NCOL,NPOINT,IFLAG,IERR)
	IF (IERR.NE.0)	STOP	'Error in reading ray file.'
C
C Find the min and max.
C
 	XMIN	=  1.0E+20
	XMAX	=  0.0D0
	DO 10 I = 1, NPOINT
	  RADIUS(I) = SQRT(RAY(1,I)**2 + RAY(3,I)**2)
	  XMIN	= MIN (XMIN,RADIUS(I))
	  XMAX	= MAX (XMAX,RADIUS(I))
10	CONTINUE
C
	WRITE(6,*)'Read    : ',NPOINT,' rays'
	WRITE(6,*)'Maximum radius : ',XMAX
	WRITE(6,*)'Minimum radius : ',XMIN
C     	CENTER= RNUMBER ('Distribution center ? ')
C     	WIDTH = RNUMBER ('             width ? ')
	WRITE(6,*)'Histogram is done for absolute radius'
	XLOW = RNUMBER ('...from : ')
	XUPP = RNUMBER ('...to   : ')
     	NBIN = IRINT ('Number of bins (odd, please) ? ')
	WRITE(6,*)'Generate the histogram at :'
	WRITE(6,*)'0       constant radius'
	WRITE(6,*)'1       constant area'
	WRITE(6,*)'2       constant volume'
	IRAD	= IRINT ('Then ? ')
     	WRITE(6,*)'Flag checks. Enter :'
     	WRITE(6,*)'0	to exclude lost rays'
     	WRITE(6,*)'1	to include lost rays too'
     	WRITE(6,*)'2	to use only lost rays'
     	ILOST = IRINT ('<?> ')
	IREFL = IRINT ('Include reflectivity ? ')
     	IF (IREFL.EQ.1) THEN
     	WRITE(6,*)'Options. Enter: '
     	WRITE(6,*)'0    to use |A| as weighing factor'
     	WRITE(6,*)'1    to use |A|**2 as weighing factor (transmitted)'
     	WRITE(6,*)'2    to use 1-|A|**2 as weighing factor (absorbed )'
     	IUNITS = IRINT ('<?> ')
	IF (IUNITS.EQ.2) THEN
     	  IFILE  = IYES 
     $	  	('Use another file for incoming power [ Y/N ] ? ')
     	  IF (IFILE.EQ.1) THEN
     	    FILEIN2 = RSTRING ('File-name ? ')
     	    CALL RBEAM18 (FILEIN2,RAY2,NCOL2,NPOINT,IFLAG,IERR)
	    IF (IERR.NE.0)	STOP	'Error in reading ray file.'
     	  END IF
	END IF
	WRITE(6,*)'Scale to :'
	WRITE(6,*)'  0      no scaling (cm-1)'
	WRITE(6,*)'  1      Watt'
	WRITE(6,*)'  2      eV/sec.'
	ISCALE 	= IRINT ('<?> ')
     	END IF
#ifdef vms
	WRITE(6,*)'Output options :'
	WRITE(6,*)'  [ 0 ] store histogram in a file'
	WRITE(6,*)'  [ 1 ] plot histogram on screen'
	WRITE(6,*)'  [ 2 ] both'
	IOUT	= IRINT ('Then ? ')
	IF (IOUT.EQ.1.OR.IOUT.EQ.2) THEN
	  CALL	SET_SCREEN	(' ',0,ITERM)
	END IF
#else
        WRITE(6,*) 'Display type:'
#if HAVE_XWINDOWS
	WRITE(6,*) '  [ 0 ] Xwindow'
#endif
	WRITE(6,*) '  [ 1 ] Tektronix'
	WRITE(6,*) '  [ 2 ] Postscript file'
	ITERM = IRINT ('Terminal type:  ')
#if !HAVE_XWINDOWS
	IF (ITERM.EQ.0) THEN
	    WRITE (*,*) 'No X Windows support. Using Postscript file'
	    ITERM=2
	ENDIF
#endif
	IOUT = 0
#endif


C
C Clear the arrays
C
     	DO 20 I=1,100
     	  XARRAY(I)  =   0.0
     	  YARRAY(I)  =   0.0
20     	CONTINUE
C
C Fill in the bins
C
     	XLOW	=   ABS(XLOW)
     	XUPP	=   ABS(XUPP)
	IF (XLOW.EQ.XUPP)	XLOW = 0.0D0
	WIDTH = XUPP - XLOW
	IF (IRAD.EQ.0) THEN
     	  STEP	=   WIDTH/(NBIN)
	  DO 30 I = 1, NBIN+1
	    XARRAY(I)	= XLOW + STEP*(I-1)
30	  CONTINUE	
	ELSE IF (IRAD.EQ.1) THEN
	  STEP	= (XUPP**2 - XLOW**2)/NBIN
	  XARRAY(1)	= XLOW
	  DO 40 I = 2, NBIN+1
	    XARRAY(I)	= SQRT(XARRAY(I-1)**2 + STEP)
40	  CONTINUE	
	ELSE IF (IRAD.EQ.2) THEN
	  STEP	= (XUPP**3 - XLOW**3)/NBIN
	  XARRAY(1)	= XLOW
	  DO 50 I = 2, NBIN+1
	    XARRAY(I)	= (XARRAY(I-1)**3 + STEP)**(1.0E0/3.0E0)
50	  CONTINUE	
	END IF
C
C Now loop through the rays.
C
     	DO 999 I=1,NPOINT
     	 IF (ILOST.EQ.0) THEN
     	  IF (RAY(10,I).LT.0.0D0) GO TO 999
     	 ELSE	IF (ILOST.EQ.2) THEN
     	  IF (RAY(10,I).GT.0.0D0) GO TO 999
      	 END IF
	 DO 60 J = 1, NBIN
	  IF (RADIUS(I).GT.XARRAY(J).AND.RADIUS(I).LE.XARRAY(J+1))
     $		GO TO 101
60	 CONTINUE
	 GO TO 999
101	 JBIN	= J
	   IF (IREFL.EQ.1) THEN
	     VAL  =   RAY(7,I)**2 + RAY(8,I)**2 + RAY(9,I)**2
	     IF (NCOL.EQ.18)	
     $		VAL = VAL + RAY(16,I)**2 + RAY(17,I)**2 + RAY(18,I)**2
	     IF (IUNITS.EQ.0) THEN
		VAL =   SQRT(VAL)
     	     ELSE IF (IUNITS.EQ.1) THEN
     		VAL  =   VAL
     	     ELSE IF (IUNITS.EQ.2) THEN
     		IF (IFILE.EQ.0) THEN
     		  VAL  =  (1.0D0-VAL)
     		ELSE
	          VAL0 =   RAY2(7,I)**2 + RAY2(8,I)**2 + RAY2(9,I)**2
	          IF (NCOL2.EQ.18)	
     $		  VAL0 = VAL0 + RAY2(16,I)**2 + RAY2(17,I)**2 + RAY2(18,I)**2
     		  VAL  =  (VAL0-VAL)
     		END IF
     	     END IF
	     IF (ISCALE.EQ.1) THEN
     	  	VAL	=  VAL*RAY(11,I)*TOCM*1.6021892D-19/TWOPI
	     ELSE IF (ISCALE.EQ.2) THEN
		VAL	=  VAL*RAY(11,I)*TOCM/TWOPI
	     END IF
	   ELSE
		VAL = 1.0
	   END IF
    	YARRAY(JBIN) = YARRAY(JBIN) + VAL
999	CONTINUE
C
C Prepare the arrays for writing
C
	XGRA(1)	= XARRAY(1)
	YGRA(1)	= 0.0E0
  	YMAX		= 0.0E0
	DO 70 I = 1, NBIN
	  XGRA(2*I)	= XARRAY(I)
	  YGRA(2*I)	= YARRAY(I)
	  XGRA(2*I+1)	= XARRAY(I+1)
	  YGRA(2*I+1)	= YARRAY(I)
	  YMAX		= MAX(YMAX,YARRAY(I))
70	CONTINUE
	NGRA	= 2*NBIN + 2
	XGRA(NGRA)	= XARRAY(NBIN+1)
	YGRA(NGRA)	= 0.0E0
	IF (IOUT.EQ.0.OR.IOUT.EQ.2) THEN
#ifdef vms
     	  OPEN (20,FILE='pspread',STATUS='NEW',INITIALSIZE=5)
#else
     	  OPEN (20,FILE='pspread.dat',STATUS='UNKNOWN')
	  REWIND (20)
#endif
     	    DO 80 I=1,NGRA
     	      WRITE (20,*)	XGRA(I),YGRA(I)
80     	    CONTINUE
#ifdef vms
	    WRITE (20,*)	'JOIN 1'
#endif
     	  CLOSE (20)
	END IF
C
C For some reasons, to use TDJOIN, the program must set the X-Y limit first.
C
#ifdef vms
	IF (IOUT.EQ.1.OR.IOUT.EQ.2) THEN
	  CALL TDNEWP
	  WRITE	(TEXT,1001) 	XARRAY(1)*0.9,XARRAY(NBIN+1)*1.1,YMAX*1.1
1001	  FORMAT ('LIMIT X ',G13.6,' ',G13.6,' Y 0.0 ',G13.6,' ;')
	  CALL TDSET  (%REF(TEXT))	  
	  CALL TDJOIN (NGRA,XGRA,YGRA,0,0,1)
	  CALL SET_SCREEN	(' ',1,ITERM)
	END IF
#else
	OPEN (21,FILE='pspread.prm',STATUS='UNKNOWN')
	WRITE(21,*) '#Primvs command file to plot output of PSPREAD'
          IF (ITERM.EQ.0) THEN
            WRITE(21,*) '# Initialize Xwindow display'
            WRITE(21,*) ' '
            WRITE(21,*) 'initpage(xwin)'
          ELSE IF (ITERM.EQ.1) THEN
            WRITE(21,*) '# Initialize Tektronix display'
            WRITE(21,*) ' '
            WRITE(21,*) 'initpage(tekt)'
          ELSE IF (ITERM.EQ.2) THEN
            WRITE(21,*) '# Initialize postscript file '
            WRITE(21,*) ' '
	    WRITE(21,*) 'setcolor(0)'
            WRITE(21,*) 'initpage(ps,"pspread.ps")'
          ENDIF
          WRITE(21,*) '# Set limits on viewing window, plot, and '
          WRITE(21,*) '# character size.'
          WRITE(21,*) 'regionr(0.1,0.1,0.9,0.9,1.0)'
          WRITE(21,3030) XARRAY(1)*0.9,XARRAY(NBIN+1)*1.1,0.0,YMAX*1.1
          WRITE(21,*) 'scalechr(0.8)'
	  WRITE(21,*) 'color(green)'
          WRITE(21,*) ' '
          WRITE(21,*) '# Plot histogram from pspread.dat and draw axes'
          WRITE(21,*) 'plotl("pspread.dat")'
          WRITE(21,*) 'box("bcnst",0,0,"bcnstv",0,0)'
          WRITE(21,*) 'closepage'
          WRITE(21,*) 'exit'
 
3030    FORMAT ('xyrange(',E15.8,',',E15.8,',',E15.8,',',E15.8,')')
 
C
C Get the program name relative to SHADOW_ROOT/bin.
C
	IFLAG = 0
	CALL PROGPATH ('primvs', PRIMVS, IFLAG)
	PRIMVSPATH = PRIMVS(1:IBLANK(PRIMVS)) // ' -i pspread.prm'
	WRITE(*,*) 'Executing program: ' // 
     $		PRIMVSPATH(1:IBLANK(PRIMVSPATH))
#if !defined(__CYGWIN32__)
	CALL SYSTEM (PRIMVSPATH)
#else
	IFLAG = 0
	CALL RUNPRIMVS ('pspread.prm', iflag)
#endif /* __CYGWIN32__ */

#endif /* !VMS */
 
C
     	IANSW = IYES ( 'Another run  [ Y/N ] ?')
     	IF (IANSW.EQ.1) GO TO 1
     	WRITE(6,*)'Return to System'
     	STOP
     	END
