C +++
C
C Source: src/utils/post/old-graphics/histo1.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	histo1.F
CRevision 1.1  92/01/16  13:37:49  cwelnak
CInitial revision
C
C Revision 1.1  91/03/11  13:08:09  v_white
C Initial revision
C 
C Revision 1.2  91/01/25  16:47:18  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/08  17:03:42  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C
C	program		histo1
C
C	purpose		this program will generate an histogram of the
C			distribution of the rays in a given column.
C
C	input		a RAY file from SHADOW
C
C	output		a plottable file
C
C	Link using GRA:GRALIB.LNK or GRA:TDSHARE.LNK
C---

     	PROGRAM		HISTO1

	IMPLICIT REAL*4 (A-H,O-Z)
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
        INCLUDE	        'SHADOW$INC:DIM.PAR/LIST'
#endif
	CHARACTER *80	FILEIN,FILEIN2,RSTRING

     	REAL*8		RAY(18,N_DIM),VAL,TCONV
     	REAL*8		RAY2(18,N_DIM)
        REAL*8          RNUMBER
     	DIMENSION	XARRAY(500),YARRAY(500),XTEMP(101)

#ifndef vms
	CHARACTER * 512		PRIMVS
	CHARACTER * 512		PRIMVSPATH
#endif
#ifdef __CYGWIN32__
	CHARACTER * 512		CMDARG
	DATA CMDARG		/'-run-primvs'/
#endif
     	
     	DATA	PI     	/  3.1415 92653 58979 32384 62643 D0 /
     	DATA	PIHALF 	/  1.5707 96326 79489 66192 31322 D0 /
     	DATA	TWOPI 	/  6.2831 85307 17958 64769 25287 D0 /
     	DATA	TODEG 	/ 57.2957 79513 08232 08767 98155 D0 /
     	DATA	TORAD	/  0.0174 53292 51994 32957 69237 D0 /
	DATA	TOCM	/  1.239 852	D-4		     /
	DATA	TOANGS 	/  1.239 852    D+4		     /

1	WRITE(6,*)'File for analysis ?'
	READ(5,3333) FILEIN

3333	FORMAT (A)

     	N_COL = IRINT ('Column to analyze ? ')
	IF (N_COL.EQ.11) THEN
	  WRITE(6,*)'Options : [0] Angstroms'
	  WRITE(6,*)'        : [1] eV'
	  WRITE(6,*)'        : [2] cm-1'
	  IENER	= IRINT ('<?> ')
	END IF
C
     	CALL	RBEAM18	(FILEIN,RAY,NCOL,NPOINT,IFLAG,IERR)
	IF (IERR.NE.0)	STOP	'Error in reading ray file.'
C
C Find the min and max.
C
 	XMIN	=  1.0E+20
	XMAX	= -1.0E+20
	DO 11 I = 1, NPOINT
	  XARG	= RAY(N_COL,I)
	  XMIN	= MIN (XMIN,XARG)
	  XMAX	= MAX (XMAX,XARG)
11      CONTINUE
	IF (N_COL.EQ.11) THEN
	   IF (IENER.EQ.0) THEN
	     XMIN	= TWOPI/XMIN*1.0E+8
	     XMAX	= TWOPI/XMAX*1.0E+8
	   ELSE IF (IENER.EQ.1) THEN
	     XMIN	= XMIN/TWOPI*TOCM
	     XMAX	= XMAX/TWOPI*TOCM
	   END IF
	END IF
	WRITE(6,*)'Read    : ',NPOINT,' rays'
	WRITE(6,*)'Maximum : ',XMAX
	WRITE(6,*)'Minimum : ',XMIN
     	CENTER= RNUMBER ('Distribution center ? ')
     	WIDTH = RNUMBER ('             width ? ')
     	NBIN = IRINT ('Number of bins (odd, please) ? ')
     	WRITE(6,*)'Flag checks. Enter :'
     	WRITE(6,*)'0	to exclude lost rays'
     	WRITE(6,*)'1	to include lost rays too'
     	WRITE(6,*)'2	to use only lost rays'
     	ILOST = IRINT ('<?> ')
     	WRITE(6,*)'Normalization kind. Enter :'
     	WRITE(6,*)'0	for no normalization'
     	WRITE(6,*)'1	to normalize to 1'
     	WRITE(6,*)'2	area normalized to 1'
     	NORM = IRINT ('<?> ')
	IREFL = IRINT ('Include reflectivity ? ')
     	IF (IREFL.EQ.1) THEN
     	WRITE(6,*)'Options. Enter: '
     	WRITE(6,*)'0      to use |A| as weighing factor'
     	WRITE(6,*)'1      to use |A|**2 as weighing factor (transmitted)'
     	WRITE(6,*)'2      to use 1-|A|**2 as weighing factor (absorbed )'
     	IUNITS = IRINT ('<?> ')
	IF (IUNITS.EQ.2) THEN
     	  IFILE  = IYES ('Use another file for incoming power [ Y/N ] ? ')
     	  IF (IFILE.EQ.1) THEN
     	    FILEIN2 = RSTRING ('File-name ? ')
     	    CALL RBEAM18 (FILEIN2,RAY2,NCOL2,NPOINT,IFLAG,IERR)
	    IF (IERR.NE.0)	STOP	'Error in reading ray file.'
     	  END IF
	END IF
	WRITE(6,*)'Scale to :'
	WRITE(6,*)'  0      no scaling (cm-1)'
	WRITE(6,*)'  1      Watt'
	WRITE(6,*)'  2      eV/sec.'
	ISCALE 	= IRINT ('<?> ')
     	END IF
#if defined (vms)
	WRITE(6,*)'Output options :'
	WRITE(6,*)'  [ 0 ] store histogram in a file'
	WRITE(6,*)'  [ 1 ] plot histogram on screen ' 
	WRITE(6,*)'  [ 2 ] both' 
	IOUT	= IRINT ('Then ? ')
	IF (IOUT.EQ.1.OR.IOUT.EQ.2) THEN
	  CALL	SET_SCREEN	(' ',0,ITERM)
	END IF
#else 
	  WRITE(6,*) 'Display type:'
#if HAVE_XWINDOWS
	  WRITE(6,*) '  [ 0 ] Xwindow'
#endif
	  WRITE(6,*) '  [ 1 ] Tektronix'
	  WRITE(6,*) '  [ 2 ] Postscript file'
	  ITERM = IRINT ('Terminal type:  ')
#if !HAVE_XWINDOWS
	IF (ITERM.EQ.0) THEN
	    WRITE (*,*) 'No X Windows support. Using Postscript file'
	    ITERM=2
	ENDIF
#endif
	IF (ITERM.LT.0 .OR. ITERM.GT.2) THEN
	    WRITE (*,*) 'Invalid device Id. Using Postscript file'
	    ITERM=2
	ENDIF
#endif

C
C Clear the arrays
C
     	DO 12 I=1,100
     	  XARRAY(I)  =   0.0
     	  YARRAY(I)  =   0.0
	  XTEMP(I)   =   0.0
12     	CONTINUE
C
C Fill in the bins
C
     	  XLOW	=   CENTER - WIDTH/2
     	  STEP	=   WIDTH/(NBIN - 1)
     	  XSTART	=   XLOW - STEP/2
     	DO 999 I=1,NPOINT
	 XARG	= RAY(N_COL,I)
C
C Use the appropriate units for column 11, if it is selected.
C
	 IF (N_COL.EQ.11) THEN
	   IF (XARG.EQ.0.0D0) GO TO 999
	   IF (IENER.EQ.0) THEN
	     XARG	= TWOPI/XARG*1.0E+8
	   ELSE IF (IENER.EQ.1) THEN
	     XARG	= XARG/TWOPI*TOCM
	   END IF
	 END IF
     	 IF (ILOST.EQ.0) THEN
     	  IF (RAY(10,I).LT.0.0D0) GO TO 999
     	 ELSE	IF (ILOST.EQ.2) THEN
     	  IF (RAY(10,I).GT.0.0D0) GO TO 999
      	 END IF
      	 ARG	=   (XARG - XSTART)/STEP
     	 JBIN	=   IFIX (ARG) + 1
      	 IF (JBIN.LT.1.OR.JBIN.GT.NBIN) GO TO 999
	   IF (IREFL.EQ.1) THEN
	     VAL  =   RAY(7,I)**2 + RAY(8,I)**2 + RAY(9,I)**2
	     IF (NCOL.EQ.18)	
     $		VAL = VAL + RAY(16,I)**2 + RAY(17,I)**2 + RAY(18,I)**2
	     IF (IUNITS.EQ.0) THEN
		VAL =   SQRT(VAL)
     	     ELSE IF (IUNITS.EQ.1) THEN
     		VAL  =   VAL
     	     ELSE IF (IUNITS.EQ.2) THEN
     		IF (IFILE.EQ.0) THEN
     		  VAL  =  (1.0D0-VAL)
     		ELSE
	          VAL0 =   RAY2(7,I)**2 + RAY2(8,I)**2 + RAY2(9,I)**2
	          IF (NCOL2.EQ.18)	
     $		  VAL0 = VAL0 + RAY2(16,I)**2 + RAY2(17,I)**2 + RAY2(18,I)**2
     		  VAL  =  (VAL0-VAL)
     		END IF
     	     END IF
	     IF (ISCALE.EQ.1) THEN
     	  	VAL	=  VAL*RAY(11,I)*TOCM*1.6021892D-19/TWOPI
	     ELSE IF (ISCALE.EQ.2) THEN
		VAL	=  VAL*RAY(11,I)*TOCM/TWOPI
	     END IF
	   ELSE
		VAL = 1.0
	   END IF
    	YARRAY(JBIN) = YARRAY(JBIN) + VAL
999	CONTINUE
C
C Prepare the arrays for writing
C
     	DO 13 I=1,NBIN
     	  XARRAY(I) =   (I-1)*STEP + XLOW
13     	CONTINUE
C
C Write the xtemp array for primvs purposes.
C
#if !defined(vms)
	  X1LOW = CENTER - 0.6125*WIDTH
	  X1UPP = CENTER + 0.6125*WIDTH
	  Y1LOW = 0.0
	  XTEMP(1) = XSTART
	  DO 51 I = 2,NBIN+1
	    XTEMP(I) = XTEMP(I-1) + STEP
51	  CONTINUE
#endif

C
C Normalize the arrays
C
     	  COUNTS	=   0.0
     	  YMAX		= - 1.0
     	DO 14 I=1,NBIN
     	  YMAX	=   AMAX1(YMAX,YARRAY(I))
     	  COUNTS=   COUNTS + YARRAY(I)
14     	CONTINUE
C
     	 IF (NORM.NE.0) THEN
     	  IF (NORM.EQ.1) THEN
	    RNORM  =   YMAX
	    Y1UPP  = 1.2
	  END IF
     	  IF (NORM.EQ.2) THEN
	    RNORM  =   COUNTS
	    Y1UPP  = 1.2*YMAX/COUNTS
	  END IF
     	   DO 16 I=1,NBIN
     	   YARRAY(I) =   YARRAY(I)/RNORM
16     	  CONTINUE
	ELSE IF (NORM.EQ.0) THEN
	  Y1UPP = 1.2*YMAX
     	END IF
C
C Ready for output.
C
#ifdef vms
	IF (IOUT.EQ.0.OR.IOUT.EQ.2) THEN
     	  OPEN (20,FILE='HISTO1',STATUS='NEW',INITIALSIZE=5)
     	    DO 17 I=1,NBIN
     	      WRITE (20,*)	XARRAY(I),YARRAY(I)
17     	    CONTINUE
     	  CLOSE (20)
	END IF
	IF (IOUT.EQ.1.OR.IOUT.EQ.2) THEN
	  CALL TDNEWP
	  CALL TDHIST (NBIN,XARRAY,YARRAY)
	  CALL SET_SCREEN	(' ',1,ITERM)
	END IF
#else
	  OPEN (22,FILE='histo1.dat',STATUS='UNKNOWN')
	  WRITE(22,*) XTEMP(1), 0.0
	  DO 53 I = 1,NBIN+1
	    WRITE(22,*) XTEMP(I), YARRAY(I)
	    WRITE(22,*) XTEMP(I+1), YARRAY(I)
53	  CONTINUE
	  WRITE(22,*) XTEMP(NBIN+1), 0.0
	  CLOSE(22)

	  OPEN (23,FILE='histo1.prm',STATUS='UNKNOWN')
	  WRITE(23,*) '# Primvs command file to plot output of HISTO1'
	  IF (ITERM.EQ.0) THEN
	    WRITE(23,*) '# Initialize Xwindow display'
	    WRITE(23,*) ' '
	    WRITE(23,*) 'initpage(xwin)'
	  ELSE IF (ITERM.EQ.1) THEN
	    WRITE(23,*) '# Initialize Tektronix display'
	    WRITE(23,*) ' '
	    WRITE(23,*) 'initpage(tekt)'
	  ELSE IF (ITERM.EQ.2) THEN
	    WRITE(23,*) '# Initialize postscript file '
	    WRITE(23,*) ' '
	    WRITE(23,*) 'setcolor(0)'
	    WRITE(23,*) 'initpage(ps,"histo1.ps")'
	  ENDIF
	  WRITE(23,*) '# Set limits on viewing window, plot, and '
	  WRITE(23,*) '# character size.'
	  WRITE(23,*) 'regionr(0.1,0.1,0.9,0.9,1.0)'
	  WRITE(23,3030) X1LOW,X1UPP,Y1LOW,Y1UPP
	  WRITE(23,*) 'color(green)'
	  WRITE(23,*) 'scalechr(0.8)'
	  WRITE(23,*) ' '
	  WRITE(23,*) '# Plot histogram from histo1.dat and draw axes'
	  WRITE(23,*) 'plotl("histo1.dat")'
	  WRITE(23,*) 'box("bcnst",0,0,"bcnstv",0,0)'
	  WRITE(23,*) 'closepage'
	  WRITE(23,*) 'exit'

3030    FORMAT ('xyrange(',E15.8,',',E15.8,',',E15.8,',',E15.8,')')

	IFLAG = 0
	CALL PROGPATH ('primvs', PRIMVS, IFLAG)
	PRIMVSPATH = PRIMVS(1:IBLANK(PRIMVS)) // ' -i histo1.prm'
#if !defined(__CYGWIN32__)
	WRITE(*,*) 'Executing program: ' // 
     $		PRIMVSPATH(1:IBLANK(PRIMVSPATH))
	CALL SYSTEM (PRIMVSPATH)
#else
	IF (IARGC() .EQ. 1) THEN
	    CALL GETARG(1, CMDARG)
	ENDIF
	IF (CMDARG(1:11).EQ.'-run-primvs') THEN
	    WRITE(*,*) 'Executing program: ' // 
     $		PRIMVSPATH(1:IBLANK(PRIMVSPATH))
	    IFLAG = 0
	    CALL RUNPRIMVS ('histo1.prm', iflag)
	ENDIF
#endif
#endif

     	IANSW = IYES ( 'Another run  [ Y/N ] ?')
     	IF (IANSW.EQ.1) GO TO 1
     	WRITE(6,*)'Return to operating system'
     	STOP
     	END
