C +++
C
C Source: src/utils/post/minmax.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: minmax.F
C Revision 1.6  1992/01/16  09:23:29  cwelnak
C 6000 changes
C
C Revision 1.5  91/07/06  19:43:52  khan
C Grenoble Changes ...
C 
C Revision 1.4  91/04/05  15:50:45  cwelnak
C changed quotes in #includes
C 
C Revision 1.3  91/03/25  15:56:09  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.2  91/01/25  16:47:24  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/08  17:03:43  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	PROGRAM		MINMAX
C
C	purpose		To locate maxima and minima in our ray arrays.
C
C---
     	PROGRAM 		MINMAX
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
        INCLUDE	        'SHADOW$INC:DIM.PAR/LIST'
#endif
     	REAL*8			RAY(12,N_DIM),AP(3,N_DIM),PHASE(3,N_DIM)
     	CHARACTER * 80		FILEIN
     	CHARACTER * 60		FILETEXT
     	CHARACTER * 17		DATETEXT
	CHARACTER * 80		COMMENT
     	DIMENSION		TEST(6)
C Statements to define the use of RSTRING
     	CHARACTER*80	RSTRING
     	EXTERNAL	RSTRING
     	FILEIN	=   RSTRING ('Input file ? ')
1000	FORMAT (A)
#if defined(vms) || 1
     	CALL	FILEINFO  (FILEIN)
     	CALL	NEXTFILE  (FILETEXT,DATETEXT)
#endif
	WRITE(6,*)'Options --- Enter'
     	WRITE(6,*)'0 for excluding the losses'
     	WRITE(6,*)'1 for including losses at a particular O.E.'
     	WRITE(6,*)'2 for including all the losses.'
     	KLOSS	=   IRINT ('Then ? ')
     	IF (KLOSS.EQ.1) THEN
     	WRITE(6,*)
     $	'Flag value ( -11000 first O.E., -22000 sec O.E., etc.) ?'
     	CHECK	=   RNUMBER ('Then ? ')
     	ELSE
     	END IF
	WRITE(6,*)'Comment ?'
	READ (5,1100)	COMMENT
C	READ (5,1100)	LCOMM,COMMENT
1100	FORMAT (A)
C1100	FORMAT (Q,A)
	KOUNT	=   0
     	CALL	RBEAM (FILEIN,RAY,PHASE,AP,NCOL,NPOINT,IFLAG,IERR)
     	DO 11 I=1,NPOINT
     	 IF (RAY(10,I).LT.0.0) KOUNT = KOUNT + 1
11     	CONTINUE
100     CONTINUE
     	WRITE(6,*)'***********'
     	WRITE(6,*)'File examined is :'
     	WRITE(6,*)FILETEXT
     	WRITE(6,*)'Was created :'
     	WRITE(6,*)DATETEXT
     	WRITE(6,*)'***********'
	WRITE(6,*)'Found ',(NPOINT-KOUNT),' good points out of',NPOINT
     	XMIN =   1.0E+20
     	XMAX = - 1.0E+20
     	YMIN =   1.0E+20
     	YMAX = - 1.0E+20
     	ZMIN =   1.0E+20
     	ZMAX = - 1.0E+20

     	X1MIN =   1.0E+20
     	X1MAX = - 1.0E+20
     	Y1MIN =   1.0E+20
     	Y1MAX = - 1.0E+20
     	Z1MIN =   1.0E+20
     	Z1MAX = - 1.0E+20
     	DO 300 I=1,NPOINT
	 IF (KLOSS.EQ.0) THEN
	   IF (RAY(10,I).LT.0.0D0)   GO TO 300
	 ELSE IF (KLOSS.EQ.1) THEN
     	   IF (RAY(10,I).LT.0.0D0.AND.RAY(10,I).NE.CHECK) GO TO 300
     	 ELSE
     	 END IF
     	TEST(1)	=   RAY(1,I)
     	TEST(2)	=   RAY(2,I)
     	TEST(3)	=   RAY(3,I)
     	TEST(4)	=   RAY(4,I)
     	TEST(5)	=   RAY(5,I)
     	TEST(6)	=   RAY(6,I)
     	XMIN = MIN(XMIN,TEST(1))
     	XMAX = MAX(XMAX,TEST(1))
     	YMIN = MIN(YMIN,TEST(2))
     	YMAX = MAX(YMAX,TEST(2))
     	ZMIN = MIN(ZMIN,TEST(3))
        ZMAX = MAX(ZMAX,TEST(3))
     	X1MIN = MIN(X1MIN,TEST(4))
     	X1MAX = MAX(X1MAX,TEST(4))
     	Y1MIN = MIN(Y1MIN,TEST(5))
     	Y1MAX = MAX(Y1MAX,TEST(5))
     	Z1MIN = MIN(Z1MIN,TEST(6))
300     Z1MAX = MAX(Z1MAX,TEST(6))

     	WRITE(6,*)'Here we are.'

     	WRITE(6,*)'X max is',XMAX
     	WRITE(6,*)'X min is',XMIN
     	WRITE(6,*)'Y max is',YMAX
     	WRITE(6,*)'Y min is',YMIN
     	WRITE(6,*)'Z max is',ZMAX
     	WRITE(6,*)'Z min is',ZMIN

     	WRITE(6,*)'X prime max is',X1MAX
     	WRITE(6,*)'X prime min is',X1MIN
     	WRITE(6,*)'Y prime max is',Y1MAX
     	WRITE(6,*)'Y prime min is',Y1MIN
     	WRITE(6,*)'Z prime max is',Z1MAX
     	WRITE(6,*)'Z prime min is',Z1MIN

#ifdef vms
     	OPEN (25,FILE='MINMAX',STATUS='NEW',CARRIAGECONTROL='LIST')
#else
     	OPEN (25,FILE='MINMAX',STATUS='UNKNOWN')
	REWIND (25)
#endif
     	WRITE (25,*)	'Searching file: '
	WRITE (25,*)	FILETEXT (1:40)
     	WRITE (25,*)	FILETEXT (41:60)
     	WRITE (25,*)	DATETEXT
     	WRITE (25,*)
	WRITE (25,*)    COMMENT
C	WRITE (25,*)    COMMENT(1:LCOMM)
     	WRITE (25,*)
     	WRITE (25,*) 'Total rays : ',NPOINT
     	WRITE (25,*) 'Lost rays  : ',KOUNT
     	IF (KLOSS.EQ.1) WRITE (25,2222) 'INCLUDING LOSSES : '
     $					,KLOSS,CHECK
     	IF (KLOSS.EQ.0) WRITE (25,1111) 'EXCLUDING LOSSES'
     	WRITE (25,3333)	'X max is ',XMAX
     	WRITE (25,3333)	'X min is ',XMIN
     	WRITE (25,3333)	'Y max is ',YMAX
     	WRITE (25,3333)	'Y min is ',YMIN
     	WRITE (25,3333)	'Z max is ',ZMAX
     	WRITE (25,3333)	'Z min is ',ZMIN

     	WRITE (25,3333)	'X prime max is ',X1MAX
     	WRITE (25,3333)	'X prime min is ',X1MIN
     	WRITE (25,3333)	'Y prime max is ',Y1MAX
     	WRITE (25,3333)	'Y prime min is ',Y1MIN
     	WRITE (25,3333)	'Z prime max is ',Z1MAX
     	WRITE (25,3333)	'Z prime min is ',Z1MIN

     	CLOSE (25)
1111	FORMAT (1X,A)
2222	FORMAT (1X,A,1X,'Option: ',I4,10X,'Flag :',G12.5)
3333	FORMAT (1X,A,T20,G19.12)
     	END

