C +++
C
C Source: src/utils/post/intens.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: intens.F
C Revision 1.8  1992/01/15  16:51:35  cwelnak
C 6000 changes
C
C Revision 1.7  91/07/06  19:43:52  khan
C Grenoble Changes ...
C 
C Revision 1.6  91/07/06  14:06:16  khan
C Grenoble changes...
C 
C Revision 1.5  91/04/05  15:50:44  cwelnak
C changed quotes in #includes
C 
C Revision 1.4  91/03/25  15:56:07  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.3  90/11/02  17:50:48  khan
C Nasty bug fix with IMPLICIT REAL*8 missing ..!!**(#&%(*@. 
C 
C Revision 1.1  90/10/08  17:03:39  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C
C	PROGRAM		INTENS
C
C	PURPOSE		To plot the transmitted/absorbed intensity
C			at a filter or mirror
C
C	INPUT		a RAY file from SHADOW
C
C	OUTPUT		a plottable file.
C
C---
	PROGRAM		INTENS
	IMPLICIT	REAL*8	(A-H,O-Z)
     	DATA	TWOPI 	/  6.2831 85307 17958 64679 25287 D0 /
	DATA	TOCM	/  1.239 852	D-4		     /
	DATA	TOANGS  /  1.239 852    D+4		     /
C
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
	INCLUDE		'SHADOW$INC:DIM.PAR/LIST'
#endif
C
     	CHARACTER*80	FILE1,FILE2,OUTFIL
     	REAL*8		RAY1(18,N_DIM),RAY2(18,N_DIM),R_TOT
C Statements to define the use of RSTRING
     	CHARACTER*80	RSTRING
10     	CONTINUE
     	FILE1	=   RSTRING ('File for Intensity calculations ? ' )
     	CALL	RBEAM18 (FILE1,RAY1,NCOL1,NP,IFLAG,IERR)
     	IF ( IERR.NE.0) STOP	'Error reading ray file.'
C
C Also calculate the number of lost rays.
C
     	I_TOT = 0
     	I_LOST = 0
	DO 29 I = 1, NP
	    IF (RAY1(10,I) .LT. 0.0D0) THEN
	       I_LOST = I_LOST + 1
	    ENDIF
	    I_TOT  = I_TOT + 1
 29	CONTINUE
	WRITE(6,*)  'Total rays :', I_TOT 
	WRITE(6,*)  'Good rays :', I_TOT - I_LOST
	WRITE(6,*) 'Each ray has ',NCOL1,' entries.'
C
	WRITE(6,*) 'Flags checks (not used for plotting): Enter'
	WRITE(6,*) ' 0 to exclude lost rays'
	WRITE(6,*) ' 1 to include lost rays too'
	WRITE(6,*) ' 2 to use only lost rays'
	ILOST = IRINT ('<?>')
C
	DO 39 I = 1, NP
	    IF (ILOST .EQ. 0) THEN
	       IF (RAY1 (10, I) .LT. 0) GOTO 39
	    ELSE IF (ILOST .EQ. 2) THEN
		IF (RAY1 (10, I) .GT. 0) GOTO 39
	    ENDIF
     	  R_TOT = R_TOT + RAY1(7,I)**2 + RAY1(8,I)**2 + RAY1(9,I)**2
 39	CONTINUE
	IF (NCOL1.EQ.18) THEN
	DO 49 I = 1, NP
	    IF (ILOST .EQ. 0) THEN
	       IF (RAY1 (10, I) .LT. 0) GOTO 49
	    ELSE IF (ILOST .EQ. 2) THEN
		IF (RAY1 (10, I) .GT. 0) GOTO 49
	    ENDIF
	  R_TOT = R_TOT + RAY1(16,I)**2 + RAY1(17,I)**2 + RAY1(18,I)**2
 49	CONTINUE
	END IF	
     	WRITE(6,*) 'Total intensity is :',R_TOT
     	WRITE(6,*) 'Normalized intensity is :',R_TOT/NP
30     	CONTINUE
     	WRITE(6,*) 'Options:'
     	WRITE(6,*) 'Intensity transmitted/reflected ....... 0'
     	WRITE(6,*) 'Intensity absorbed .................... 1'
     	WRITE(6,*) 'Local reflectivity/transmission ....... 2'
     	KIND	=   IRINT (' Then ? ')
     	IF (KIND.NE.2) THEN
	  WRITE(6,*)'Spectrum type :'
	  WRITE(6,*)'  [0]    # photons/sec.'
	  WRITE(6,*)'  [1]    Watt'
     	  KUNIT	=   IRINT ('Then ? ')
     	  KPOW  = IYES ('Normalize to source power [ Y/N ] ? ')
     	  IF (KPOW.EQ.1) PWFAC = RNUMBER ('Total source power emitted ? ')
	  RFAC	= PWFAC/NP
     	END IF
     	IF (KIND.NE.0) THEN
     	  FILE2 = RSTRING ('Input I0 file : ' )
     	  CALL RBEAM18 (FILE2,RAY2,NCOL2,NP,IFLAG,IERR)
     	  IF (IERR.NE.0) STOP	'Error reading ray file.'
     	END IF
20     	  FILE2 =  RSTRING ('File-name  for [x,y] file ? ')
     	  KPLT  =  IRINT ('Bi [ 0 ] or Tri-dimensional plot [ 1 ] ? ')
     	   IF (KPLT.EQ.1) THEN
     	    KX = IRINT ('Row for plot x-axis ? ')
     	    KY = IRINT ('             y-axis ? ')
	    KSCAX = 0
     	    KSCAY = 0
	     IF (KX.EQ.11) THEN
	       WRITE(6,*) 'Enter :'
	       WRITE(6,*) '	0		cm-1'
	       WRITE(6,*) '	1		eV'
	       WRITE(6,*) '	2		angst'
	       KSCAX = IRINT ('Then ? ')
	     END IF
	     IF (KY.EQ.11) THEN
	       WRITE(6,*) 'Enter :'
	       WRITE(6,*) '	0		cm-1'
	       WRITE(6,*) '	1		eV'
	       WRITE(6,*) '	2		angst'
	       KSCAY = IRINT ('Then ? ')
	     END IF
     	   ELSE
     	    KX	=  IRINT ('Row for plot x-axis ? ')
	    KSCAX = 0
	     IF (KX.EQ.11) THEN
	       WRITE(6,*) 'Enter :'
	       WRITE(6,*) '	0		cm-1'
	       WRITE(6,*) '	1		eV'
	       WRITE(6,*) '	2		angst'
	       KSCAX = IRINT ('Then ? ')
	     END IF
     	   END IF


#ifdef vms
     	 OPEN (20,FILE=FILE2,STATUS='NEW',ERR=20)
#else
     	 OPEN (20,FILE=FILE2,STATUS='UNKNOWN',ERR=20)
	 REWIND (20)
#endif
     	 DO I=1,NP
     	   XPL	=    RAY1(KX,I)
     	   YPL	=    RAY1(KY,I)
     	   ZPL	=    RAY1(7,I)**2 + RAY1(8,I)**2 + RAY1(9,I)**2
	   IF (NCOL1.EQ.18)
     $	     ZPL = ZPL + RAY1(16,I)**2 + RAY1(17,I)**2 + RAY1(18,I)**2
     	  IF (KIND.EQ.1) THEN
     	    ZPL0=    RAY2(7,I)**2 + RAY2(8,I)**2 + RAY2(9,I)**2
	    IF (NCOL2.EQ.18)
     $	      ZPL0 = ZPL0 + RAY2(16,I)**2 + RAY2(17,I)**2 + RAY2(18,I)**2
     	    ZPL	=    ZPL0 - ZPL
     	  ELSE IF (KIND.EQ.2) THEN
     	    ZPL0=    RAY2(7,I)**2 + RAY2(8,I)**2 + RAY2(9,I)**2
	    IF (NCOL2.EQ.18)
     $	      ZPL0 = ZPL0 + RAY2(16,I)**2 + RAY2(17,I)**2 + RAY2(18,I)**2
     	    ZPL	=    ZPL/ZPL0
     	  END IF

	  IF (KIND.NE.2) THEN
     	    IF (KUNIT.EQ.1) THEN		! Watt
     	      IF (KPOW.EQ.0) THEN
     		ZPL = ZPL*TOCM*RAY1(11,I)/TWOPI*1.602E-19
     	      ELSE
     		ZPL = ZPL*RFAC
     	      END IF
	    ELSE				! Photons/sec
     	      IF (KPOW.EQ.0) THEN
     		ZPL = ZPL
     	      ELSE
     		ZPL = ZPL*RFAC/(TOCM*RAY1(11,I)/TWOPI*1.602E-19)
     	      END IF
     	    END IF
	  END IF
     	   IF (KPLT.EQ.1) THEN
	    IF (KSCAX.EQ.0.AND.KSCAY.EQ.0)	THEN
     		WRITE (20,*)	XPL,YPL,ZPL
	    ELSE	IF (KSCAX.EQ.1)		THEN
     		WRITE (20,*)    TOCM*XPL/TWOPI,YPL,ZPL
	    ELSE	IF (KSCAX.EQ.2)		THEN
     		WRITE (20,*)    TWOPI/XPL*1.0E8,YPL,ZPL
	    ELSE	IF (KSCAY.EQ.1)		THEN
     		WRITE (20,*)    XPL,TOCM*YPL/TWOPI,ZPL
	    ELSE	IF (KSCAY.EQ.2)		THEN
     		WRITE (20,*)    XPL,TWOPI/YPL*1.0E8,ZPL
     	    END IF
     	   ELSE	IF (KPLT.EQ.0) THEN
	    IF (KSCAX.EQ.0)	WRITE (20,*)	XPL,ZPL
	    IF (KSCAX.EQ.1)	WRITE (20,*)    TOCM*XPL/TWOPI,ZPL
	    IF (KSCAX.EQ.2)	WRITE (20,*)    TWOPI/XPL*1.0E8,ZPL
	   END IF
     	 END DO
     	 CLOSE (20)
	ITRY	= IRINT ('Another run [1/0] ? ')
     	IF (ITRY.EQ.1)	GO TO 10
     	END
