C +++
C
C Source: src/utils/optics/abrefc.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: abrefc.F
C Revision 1.6  1992/01/15  15:50:24  cwelnak
C 6000 changes
C
C Revision 1.5  91/07/06  19:42:54  khan
C Grenoble Changes ...
C 
C Revision 1.4  91/04/05  15:21:20  cwelnak
C changed quotes in #includes
C 
C Revision 1.3  91/03/25  15:52:03  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.2  91/03/25  15:48:39  khan
C Getting ready for SUN port ...
C 
C Revision 1.1  90/10/10  13:32:51  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	program 	ABREFC				      
C								      
C	F.Cerrina,	SRC - June 1983				      
C								      
C This program is based on the compilation of atomic scattering factor
C The photon energy range is 30-100000 eV, for all elements.	      
C 								      
C The program is self-explanatory and needs no particular explanation 
C The output will be both at the default output device (tt:) and to the
C following files :
C				
C	OUTPUT		ABCOEFF 	= absorption coefficient (cm-1)       
C			CROSS		= cross section, (cm-2)
C			TRANSMISSION 	= transmission ratio                  
C			DIELEC  	= real and complex part of dielectric 
C				  	constant                            
C			REF*		= reflectivity                        
C								      
C	Link with READLIB.OBJ
C---
C     	PROGRAM		REFLECTIVITY
     	PROGRAM		ABREFC
  	REAL*8		RNUMBER
     	DIMENSION	OUTFIL(420,2),ENERGY(420),IREL(5)
	CHARACTER*2	ELEMENT(5),ELE
	CHARACTER*80	RSTRING
     	INTEGER *4 	NUMBER,NATOM(5),NATOMS
     	DIMENSION	OUTFIL11(420),OUTFIL12(420)
     	DIMENSION	OUTFIL21(420),OUTFIL22(420)
     	DIMENSION	OUTFIL31(420),OUTFIL32(420)
     	DIMENSION	OUTFIL41(420),OUTFIL42(420)
     	DIMENSION	OUTFIL51(420),OUTFIL52(420)
     	DATA	PI     	/  3.1415 92653 58979 32384 62643 D0 /
     	DATA	PIHALF 	/  1.5707 96326 79489 66192 31322 D0 /
     	DATA	TWOPI 	/  6.2831 85307 17958 64679 25287 D0 /
     	DATA	TODEG 	/ 57.2957 79513 08232 08767 98155 D0 /
     	DATA	TORAD	/  0.0174 53292 51994 32957 69237 D0 /
	DATA	TOCM	/  1.239 852	D-4		     /
	DATA	TOANGS 	/  1.239 852    D+4		     /
     	DATA	IREL	/ 5*0	/
     	RADIUS	=   2.817939 E-13
     	AVOG	=   6.022098 E+23
     	IPRI	=   IYES   ('Full printout at Terminal ? ')
     	THICK	=   RNUMBER('Thickness (microns) : ')
     	THICK	=   THICK/10000
     	THETAD	=    RNUMBER('Incidence angle : ')
     	DENSITY	=    RNUMBER('Density : ')
     	WRITE(6,*) 'The program is setup to compute optical constants of'
     	WRITE(6,*) 'compounds with up to 5 elements.'
     	NATOMS	=   IRINT('How many atomic species ? ')
     	WRITE(6,*) 'H2O would be: H, 2 and O, 1.'
     	DO 31 I = 1,NATOMS
     	  WRITE(6,*) 
     $'Enter atomic symbol (capitalized) and formula index for : ',I
	  ELEMENT(I)	= RSTRING(' ')
     	  IREL(I)	= IRINT(' ')
31	CONTINUE
     	WRITE(6,*) 'Enter starting photon energy,end and step'
     	READ(*,*) ESTART,EFINAL,ESTEP
     	NPOINT	=  (EFINAL-ESTART)/ESTEP + 1
** Get the data. F1 and F2 are then 'averaged' together
     	RMOL	= 0.0
     	GO TO (55,44,33,22,11)	NATOMS
11	ELE	= ELEMENT(5)
	CALL	READLIB(ELE,NUMBER,ATWT,RMU,EMF,ENERGY,OUTFIL51,OUTFIL52)
	NATOM(5)	= NUMBER
     	RMOL	=          ATWT*IREL(5)
22	ELE	= ELEMENT(4)
	CALL	READLIB(ELE,NUMBER,ATWT,RMU,EMF,ENERGY,OUTFIL41,OUTFIL42)
	NATOM(4)	= NUMBER
     	RMOL	= RMOL+         ATWT*IREL(4)
33	ELE	= ELEMENT(3)
	CALL	READLIB(ELE,NUMBER,ATWT,RMU,EMF,ENERGY,OUTFIL31,OUTFIL32)
	NATOM(3)	= NUMBER
     	RMOL	= RMOL+         ATWT*IREL(3)
44	ELE	= ELEMENT(2)
	CALL	READLIB(ELE,NUMBER,ATWT,RMU,EMF,ENERGY,OUTFIL21,OUTFIL22)
	NATOM(2)	= NUMBER
     	RMOL	= RMOL+         ATWT*IREL(2)
55	ELE	= ELEMENT(1)
	CALL	READLIB(ELE,NUMBER,ATWT,RMU,EMF,ENERGY,OUTFIL11,OUTFIL12)
	NATOM(1)	= NUMBER
     	RMOL	= RMOL+        ATWT*IREL(1)
     	WRITE(6,*) 'Molecular weight is :',RMOL
** Computes atomic concentrations and molecular weigth
     	RMOLEC	=   DENSITY/RMOL*AVOG	! This is the number of molecules
     	AT1	=   RMOLEC*IREL(1)
     	AT2	=   RMOLEC*IREL(2)
     	AT3	=   RMOLEC*IREL(3)
     	AT4	=   RMOLEC*IREL(4)
     	AT5	=   RMOLEC*IREL(5)
     	WRITE(6,*) 'Atoms/Cm3'
     	WRITE(6,*) AT1,AT2,AT3,AT4,AT5
** Computes now the effective F1 and F2
     	DO 12 I = 1,420
     	F1	=   0.0
     	F2	=   0.0
     	GO TO (155,144,133,122,111)	NATOMS
111	F1	=        OUTFIL51(I)*AT5
     	F2	=        OUTFIL52(I)*AT5
122	F1	=   F1 + OUTFIL41(I)*AT4
     	F2	=   F2 + OUTFIL42(I)*AT4
133	F1	=   F1 + OUTFIL31(I)*AT3
     	F2	=   F2 + OUTFIL32(I)*AT3
144	F1	=   F1 + OUTFIL21(I)*AT2
     	F2	=   F2 + OUTFIL22(I)*AT2
155	F1	=   F1 + OUTFIL11(I)*AT1
     	F2	=   F2 + OUTFIL12(I)*AT1
     	OUTFIL(I,1)	=   F1
     	OUTFIL(I,2)	=   F2
12      CONTINUE  
** Computes the ALPHA and gamma coefficients.
*** Finds and interpolate for the photon energy.
#ifdef vms
     	OPEN (22, FILE='REFLECTIVITY',STATUS='NEW')
     	OPEN (20, FILE='ABCOEFF',STATUS='NEW')
     	OPEN (21, FILE='TRANSMISSION',STATUS='NEW')
     	OPEN (23, FILE='DIELEC', STATUS='NEW')
     	OPEN (24, FILE='ENERGY_LOSS', STATUS='NEW')
     	OPEN (25, FILE='ELECTRON_YIELD', STATUS='NEW')
     	OPEN (26, FILE='REFRAC_INDEX', STATUS='NEW')
     	OPEN (27, FILE='CROSS_SECTION', STATUS='NEW')
#else
     	OPEN (22, FILE='REFLECTIVITY',STATUS='UNKNOWN')
	REWIND (22)
     	OPEN (20, FILE='ABCOEFF',STATUS='UNKNOWN')
	REWIND (20)
     	OPEN (21, FILE='TRANSMISSION',STATUS='UNKNOWN')
	REWIND (21)
     	OPEN (23, FILE='DIELEC', STATUS='UNKNOWN')
	REWIND (23)
     	OPEN (24, FILE='ENERGY_LOSS', STATUS='UNKNOWN')
	REWIND (24)
     	OPEN (25, FILE='ELECTRON_YIELD', STATUS='UNKNOWN')
	REWIND (25)
     	OPEN (26, FILE='REFRAC_INDEX', STATUS='UNKNOWN')
	REWIND (26)
     	OPEN (27, FILE='CROSS_SECTION', STATUS='UNKNOWN')
	REWIND (27)
#endif
	ELFACTOR	= LOG10(1.0E4/30.0)/300.0
     	DO 13 I=1,NPOINT
     	PHOTON	=   ESTART + (I-1)*ESTEP
	NENER	=   LOG10(PHOTON/30.0E0)/ELFACTOR + 1
     	F1	=   OUTFIL(NENER,1) + 
     $	(OUTFIL(NENER+1,1) - OUTFIL(NENER,1))*(PHOTON - ENERGY(NENER))/
     $	(ENERGY(NENER+1) - ENERGY(NENER))
     	F2	=   OUTFIL(NENER,2) + 
     $	(OUTFIL(NENER+1,2) - OUTFIL(NENER,2))*(PHOTON - ENERGY(NENER))/
     $	(ENERGY(NENER+1) - ENERGY(NENER))
*** Computes now ALPHA and gamma (dielectric constant):
C
C   epsi = 1 - alpha - i gamma
C
     	WAVE	=   TOCM/PHOTON
     	ALPHA	=   RADIUS/PI*(WAVE**2)*F1
     	GAMMA	=   RADIUS/PI*(WAVE**2)*F2
** Computes the Energy Loss rate
     	ELOSS	=   GAMMA/((1-ALPHA)**2 + GAMMA**2)
** Computes the Electron Photoyield
     	EYIELD	=   F2
** Computes the optical coefficients.
     	THETA	=   TORAD*THETAD
     	DELTA	=   PIHALF - THETA
     	RHO	=   (SIN(DELTA))**2 - ALPHA
     	RHO	=   RHO + SQRT ((SIN(DELTA)**2 - ALPHA)**2 + GAMMA**2)
     	RHO	=   SQRT(RHO/2)
** Computes now the reflectivity for s-pol
     	RS1	=   4*(RHO**2)*(SIN(DELTA)-RHO)**2 + GAMMA**2
     	RS2	=   4*(RHO**2)*(SIN(DELTA)+RHO)**2 + GAMMA**2
     	RS	=   RS1/RS2
** Computes now the polarization ratio
     	RATIO1	=   4*RHO**2*(RHO*SIN(DELTA)-COS(DELTA)**2)**2 +
     $		    GAMMA**2*SIN(DELTA)**2
     	RATIO2	=   4*RHO**2*(RHO*SIN(DELTA)+COS(DELTA)**2)**2 +
     $		    GAMMA**2*SIN(DELTA)**2
     	RATIO	=   RATIO1/RATIO2
** The reflectivity for p light will be
     	RP	=   RS*RATIO
** For an unpolarized beam we have
     	RUNP	=   0.5*(RS+RP)
** Computes now the penetration depth
C
C fixed 18 sept 1984
C
     	DEPTH	=   WAVE/TWOPI/GAMMA
     	ABSORP	=   1/DEPTH
C
C Compute cross section for absorption
C
     	CROSS	=   ABSORP/RMOLEC
C
C** Computes the film absorption
C
     	TRANS	=   EXP(-THICK*ABSORP)
C
C** Computes the complex refraction index
C
     	BETA	=   GAMMA/2
     	DELTA	=   ALPHA/2
C
C** Prints out the results
C
     	IF (IPRI.EQ.1) THEN
     	 WRITE (6,1000)
	 DO 14 J = 1, NATOMS
     	   WRITE (6,1005) NATOM(J),ELEMENT(J)
14	 CONTINUE
     	  WRITE (6,1010)
      	  WRITE (6,1015) PHOTON,WAVE,F1,F2
     	  WRITE (6,1016)
     	  WRITE (6,1020) ALPHA,GAMMA
     	  WRITE (6,1025)
     	  WRITE (6,1027) DELTA,BETA
     	  WRITE (6,1030) RS,RP,RUNP
     	  WRITE (6,1040) DEPTH
     	  WRITE (6,1050) ABSORP
     	END IF
     	 WRITE (22,*) PHOTON,RUNP,RS,RP
     	 WRITE (20,*) PHOTON,ABSORP
     	 WRITE (21,*) PHOTON,TRANS
     	 WRITE (23,*) PHOTON,ALPHA,GAMMA
     	 WRITE (24,*) PHOTON,ELOSS
     	 WRITE (25,*) PHOTON,EYIELD
     	 WRITE (26,*) PHOTON,DELTA
     	 WRITE (27,*) PHOTON,CROSS
13      CONTINUE
     	CLOSE (22)
     	CLOSE (21)
     	CLOSE (20)
     	CLOSE (23)
     	CLOSE (24)
     	CLOSE (25)
     	CLOSE (26)
     	CLOSE (27)
1000	FORMAT (1X,'Atomic number',T30,'Symbol')
1005	format (15X,I2,T30,A2)
1010	FORMAT (1X,'Photon',T20,'Wavelength',T40,'F1',T60,'F2')
1015	FORMAT (1X,G12.5,T20,G12.5,T40,G12.5,T60,G12.5,/)
1016	FORMAT (1X,
     $'Complex dielectric constant, K = 1 - Alpha + i*Gamma')
1020	FORMAT (1X,'ALPHA = ',G12.5,T40,'GAMMA = ',G12.5)
1025	FORMAT (1X,'Complex refractive index, N = 1 - Delta - i*Beta')
1027	FORMAT (1X,'DELTA = ',G12.5,T40,'BETA  = ',G12.5)
1030	FORMAT (1X,'Reflectivity (S) = ',G12.5,/,1X,
     $	'Reflectivity (P) = ',G12.5,/,1x,'Reflectivity     = ',G12.5)
1040	FORMAT (1X,'Penetration depth (CM) = ',G12.5)
1050	FORMAT (1X,'Absorption coefficient (CM-1) = ',G12.5)
     	CALL	EXIT(0)

     	END
