
#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

	subroutine segment_calc(vvin,ppin,itik,pout,vnor,isega,tpar)

#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c	INCLUDE         './../include/warning.blk'
c
c
#	include		<common.blk>
#	include		<warning.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
     	INCLUDE		'SHADOW$INC:WARNING.BLK/LIST'
#endif


	real*8 vvin(3),ppin(3),rorient(4),ps_cent(3)
	real*8 px(3),py(3),pz(3),pout(3),vnor(3)
	real*8 tpar,x_bc(2),y_bc(2),pos(2),pf_cent(3)
	real*8 r1,r2,d_x,d_y,siz(2),rmax
	real*8 seg_orient(20,20,4)
	integer*4 iseg_table(30,2),ico,itik,isega
	integer*4 i1,i2,j1,i,j,ik,num(2)
	integer*4 iseg_x,iseg_y

C
C put F_KOMA here is to avoid conflicting calculation
C
	isega = 0
C
C  clear the flag in case of confusion
C

	
	if(itik.eq.1.and.f_koma.ne.1) then
	ierr =0

	call segment_read(file_segment,seg_orient,rmax,ierr)

	if(ierr.eq.-1) then
	call leave
     $    ('segmented mirror','wrong  data file format')
	endif

	r1 = iseg_xnum*1.0d0
	r2 = iseg_ynum*1.0d0

C	do i = 1,4
C	type *,'seg_orient 3 1 ',seg_orient(3,1,i)
C	end do

	rmax_height = rmax
	num(1) = iseg_xnum
	num(2) = iseg_ynum
	siz(2) = seg_leny
	siz(1) = seg_lenx

	isega = 1

	if(siz(1).eq.0.0d0.or.siz(2).eq.0.0.or.num(1).eq.0.0.or.
     $	num(2).eq.0.0d0 ) then

	call leave
     $   ('segmented mirror','wrong input data setting')

	endif

	goto 97
	endif

	d_x = seg_lenx/2.
	d_y = seg_leny/2.


	call create_table(vvin,ppin,iseg_table)
C	type *,'iseg_tab',iseg_table(1,1)

	if(iseg_table(1,1).eq.1) goto 93 

	ico = iseg_table(1,1)

	do 91 i = 2,ico

	iseg_x = iseg_table(i,1)
	iseg_y = iseg_table(i,2)

C	type *,'iseg_x y',iseg_x,iseg_y


C 	i1 = jidint(r1/2.) + iseg_x + 1
C 	j1 = jidint(r2/2.) + iseg_y + 1
 	i1 = idint(r1/2.) + iseg_x + 1
 	j1 = idint(r2/2.) + iseg_y + 1
C	type *,'i1 j1',i1,j1

	do ik = 1,4
	rorient(ik) = seg_orient(i1,j1,ik)
C	type *,'seg', seg_orient(i1,j1,ik)
	end do

C	type *,'rorient',rorient


	ps_cent(1) = iseg_x * seg_lenx
	ps_cent(2) = iseg_y * seg_leny
	ps_cent(3) = rorient(4)

	call eular_rotation(rorient,px,py,pz)

	iflag = 0

	call frame_change_calc(ppin,vvin,ps_cent,px,py,pz,vnor,pout,
     $		tpar,iflag)

	if(iflag.ne.1) goto 93

C	type *,'pout',pout

C	type *,'ps_cent',ps_cent
	pos(1) = pout(1)
	pos(2) = pout(2)

	x_bc(1) = ps_cent(1) + d_x
	x_bc(2) = ps_cent(1) - d_x

	y_bc(1) = ps_cent(2) + d_y
	y_bc(2) = ps_cent(2) - d_y

	i_check = 0

C	type *,'bc',x_bc,y_bc

	call pos_check(pos,x_bc,y_bc,i_check)

C	type *,'position  ch',i_check

	if(i_check.eq.1) goto  95

	
91	continue

93	continue
	isega = -1

95	continue
	if(isega.ne.-1) then
	isega = 1
	endif

97	continue
	return
	end


	subroutine create_table(vvin,ppin,iseg_table)
 	
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c	INCLUDE         './../include/warning.blk'
c
c
#	include		<common.blk>
#	include		<warning.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
     	INCLUDE		'SHADOW$INC:WARNING.BLK/LIST'
#endif


	real*8 x_bc(2),y_bc(2)
	real*8 vvin(3),ppin(3),bc(2),num(2)
	real*8 siz(2),xbc(2),ybc(2),z_testban,z_testmark
	real*8 t_proper,x_ini,y_ini
	real*8 x_inf,y_inf,pos_region(2),d_x,d_y,x_x1,y_y1
	real*8 t_1,t_2,t_a,t_b,t_to,x_cent,y_cent
	integer*4 isa_ini(2),isa_inf(2),i_ycon,i_xcon
	integer*4  iseg_table(30,2)
	integer*4  in,i1,iseg_count,i_zpass
	integer*4  ibc_flag,iseg_lost
	integer*4  i_check,ico,i_ini,j_ini,i,j,icot
	integer*4  i_prop_check,i_xy_pro

	CHARACTER  A(80)*1,B(80)*1
	CHARACTER*10  name,nameout



	num(1) = iseg_xnum
	num(2) = iseg_ynum
	siz(1) = seg_lenx
	siz(2) = seg_leny
C	type *,'rmax_height',rmax_height
C	type *,'ppin',ppin
C	type *,'vvin',vvin

C
C decide the segment unit : they are from (-i_xcon,-i_jcon) to
C   (i_xcon,y_xcon)
C


	t_proper = 0
	icase = 0
C	i_xcon = jidint(num(1)/2)
C	i_ycon = jidint(num(2)/2)
	i_xcon = idint(num(1)/2)
	i_ycon = idint(num(2)/2)
	x_bc(1)=(num(1)*siz(1))/2
	y_bc(1)=(num(2)*siz(2))/2
	x_bc(2) = -1.*x_bc(1)
	y_bc(2) = -1.*y_bc(1)
C	type *,'bc',x_bc,y_bc
	d_x = siz(1)/2.
	d_y = siz(2)/2.
C
C initial setting: iseg_count decide how many segmented mirror
C is going to be selected, z_testben decide the propergation
C of the ray in the z-direction, z_testmark is  the
C maximum range  that the z_testben can have.
C

	iseg_lost = 0
	iseg_count = 1
	icot = 0
	i_zpass = 0
	z_testben= 0.0

	pos_region(1) = ppin(1)
	pos_region(2) = ppin(2)
	
	ibc_flag = 0
	call region_check(pos_region,x_bc,y_bc,ibc_flag)
C	type *,'ibc', ibc_flag

	if(ibc_flag.eq.-1.0) then

C
C	ibc_flag = -1 is outside case
C       inside the segmented mirror region means that
C  the ppin(1) and ppin(2) are points within the 
C  x-boundary and y-boundary
C  and the reason for doing so is a homework
C

C	 type *,'outside'


	if(vvin(2).eq.0) then
	
	 iseg_lost = 1
         goto 173
	 endif

	if(vvin(3).eq.0.0d0) then

	  if(ppin(3).gt.rmax_height) then

		iseg_lost = 1
		goto 173

	  else
                i_zpass = 1
	  endif


	else

	  if(ppin(3).eq.0.0d0) i_zpass = 1

         endif

C
C testing for some special cases and arrangement
C
	
        t_proper = (y_bc(2)-ppin(2))/vvin(2)

	if(t_proper.lt.0.0d0) t_proper= -1.0*t_proper

	x_ini = vvin(1) *t_proper + ppin(1)
	y_ini = y_bc(2)

C	type *,'tpro',t_proper
C	type *,'x_ini y_ini',x_ini,y_ini

	pos_region(1) = x_ini
	pos_region(2) = y_ini

	i_check = 0

	call region_check(pos_region,x_bc,y_bc,i_check)

C	 type *,'icheck',i_check
	if(i_check.eq.-1) then

		iseg_lost = 1
		goto 173
	endif


	 if(i_zpass.ne.1) then

	   z_testmark = ppin(3)/vvin(3)

	 if(z_testmark.lt.0.0d0) then

	   z_testmark = z_testmark*(-1.0d0)

C	 type *,'z_testmark',z_testmark
	 endif

	  if(t_proper.gt.z_testmark) then
		iseg_lost = 1
		goto 173

	endif
	endif

	    
	    icot = iseg_count +1

	    i_ini =  nint(x_ini/siz(1))
C	    i_ini =  jidnnt(x_ini/siz(1))
C
C  caution: here I use a trick note that
C  in order to have the correct answer -3.5 should be 
C  -3 instead of -4
C  actually, i should simply use jidint function in the
C  beginning which will return the largest integer
C  whose absoulte value will not exceed the argument
C
C	    j_ini =  jidnnt(y_ini/siz(2)) + 1
	    j_ini =  -3

	    x_cent = i_ini*seg_lenx
C	type *,'i j',i_ini,j_ini

	iseg_table(icot,1) = i_ini
	iseg_table(icot,2) = j_ini

	  iseg_count = iseg_count + 1
	  icot = iseg_count + 1

	if(vvin(1).eq.0.0d0) then

	 icase = 1

         isa_ini(1) = i_ini
         isa_ini(2) = j_ini

	  if(i_zpass.ne.1)  then

	    y_inf = ppin(2)+vvin(2)*z_testmark
C	    isa_inf(2) =  jidnnt(y_inf/siz(2))
	    isa_inf(2) =  nint(y_inf/siz(2))

	   if(isa_inf(2).gt.i_ycon) isa_inf(2) = i_ycon
	    
	  else

	    isa_inf(2) = i_ycon

	  endif
	
	   call straight_pass(icase,isa_ini,isa_inf,iseg_table)
	   
	   goto 99

	 endif

	  xtemp = ppin(1)  + vvin(1) * z_testmark
	  ytemp = ppin(2)  + vvin(2) * z_testmark

C	type *,'x y limit z_test',xtemp,ytemp,z_testmark
C
C    normal case (no special beheavour)
C

	  x_x1 = x_ini - x_cent

	  test_xrange = d_x-x_x1

	    t_1 = test_xrange /vvin(1)
	    t_2 = siz(2) /vvin(2)

	else

C
C  inside the segmented region
C
C

	  t_proper = 0.0d0

	  if(vvin(3).eq.0.0d0.or.ppin(3).eq.0.0d0) then
		iseg_lost = 1
		goto 173
	  endif

	    icot = iseg_count +1

	    x_ini = ppin(1)
	    y_ini = ppin(2)

C	    i_ini =  jidnnt(ppin(1)/siz(1))
C	    j_ini =  jidnnt(ppin(2)/siz(2))
	    i_ini =  nint(ppin(1)/siz(1))
	    j_ini =  nint(ppin(2)/siz(2))

C	    type *,'i j',i_ini,j_ini

	    x_cent = siz(1)*i_ini
	    y_cent = siz(2)*j_ini
	
	iseg_table(icot,1) = i_ini
	iseg_table(icot,2) = j_ini


	 iseg_count = iseg_count + 1
	 icot = icot +1
C
C   there is no i_zpass flag inside in this case 
C
C

	  z_testmark = ppin(3) /vvin(3)
	if(z_testmark.lt.0.0d0) z_testmark = -1.0*z_testmark
	
C	  type *,'z_test',z_testmark

	  xtemp = ppin(1)  + vvin(1) * z_testmark
	  ytemp = ppin(2)  + vvin(2) * z_testmark

C	type *,'x y temp',xtemp,ytemp

          if(vvin(1).eq.0.0) icase = 1

            if(vvin(2).eq.0.0) icase = 2

             if(vvin(2).eq.0.0.and.vvin(1).eq.0.0) icase = 3
		
	     
C	   type *,'icase',icase

	  if(icase.ne.0) then

	  isa_ini(1) = i_ini
	  isa_ini(2) = j_ini

	    if(icase.eq. 1) then

	    y_inf = ppin(2)+vvin(2)*z_testmark
C	    isa_inf(2) =  jidnnt(y_inf/siz(2))
	    isa_inf(2) =  nint(y_inf/siz(2))
     
	   if(isa_inf(2).gt.i_ycon) isa_inf(2) = i_ycon

	   elseif (icase.eq.2) then

	    x_inf = ppin(1)+vvin(1)*z_testmark

C	    isa_inf(1) =  jidnnt(y_inf/siz(1))
	    isa_inf(1) =  nint(y_inf/siz(1))
     
	   if(isa_inf(1).gt.i_ycon) isa_inf(1) = i_ycon


	   endif


	   call straight_pass(icase,isa_ini,isa_inf,iseg_table)
	   
	   goto 99

	   endif
		

	  x_x1 = x_ini - x_cent
	  y_y1 = y_ini - y_cent

	  test_xrange = d_x-x_x1
	  test_yrange = d_y-y_y1

C	  type *,'test_x y range',test_xrange,test_yrange
	  t_1   = d_x/vvin(1)
	  t_2   = d_y/vvin(2)

C	  type *,'t_1 t_2',t_1,t_2

	endif


C
C  main calculation
C


81	  continue
	  t_a = t_1
	  t_b = t_2

          if(t_1.lt.0.0d0) t_a = -1.0*t_1
          if(t_2.lt.0.0d0) t_b = -1.0*t_2
	  
	  t_to = t_b
          if(t_a.lt.t_b) t_to = t_a
C	  t_to = dmin1(t_a,t_b)
	  t_proper = t_proper + t_to

C	   type *,'t_proper ',t_proper
C           type *,'t z',z_testmark

	  if (i_zpass.ne.1) then

	  if(t_proper.gt.z_testmark) then

		i_endtable = 1
		goto 234

	  endif
	  endif

	  if(t_a.gt.t_b) then
	  i_xy_pro= 0
	  else if (t_a.eq.t_b) then
	  i_xy_pro= -1
	  else
	  i_xy_pro = 1

	  endif


	  x_ini = x_ini + vvin(1) * t_to
	  y_ini = y_ini + vvin(2) * t_to

C 	type *,'x y pos',x_ini,y_ini

	pos_region(1) = x_ini
	pos_region(2) = y_ini

	i_prop_check = 0

	call region_check(pos_region,x_bc,y_bc,i_prop_check)

C	type *,'x y xbc ybc',x_ini,y_ini,x_bc,y_bc
C	type *,'icheck',i_prop_check

	if(i_prop_check.eq.-1) then

		i_endtable = 1
	        goto 234
	endif

C	type *,'i_xy_pro',i_xy_pro

C	type *,'iseg_count icot',iseg_count,icot

	 if(i_xy_pro.eq.1) then

	  if(vvin(1).gt.0.0d0) then

	   iseg_table(icot,1) = iseg_table(iseg_count,1) + 1	

	   else

	   iseg_table(icot,1) = iseg_table(iseg_count,1) - 1

	   endif

	    iseg_table(icot,2) = iseg_table(iseg_count,2)

	    y_cent = siz(2)*iseg_table(icot,2) 
	    y_y1 = y_ini - y_cent	
	    test_yrange = d_y-y_y1

	    t_1 = siz(1) /vvin(1)
	    t_2 = test_yrange /vvin(2)

	    iseg_count = iseg_count + 1
	    icot = iseg_count + 1
C	    goto  81

	  else if(i_xy_pro.eq.0) then

	    iseg_table(icot,1) = iseg_table(iseg_count,1)

	   iseg_table(icot,2) = iseg_table(iseg_count,2) + 1	

	    x_cent = siz(1)*iseg_table(icot,1) 

	    x_x1 = x_ini - x_cent	
	    test_xrange = d_x-x_x1

	    t_1 = test_xrange /vvin(1)
	    t_2 = siz(2) /vvin(2)

	    iseg_count = iseg_count + 1
	    icot = iseg_count + 1
C	    goto  81

	  else
	
	  if(vvin(1).gt.0.0d0) then

	   iseg_table(icot,1) = iseg_table(iseg_count,1) + 1	

	   else

	   iseg_table(icot,1) = iseg_table(iseg_count,1) - 1

	   endif

	    iseg_table(icot,2) = iseg_table(iseg_count,2) + 1


	    t_1 = siz(1) /vvin(1)
	    t_2 = siz(2) /vvin(2)


	  iseg_count = iseg_count + 1
	  icot = iseg_count + 1
C	    goto  81
	    
	 endif
	 
	 goto 81

234	continue

	iseg_table(1,1)= iseg_count
	iseg_table(1,2)= iseg_count

99	continue

	i1 = iseg_count 
C	do  900 i = 1,i1
C	write(2,179)(iseg_table(i,j),j=1,2)
C179	format(3x,2I8)
C900	continue

173 	continue
	if(iseg_lost.eq.1) then
	iseg_table(1,1) = 1
	endif


	return
	END

	subroutine region_check(pos,x_bc,y_bc,ibc_flag)

#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c	INCLUDE         './../include/warning.blk'
c
c
#	include		<common.blk>
#	include		<warning.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
     	INCLUDE		'SHADOW$INC:WARNING.BLK/LIST'
#endif


	real*8 pos(2),x_bc(2),y_bc(2)
	integer*4 ibc_flag

C	type *,'pos',pos
C	type *,'y_bc',y_bc
	if(pos(1).lt.x_bc(1).and.pos(1).gt.x_bc(2)) then

	if(pos(2).lt.y_bc(1).and.pos(2).ge.y_bc(2)) then

	   ibc_flag = 1

	endif
	endif

	if(ibc_flag.ne.1) ibc_flag=-1

	return
	end


	subroutine pos_check(pos,x_bc,y_bc,ibc_flag)

#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c	INCLUDE         './../include/warning.blk'
c
c
#	include		<common.blk>
#	include		<warning.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
     	INCLUDE		'SHADOW$INC:WARNING.BLK/LIST'
#endif

	real*8 pos(2),x_bc(2),y_bc(2)
	integer*4 ibc_flag

C	type *,'pos',pos
C	type *,'y_bc',y_bc
	if(pos(1).le.x_bc(1).and.pos(1).ge.x_bc(2)) then

	if(pos(2).le.y_bc(1).and.pos(2).ge.y_bc(2)) then

	   ibc_flag = 1

	endif
	endif

	if(ibc_flag.ne.1) ibc_flag=-1

	return
	end


	   subroutine  straight_pass(icase,isa_ini,isa_inf,iseg_table)

#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c	INCLUDE         './../include/warning.blk'
c
c
#	include		<common.blk>
#	include		<warning.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
     	INCLUDE		'SHADOW$INC:WARNING.BLK/LIST'
#endif

	integer*4 isa_ini(2),isa_inf(2),iseg_table(30,2)
	integer*4   icase,icont,ico,itemp

	   itemp = 0
	if(icase.eq.1) then

	  icont = isa_inf(2)-isa_ini(2) 
	  do 71 ico = 2,2+icont

	  iseg_table(ico,2) = isa_ini(2) + itemp
	
	  itemp = itemp + 1

	  iseg_table(ico,1) = isa_ini(1) 

71	continue

         iseg_table(1,1) = ico + 1

	elseif (icase.eq.2) then

	  icont = isa_inf(1)-isa_ini(1) 
	  do 73 ico = 2,2+icont

	  iseg_table(ico,1) = isa_ini(1) + itemp
	
	  itemp = itemp + 1

	  iseg_table(ico,2) = isa_ini(2) 

73	continue
         iseg_table(1,1) = ico + 1

	elseif (icase.eq.3) then

         iseg_table(1,1) =  2
	  iseg_table(2,1) = isa_ini(1) 
	  
	  iseg_table(2,2) = isa_ini(2) 
	endif
	
 	return

	end


	subroutine eular_rotation(rorient,px,py,pz)

	real*8 rorient(4),px(3),py(3),pz(3)
	character  a(10)*1


23 	continue

C	type *,'your three angle Eular 1 2 3?'
C	read(5,*)(orient(i),i=1,3)
C	read(5,*)orient(1),orient(2),orient(3)

C	type *,'orient',orient
	
C
C   please see Marion Classical Dynamics of Particles and Systems
C   p.385
C

	px(1) = dcosd(rorient(1))*dcosd(rorient(3)) - dcosd(rorient(2))
     $	        *dsind(rorient(1))*dsind(rorient(3))

	px(2) = dcosd(rorient(3))*dsind(rorient(1)) + dcosd(rorient(2))
     $	        *dcosd(rorient(1))*dsind(rorient(3))

        px(3) = dsind(rorient(2))*dsind(rorient(3))


	py(1) = -dcosd(rorient(1))*dsind(rorient(3)) - dcosd(rorient(2))
     $	        *dsind(rorient(1))*dcosd(rorient(3))

	py(2) = -dsind(rorient(1))*dsind(rorient(3)) + dcosd(rorient(2))
     $	        *dcosd(rorient(1))*dcosd(rorient(3))

	py(3) = dsind(rorient(2))*dcosd(rorient(3))


	pz(1) = dsind(rorient(2))*dsind(rorient(1))

	pz(2) = -dsind(rorient(2))*dcosd(rorient(1))


	pz(3) = dcosd(rorient(2))

	return
	end



	subroutine segment_read(infile,seg_orient,rmax,ierr)

#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c	INCLUDE         './../include/warning.blk'
c
c
#	include		<common.blk>
#	include		<warning.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
     	INCLUDE		'SHADOW$INC:WARNING.BLK/LIST'
#endif
 	

	real*8	seg_orient(20,20,4),rmax
	integer*4  ibc_flag,iseg_lost,ierr
	integer*4  i_check,ico,i_ini,j_ini,i,j,icot
	integer*4  i_prop_check,i_xy_pro

	character*80 infile

	open(1,file=infile,status='old')
	rewind(1)
C
C Three rotation angles and one height variable
C
	do 91  i = 1,iseg_xnum
	do   92  j = 1,iseg_ynum
	read(1,*,err=20,end=100)(seg_orient(i,j,k),k=1,4)
92	continue
91	continue

	read(1,*,err=20,end=100)rmax


	close(1)


C	type *,'rmax',rmax

100	continue
	ierr = 1
 	return

20 	continue
	close(1)
	ierr = -1
	return
	END


	subroutine frame_change_calc(ppin,vvin,pf_cent,px,py,pz,vnor,pout,
     $		tpar,iflag)
	
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c	INCLUDE         './../include/warning.blk'
c
c
#	include		<common.blk>
#	include		<warning.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
     	INCLUDE		'SHADOW$INC:WARNING.BLK/LIST'
#endif


	real*8	ppin(3),vvin(3),pf_cent(3)
	real*8	px(3),py(3),pz(3),vnor(3),pout(3)
	real*8  pf_start(3),pf_vin(3),pf_out(3)
	real*8	tpar
	integer*4  iflag


	CALL    FA_ROT (ppin,PF_START,PF_CENT,px,py,pz)
	CALL    FA_ROT (VVIN,PF_VIN,ORIGIN,px,py,pz)

C
C Find the intercept point of the facet surface
C

	I_BASELINE=FMIRR
	FMIRR=9
	IFLAG=1
	      CALL    SPOLY  (PF_START,PF_VIN,TPAR,IFLAG)
	      IF (IFLAG.EQ.-1) THEN
	        FMIRR=I_BASELINE
	        GO TO 100
	      ENDIF

C	PHASE (1,ITIK) = PHASE(1,ITIK) + TPAR*R_IND_OBJ

	PF_OUT(1)=PF_START(1) + PF_VIN(1) * TPAR
	PF_OUT(2)=PF_START(2) + PF_VIN(2) * TPAR
	PF_OUT(3)=PF_START(3) + PF_VIN(3) * TPAR

C
C Find the normal vector on the intercepted point
C

	CALL    NORMAL (PF_OUT,PFNORMAL)

	  CALL DOT(PF_VIN,PFNORMAL,TEMP)
	  IF (TEMP.GT.0.0D0) THEN
	    CALL SCALAR(PFNORMAL,-1.0D0,PFNORMAL)
	  endif

	CALL    NORM   (PFNORMAL,PFNORMAL)

C
C Rotate and translate the normal vector and the intercepted
C point back to the baseline frame system
C


C	  IF (F_INC_MNOR_ANG.EQ.1) THEN
C
C	    CALL DOT(PF_VIN, PFNORMAL, TEMP)
C	    TEMP2 = DACOSD(TEMP)
C	    WRITE(46,*)TEMP2
C
C	  END IF

	CALL    FA_ROTBACK (PF_OUT,POUT,PF_CENT,px,py,pz)
	CALL    FA_ROTBACK (PFNORMAL,VNOR,ORIGIN,px,py,pz)

	iflag = 1
100	continue
	return
	end

