C +++
C
C Source: src/trace/screen.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	screen.F
C Revision 1.9  91/07/06  20:07:38  khan
C Grenoble and after. Minor changes
C 
C Revision 1.8  91/04/05  15:06:04  cwelnak
C changed quotes on #includes
C 
C Revision 1.7  91/03/22  10:58:11  cwelnak
C SUN version -- INCLUDE to #include
C 
C Revision 1.6  91/02/14  11:54:56  cwelnak
C added PPOUT to calls to REFLEC.
C 
C Revision 1.5  90/11/13  14:01:59  khan
C Cleanup and SAVE statements
C 
C Revision 1.4  90/07/19  21:38:03  khan
C Put #ifdef's to make it work on BOTH VMS and Ultrix
C 
C Revision 1.3  90/07/14  22:51:19  khan
C All public include files (common.blk, etc) are now in ./../include/ dir.
C 
C Revision 1.2  90/07/14  12:14:57  khan
C Added Binary Flag to WRITE_OFF (default in VMS).
C 
C Revision 1.1  90/07/10  14:56:56  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE	SCREEN
C
C	PURPOSE		This s. computes the intersection of the ray 
C			with the screen plane. The format is the 
C			standard (12,N) matrix. The result is in the 
C			form of the (u,v) coordinates onto the screen 
C			plane. These are filed away and the input ray 
C			is NOT changed, unless the screen is a stop or 
C			a slit. In that the case the appropriate flag 
C			is set if the ray has been lost.
C
C	ARGUMENTS	[ I ]	RAY	The beam description as computed
C					by RESTART or MIRROR
C			[ I ]   I_WHAT  Selects a screen vs.a stop
C			[ I ]   I_ELEMENT OE number
C
C	OUTPUT		To disk. Generate a SCRxxyy.DAT file, xx being 
C			the screen number and yy the OE number.
C
C---
	SUBROUTINE 	SCREEN 	(RAY,AP_IN,PH_IN,I_WHAT,I_ELEMENT)
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#	include		<common.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
#endif

     	CHARACTER*12	LOCFILE
	CHARACTER*80	FILE_TMP
	DIMENSION 	RAY(12,N_DIM),OUT(12,N_DIM),PH_IN(3,N_DIM),
     $			PH_OUT(3,N_DIM),AP_IN(3,N_DIM),AP_OUT(3,N_DIM)
	DIMENSION 	V_OUT(3),P_IN(3),P_SCREEN(3),A_VEC(3),AP_VEC(3)
     	DIMENSION 	SCR_CEN(3),UX_SC(3),WY_SC(3),VZ_SC(3)
C
C Save some local large arrays to avoid overflowing stack.
C
	SAVE		OUT, PH_OUT, AP_OUT

     	WRITE(6,*)'Call to SCREEN'

     	IF (I_ABS(I_WHAT).EQ.1) THEN
     	  FTEMP	=  F_REFL
     	  F_REFL = 0
	  FILE_TMP = FILE_REFL
#ifdef HP_F77_BUGGY_NAMELIST
     	  FILE_REFL = FILABS(I_WHAT)
#else
     	  FILE_REFL = FILE_ABS(I_WHAT)
#endif
     	  CALL	REFLEC (DUM,DUM,DUM,DUM,DUM,DUM,DUM,DUM,
     $			THICK(I_WHAT),0)
     	END IF
** Set up the correct versors.
	KK = 0
	IF (I_SCREEN(I_WHAT).EQ.0)THEN
     		KK = 1
     		POLE =   SL_DIS(I_WHAT)
     	ELSE IF (I_SCREEN(I_WHAT).EQ.1) THEN
     		KK = 2
     		POLE = - SL_DIS(I_WHAT)
     	ELSE
     		CALL LEAVE ('SCREEN','Wrong values for screen position.',0)
     	END IF

     	DO  10 I=1,3
     	 UX_SC(I) =   UX_SCR(I,KK)
     	 WY_SC(I) =   WY_SCR(I,KK)
     	 VZ_SC(I) =   VZ_SCR(I,KK)
10     	CONTINUE

** Computes first the intercept onto the screen plane and the 
** absorption, if set.
     	ATTEN	=   1.0D0

     	DO 100	J=1,NPOINT

** Checks if the ray has been reflected by the mirror.

     	IF (RAY(10,J).LT.-1.0D6) GO TO 100

     	P_IN(1)	=   RAY(1,J)
     	P_IN(2)	=   RAY(2,J)
	P_IN(3)	=   RAY(3,J)

     	V_OUT(1)  =   RAY(4,J)
     	V_OUT(2)  =   RAY(5,J)
     	V_OUT(3)  =   RAY(6,J)

	A_VEC(1) = RAY(7,J)
	A_VEC(2) = RAY(8,J)
	A_VEC(3) = RAY(9,J)

	AP_VEC(1) = AP_IN(1,J)
	AP_VEC(2) = AP_IN(2,J)
	AP_VEC(3) = AP_IN(3,J)

     	ABOVE	=   POLE	   - P_IN(1)*WY_SC(1)
     $			    	   - P_IN(2)*WY_SC(2)
     $			    	   - P_IN(3)*WY_SC(3)

     	BELOW   =   WY_SC(1)*V_OUT(1) + WY_SC(2)*V_OUT(2) +
     $		    WY_SC(3)*V_OUT(3)

     	IF (BELOW.NE.0.0D0) THEN
     		DIST	=   ABOVE/BELOW
     	ELSE
     		RAY(10,J)  = - 1.0D4*I_ELEMENT - 1.0D2*I_WHAT
     		GO TO 100
     	END IF

** Computes now the intersections onto screen plane.

     	P_SCREEN(1)  =   P_IN(1) + DIST*V_OUT(1)
     	P_SCREEN(2)  =   P_IN(2) + DIST*V_OUT(2)
     	P_SCREEN(3)  =   P_IN(3) + DIST*V_OUT(3)

** Rotate now the results in the SCREEN reference plane.
** Computes the projection of P_IN onto the image plane versors.

     	CALL	SCALAR	(WY_SC,POLE,SCR_CEN)
     	CALL 	VECTOR 	(SCR_CEN,P_SCREEN,P_SCREEN)

     	CALL 	DOT 	(P_SCREEN,UX_SC,UX_1)
     	CALL 	DOT 	(P_SCREEN,VZ_SC,VZ_1)
     	CALL 	DOT 	(P_SCREEN,WY_SC,WY_1)

** Computes now the new directions for the beam in the U,V,N ref.

     	CALL 	DOT 	(V_OUT,UX_SC,VV_1)
     	CALL 	DOT 	(V_OUT,WY_SC,VV_2)
     	CALL 	DOT 	(V_OUT,VZ_SC,VV_3)

** Computes the new directions of A in the U,V,N ref.frame

     	CALL DOT (A_VEC,UX_SC,A_1)
     	CALL DOT (A_VEC,WY_SC,A_2)
     	CALL DOT (A_VEC,VZ_SC,A_3)

** This will compute the transmission coefficient.
     	IF (I_ABS(I_WHAT).EQ.1) THEN
     	 CALL	REFLEC (PPOUT,RAY(11,J),VV_2,DUM,DUM,DUM,DUM,
     $			 DUM,ATTEN,2)
     	END IF
** Saves the results
     	OUT(1,J)  =   UX_1
     	OUT(2,J)  =   WY_1
     	OUT(3,J)  =   VZ_1
     	OUT(4,J)  =   VV_1
     	OUT(5,J)  =   VV_2
     	OUT(6,J)  =   VV_3
     	RAY(7,J)  =   RAY(7,J)*ATTEN
     	OUT(7,J)  =   A_1*ATTEN
     	RAY(8,J)  =   RAY(8,J)*ATTEN
     	OUT(8,J)  =   A_2*ATTEN
     	RAY(9,J)  =   RAY(9,J)*ATTEN
     	OUT(9,J)  =   A_3*ATTEN
     	OUT(10,J) =   RAY(10,J)
     	OUT(11,J) =   RAY(11,J)
     	OUT(12,J) =   RAY(12,J)
	IF (NCOL.GT.12) THEN
	  PH_OUT (1,J) = PH_IN(1,J) + DIST
	  IF (NCOL.EQ.18) THEN
	    PH_OUT (2,J) = PH_IN(2,J)
	    PH_OUT (3,J) = PH_IN(3,J)
	    CALL	DOT	(AP_VEC,UX_SC,AP_1)
	    CALL	DOT	(AP_VEC,WY_SC,AP_2)
	    CALL	DOT	(AP_VEC,VZ_SC,AP_3)
	    AP_IN  (1,J) = AP_IN(1,J)*ATTEN
	    AP_OUT (1,J) = AP_1*ATTEN
	    AP_IN  (2,J) = AP_IN(2,J)*ATTEN
	    AP_OUT (2,J) = AP_2*ATTEN
	    AP_IN  (3,J) = AP_IN(3,J)*ATTEN
	    AP_OUT (3,J) = AP_3*ATTEN
	  END IF
	END IF
100	CONTINUE
     	IF (I_SLIT(I_WHAT).EQ.1)	THEN
     	 IF (K_SLIT(I_WHAT).EQ.0) THEN
     		U_1   = - RX_SLIT(I_WHAT)/2
     		U_2   =   RX_SLIT(I_WHAT)/2
     		V_1   = - RZ_SLIT(I_WHAT)/2
     		V_2   =   RZ_SLIT(I_WHAT)/2
	  IF (I_STOP(I_WHAT).EQ.0) THEN
     	  DO 200 ICHECK=1,NPOINT
     		TEST1 = (OUT(1,ICHECK) - U_1)*(U_2 - OUT(1,ICHECK))
     		TEST2 = (OUT(3,ICHECK) - V_1)*(V_2 - OUT(3,ICHECK))
C     		IF (I_STOP(I_WHAT).EQ.1) TEST1 = - TEST1
C     		IF (I_STOP(I_WHAT).EQ.1) TEST2 = - TEST2
     	    IF (TEST1.LT.0.0D0.OR.TEST2.LT.0.0D0) THEN
     		RAY (10,ICHECK)	  = - 1.0D2*I_ELEMENT - 1.0D0*I_WHAT
     		OUT (10,ICHECK)	  = - 1.0D2*I_ELEMENT - 1.0D0*I_WHAT
     	    END IF
200	  CONTINUE
	  ELSE IF (I_STOP(I_WHAT).EQ.1) THEN
     	  DO 222 ICHECK=1,NPOINT
		IF (OUT(1,ICHECK).GT.U_2.OR.OUT(1,ICHECK).LT.U_1) THEN
		  TEST1 = 1
		ELSE
		  TEST1 = -1
		END IF
		IF (OUT(3,ICHECK).GT.V_2.OR.OUT(3,ICHECK).LT.V_1) THEN
		  TEST2 = 1
		ELSE
		  TEST2 = -1
		END IF

     	    IF (TEST1.LT.0.0D0.AND.TEST2.LT.0.0D0) THEN
     		RAY (10,ICHECK)	  = - 1.0D2*I_ELEMENT - 1.0D0*I_WHAT
     		OUT (10,ICHECK)	  = - 1.0D2*I_ELEMENT - 1.0D0*I_WHAT
     	    END IF
222	  CONTINUE

	  END IF
     	 ELSE IF (K_SLIT(I_WHAT).EQ.1) THEN
     	  	AXLAR	=   RX_SLIT(I_WHAT)**2/4
     	  	AXSMA	=   RZ_SLIT(I_WHAT)**2/4
     	  DO 300 I=1,NPOINT
     	  	TEST	=   OUT(1,I)**2/AXLAR + OUT(3,I)**2/AXSMA 
     $						- 1.0D0
     		IF (I_STOP(I_WHAT).EQ.1)   TEST = - TEST
     	  	IF (TEST.GT.0.0D0) THEN
     		 RAY  (10,I) = - 1.0D2*I_ELEMENT - 1.0D0*I_WHAT
     		 OUT  (10,I) = - 1.0D2*I_ELEMENT - 1.0D0*I_WHAT
     		END IF
300	  CONTINUE
     	ELSE
     		CALL	FUNNY	(OUT)
     	END IF
     	ELSE
     	END IF
C
C EOF marker
C
     	KOUNTS	=   100*I_ELEMENT + I_WHAT
#ifdef vms
     	CALL	FNAME	(LOCFILE,'SCREEN',KOUNTS,4)
#else
     	CALL	FNAME	(LOCFILE,'screen',KOUNTS,4)
#endif
	IFLAG	= 0
     	CALL	WRITE_OFF (LOCFILE,OUT,PH_OUT,AP_OUT,NCOL,NPOINT,IFLAG,
     $                     0,IERR)
     	IF	(IERR.NE.0)	CALL LEAVE 
     $		('SCREEN','Error writing SCREEN.',IERR)
     	IF (I_ABS(I_WHAT).EQ.1) THEN
	    F_REFL	=   FTEMP
	    FILE_REFL 	=   FILE_TMP
	END IF
C Purge away some useless arrays
C%	MPURGE(1)	= %LOC(OUT(1,1))
C%	MPURGE(2)	= %LOC(OUT(12,N_DIM))
C%	CALL SYS$PURGWS	(MPURGE)
C%	MPURGE(1)	= %LOC(AP_OUT(1,1))
C%	MPURGE(2)	= %LOC(AP_OUT(3,N_DIM))
C%	CALL SYS$PURGWS	(MPURGE)
C%	MPURGE(1)	= %LOC(PH_OUT(1,1))
C%	MPURGE(2)	= %LOC(PH_OUT(3,N_DIM))
C%	CALL SYS$PURGWS	(MPURGE)
	WRITE(6,*)'Exit from SCREEN'
	RETURN
	END
