C +++
C
C Source: src/trace/mirror.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: mirror.F
C Revision 1.17  1992/12/17  22:43:02  cwelnak
C *** empty log message ***
C
C Revision 1.16  92/09/22  14:23:43  cwelnak
C facet calculations -- G.J. Chen
C 
C Revision 1.15  92/08/26  20:30:13  sanchez
C Roughness changes. Laue crystals model
C 
C Revision 1.14  1992/08/26  14:02:50  cwelnak
C latest 6000 changes.
C
C Revision 1.13  1991/08/28  09:36:40  cwelnak
C added IPSFLAG to surface roughness
C
C Revision 1.12  91/07/06  20:07:29  khan
C Mirror roughness model by Singh
C 
C Revision 1.11  91/04/05  15:05:52  cwelnak
C changed quotes on #includes
C 
C Revision 1.10  91/03/22  10:35:28  cwelnak
C SUN version -- INCLUDE to #include
C 
C Revision 1.9  91/03/15  15:37:49  khan
C Getting ready for Sun port...
C 
C Revision 1.8  91/02/21  14:47:58  khan
C vc
C Wrapper for Random number generator.
C 
C Revision 1.7  91/02/14  11:37:08  khan
C Latest VMS version (and a new bug...)
C 
C Revision 1.6  90/11/17  12:39:41  khan
C the DISP='SAVE' in CLOSE(20) was creating annoying messages in  Tthe
C Ultrix version. Now only for VMS.
C 
C Revision 1.5  90/11/13  14:01:51  khan
C Cleanup and SAVE statements
C 
C Revision 1.4  90/07/19  21:37:53  khan
C Put #ifdef's to make it work on BOTH VMS and Ultrix
C 
C Revision 1.3  90/07/14  22:51:12  khan
C All public include files (common.blk, etc) are now in ./../include/ dir.
C 
C Revision 1.2  90/07/14  12:10:07  khan
C Fixed arguments to WRITE_OFF (added the binary write flag, default in VMS).
C Also all files opened with STATUS=UNKNOWN.
C 
C Revision 1.1  90/07/10  14:56:33  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE	MIRROR
C
C	PURPOSE 	To compute the intersection and the reflected 
C			beam on the mirror surface.The results are 
C			tranferred back to the main program.
C
C	ALGORITHM	Several, depending on the function.
C
C	INPUT		a) RAY, i.e., beam array
C			b) data from MSETUP, through the common
C
C	OUTPUT		a) RAY
C			b) MIRRxx, where xx is the OE number
C			c) RMIRRxx, if the mirror has been moved.
C			d) PHASExx, phase of the rays
C---
	Subroutine 	MIRROR1 (RAY,AP,PHASE,I_WHICH)

#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c	INCLUDE         './../include/warning.blk'
c
c
#include		<common.blk>
#include		<warning.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
     	INCLUDE		'SHADOW$INC:WARNING.BLK/LIST'
#endif


     	REAL * 8	K_PAR(3)

	DIMENSION 	RAY(12,N_DIM),RAY_CALL(7),PHASE(3,N_DIM)
     	DIMENSION	CODLING(12,N_DIM),AP(3,N_DIM)
	DIMENSION 	VVIN(3),PPOUT(3),VTEMP(3),VNOR(3)
	DIMENSION	VNORG(3),VVOUT(3)
     	DIMENSION	P_TRUE(3),P_NORM(3),P_START(3),P_TEMP(3)
     	DIMENSION	GSCATTER(3),Q_IN(3),Q_OUT(3)
     	DIMENSION	AS_VEC(3),AS_TEMP(3),S_VEC(3)
	DIMENSION	AP_VEC(3),AP_TEMP(3)
      	DIMENSION	DIS1(3),DIS2(3),HYPER(3),HYPER1(3),VTAN(3)
     	DIMENSION	VHOLO1(3),VHOLO2(3),STEMP(3)
	REAL*8		RH_DENS
	INTEGER*4	I_BASELINE,ISEGA,IPRO
	DIMENSION	PF_CENT(3),PF_NOR(3),PF_TAU(3)
	DIMENSION	PF_START(3),PF_VIN(3),PF_BNOR(3)
	DIMENSION	PF_OUT(3),PFNORMAL(3)
	DIMENSION	ANGLE(4,N_DIM)
	INTEGER		SURFERR

C
C Save some local large arrays to avoid overflowing stack.
C
	SAVE		CODLING, ANGLE


	IF (F_KOMA.NE.1) THEN
     	  WRITE(6,*) 'Call to MIRROR'
	ENDIF

C
	IF (F_KOMA.EQ.1.AND.F_DOT.EQ.1) THEN
	  GOTO 5009
	ENDIF
C
	PI3HALF	=   3.0D0*PIHALF
	XFIRST 	=   RWIDX2
	XSECON 	=   RWIDX1
	YFIRST 	=   RLEN2	! source side
	YSECON 	=   RLEN1	! image  side

     	X_C_P   =   COD_LEN/2   ! codling slit
     	X_C_M   = - COD_LEN/2
     	Z_C_P	=   COD_WID/2
     	Z_C_M   = - COD_WID/2

C
C      The counting integers for the roughness calculation
C
 
        KROUGH_COUNT  = 0
        KROUGH_COUNT2 = 0

     	K_1	=   0
     	K_2	=   0
     	K_3	=   0
     	K_4	=   0
     	K_5	=   0
	K_6	=   0

C
C  Initialize variables that are used later (assumed to be initialized).
C
	G_MOD = 0.0
	G_FAC = 0.0
C
C  JOHANSSON SETUP 
C
        IF (F_JOHANSSON.EQ.1) THEN
                 A_BRAGG_OLD = A_BRAGG
                 ORDER_OLD   = ORDER
                 G_FAC       =   1.0D0
        END IF
C
C
C
     	IF (F_GRATING.EQ.1.OR.F_BRAGG_A.EQ.1) THEN
	  IF (F_RULING.EQ.0.OR.F_RULING.EQ.1) THEN
     		G_MOD	=   TWOPI*RULING*ORDER
		G_FAC	=   1.0D0
     	  ELSE IF (F_RULING.EQ.2) THEN
     		DO 199 I=1,3
     		 DIS1(I) = HOLO1(I)
     		 DIS2(I) = HOLO2(I)
 199		CONTINUE
     		CALL  CROSS (HOLO1,Z_VERS,VHOLO1)
     		CALL  CROSS (HOLO2,Z_VERS,VHOLO2)
     		CALL  NORM (VHOLO1,VHOLO1)
     		CALL  NORM (VHOLO2,VHOLO2)
	  ELSE
	  END IF
     	END IF
     	  EFF_REF 	= 0.0D0
     	  EFF_REF_S 	= 0.0D0
     	  EFF_REF_P	= 0.0D0
     	IF (F_REFLEC.NE.0.AND.F_CRYSTAL.EQ.0)  THEN
     	  CALL REFLEC 
     $		(PPOUT,0.0D0,0.0D0,0.0D0,R_P,R_S,PHASEP,PHASES,ABSOR,0)
D
D	  OPEN	(27,FILE='REPHASE',STATUS='NEW')	
D
     	END IF
C
C If no reflectivity options are selected for crystal case, full polarization
C dependence is assumed.
C
     	IF (F_CRYSTAL.EQ.1.AND.F_REFLEC.EQ.0)  F_REFLEC = 1
	
C We rotate now the 'source' as specified by the mirror rotations.

     	IF (F_MOVE.EQ.1) CALL ROT_FOR (RAY,AP)
D
D
D	OPEN (23,FILE='RULING',STATUS='NEW')

C
C Return to Kumakhov if initializing, entrance point for subsequent
C calls to MIRROR by KUMAKHOV
C
	IF (F_KOMA.EQ.1) THEN
	   RETURN
	ENDIF
5009    CONTINUE
C
C Start the loop through the beam
C
	DO 1099 ITIK=1,NPOINT
C
C Counts the "good" and "bad" rays
C
     	IF (RAY(10,ITIK).LT.0.0D0)	K_1 = K_1 + 1
     	IF (RAY(10,ITIK).GE.0.0D0)	K_2 = K_2 + 1
* Check if the ray is acceptable
	IF (RAY(10,ITIK).LT.-1.0D6) 	GO TO 10000
C
     	P_START(1)  =   RAY(1,ITIK)
     	P_START(2)  =   RAY(2,ITIK)
     	P_START(3)  =   RAY(3,ITIK)
	 VVIN(1)	 =   RAY(4,ITIK)
	 VVIN(2)  =   RAY(5,ITIK)
	 VVIN(3)  =   RAY(6,ITIK)
     	  AS_VEC(1) =   RAY(7,ITIK)
     	  AS_VEC(2) =   RAY(8,ITIK)
     	  AS_VEC(3) =   RAY(9,ITIK)
	   AP_VEC(1) =   AP(1,ITIK)
	   AP_VEC(2) =   AP(2,ITIK)
	   AP_VEC(3) =   AP(3,ITIK)
C
C  Check if it is segment mirror case
C
        if(F_SEGMENT.EQ.1) then
        
         if(itik.eq.1) then
           call segment_calc(vvin,p_start,itik,ppout,vnor,isega,tpar)
           ierr = isega
           IF    (ierr.NE.1) CALL LEAVE ('Mirror','Error ',IERR)
         endif
 
         ipro = 5 
         goto 717
        endif

C
C solve for intercepts
C
	IFLAG	= 1
     	CALL	INTERCEPT (P_START, VVIN, TPAR, IFLAG)
C
C tests for return
C
     	IF (IFLAG.GE.0) THEN
	  PPOUT(1) = P_START(1) + VVIN(1)*TPAR
	  PPOUT(2) = P_START(2) + VVIN(2)*TPAR
	  PPOUT(3) = P_START(3) + VVIN(3)*TPAR
     	ELSE
     	 DO 299 I_DEL=1,11
 299       RAY (I_DEL,ITIK) = 0.0D0
     	 RAY (10, ITIK) = -1.1D6*I_WHICH
	 I_KOMA = -1
     	 GO TO 10000
     	END IF
C
C Intercepts completed; proceed
C
C tests if surface errors are defined
C
     	IF (F_RIPPLE.EQ.1) THEN
C
C The case of a rippled surface is solved by successive approximations
C Due to the small amplitudes involved, few iterations are enough.
C
C THE subroutine SURFACE has been modified to take another parameter. It
C is now called with SURFERR as well. If a SURFERR of -9 is passed back 
C from the SURFACE, the ray is tagged as lost.  This is because the -9 
C error indicates that the intersection of the ray with the mirror 
C could not be calculated correctly. That can occur at the mirror periphery 
C when the mirror contour is specified as a spline error surface generated 
C by the utility PRESURFACE and results in errant rays which appear to be
C reflected from the base mirror figure (e.g. plane), *not* the error 
C surface specified.

     	DO 300 I=1,3
     	   CALL  SURFACE 	(PPOUT,P_TRUE,VTEMP,SURFERR)
	   IF (SURFERR.EQ.-9) THEN
C	   	WRITE(6,*)'SURFERR = ',SURFERR
		RAY(10,ITIK) = -9
	   ENDIF
C
C Evaluate now the intersection of the incoming beam with a plane 
C tangent to the TRUE surface in P_TRUE.
C
     	   CALL  DOT   		( VTEMP, VVIN, T_1)
     	   CALL  VECTOR 	( P_START, P_TRUE, P_TEMP)
     	   CALL  DOT		( P_TEMP, VTEMP, T_2)
C
     	   TPAR	 = T_2/T_1
C
     	   STEMP(1)	=   P_START(1) + TPAR*VVIN(1)	! 1st approx
     	   STEMP(2)	=   P_START(2) + TPAR*VVIN(2)	!
     	   STEMP(3)	=   P_START(3) + TPAR*VVIN(3)	!
C
C Computes ideal surface position above former approximation
C
     	  IF (I.NE.3) THEN
	    IFLAG	= -1
     	    CALL	INTERCEPT ( STEMP, Z_VRS, T_2, IFLAG)
     	    PPOUT(1)  =   STEMP(1)
     	    PPOUT(2)  =   STEMP(2)
     	    PPOUT(3)  =   STEMP(3) + T_2			
     	  END IF
300	   CONTINUE
     	  PPOUT(1) = STEMP(1)
     	   PPOUT(2) = STEMP(2)
     	    PPOUT(3) = STEMP(3)
     	  VNOR(1)  = VTEMP(1)
     	   VNOR(2)  = VTEMP(2)
     	    VNOR(3)  = VTEMP(3)
     	  CALL NORM	(VNOR, VNOR)
     	ELSE
C
C Computes the normal for the ideal surface. The normal (gradient) is 
C defined as 'outward' for a concave surface, in our case it will be 
C directed aloneg -Z (down). The formulae we need use however a normal
C along the +Z direction. So:
C
C               from   NORMAL           set to:
C              /            \
C           concave        convex       result (always)
C
C            -Z             +Z            +Z
C
C                                         -Z   for a refractor
C
	  CALL NORMAL (PPOUT,VNOR)
     	  CALL NORM	(VNOR, VNOR)
C
C Then the following test will insure that the normal is always UPWARD
C
     	  IF (F_CONVEX.EQ.0)  CALL SCALAR (VNOR,-1.0D0,VNOR)
     	END IF
C
C COMPUTES THE PHASE
C
	IF (F_KOMA.EQ.1) THEN
	  CALL DOT(VVIN,VNOR,TEMP)
	  IF (TEMP.GT.0.0D0) THEN
	    CALL SCALAR(VNOR,-1.0D0,VNOR)
	  ENDIF
	ENDIF

	IF (F_FACET.NE.1.AND.F_KOMA.NE.1.AND.F_SEGMENT.NE.1) THEN
     	PHASE (1,ITIK) = PHASE(1,ITIK) + TPAR*R_IND_OBJ
	ELSE IF (F_KOMA.EQ.1) THEN
	  IF (VVIN(3).EQ.0.0) THEN
	    DO 995 I_DEL=1,11
	      RAY(I_DEL,ITIK) = 0.0D0
995	    CONTINUE
	    RAY (10,ITIK) = -1.1D6*I_WHICH
	    I_KOMA = -1
	    GOTO 10000
	  ELSE
	    TEMPKO = -1.0*PPOUT(3)

	    IF (TEMPKO.GE.ZKO_LENGTH) THEN
	       KOXX = 1
	       GOTO 10000
	    ELSE
	       PHASE(1,ITIK) = PHASE(1,ITIK) + TPAR*R_IND_OBJ
	    ENDIF
	  ENDIF
C	ELSE

	END IF

C
C Project the incoming ray VVIN onto the normal; 
C
     	IF (F_REFRAC.NE.0)  CALL SCALAR (VNOR,-1.0D0,VNOR)
	CALL PROJ (VVIN,VNOR,VTEMP)
C
C Stores intercepts:
C
	RAY(1,ITIK) 	= PPOUT(1)
	RAY(2,ITIK) 	= PPOUT(2)
	RAY(3,ITIK) 	= PPOUT(3)
C
C  in the case of surface roughnes, check if the ray
C  will be specularly reflected or will be scattered
C  because of the surface roughness. In the last
C  case set the new flag F_SCATTER_ROUGH=1
C
	if (f_roughness.eq.1) then
c
c  calculate the roughness rms along the direction of the ray
c
	 call vector(vtemp,vvin,k_par)
	 call norm  (k_par,k_par)
	 if (abs(k_par(1)).lt.1d-37.and.abs(k_par(2)).lt.1d-37) 
     $    then                                          !normal incidence
	 rough_rms = dsqrt(rough_x**2+rough_y**2)/sqrt(2.0)
	 else
C
C	 rough_rms = dsqrt((k_par(i)*rough_x)**2
C     $               +(k_par(2)*rough_y)**2)
C
C I believe the k_par(i) in the above equation should be k_par(1).
C It is causing lots o' damage on the HP.
C clw. 6 jan 1995.
C
	 rough_rms = dsqrt((k_par(1)*rough_x)**2
     $               +(k_par(2)*rough_y)**2)
	 endif
c
c  calculate SIGMAPHA, which gives the weighting factor
c  between specularly reflected and scattered light
c
	 call dot(vvin,vnor,sin_val)      ! sine (grazing angle)
	sigmapha = 4*rough_rms*sin_val/(twopi*1.0d8/ray(11,itik))
	sigmapha = sigmapha**2
c	sigmapha = 1-exp(-1*(2*rough_rms*sin_val*(ray(11,itik)/1.0d8))**2)
	 if (wran(ISTAR1).gt.sigmapha) then
	  f_scatter_rough = 0                ! specular reflection
	 else 
	  f_scatter_rough = 1                ! scattered light
	 endif
	endif
C
     	IF (F_REFRAC.EQ.0) THEN
C
C Reflection Case; 
C
	  RAY(4,ITIK) 	= VVIN(1) - 2*VTEMP(1)
	  RAY(5,ITIK) 	= VVIN(2) - 2*VTEMP(2)
	  RAY(6,ITIK) 	= VVIN(3) - 2*VTEMP(3)
     	ELSE
C
C Refraction case; the normal is NOT inverted as it is defined as 
C 'outward' from the surface.
C
C
C If the k-number is not specified, assume a default of 10000 cm-1.
C
	  if (f_crystal.ne.1) then        !skip this part when laue crystals
	  IF (RAY(11,ITIK).NE.0.0D0) THEN
	    Q_IN_MOD	=   RAY(11,ITIK)
	  ELSE
	    Q_IN_MOD	=   10000
	  END IF
     	  CALL SCALAR	(VVIN,Q_IN_MOD,Q_IN)
     	  CALL PROJ	(Q_IN,VNOR,VTEMP)
     	  CALL VECTOR 	(VTEMP,Q_IN,K_PAR)
	  CALL DOT	(VTEMP,VTEMP,Q1_PER)
	  CALL DOT 	(K_PAR,K_PAR,Q_PAR)
	  Q2_PER	= ALFA**2*Q1_PER + (ALFA**2-1)*Q_PAR
	  CALL SCALAR	(VTEMP,SQRT(Q2_PER/Q1_PER),VTEMP)
	  CALL SUM	(VTEMP,K_PAR,Q_OUT)
	  CALL DOT	(Q_OUT,Q_OUT,TTEMP)
	  CALL NORM	(Q_OUT,VTEMP)
 	  IF (RAY(11,ITIK).NE.0.0D0)  RAY(11,ITIK)  =   SQRT (TTEMP)
     	  RAY(4,ITIK)	=   VTEMP(1)
     	  RAY(5,ITIK)	=   VTEMP(2)
     	  RAY(6,ITIK)	=   VTEMP(3)
     	END IF
	  endif
C
C Check if the intercept is within the mirror limits. If not, the
C ray will be assumed to be lost forever and not used again in any
C calculation.
C
     	IF (FHIT_C.EQ.1) THEN
     	 IF (FSHAPE.EQ.1) THEN
	  TESTX 	= (PPOUT(1) - XFIRST)*(XSECON - PPOUT(1))
	  TESTY 	= (PPOUT(2) - YFIRST)*(YSECON - PPOUT(2))
     	 ELSE 	IF (FSHAPE.EQ.2) THEN
     	  TESTX	= PPOUT(1)**2/RWIDX2**2 + PPOUT(2)**2/RLEN2**2 
     $			- 1.0D0
     	  TESTX	= - TESTX
     	  TESTY	= TESTX
     	 ELSE 	IF (FSHAPE.EQ.3) THEN
     	  TESTX	= PPOUT(1)**2/RWIDX2**2 + PPOUT(2)**2/RLEN2**2 
     $			- 1.0D0
     	  TESTX = - TESTX
     	  TESTY	= PPOUT(1)**2/RWIDX1**2 + PPOUT(2)**2/RLEN1**2 
     $			- 1.0D0
     	 END IF
     	ELSE
     	 TESTX	= 1.0D0
     	 TESTY	= 1.0D0
     	END IF

	IF (TESTX.LT.(0.0).OR.TESTY.LT.(0.0)) THEN
	 RAY (10,ITIK)	= - 1.1D4*I_WHICH ! Beam out of the mirror limits.
	END IF
C
C mosaic crystal calculation
C
        IF (F_MOSAIC.EQ.1) THEN
         WAVEN  =   RAY(11,ITIK)
		 if (f_refrac.eq.0) then                     !bragg
           CALL MOSAIC (VVIN,VNOR,WAVEN,VNORG)
		 else if (f_refrac.eq.1) then                !laue
		   call rotvector (vnor,x_vrs,pihalf,vtemp)
		   call mosaic (vvin,vtemp,waven,vnorg)
		 endif
         CALL PROJ (VVIN,VNORG,VTEMP)
	 DO 399 I=1,3
 399	  VVOUT(I) = VVIN(I) - 2*VTEMP(I)
          RAY(4,ITIK)  = VVOUT(1)
           RAY(5,ITIK)  = VVOUT(2)
            RAY(6,ITIK)  = VVOUT(3)
        END IF

C
C This is the loop that handles the facets case
	IF (F_FACET.EQ.1) THEN
C
C Find the index of the facet
C We use double precision to IDNINT to find the nearest integer
C Find the index of the facet
C

	IFAC_X  = IDNINT(PPOUT(1)/RFAC_LENX)
	IFAC_Y  = IDNINT(PPOUT(2)/RFAC_LENY)
	PF_CENT(1)= IFAC_X*RFAC_LENX
	PF_CENT(2)= IFAC_Y*RFAC_LENY

C
C Determine the center coordinate of the facet
C and the new coordinate system
C
	PF_CENT(3)=0.0D0

C
C Seperate the Torudial baselin case from
C the other baseline
C

	IF (FMIRR.EQ.3) THEN
	 IF (F_TORUS.EQ.0) THEN
	    Z_VRS(3)=-1.0D0
            IFLAG=1
C
C  note: here we have to reset F_TORUS = 3 in order to
C  find the proper distance from the z=0 plane to the
C  baseline mirror. i.e. At F_TORUS = 0 we calculate
C  the farthest distance while at F_TORUS = 3 we get
C  the closest distance.
C
	    FRUS = F_TORUS
	    F_TORUS = 3
	    CALL INTERCEPT (PF_CENT,Z_VRS,TPAR,IFLAG)
	      F_TORUS=FRUS
	      Z_VRS(3)=1.0D0
          IF (IFLAG.NE.0) THEN
C 6/5/93
C g.j.
C
         DO 295 I_DEL=1,11
 295       RAY (I_DEL,ITIK) = 0.0D0
         RAY (10, ITIK) = -1.1D6*I_WHICH
         goto 10000
         ENDIF

	 ELSE
	      CALL LEAVE
     $ ('FACET','This part has not been considered yet',0)
         END IF
C
C For the base line other than Tordial baseline
C
	ELSE
	  IFLAG=-1
C
C Set the IFLAG = -1 for the closest intercepted length
C

	      CALL INTERCEPT (PF_CENT,Z_VRS,TPAR,IFLAG)
	      IF (IFLAG.NE.0) THEN
C 6/5/93
C g.j.
C
         DO 297 I_DEL=1,11
 297       RAY (I_DEL,ITIK) = 0.0D0
         RAY (10, ITIK) = -1.1D6*I_WHICH
         goto 10000
         ENDIF

        ENDIF
	    PF_CENT(3) = TPAR


C Define the normal vector for the facet mirror
C
	      CALL    NORMAL (PF_CENT,PF_NOR)
	      IF (F_CONVEX.EQ.0) CALL SCALAR (PF_NOR,-1.0D0,PF_NOR) 
	      CALL    NORM   (PF_NOR,PF_NOR)
C
C Define binormal and tangential vectors
C
              PF_BNOR(2)=0.0D0
	      IF (PF_NOR(3).EQ.0) CALL LEAVE
     $               ('FACET','N_z should not be zero',0)
	    IF (PF_NOR(1).NE.0.) THEN
	       PF_BNOR(1)=PF_NOR(3)
	       PF_BNOR(3)=-1.*PF_NOR(1)
	    ELSE
	       PF_BNOR(1)=1.
	       PF_BNOR(3)=0.
	    ENDIF
	    CALL NORM(PF_BNOR,PF_BNOR)
	       CALL CROSS (PF_NOR,PF_BNOR,PF_TAU)
	       CALL NORM (PF_TAU,PF_TAU)

C
C Local refence frame has been set
C
C Rotate and translate the incident ray to the
C new coordinate system
C
C The PF_START will be the new coordinate for the ray and
C the PF_VIN the new direction.
C

	CALL    FA_ROT (P_START,PF_START,PF_CENT,PF_BNOR,PF_TAU,PF_NOR)
	CALL    FA_ROT (VVIN,PF_VIN,ORIGIN,PF_BNOR,PF_TAU,PF_NOR)

C
C Find the intercept point of the facet surface
C

	I_BASELINE=FMIRR
	FMIRR=9
	IFLAG=1
	      CALL    SPOLY  (PF_START,PF_VIN,TPAR,IFLAG)
	      IF (IFLAG.EQ.-1) THEN
	        FMIRR=I_BASELINE
C 6/5/93
C g.j.
C
              DO 293 I_DEL=1,11
 293          RAY (I_DEL,ITIK) = 0.0D0
              RAY (10, ITIK) = -1.1D6*I_WHICH
              goto 10000
	      ENDIF

	PHASE (1,ITIK) = PHASE(1,ITIK) + TPAR*R_IND_OBJ

	PF_OUT(1)=PF_START(1) + PF_VIN(1) * TPAR
	PF_OUT(2)=PF_START(2) + PF_VIN(2) * TPAR
	PF_OUT(3)=PF_START(3) + PF_VIN(3) * TPAR

C
C Find the normal vector on the intercepted point
C

	CALL    NORMAL (PF_OUT,PFNORMAL)
	CALL    NORM   (PFNORMAL,PFNORMAL)

C
C Rotate and translate the normal vector and the intercepted
C point back to the baseline frame system
C
          IF (F_ANGLE.EQ.1) THEN
            CALL DOT(PF_VIN, PFNORMAL, TEMP)
            CALL DOT(PF_OUT, PFNORMAL, TEMP1)
            ANGLE_IN = DACOSD(TEMP)
            ANGLE_OUT = DACOSD(TEMP1)
          END IF

	CALL    FA_ROTBACK (PF_OUT,PPOUT,PF_CENT,PF_BNOR,PF_TAU,PF_NOR)
	CALL    FA_ROTBACK (PFNORMAL,VNOR,ORIGIN,PF_BNOR,PF_TAU,PF_NOR)

	CALL    PROJ (VVIN,VNOR,VTEMP)

        RAY(1,ITIK) = PPOUT(1)
	RAY(2,ITIK) = PPOUT(2)
	RAY(3,ITIK) = PPOUT(3)
	RAY(4,ITIK) = VVIN(1) - 2.0D0*VTEMP(1)
	RAY(5,ITIK) = VVIN(2) - 2.0D0*VTEMP(2)
	RAY(6,ITIK) = VVIN(3) - 2.0D0*VTEMP(3)

	FMIRR = I_BASELINE

	ENDIF    ! END OF FACET IF

C
C End of the facet calculation
C

C
C begin of the segment mirror operation
C       G.J. 4/19/93
C
 
717     continue
 
        IF (F_SEGMENT.EQ.1)  then
        
C isega flag of the segment calculation
C
        isega = 0
 
         call segment_calc(vvin,p_start,ipro,ppout,vnor,isega,tpar)
 
 
        if(isega.ne.1)  then
         DO 296 I_DEL=1,11
296       RAY (I_DEL,ITIK) = 0.0D0
         RAY (10, ITIK) = -1.1D6*I_WHICH
        goto 10000
        endif
 
          IF (F_ANGLE.EQ.1) THEN
 
            VVOUT(1) = VVIN(1) - 2.0D0*VTEMP(1)
            VVOUT(2) = VVIN(2) - 2.0D0*VTEMP(2)
            VVOUT(3) = VVIN(3) - 2.0D0*VTEMP(3)
 
          END IF
 
        PHASE (1,ITIK) = PHASE(1,ITIK) + TPAR*R_IND_OBJ
        CALL    PROJ (VVIN,VNOR,VTEMP)
 
        RAY(1,ITIK) = PPOUT(1)
        RAY(2,ITIK) = PPOUT(2)
        RAY(3,ITIK) = PPOUT(3)
        RAY(4,ITIK) = VVIN(1) - 2.0D0*VTEMP(1)
        RAY(5,ITIK) = VVIN(2) - 2.0D0*VTEMP(2)
        RAY(6,ITIK) = VVIN(3) - 2.0D0*VTEMP(3)
 
        endif
C
C end of segment calculation
C


     	  IF (F_GRATING.EQ.1.OR.F_BRAGG_A.EQ.1.OR.
     $			F_SCATTER_ROUGH.EQ.1) THEN
C Grating case. Computes the diffracted beam **
C Scattering vector. First we bring the normal upward, as this will be
C useful. This is not done for a convex grating.
C
C     	IF (F_CONVEX.EQ.0)	CALL SCALAR (VNOR,-1.0D0,VNOR)
C
C Gscatter, the G vector used for scattering the ray, will be then
C tangent to the surface. However, the ruling density will change if 
C the ruling is uniform in the X-Y plane. This is the first case.
C The second case is probably unrealistic, as it refers to a constant
C ruling density on the grating surface. This could correspond to the
C case of a bent plane grating.
C The third is the case of an holographic grating.
C These differences are taken care by the term G_FAC. It modifies the
C surface line density at the intercept point by computing the angle
C between the tangent plane and the basal plane at that point along Y.
C This is correct indipendent of the grating figure since the angle is
C obtained from the NORMAL (VNOR) and the Y versor (Y_VRS).
C
C The grating calculation is also used for asymmetrically cut 
C crystals in the conventional mode (f_ruling=1) or in the 
C Johansson mounting (f_ruling=5). If surface roughness is consider
C the program uses the grating model to calculate the diffarction
C with a stochastic diffracting vector
C
     	IF (F_RULING.EQ.0) THEN
     		CALL	CROSS	(VNOR,X_VRS,VTAN)
     		CALL	NORM	(VTAN,VTAN)
     		CALL	DOT	(VNOR,Y_VRS,G_FAC)
     		G_FAC	=   SQRT (1.0D0 - G_FAC**2)
     		G_MODR	=   G_MOD*G_FAC
C
C This is the first implementation of the phase shift (m*N*lamda) due to 
C grating diffraction, as it is the simplest one.
C
		IF (ORDER.NE.0.AND.RAY(11,ITIK).NE.0)
     $PHASE(1,ITIK)	= PHASE(1,ITIK) + PPOUT(2)*G_MOD/RAY(11,ITIK)
	ELSE IF (F_RULING.EQ.1) THEN
     		CALL	CROSS	(VNOR,X_VRS,VTAN)
     		CALL	NORM	(VTAN,VTAN)
     		G_MODR	=   G_MOD
	ELSE IF (F_RULING.EQ.5) THEN
     		CALL	CROSS	(VNOR,X_VRS,VTAN)
     		CALL	NORM	(VTAN,VTAN)
C
C The case of the Johansson crystal is implemented by computing a local
C surface line density on the basis of the d_spacing and of the local asymmetry
C angle.
C
	  IF (F_JOHANSSON.EQ.1) THEN
*
* arc fom origin to intercept point on the YZ plane
*
	        IF (FMIRR.EQ.1) THEN                        !Spherical case
 	         ARC = RMIRR * ASIN (PPOUT(2)/RMIRR)
	        ELSE IF (FMIRR.EQ.5) THEN                   !Plane case
	         ARC = SQRT (PPOUT(2)**2 + PPOUT(3)**2)
	         IF (PPOUT(2).LT.0) ARC=-ARC
* Add the toroidal case 94/11/23 * New part!!!! */
C Written by MSR, added CLW 19 dec 1994.
                ELSE IF (FMIRR.EQ.3) THEN                   !Torus case
                 ARC = (R_MAJ + R_MIN) * ASIN (PPOUT(2)/RMIRR)
 

	        ELSE                                        !No more cases now
	         CALL LEAVE('Error in MIRROR',
     $'Johansson surface not implemented yet.Try spherical or plane',0)
		END IF
*
* local planes cut angle
*
	        A_BRAGG = ARC/R_JOHANSSON + A_BRAGG_OLD
	        IF (A_BRAGG.LT.0) ORDER = -1
	        IF (A_BRAGG.GE.0) ORDER = +1
	        RDENS   = ABS(SIN(A_BRAGG)/D_SPACING)
	        G_MODR  = RDENS*TWOPI*ORDER
	  ELSE
C
C Compute now the adjustment to the surface line density at the point
C of intercept
C
     		CALL	DOT	(VNOR,Y_VRS,G_FAC)
     		G_FAC	=   SQRT (1.0D0 - G_FAC**2)
C
C Computes distance of intercept projection on basal plane from
C origin.
C
     		TTEMP	=   PPOUT(3)/VVIN(3)
		DIST	=   PPOUT(2) + VVIN(2)*TTEMP
C
C Test for sign flag
C
     		IF (F_RUL_ABS.EQ.0) DIST = ABS(DIST)
		RDENS	=   RULING + RUL_A1*DIST + RUL_A2*DIST**2
     $				+ RUL_A3*DIST**3 + RUL_A4*DIST**4
		G_MODR	=   RDENS*TWOPI*ORDER*G_FAC
	  END IF
     	ELSE IF (F_RULING.EQ.2) THEN
C
C computes normal to laser wavefronts at intercept
C
     	 IF (F_PW.EQ.0) THEN		! Both spherical sources
     	  IF (F_PW_C.EQ.0) THEN
     		CALL	VECTOR	(HOLO1,PPOUT,DIS1)
     		CALL	VECTOR	(HOLO2,PPOUT,DIS2)
     	  ELSE IF (F_PW_C.EQ.1) THEN
     		CALL	VECTOR  (HOLO2,PPOUT,DIS2)
     		CALL	VDIST	(PPOUT,HOLO1,VHOLO1,DIS1)
     	  ELSE IF (F_PW_C.EQ.2) THEN
     		CALL	VECTOR	(HOLO1,PPOUT,DIS1)
     		CALL	VDIST	(PPOUT,HOLO2,VHOLO2,DIS2)
     	  ELSE IF (F_PW_C.EQ.3) THEN
     		CALL	VDIST	(PPOUT,HOLO1,VHOLO1,DIS1)
     		CALL	VDIST	(PPOUT,HOLO2,VHOLO2,DIS2)
     	  END IF
     		CALL	NORM	(DIS1,DIS1)
     		CALL	NORM	(DIS2,DIS2)
     	 ELSE IF (F_PW.EQ.1) THEN	! plane/spherical
     	  IF (F_PW_C.EQ.2.OR.F_PW_C.EQ.3) THEN
     		CALL	VDIST	(PPOUT,HOLO2,VHOLO2,DIS2)
     	  ELSE
     		CALL	VECTOR	(HOLO2,PPOUT,DIS2)
     	  END IF
     		CALL	NORM	(DIS2,DIS2)
     	 ELSE IF (F_PW.EQ.2) THEN	! spherical/plane
     	  IF (F_PW_C.EQ.1.OR.F_PW_C.EQ.3) THEN
     		CALL	VDIST	(PPOUT,HOLO1,VHOLO1,DIS1)
     	  ELSE
     		CALL	VECTOR	(HOLO1,PPOUT,DIS1)
     	  END IF
     		CALL	NORM	(DIS1,DIS1)
     	 ELSE IF (F_PW.EQ.3) THEN	! plane/plane
** Nothing to do. DIS1,DIS2 are already defined.
     	 ELSE
     	 END IF
C
C Take in account REAL/ VIRTUAL recording sources
C
     	IF (F_VIRTUAL.EQ.1) THEN
     	  CALL	SCALAR (DIS2,-1.0D0,DIS2)
     	ELSE IF (F_VIRTUAL.EQ.2) THEN
     	  CALL	SCALAR (DIS1,-1.0D0,DIS1)
     	ELSE IF (F_VIRTUAL.EQ.3) THEN
     	  CALL	SCALAR (DIS2,-1.0D0,DIS2)
     	  CALL	SCALAR (DIS1,-1.0D0,DIS1)
     	END IF
     		CALL	VECTOR	(DIS2,DIS1,HYPER)
     		CALL	NORM	(HYPER,HYPER)
** HYPER is the normal to the hyperboloid in PPOUT.
     		CALL	CROSS	(HYPER,VNOR,VTEMP)
     		CALL	NORM	(VTEMP,VTEMP)
     		CALL	CROSS	(VNOR,VTEMP,VTAN)
     		CALL	NORM	(VTAN,VTAN)
** VTAN is now a vector tangent to the grating surface and orthogonal
** to the groove. We compute now the ruling density at that point.
     		CALL	VECTOR	(DIS2,DIS1,HYPER1)
     		CALL	DOT	(VTAN,HYPER1,ADJUST)
     		RULING	=   ADJUST*1.0D8/HOLO_W
     		G_MODR	=   ORDER*TWOPI*RULING
D	WRITE (23,*)    'ray = ',itik
D	WRITE (23,*)	PPOUT
D	WRITE (23,*)	VTAN
D	WRITE (23,*)	RULING
** Check now  the direction of VTAN. If it is not pointing toward +y,
** it is reversed. This to get out of the problem of the convexity of
** the grooves.
     	 IF (VTAN(2).LT.0.0D0.AND.FZP.EQ.0) THEN
     	   CALL SCALAR (VTAN,-1.0D0,VTAN)
     	 END IF
	ELSE IF (F_RULING.EQ.3) THEN
	  SPACING = SQRT((DIST_FAN-PPOUT(2))**2+PPOUT(1)**2)/RULING
	  SPACING = SPACING/DIST_FAN
	  ARG	  = PPOUT(1) /(DIST_FAN-PPOUT(2))
	  PHI_XY  = ATAN (ARG)
	  VTAN(3) = 0.0D0
	  VTAN(1) = COS(PHI_XY)
	  VTAN(2) = SIN(PHI_XY)
C
C COMA_FAC  is the coma correction factor
C
	  SPACING = SPACING*(1+PHI_XY**2*COMA_FAC)
	  G_MODR = TWOPI/SPACING*ORDER
	END IF
	    CALL	SCALAR	(VTAN,G_MODR,GSCATTER)
D	WRITE (23,*)	GSCATTER
	if (f_scatter_rough.eq.1) then
	krough_count = krough_count + 1
C
C       if the surface roughness is selected calculate the scattering
C       vector due to the roughness, and this vector is added to
C       the scattering vector if we are working with gratings
C       or is used alone if we work with mirrors
C
C
C	Modifications to MIRROR to include effects of uncorrelated roughness.
C	A random scattering vector of length and direction specified in
C	a power spectral density file is used. VERSION FOR A PLANE MIRROR.
C
		IPSFLAG = 1
		IERR = 0
		CALL PSPECT (X1,X2,ISTAR1,IERR,IPSFLAG)
		IF (IERR.NE.0) CALL LEAVE 
     $		('MIRROR', 'Error on return from PSPECT', 0)
	IF (WRAN(ISTAR1).LT.0.5D0) X1 = -X1
	IF (WRAN(ISTAR1).LT.0.5D0) X2 = -X2
 	RH_DENS = SQRT (X1**2 + X2**2)
	ORDER = 1.0
	IF (WRAN(ISTAR1).LE.0.5D0) ORDER = -1.0
	G_MODR = RH_DENS * ORDER
C
C	Now to build GSCATTER.  It must be in the tangent plane.
C	Remember that VTAN and GSCATTER are parallel.
C
	VTAN(1) = X1/RH_DENS
	VTAN(2) = X2/RH_DENS
	VTAN(3) = 0.0D0
C	VNOR = Z_VRS
C	CALL CROSS (VTAN,VNOR,BNOR)
C 	CALL NORM (BNOR,BNOR)
C
C	Check to see that VTAN is not zero.
C
	CALL DOT (VTAN,VTAN,TEST)
	IF (ABS(TEST).LE.1.0D-10) CALL LEAVE 
     $('MIRROR',
     $'Impossible condition 1 in MIRROR during VTAN calculation',0)
c
c now build the GSCATTER vector
c
	CALL SCALAR	(VTAN,G_MODR,stemp)
	if (f_grating.eq.1.or.f_bragg_a.eq.1) then
	 call sum (gscatter,stemp,gscatter)
	else 
	 gscatter(1) = stemp(1)
	  gscatter(2) = stemp(2)
	   gscatter(3) = stemp(3)
	endif
C
	endif
** 2. Projects the incoming vector on the scattering plane
		IF (RAY(11,ITIK).NE.0.0D0) THEN
     		  Q_IN_MOD	=   RAY(11,ITIK)
		ELSE
		  IF (ORDER.EQ.0) THEN		! Arbitrarily assume k=10000cm-1
		    Q_IN_MOD	=   10000	! for zeroth order.
		  ELSE
		    WRITE(6,*) 'Warning! Photon energy of incoming ',
     $'ray is not defined. No diffractions computed.'
		    GO TO 10000
		  END IF
		END IF
     		CALL SCALAR	(VVIN,Q_IN_MOD,Q_IN)
     		CALL PROJ	(Q_IN,VNOR,VTEMP)
     		CALL VECTOR 	(VTEMP,Q_IN,K_PAR)
	        if (f_refrac.eq.1) then                           !laue xtals
	        if (abs(a_bragg-pihalf).lt.1d-15) then            !laue symm
				call rotvector (vnor,x_vrs,-a_bragg,stemp)
	            call proj (vvin,stemp,vtemp)
	            q_out(1) 	= VVIN(1) - 2*vtemp(1)
	            q_out(2) 	= VVIN(2) - 2*vtemp(2)
	            q_out(3) 	= VVIN(3) - 2*vtemp(3)
				goto 8989
	          endif
c			call sum	(vtemp,gscatter,q_out) 
c     		else if (f_refrac.ne.1) then
	        endif
			  CALL SUM	(K_PAR,GSCATTER,Q_OUT)
     		CALL DOT	(Q_OUT,Q_OUT,Q_OUT_MOD)
     		VALUE  =   Q_IN_MOD**2 - Q_OUT_MOD
     		  IF (VALUE.LT.0.0D0) THEN
			IF (f_scatter_rough.eq.1) THEN
			    GOTO 450
			ELSE
			    RAY(10,ITIK)	= - 1.010101D6
			    GO TO 10000
			ENDIF
     		  ELSE
     		VALUE  =   DSQRT( VALUE )
     		CALL SCALAR	(VNOR,VALUE,VTEMP)
     		CALL SUM	(VTEMP,Q_OUT,Q_OUT)
     		CALL NORM	(Q_OUT,Q_OUT)
                krough_count2 = krough_count2 + 1
C
C If it is Kumakhov case the value would not make sense
C

8989	    continue
     		RAY(4,ITIK) =   Q_OUT(1)
     		RAY(5,ITIK) =   Q_OUT(2)
     		RAY(6,ITIK) =   Q_OUT(3)
     		  END IF
** Resets VNOR to initial value.
C     	IF (F_CONVEX.EQ.0)	CALL SCALAR (VNOR,-1.0D0,VNOR)
     	  ELSE
     	  END IF
450    	IF (FMIRR.EQ.6)	THEN		! Codling slit case

     		T_SLIT	= - P_START(2)/VVIN(2)
     		X_SLIT	=   P_START(1) + VVIN(1)*T_SLIT
     		Z_SLIT	=   P_START(3) + VVIN(3)*T_SLIT

     		TEST_X  =   (X_C_P - X_SLIT)*(X_SLIT - X_C_M)
     		TEST_Z  =   (Z_C_P - Z_SLIT)*(Z_SLIT - Z_C_M)

     		CODLING(1,ITIK)	=   X_SLIT
     		CODLING(2,ITIK) =    .0D0
     		CODLING(3,ITIK) =   Z_SLIT
     		CODLING(4,ITIK) =    .0D0
     		CODLING(5,ITIK) =    .0D0
     		CODLING(6,ITIK) =    .0D0
	        CODLING(12,ITIK)=   RAY(12,ITIK)

     		IF (TEST_X.LT.0.0D0.OR.TEST_Z.LT.0.0D0)  THEN
     			RAY(10,ITIK) = - 1.1D+4*I_WHICH
     			CODLING(10,ITIK) = - 1.1D+4*I_WHICH
     		ELSE
     			CODLING(10,ITIK) =   RAY(10,ITIK)
     		END IF
     	ELSE
     	END IF	

* First we bring the normal upwards
C
C     	IF (F_CONVEX.EQ.0)	CALL SCALAR (VNOR,-1.0D0,VNOR)
C
* Reflectivity
* Check for reflectivity. If this mode is "on", we have to compute
* some angles, namely the sine of the incidence angle and the sine
* of the A vector with the normal. Also, the polarized light is 
* treated as a superposition of two orthogonal A vectors with the appropriate
* phase relation. These two incoming vectors have to be resolved into the
* local S- and P- component with a new phase relation.
* A_VEC will be rotated later, once the amplitude will have been determined.
     	CALL	CROSS 	(VVIN,VNOR,AS_TEMP)	! vector pp. to inc.pl.
     	IF (M_FLAG.EQ.1) THEN
	CALL	DOT	(AS_VEC,AS_VEC,AS2)
	CALL	DOT	(AP_VEC,AP_VEC,AP2)
	IF (AS2.NE.0)	THEN
     	 DO 499 I=1,3
 499   	   AS_TEMP(I) = AS_VEC(I)
	ELSE
	 DO 599 I=1,3
 599	   AS_TEMP(I) = AP_VEC(I)
	END IF
     	END IF
     	CALL	NORM  	(AS_TEMP,AS_TEMP)	! Local unit As vector
	CALL	CROSS	(AS_TEMP,VVIN,AP_TEMP)
	CALL	NORM	(AP_TEMP,AP_TEMP)	! Local unit Ap vector
	CALL	DOT	(AS_VEC,AS_TEMP,A11)	! matrix element of rotation
	CALL	DOT	(AP_VEC,AS_TEMP,A12)	! matrix element of rotation
	CALL	DOT	(AS_VEC,AP_TEMP,A21)	! matrix element of rotation
	CALL	DOT	(AP_VEC,AP_TEMP,A22)	! matrix element of rotation
	PHS	= PHASE(2,ITIK)
	PHP	= PHASE(3,ITIK)
** Now recompute the ampltitude and phase of the local S- and P- component.
	AS_NEW	= SQRT(ABS(A11**2 + A12**2 + 2.0D0*A11*A12*COS(PHS-PHP)))
	AP_NEW	= SQRT(ABS(A21**2 + A22**2 + 2.0D0*A21*A22*COS(PHS-PHP)))
	CALL	SCALAR	(AS_TEMP,AS_NEW,AS_VEC)	! Local As vector
	CALL	SCALAR	(AP_TEMP,AP_NEW,AP_VEC)	! Local Ap vector
	PHTS	= A11*SIN(PHS) + A12*SIN(PHP)
	PHBS	= A11*COS(PHS) + A12*COS(PHP)
	PHTP	= A21*SIN(PHS) + A22*SIN(PHP)
	PHBP	= A21*COS(PHS) + A22*COS(PHP)
	CALL	ATAN_2	(PHTS,PHBS,PHS)		! Phase of local As vector
	CALL	ATAN_2	(PHTP,PHBP,PHP)		! Phase of local Ap vector
C
C
     	CALL	DOT	(VVIN,VNOR,SIN_VAL)	! sin(graz. ang)
     	CALL	DOT	(Q_OUT,VNOR,SIN_REF)	! sin(graz.ref.ang)
C
C MLAYER thicknesses may be scaled to the angle from the pole.
C
	IF (F_THICK.EQ.1) THEN
	  CALL	DOT	(VNOR,Z_VRS,COS_POLE)	! cos(ang. of normal from pole)
	ELSE
	  COS_POLE	= 1.0D0
	END IF
     	SIN_VAL	=   ABS(SIN_VAL)
	COS_POLE =	ABS(COS_POLE)
* Computes now the reflectivity
     	WAVEN	=   RAY(11,ITIK)
     	IF (F_REFLEC.NE.0) THEN
	  IF (F_CRYSTAL.EQ.1) THEN
C
C Bragg case
C
* rotation of surface normal an angle A_BRAGG around the axis X 
* for having the normal to Bragg planes in asymmetrical case, then
* calculation of the angle between this normal and incident ray
*
	IF (F_BRAGG_A.EQ.1.or.f_refrac.eq.1) THEN  !bragg asymm or any laue
	 CALL ROTVECTOR (VNOR,X_VRS,A_BRAGG,VTEMP)
	 CALL DOT  (VVIN,VTEMP,SIN_BRG)
	 SIN_BRG = ABS(SIN_BRG)
	ELSE                                       !bragg sym
	 SIN_BRG = SIN_VAL
	 SIN_REF = SIN_VAL
	END IF
     	  CALL	CRYSTAL	(WAVEN, SIN_VAL, SIN_REF, SIN_BRG, REF_S, REF_P,
     $ PHASES, PHASEP, DEPTH_MFP_S, DEPTH_MFP_P, DELTA_REF, THETA_B,1)
	  ELSE
C
C "normal" mirror
C
	   CALL	REFLEC 	(PPOUT,WAVEN,SIN_VAL,COS_POLE,
     $			REF_P,REF_S,PHASEP,PHASES,ABSOR,1)
	  END IF
C
C       Mosaic crystal corrections in
C       penetration depth and, consequently, phase shift
C
	  IF (F_MOSAIC.EQ.1) THEN
	    IF (F_FACET.EQ.1) THEN
	      CALL LEAVE ('MIRROR',
     $		'CONFLICT BETWEEN MOSAIC AND FACET',0)
	    ENDIF
	   CALL  DOT (AS_VEC,AS_VEC,AS_MOD)
	   CALL  DOT (AP_VEC,AP_VEC,AP_MOD)
	   A_DEG = AS_MOD/(AS_MOD+AP_MOD)
	   A_RND = WRAN (MOSAIC_SEED)
	   IF (A_RND.LE.A_DEG) THEN
	    DEPTH_MFP = DEPTH_MFP_S
	   ELSE IF (A_RND.GT.A_DEG) THEN
	    DEPTH_MFP = DEPTH_MFP_P
	   END IF
	   IF (DEPTH_MFP.GT.1.0D-10) THEN
	    ARG = THICKNESS/DEPTH_MFP/SIN_VAL
	   ELSE
	    ARG = 0
	   END IF
	   CALL MFP(0.0D0,MOSAIC_SEED,-2)
	   CALL MFP(ARG,MOSAIC_SEED,-1)
	   CALL MFP(DEPTH_INC,MOSAIC_SEED,0)
	   DEPTH_INC = DEPTH_INC*DEPTH_MFP
	   DO 699 I=1,3
 699	    VTEMP(I) = PPOUT(I) + DEPTH_INC*VVIN(I)
	   CALL INTERCEPT (VTEMP,VVOUT,DEPTH_REF,IFLAG)
	   DO 799 I=1,3
 799	    RAY(I,ITIK) = VTEMP(I) + DEPTH_REF*VVOUT(I)
	   PHASE (1,ITIK) = PHASE (1,ITIK) +
     $        (DEPTH_INC+DEPTH_REF)*(1.0D0-DELTA_REF)
	  END IF
*
*  Reset Johansson asymmetrical parameters to its original value
*
	  IF (F_JOHANSSON.EQ.1) THEN
	   A_BRAGG = A_BRAGG_OLD
	   ORDER   = ORDER_OLD
	  END IF
D	  ANG_INC	= ACOSD(SIN_VAL)
D	  WREFS		= REF_S
D	  WREFP		= REF_P
D	  WPS		= PHASES
D	  WPP		= PHASEP
D	  WRITE	(27,*)	ANG_INC,WREFS,WREFP,WPS,WPP
     	 IF (F_REFLEC.EQ.1) THEN 			! Full polarization case
     	   CALL	SCALAR	(AS_VEC,REF_S,AS_VEC)
     	   CALL	SCALAR  (AP_VEC,REF_P,AP_VEC)
	   PHP	= PHP + PHASEP
	   PHS	= PHS + PHASES
     	   EFF_REF_S = EFF_REF_S + REF_S**2
           EFF_REF_P = EFF_REF_P + REF_P**2
     	 ELSE IF (F_REFLEC.EQ.2) THEN			! No interested in it
	   REF		= (REF_S**2 + REF_P**2)/2
     	   EFF_REF 	= EFF_REF + REF
	   REF		= SQRT(REF)
	   CALL	SCALAR	(AP_VEC,REF,AP_VEC)
     	   CALL	SCALAR	(AS_VEC,REF,AS_VEC)
     	 END IF
      	END IF
C
C Rotate the A vector so that its sign is no longer imbedded in the phase angle.
C
	IF ((COS(PHS)).LT.0.0D0) THEN
	  PHS	= PHS - PI
	  CALL	SCALAR	(AS_VEC,-1.0D0,AS_VEC)
	END IF
	IF ((COS(PHP)).LT.0.0D0) THEN
	  PHP	= PHP - PI
	  CALL	SCALAR	(AP_VEC,-1.0D0,AP_VEC)
	END IF

** So far we have the new amplitude of the two components. We have now
** to 'reflect' A_VEC onto the mirror. For this, notice that the s-comp
** is geometrically unchanged, while the p-comp is changed. The angles
** are exchanged with respect to VVIN. Things are more complicated in
** the case of a grating, due to the vectorial nature of the diffraction,
** not treated here. We make the simplifying assumption that the
** diffraction will not change the degree of polarization. This mean that
** A_VEC will have the same components referred to the ray as before the
** diffraction. 

     	 VVOUT(1)	=   RAY(4,ITIK)
     	 VVOUT(2)	=   RAY(5,ITIK)
     	 VVOUT(3)	=   RAY(6,ITIK)
D	WRITE	(24,*)	ITIK
D	WRITE	(24,*)	VNOR
D	WRITE	(24,*)	VTEMP
D	WRITE	(24,*)	A_VEC
D	WRITE	(24,*)	A_S
D	WRITE	(24,*)	A_P
C 
C The following IF block applies only to the GRATING case.
C The binormal is redefined in terms of the diffraction
C plane.
C
     	IF (F_GRATING.NE.0.OR.F_BRAGG_A.EQ.1) THEN
	  CALL	PROJ	(VVOUT,VNOR,VTEMP)
	  CALL	SCALAR	(VTEMP,-2.0D0,VTEMP)
	  CALL	SUM	(VTEMP,VVOUT,VTEMP)
	  CALL	CROSS	(VTEMP,VNOR,AS_TEMP)
     	 IF (M_FLAG.EQ.1) THEN
	   CALL	DOT	(AS_VEC,AS_VEC,AS2)
	   CALL	DOT	(AP_VEC,AP_VEC,AP2)
	  IF (AS2.NE.0)	THEN
     	    DO 899 I=1,3
 899          AS_TEMP(I) = AS_VEC(I)
	  ELSE
	   DO 999 I=1,3
 999	     AS_TEMP(I) = AP_TEMP(I)
     	  END IF
	 END IF
     	  CALL	NORM  	(AS_TEMP,AS_TEMP)	! Local unit As vector
	  CALL	CROSS	(AS_TEMP,VTEMP,AP_TEMP)
	  CALL	NORM	(AP_TEMP,AP_TEMP)	! Local unit Ap vector
     	  CALL	DOT	(AS_VEC,AS_VEC,RES)
     	  RES	=    SQRT (RES)
     	  CALL	SCALAR	(AS_TEMP,RES,AS_VEC)
	  CALL	DOT	(AP_VEC,AP_VEC,RES)
	  RES	=    SQRT (RES)
	  CALL	SCALAR	(AP_TEMP,RES,AP_VEC)
     	END IF
     	CALL	PROJ	(AP_VEC,VNOR,VTEMP)
	CALL	VECTOR	(VTEMP,AP_VEC,VTEMP)
     	CALL	SCALAR	(VTEMP,-2.0D0,VTEMP)
     	CALL	SUM	(AP_VEC,VTEMP,AP_VEC)
D	WRITE	(24,*)	A_P
D	WRITE	(24,*)	VNOR
C
C If full polarization is not selected, then only the As vector will be written
C onto disk.  To have the As carry the correct magnitude, we must sum As and Ap.
C
	IF (NCOL.NE.18)	THEN
	  CALL	SUM	(AS_VEC,AP_VEC,AS_VEC)
	ELSE
	  AP  (1,ITIK)	=   AP_VEC(1)
	  AP  (2,ITIK)	=   AP_VEC(2)
	  AP  (3,ITIK)	=   AP_VEC(3)
	END IF
C
     	RAY (7,ITIK)	=   AS_VEC(1)
     	RAY (8,ITIK)	=   AS_VEC(2)
     	RAY (9,ITIK)	=   AS_VEC(3)

	PHASE(2,ITIK)	=   PHS
	PHASE(3,ITIK)	=   PHP



10000	CONTINUE

	IF (F_KOMA.NE.1) THEN
	IF (F_ANGLE.EQ.1) THEN
C
C Save index, incidence and reflection angles for all rays.
C
	IF (F_FACET.NE.1) THEN		! already set them in facet
	  CALL DOT (VVIN,VNOR,SIN_IN)
	  CALL DOT (VVOUT,VNOR,SIN_OUT)

  	  ANGLE_IN = TODEG*ACOS (SIN_IN)
	  ANGLE_OUT = TODEG*ACOS (SIN_OUT)
	ENDIF

	  ANGLE(1,ITIK) = ITIK
	  ANGLE(2,ITIK) = 180 - ANGLE_IN
	  ANGLE(3,ITIK) = ANGLE_OUT
	  ANGLE(4,ITIK) = RAY(10,ITIK)

	ENDIF
	ENDIF

C
C Counts lost rays in this OE
C
C Good rays
     	IF (RAY(10,ITIK).GE.0.0D0)	K_3 = K_3 + 1
C Lost rays
     	IF (RAY(10,ITIK).LT.0.0D0)	K_4 = K_4 + 1
C Hard lost
	IF (RAY(10,ITIK).LT.-1.0D6)	K_6 = K_6 + 1

 1099	CONTINUE
C
C Kumakhov case skips the file writing ...
C
	IF (F_KOMA.NE.1) THEN
C
C* Store the results for later examination or processing *
C* Insert also an 'end of file' marker for external processor *
C
     	IF ((FWRITE.EQ.0).OR.(FWRITE.EQ.1)) THEN
#ifdef	vms
     	  CALL	FNAME	(FFILE, 'MIRR', I_WHICH, 2)
#else
     	  CALL	FNAME	(FFILE, 'mirr', I_WHICH, 2)
#endif
	  IFLAG	= 0
     	  CALL	WRITE_OFF	(FFILE,RAY,PHASE,AP,NCOL,NPOINT,IFLAG,
     $ 0,IERR)
     	  IF	(IERR.NE.0) CALL LEAVE 
     $			('MIRROR','Error writing MIRR',IERR)
     	END IF
D
D	IF (F_REFL.EQ.2)	CLOSE(27)
D
C
C If codling slit, write out
C
     	IF (FMIRR.EQ.6) THEN
#ifdef vms
     	  CALL	FNAME	(FFILE, 'CODL', I_WHICH, 2)
#else
     	  CALL	FNAME	(FFILE, 'codl', I_WHICH, 2)
#endif
	  IFLAG	= 0
     	  CALL	WRITE_OFF (FFILE,CODLING,PHASE,AP,NCOL,NPOINT,IFLAG,
     $ 0, IERR)
     	  IF	(IERR.NE.0) CALL LEAVE
     $		 ('MIRROR','Error writing CODLING',IERR)
     	END IF
C
C Evaluates now the mirror efficiencies; two figures of merit are given, the
C geometrical efficiency (i.e., reflectivity = 1) and the reflectivity. The
C overall f.m. is the product of the two.
C
C
C Total of rays lost out of the mirror
C
     	K_5	=   K_4 - K_1
	K_6	=   NPOINT - K_6

     	IF (K_2.NE.0) THEN
     	EFF_GEOM  =  FLOAT(K_3)/FLOAT(K_2)
     	ELSE
     	END IF
     	IF (F_REFLEC.EQ.1) THEN
     	  ABS_REF_S 	=  (EFF_REF_S/K_6)
     	  ABS_REF_P 	=  (EFF_REF_P/K_6)
     	  ABS_REF	=  (ABS_REF_S + ABS_REF_P)/2
     	  OVERALL	=  ABS_REF*EFF_GEOM
     	ELSE IF (F_REFLEC.EQ.2) THEN
     	  ABS_REF	=  (EFF_REF/K_6)
     	  OVERALL	=  ABS_REF*EFF_GEOM
     	END IF
#if vms
     	CALL	FNAME	(FFILE, 'EFFIC', I_WHICH, 2)
	OPEN (UNIT=20,FILE=FFILE,STATUS='NEW',CARRIAGECONTROL='LIST')
#elif unix
     	CALL	FNAME	(FFILE, 'effic', I_WHICH, 2)
	OPEN (UNIT=20,FILE=FFILE,STATUS='UNKNOWN')
	REWIND (20)
#endif
     	IF (K_2.EQ.0)	WRITE (20,3000)
	WRITE (20,2000) NPOINT,K_2,K_5,I_WHICH,EFF_GEOM
     	IF (F_REFLEC.EQ.1) THEN
     	  WRITE (20,2010) ABS_REF_S,ABS_REF_P,ABS_REF
     	ELSE IF (F_REFLEC.EQ.2) THEN
     	  WRITE (20,2020) ABS_REF
     	END IF
        IF (F_ROUGHNESS.EQ.1) THEN
           WRITE(20,2040) krough_count2,krough_count
        END IF
     	IF (F_REFLEC.NE.0) WRITE (20,2030) OVERALL
#if vms
	CLOSE (20,DISP='SAVE')
#elif unix
	CLOSE (20)
#endif

3000	FORMAT (1X,'WATCH OUT !! NO GOOD RAYS IN INPUT !!')
2000	FORMAT (1X,'Of a total of ',I6,' rays, of which ',I6,' formed ',
     $ 'the input set ',/,1X,I6,' were out of the mirror N. ',I4,/,1X,
     $ 'The mirror collects ',G12.5,' of the incoming flux.')
2010	FORMAT (1X,'The average reflectivities are :',/,
     $		1X,'S-pol ',20X,G12.5,/,
     $		1X,'P-pol ',20X,G12.5,/,
     $		1x,'Total ',20X,G12.5)
2020	FORMAT (1X,'The average reflectivity is :',G12.5)
2030	FORMAT (1X,'The overall efficiency of the mirror is :',G12.5)
2040    FORMAT (1X,'There were',I6,'rays scattered out of the elastic',
     $        ' peak',1X,/,'and',I6,
     $	      ' rays were decided to be scattered',
     $        ' by the rho**2 factor')

	IF (F_ANGLE.EQ.1) THEN
C write incidence and reflection information to file
 
        CALL FNAME (FFILE, 'angle', I_WHICH, 2)
#if vms
        OPEN (UNIT=55,FILE=FFILE,STATUS='NEW',CARRIAGECONTROL='LIST')
#elif unix
        OPEN (UNIT=55,FILE=FFILE,STATUS='UNKNOWN')
        REWIND (55)
#endif
 
        DO 2525 J = 1,NPOINT
2525      WRITE(55,*) ANGLE(1,J),ANGLE(2,J),ANGLE(3,J),ANGLE(4,J)
        CLOSE(55)
	
	END IF


     	IF ((FWRITE.EQ.0).OR.(FWRITE.EQ.1)) THEN
#ifdef vms
     	  CALL	FNAME	(FFILE, 'RMIR', I_WHICH, 2)
#else
     	  CALL	FNAME	(FFILE, 'rmir', I_WHICH, 2)
#endif
     	 IF (F_MOVE.EQ.1)   THEN
     	   CALL ROT_BACK (RAY,AP)
	   IFLAG	= 0
     	   CALL	WRITE_OFF	(FFILE,RAY,PHASE,AP,NCOL,NPOINT,IFLAG,
     $ 0,IERR)
     	  IF (IERR.NE.0) CALL LEAVE ('MIRROR','Error writing RMIR',IERR)
     	 END IF
     	END IF
     	WRITE(6,*) 'Exit from MIRROR'
D	CLOSE (23)

#if vms
	MPURGE(1)	= %LOC(CODLING(1,1))
	MPURGE(2)	= %LOC(CODLING(12,N_DIM))
	CALL	SYS$PURGWS	(MPURGE)
#endif
	ENDIF

	END
