#ifdef decstation
#include <cursesX.h>
#else
#include <curses.h>
#endif
#include <stdio.h>

#if !NO_FORT_UNDERSCORE
# define F77_NAME(f) f##_
#else
# define F77_NAME(f) f
#endif

/*
 * G77 (GNU FORTRAN, upto and including v.0.5.18) adds a SECOND underscore
 * to names that already contain an underscore. Annoying as well, and
 * hence the G77_HACK_NAME(f) hack.
 */

#define G77_HACK_NAME(f) f##__

#if defined(_AIX) || defined(rs6000) || defined(hppa) || defined(__hpux)
# define SYSV_DELETE 1
#endif

#if SYSV_DELETE
# define DELETE		03612
# define BACKSPACE	03507
#elif __CYGWIN32__
# define DELETE		0512
# define BACKSPACE	010
#else
# define DELETE		0177
# define BACKSPACE	'\b'
#endif

#if G77
# define CURSES_PUT_NL		G77_HACK_NAME(curses_put_nl)
# define CURSES_PUT_CHARS	G77_HACK_NAME(curses_put_chars)
# define CURSES_READ		G77_HACK_NAME(curses_read)
# define CURSES_RETURN		G77_HACK_NAME(curses_return)
# define CURSES_PROMPT		G77_HACK_NAME(curses_prompt)
# define CURSES_INIT		G77_HACK_NAME(curses_init)
# define CURSES_ERASE_PAGE	G77_HACK_NAME(curses_erase_page)
# define CURSES_ERASE_LINE	G77_HACK_NAME(curses_erase_line)
# define CURSES_SET_CURSOR	G77_HACK_NAME(curses_set_cursor)
# define CURSES_PUT_SCREEN	G77_HACK_NAME(curses_put_screen)
# define CURSES_PUT_BUFFER	G77_HACK_NAME(curses_put_buffer)
# define CURSES_EXIT_SUBROUTINE	G77_HACK_NAME(curses_exit_subroutine)
# define CURSES_SCROLLOK	G77_HACK_NAME(curses_scrollok)
# define CURSES_YESNO		G77_HACK_NAME(curses_yesno)
# define CURSES_SUSPEND		G77_HACK_NAME(curses_suspend)
# define CURSES_RESTART		G77_HACK_NAME(curses_restart)
#else
# define CURSES_PUT_NL		F77_NAME(curses_put_nl)
# define CURSES_PUT_CHARS	F77_NAME(curses_put_chars)
# define CURSES_READ		F77_NAME(curses_read)
# define CURSES_RETURN		F77_NAME(curses_return)
# define CURSES_PROMPT		F77_NAME(curses_prompt)
# define CURSES_INIT		F77_NAME(curses_init)
# define CURSES_ERASE_PAGE	F77_NAME(curses_erase_page)
# define CURSES_ERASE_LINE	F77_NAME(curses_erase_line)
# define CURSES_SET_CURSOR	F77_NAME(curses_set_cursor)
# define CURSES_PUT_SCREEN	F77_NAME(curses_put_screen)
# define CURSES_PUT_BUFFER	F77_NAME(curses_put_buffer)
# define CURSES_EXIT_SUBROUTINE	F77_NAME(curses_exit_subroutine)
# define CURSES_SCROLLOK	F77_NAME(curses_scrollok)
# define CURSES_YESNO		F77_NAME(curses_yesno)
# define CURSES_SUSPEND		F77_NAME(curses_suspend)
# define CURSES_RESTART		F77_NAME(curses_restart)
#endif

#define PRINTABLE		F77_NAME(printable)
#define CONTROLC		F77_NAME(controlc)

/*
 * This is to make sure we can trap ^C under linux+g77 combo. Has the
 * unfortunate side-effect that it also traps other useful signals like
 * ^Z etc. C'est la vie. CURSES_USE_RAW_MODE is defined via Makefile.
 */
#if CURSES_USE_RAW_MODE
# define nocbreak noraw
# define cbreak raw
#endif

static char buf[BUFSIZ];

#define CNTRL(ch)	((ch) ^ 0100)


void CURSES_PUT_NL () {
    addch ('\n');
    refresh ();
}

void CURSES_PUT_CHARS (string, len)
char *string;
unsigned long len;
{
    strncpy (buf, string, len);
    buf[len] = '\0';

    addstr (buf);
    refresh ();
}


/*
 *
 *	subroutine tt_read (string,lstring,code)
 *
 *  Call SMG$ routine to read user input from terminal
 *    with non-default handling of terminators
 *
 *  Recognizes as special cases the following:
 *	escape sequences of arrow keys (VT100 and VT52)
 *	Tab / Backspace / GT Sign / LT Sign / Question Mark
 *
 *  string	- output/string
 *		  data read from terminal
 *		  length determines maximum data read
 *  lstring	- output/integer
 *		  number of bytes of data (excluding terminators)
 *  code		- output/integer
 *		  way read was terminated
 *		    0 => cr/lf/ff/ and other non-printing character
 *		    1 => up arrow or backspace
 *		    2 => right arrow or '>'
 *	 	    3 => down arrow or tab
 *		    4 => left arrow or '<' or control/z
 *		    5 => control/c  or control/y
 *		    6 => control/w
 *
 *  Note: bit mask of characters that terminate read
 *	bs=10	tab=11	'<'=74	'>'=76  cntl/w=27  cntl/z=32	(octal)
 *	    8        9  60      62	  23		26      (decimal)
 */

void CURSES_READ (string, lstring, code, len)
char *string;
int *lstring;
int *code;
unsigned long len;
{
    /* the last element is always the CNTRL('C')! */
    static int stop_char[] = {
	'\n', '\r', '\t', BACKSPACE, '>', '<', 
	KEY_LEFT, KEY_UP, KEY_RIGHT, KEY_DOWN,
	CNTRL('P'), CNTRL('N'),
	CNTRL('W'), CNTRL('D'), CNTRL('C')
    };
    static int stop_code[] = {
	0, 0, 3, 1, 2, 4, 
	4, 1, 2, 3,
	1, 3,
	6, 4, 5
    };

    extern void CONTROLC();
    int ctrlc = 0;
    int startrow, startcol;
    int row, col;

    int skip;

    int ncodes = sizeof(stop_char)/sizeof(stop_char[0]);
    int codefound = 0;
    int index = 0;
    int ch = 0;
    int nread = 0;
    buf[nread] = '\0';

    getyx (stdscr, startrow, startcol);

    refresh ();
    for (codefound = 0, skip = 0;;codefound = 0, skip = 0) {
	ch = getch();
	CONTROLC(&ctrlc);
	if (ctrlc == 1) {
	    index = ncodes-1;
#ifdef DEBUG
	    fprintf (stderr, "CONTROL C received\n");
#endif
	    break;
	}
	if (ch == DELETE || ch == BACKSPACE) {
	    if (nread) {
		--nread;
		getyx (stdscr, row, col);
		move (row, col-1);
		delch();
		refresh();
#ifdef DEBUG
		fprintf (stderr, "Deleting last character typed\n");
#endif
	    }
	    skip = 1;
	} 
	else if (ch == CNTRL('U')) { /* kill the line up to first point*/
	    move (startrow, startcol);
	    clrtoeol();
	    refresh();
	    nread = 0;
	    skip = 1;
	}
	else {
	    skip = 0;
	}

	if (skip)
	    continue;

	for (index = 0; index < ncodes; index++) {
	    if (ch == stop_char[index]) {
		codefound = 1;
		break;
	    }
	}
	if (codefound) {
#ifdef DEBUG
	    fprintf (stderr, "Code found %d (%c)\n", ch, ch);
#endif
	    break;
	}
	else {
	    buf[nread++] = ch;
	    addch (ch);
	    refresh();
#ifdef DEBUG
	    fprintf (stderr, "Read character %c (%d)\n", ch, ch);
#endif
	}
    }

    if (nread > len) {
#ifdef DEBUG
	fprintf (stderr, "BUFFER overflow in curses_read!\n");
#endif
	nread = len;
    }
    *code = stop_code[index];
    *lstring = nread;
    strncpy (string, buf, nread);
}


/*
 *	subroutine tt_return (string,lstring,code)
 *
 *  Call SMG$ routine to wait for user to type carriage return
 *    with non-default handling of terminators
 *
 *  Recognizes as special cases the following:
 *	escape sequences of arrow keys (VT100 and VT52)
 *	Tab / Backspace / GT Sign / LT Sign / Question Mark
 *
 *  string	- output/string
 *		  data read from terminal
 *		  length determines maximum data read
 *  lstring	- output/integer
 *		  number of bytes of data (excluding terminators)
 *  code		- output/integer
 *		  way read was terminated
 *		    0 => cr/lf/ff/ and other printing or non-printing character
 *		    1 => up arrow or backspace
 *		    2 => right arrow or '>'
 *	 	    3 => down arrow or tab
 *		    4 => left arrow or '<'
 *		    5 => control/c  or control/y
 *		    6 => control/w
 */

void CURSES_RETURN (string, lstring, code, len)
char *string;
int *lstring;
int *code;
unsigned long len;
{

    int codes;
    CURSES_READ (string, lstring, code, len);
    if (*code != 0) {
#ifdef DEBUG
	fprintf (stderr, "NO RETURN! in curses_return\n");
#endif
	*code = 0;
    }
}


/*
 *	subroutine tt_prompt (prompt,string,lstring,code)
 *
 *  prompt	- input/string
 *		  prompt string
 *  string	- output/string
 *		  data read from terminal
 *		  length determines maximum data read
 *  lstring	- output/integer
 *		  number of bytes of data (excluding terminators)
 *  code		- output/integer
 *		  way read was terminated
 *		    0 => cr/lf/ff/ and other non-printing character
 *		    1 => control/c  or control/y or control/z
 */

void CURSES_PROMPT (prompt, string, lstring, code, len1, len2)
char *prompt;
char *string;
int *lstring;
int *code;
unsigned long len1, len2;
{
    CURSES_PUT_CHARS (prompt, len1);
    CURSES_READ (string, lstring, code, len2);
    CURSES_PUT_NL ();
}

/*
 *	subroutine tt_init
 *
 *  Opens channel to terminal 
 *  initializes device independent screen management routines
 *
 */

void CURSES_INIT () {
    initscr();
    savetty();
    clear();
    noecho();
    keypad(stdscr, 1);
    cbreak();
    clearok(stdscr,1);
}

/*
 *  subroutine erase_page (row,col)
 *
 *  Erases from specified cursor position to the end of display
 *
 *  row		- input/integer*4
 *  col		- input/integer*4
 */

void CURSES_ERASE_PAGE (row, col)
int *row, *col;
{
    if (*row == 1 && *col == 1) {
	clear();
    }
    else {
	move (*row-1, *col-1);
	clrtobot ();
    }
    refresh();
}


/*
 *  subroutine erase_line (row,col)
 *
 *  Erases from specified cursor position to the end of line
 *
 *  row		- input/integer*4
 *  col		- input/integer*4
 */

void CURSES_ERASE_LINE (row, col)
int *row, *col;
{
    move (*row-1, *col-1);
    clrtoeol ();
    refresh();
}


/*
 *  subroutine set_cursor (row,col)
 *
 *  Moves cursor to the specified position
 *
 *  row		- input/integer*4
 *  col		- input/integer*4
 */

void CURSES_SET_CURSOR (row, col)
int *row, *col;
{
    move (*row-1, *col-1);
    refresh();
}

/*
 *  subroutine put_screen (text,row,col)
 *
 *  Displays text at the specified position
 *
 *  row		- input/integer*4
 *  col		- input/integer*4
 */

void CURSES_PUT_SCREEN (text, row, col, len)
char *text;
int *row, *col;
unsigned long len;
{
    move (*row-1, *col-1);
    CURSES_PUT_CHARS (text, len);
    refresh();
}

/*
 *  subroutine put_buffer
 *
 *  Flush SMG$ buffer
 */

void CURSES_PUT_BUFFER () {
    refresh ();
}


void CURSES_EXIT_SUBROUTINE () {
    clear();
    resetty();
    endwin ();
}



void CURSES_SCROLLOK (boolf)
int *boolf;
{
    scrollok (stdscr, *boolf);
}



void PRINTABLE (string, codep, len)
char *string;
int *codep;
unsigned long len;
{
    int code = 0;
    int i = 0;

    for (; i < len; i++) {
	if (!isprint(string[i])) {
	    code = -1;
	    break;
	}
    }

    *codep = code;
}


int CURSES_YESNO (string, len)
char *string;
unsigned long len;
{
    int ret = 0;
    int lstring;
    int code;
    char buf[BUFSIZ];

    CURSES_PUT_CHARS (string, len);
    CURSES_READ ((char*)buf, &lstring, &code, BUFSIZ);
    CURSES_PUT_NL ();

    switch (buf[0]) {
	case 'y':
	case 'Y':
	case '1':
	    ret = 1;
	    break;
	
	default:
	    break;
    }

    return ret;
}

void CURSES_SUSPEND () {
    clear();
    resetty();
    echo();
    nocbreak();
    nl();
}


void CURSES_RESTART () {
    noecho();
    cbreak();
}

