C +++
C
C Source: src/tools/math/atan2.f
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	atan2.f
C Revision 1.1  90/07/17  13:54:43  khan
C Initial revision
C 
C 
C ---

	DATA PI/3.141592653589793238462643D0/
	DATA PIMEZ/1.570796326794896619231322D0/
	DATA PIDOPP/6.283185307179586467925287D0/
	DATA RAD/57.295779513082320876798155D0/
	DATA DEG/0.017453292519943295769237D0/

	write(6,*)'ATAN2(Z,X)'
	write(6,*)'	X','	  Z','	     RADS',	'	DEGS'

      	DO 100 I = -1,1
      	DO 100 J = -1,1
      	X 	=  I*1.0
      	Z	=  J*1.0
      	IF (X.EQ.0.AND.Z.EQ.0) THEN
      		ANGLE = 0.0
      		GO TO 50
      	ELSE
      	END IF
      	ANGLE 	= ATAN2(Z,X)
	ANGLE1	= ANGLE/PIDOPP*360.0
	
50	write(6,*)X,Z,ANGLE,ANGLE1
100	CONTINUE
      	END
