C +++
C
C Source: src/source/id/user_undul.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: user_undul.F
C Revision 1.6  1992/01/22  22:15:43  cwelnak
C 6000 changes and VMS devel update
C
C Revision 1.5  1991/07/06  20:03:58  khan
C Grenoble and after. Minor changes
C
C Revision 1.4  90/11/13  14:01:05  khan
C Cleanup and SAVE statements
C 
C Revision 1.3  90/10/30  00:01:52  khan
C Fix Ultrix -> VMS things that got screwed up in VMS -> Ultrix.
C 
C Revision 1.2  90/07/17  23:04:59  khan
C Fixed STATUS=NEW in OPEN statements to UNKNOWN for Unix.
C Substitue pre_rad.blk for PRE_RAD.BLK
C 
C Revision 1.1  90/07/17  15:36:41  khan
C Initial revision
C 
C 
C ---
C+++
C
C	PROGRAM		USER_UNDUL
C
C	PURPOSE		This is the main calling program to
C			a) read in all the inputs (UREAD)
C			b) compute photon spectra as per user request
C
C	NOTE		Since this program uses no arrays, the angle and energy
C			are not limited to 31 and 51 points as in MAKE_ID.
C
C---
	PROGRAM		USER_UNDUL
	IMPLICIT	REAL*8	(A-H,O-Z)

	CHARACTER*80	RSTRING,FNAME
	CHARACTER*3	BELL
	DIMENSION	ATHETA(101),APHI(40)
	DIMENSION	UPH(101,10),FXY(101,101),FY(101)
	DIMENSION	UPD(101,10),FPD(101,101),TPOWER(10001)

#if defined(unix) || HAVE_F77_CPP
#	include 	"pre_rad.blk"
#elif defined(vms)
	INCLUDE		'PRE_RAD.BLK/LIST'
#endif

	NAMELIST	/PARAIN/	NCOMP,RCURR,ICOMP,BPASS,
     $					IANGLE,IAPERTURE,IEXTERNAL,
     $					FOUT,FIN,FTRAJ,EMIN,EMAX,
     $					THEMIN,THEMAX,PHIMIN,PHIMAX,
     $					NE,NT,NP,NCHECK,IOPT,ITER,IPASS,
     $					I_EDIV,EDIVX,EDIVY,FINT,IINT
     	
     	DATA	PI     	/  3.1415 92653 58979 32384 62643 D0 /
     	DATA	PIHALF 	/  1.5707 96326 79489 66192 31322 D0 /
     	DATA	TWOPI 	/  6.2831 85307 17958 64769 25287 D0 /
C
C Read in namelist and trajectory file from EPATH
C
	write(6,*) 'Parameters from : '
	write(6,*) '	User interactive process   (0) '
	write(6,*) '	NAMELIST file		   (1) '
	INAME 		= IYES ('Choice : ')
C
	if (INAME.eq.1) then
C
C Read in the namelist file of parameters
C
	   FNAME	= RSTRING ('Namelist file : ')
	   OPEN	(31, FILE=FNAME, STATUS='OLD')
	   READ	(31,NML=PARAIN)
	   CLOSE	(31)
	   CALL		UREAD
	else
	   CALL	UNDUL_USER_IO
	end if
C
C  compute the number of points and step size
C
	IF (EMAX.EQ.EMIN) THEN
	   NE    = 1
	   ESTEP = 0.0D0
	ELSE
     	   ESTEP  = (EMAX-EMIN)/(NE-1)
	END IF
     	BDEL	= ABS(ESTEP)
C
     	IF (PHIMAX.EQ.PHIMIN) THEN
	  NP      = 1
	  PHISTEP = 0.0D0
     	ELSE	
     	 IF (NP.GT.1) THEN
	  PHISTEP   = (PHIMAX-PHIMIN)/(NP-1)	! open string of points
						! for 1 quadrant.
     	 ELSE
     	  PHISTEP = ABS ( PHIMAX - PHIMIN )
     	 END IF
     	END IF
C
     	IF (THEMAX.EQ.THEMIN) THEN
	  NT      = 1
	  THESTEP = 0.0D0
     	ELSE
     	 IF (NT.GT.1) THEN
 	  THESTEP   = (THEMAX-THEMIN)/(NT-1)	! open string of points
     	 ELSE
     	  THESTEP = ABS ( THEMAX - THEMIN )
     	 END IF
     	END IF
C
C Computes some parameters for report
C
     	TIME0	=   CPUTIM()
     	CALL REPORT (ENER, THETA, PHI, TTIME, PERC, -1)
C
C Check if the steps are too small
C
	IF (I_EDIV.EQ.1) THEN
	  IF (THESTEP.GT.(3*EDIVY))	WRITE(6,*)	
     $		'WARNING.  The angular step in the vertical is too large.'
	  IF (PHISTEP.GT.(3*EDIVX))	WRITE(6,*) 	
     $		'WARNING.  The angular step in the horizontal is too large.'
	END IF
C
C Open file
C     	
	TEN_DEG	= PIHALF/9.0
#ifdef vms 
     	OPEN 	(30, FILE=FOUT, STATUS='NEW', INITIALSIZE=100,
     $	CARRIAGECONTROL='LIST')
	IF (IINT.EQ.1)	OPEN	(40, FILE=FINT, STATUS='NEW')
#else
	OPEN	(30, FILE=FOUT, STATUS='UNKNOWN')
	REWIND	(30)
	IF (IINT.EQ.1)	OPEN	(40, FILE=FINT, STATUS='UNKNOWN')
	REWIND	(40)
#endif

     	DO 19 K=1,NE
         ENER = EMIN + ESTEP*(K-1)

	 IF (I_EDIV.EQ.0) THEN			! No electron divergence

	   TOTPOINTS	= NP*NT*NE
	   DO 29 J = 1, NT
	     THE	= THEMIN + (J-1)*THESTEP
	     DO 39 I = 1, NP
	       PHI	= PHIMIN + (I-1)*PHISTEP
     	       IPOINTS  = IPOINTS + 1
     	       KCHECK 	= KCHECK + 1
C
C PHOT is either photons/sec/rad^2/eV or photons/sec/rad^2/bandpass. See 
C UPHOTON.FOR.
C
     	       CALL UPHOTON (ENER, THE, PHI, PHOT, POL)
     	       IF (PHOT.LE.1.0E-10) PHOT = 1.0D-10
     	       IF (POL.LE.1.0E-10) POL = 1.0D-10
	       FXY(I,J)		= PHOT
	       FPD(I,J)		= POL

     	       IF (KCHECK.EQ.NCHECK) THEN
    	    	 TTIME  = CPUTIM()-TIME0
     	     	 PERC = IPOINTS/TOTPOINTS*100
     	     	 CALL REPORT (ENER, THE, PHI, TTIME, PERC, 1)
     	     	 KCHECK = 0
     	       END IF

39     	     CONTINUE
29     	   CONTINUE

	 ELSE				! Include electron divergence
C
C Choose the angular meshs (ATHETA, APHI) which is later used for convolution
C
	   CALL	CHOOSE	(ENER,ATHETA,NT0,APHI,NP0)
     	   TOTPOINTS = 10*NT0*NE
	   IOLD	= IANGLE
	   IANGLE = 1

     	   DO 49 J = 1, NT0
     	     DO 59 I = 1, 10
	       THE	= ATHETA(J)
	       PHI	= (I-1)*TEN_DEG
     	       IPOINTS 	= IPOINTS + 1
     	       KCHECK 	= KCHECK + 1
C
C PHOT is either photons/sec/rad^2/eV or photons/sec/rad^2/bandpass. See 
C UPHOTON.FOR.
C
     	       CALL UPHOTON (ENER, THE, PHI, PHOT, POL)
     	       IF (PHOT.LE.1.0E-10) PHOT = 1.0D-10
     	       IF (POL.LE.1.0E-10) POL = 1.0D-10
	       UPH(J,I)		= PHOT
	       UPD(J,I)		= POL

     	       IF (KCHECK.EQ.NCHECK) THEN
    	         TTIME  = CPUTIM()-TIME0
     	         PERC 	= IPOINTS/TOTPOINTS*100
     	         CALL REPORT (ENER, THE, PHI, TTIME, PERC, 1)
     	         KCHECK = 0
     	       END IF

59     	     CONTINUE
49   	   CONTINUE
	   IANGLE	 = IOLD
C
C Now the convolution
C
	   CALL	CONVOL	(ATHETA,APHI,UPH,UPD,NT0,NP0,FXY,FPD)

	  END IF

	  DO 79 J = 1, NT
	    AY		= THEMIN + (J-1)*THESTEP
	    DO 89 I = 1, NP
	      AX	= PHIMIN + (I-1)*PHISTEP
	      WRITE	(30,1001)	ENER,AY,AX,FXY(I,J),FPD(I,J)
89	    CONTINUE
79	  CONTINUE
C
C If the user wants to integrate the flux over the two angles...
C
	  IF (IINT.EQ.1) THEN
	    CALL	INTEGRATE	(FXY,FY,FNUM)
	    WRITE	(40,*)		ENER,FNUM
	    TPOWER(K)	= FNUM
	  END IF	  

19     	CONTINUE


1001	FORMAT	(1X,4(1X,G12.5),2X,G15.9)

	IF (IINT.EQ.1) THEN
	TOTPOWER	= 0.0E0
	  DO 99 K = 1, NE-1
	    IF (ICOMP.EQ.0) THEN
	      TOTPOWER	= TOTPOWER + 0.5*(TPOWER(K)+TPOWER(K+1))/BPASS
     $					*ESTEP*1.602E-19
	    ELSE
	      E0	= EMIN + (K-1)*ESTEP
	      E1	= EMIN + K*ESTEP
	      TOTPOWER	= TOTPOWER + 0.5*(TPOWER(K)*E0+TPOWER(K+1)*E1)
     $					*ESTEP*1.602E-19
	    END IF
99	  CONTINUE
	  WRITE(6,*) 'Total power emitted = ',TOTPOWER,' Watt'
	END IF
C
C Finally write out the new namelist file.
C
#ifdef vms
	OPEN	(35, FILE='USER.PAR', STATUS='NEW')
#else
	OPEN	(35, file='USER.PAR', STATUS='UNKNOWN')
	REWIND	(35)
#endif
	WRITE	(35, NML=PARAIN)
	CLOSE	(35)
C
C Ring a bell to wake up the user
C
	BELL(1:1)	= CHAR(7)
	BELL(2:2)	= CHAR(7)
	BELL(3:3)	= CHAR(7)
	WRITE(6,*) BELL

	END
