C
C
C Source: src/source/id/rns.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	rns.F
C Revision 1.5  91/04/05  14:47:38  cwelnak
C changed quotes on #includes
C 
C Revision 1.4  91/03/21  15:29:48  cwelnak
C SUN version -- changes INCLUDE to #include
C 
C Revision 1.3  90/10/30  00:01:40  khan
C Fix Ultrix -> VMS things that got screwed up in VMS -> Ultrix.
C 
C Revision 1.2  90/07/17  23:04:52  khan
C Fixed STATUS=NEW in OPEN statements to UNKNOWN for Unix.
C Substitue pre_rad.blk for PRE_RAD.BLK
C 
C Revision 1.1  90/07/17  15:36:36  khan
C Initial revision
C 
C 
C ---



C+++
C
C	SUBROUTINE	RNS
C
C	PURPOSE		Integrate #photons/sec/eV/rad**2 first over phi,
C			then over theta.
C
C	ALGORITHM	Integration performed using QSF
C			RECTANGULAR APERTURE (cartesian angles)
C			PINHOLE APERTURE (polar angles)
C
C	INPUT:		RN0(phi, theta, ener)
C			Common block PARA3 should be defined by the calling 
C			program
C
C	OUTPUT:		RN1(theta, ener)
C			RN2(ener)
C---
	SUBROUTINE	RNS (RN0,RN1,RN2,UPHI,UTHETA,UENER)
	IMPLICIT	REAL*8	(A-H,O-Z)

#if vms
	INCLUDE		'PRE_RAD.BLK/LIST'
#elif unix
#include		"pre_rad.blk"
#endif

	DIMENSION	RN0(31,31,51),RN1(31,51),RN2(51)
	DIMENSION	UPHI(31,31,51),UTHETA(31,51),UENER(51)

	DIMENSION	YRN0(1001),YRNN0(1001)
	DIMENSION	YRN1(1001),YRNN1(1001)
	DATA	PI	/  3.1415 92653 58979 32384 62643 D0 /

C
	IF (IANGLE.EQ.1) THEN		!Polar coords
C	  
C	   TYPE *,'BEGIN INTEGRATION OVER PHI'
C
	   DO 155 K = 1,NE
	      DO 165 J = 1,NT
		 DO 175 I = 1,NP
		    YRN0(I) = RN0(I,J,K) * UTHETA(J,K)
C		    IF (J.EQ.1) THEN
C			YRN0(I)	= YRN0(I)/(UPHI(NP,J,K)-UPHI(1,J,K))*
C     $				(UTHETA(2,K)-UTHETA(1,K))*PI/16
C		    ELSE IF (J.NE.1) THEN
C			IF (I.EQ.1.OR.I.EQ.NP) THEN
C			     YRN0(I) = YRN0(I)/2.0D0*UTHETA(J,K) 
C			ELSE
C			     YRN0(I) = YRN0(I)*UTHETA(J,K)
C			END IF
C		    END IF

175		 CONTINUE

		 IF (J.EQ.1) THEN
		   ARN	= 0.0D0
		   DO 185 I = 1, NP
		     ARN = ARN + 0.5D0*(RN0(I,1,K) + RN0(I,2,K))
185		   CONTINUE
		   ARN	= ARN/NP
		   DO 195 I = 1, NP
		     YRN0(I)	= ARN*0.5D0*(UTHETA(2,K)-UTHETA(1,K))/2.0D0
195		   CONTINUE
		 END IF

C  Use trapezoidal integration
		 YRNN0(1) = 0.0D0
		 DO 205 I=2,NP
		   YRNN0(I) = YRNN0(I-1) + (UPHI(I,J,K)-UPHI(I-1,J,K))*
     $					0.5D0*( YRN0(I-1) + YRN0(I) )
205		 CONTINUE
C
		 RN1(J,K) = YRNN0(NP)
165	      CONTINUE
155	   CONTINUE
C
C	TYPE *,'BEGIN INTEGRATION OVER THETA'
C
	   DO 215 K = 1,NE
	      DO 225 J = 1,NT
		 YRN1(J) = RN1(J,K) 
225	      CONTINUE
C  Use trapezoidal integration
		 YRNN1(1) = 0.0D0
		 DO 235 J=2,NT
		   YRNN1(J) = YRNN1(J-1) + (UTHETA(J,K)-UTHETA(J-1,K))*
     $					0.5D0*( YRN1(J-1) + YRN1(J) )
235		 CONTINUE
C
	      IF (IAPERTURE.EQ.1) THEN
	         RN2(K) = YRNN1(NT)*4.0D0
	      ELSE IF (IAPERTURE.EQ.2) THEN
	         RN2(K) = YRNN1(NT)
	      END IF
215	   CONTINUE
	ELSE IF (IANGLE.EQ.2) THEN		! Cartesian coords
C
C     	   TYPE *,'BEGIN INTEGRATION OVER  PHI'
C
	   DO 245 K=1,NE				! # ENER
	      DO 255 J=1,NT				! # THE
	   	 DO 265 I=1,NP			! # PHI
	      	    YRN0(I) = RN0(I,J,K)	! Prepare integration over phi
C		       IF (I.EQ.1.AND.J.EQ.1)THEN
C	      	          YRN0(I) = YRN0(I)/4.0D0
C		       ELSE IF (I.EQ.1.OR.J.EQ.1) THEN
C	      	          YRN0(I) = YRN0(I)/2.0D0
C		       ELSE
C		          YRN0(I) = YRN0(I)
C		       END IF
265	   	 CONTINUE
C  Use trapezoidal integration
		 YRNN0(1) = 0.0D0
		 DO 275 I=2,NP
		   YRNN0(I) = YRNN0(I-1) + (UPHI(I,J,K)-UPHI(I-1,J,K))*
     $					0.5D0*( YRN0(I-1) + YRN0(I) )
275		 CONTINUE
C
	   	 RN1(J,K) = YRNN0(NP)
255	      CONTINUE
245	   CONTINUE
C
C Begin integration over theta
C 
C     	   TYPE *,'BEGIN INTEGRATION OVER THETA'
C
C
     	   DO 285 K=1,NE
     	      DO 295 J=1,NT
     	         YRN1(J) = RN1(J,K)
295           CONTINUE
C  Use trapezoidal integration
		 YRNN1(1) = 0.0D0
		 DO 305 J=2,NT
		   YRNN1(J) = YRNN1(J-1) + (UTHETA(J,K) - UTHETA(J-1,K))*
     $					0.5D0*( YRN1(J-1) + YRN1(J) )
305		 CONTINUE
C
C Multiply by 4 for the entire rectangular region.
C
	      IF (IAPERTURE.EQ.3) THEN		!rectangle centered in xy plane 
	         RN2(K) = YRNN1(NT)*4.0
	      ELSE IF (IAPERTURE.EQ.4) THEN
	         RN2(K) = YRNN1(NT)		!rectangle in 1st quadrant.
	      END IF
285        CONTINUE
C
	END IF
C
	IF (IPASS.NE.0)	RETURN
C
C Include total power calculation
C
     	WRITE(6,*) 'Calculation completed.'
     	WRITE(6,*) '----------------------------',
     $'-----------------------------------------------'
     	WRITE(6,*) ' '
     	WRITE(6,*) '----------------------------',
     $'-----------------------------------------------'
     	WRITE(6,*) ' '
     	WRITE(6,*) 'Begin computation of total power.'
     	TOTPOWER = 0.0D0
C
C Notice: RN2 is either of:	#phot/eV/sec 
C 			or:	#phot/bpass/sec
C
d	do kc=1,ne
d	write (90,*) ener(kc),rn2(kc)
d	end do
d
     	DO 315 K=1,NE-1
     	 IF (ICOMP.EQ.0) THEN		! Constant Bpass
     	   TOTPOWER = TOTPOWER + 0.5*(RN2(K)+RN2(K+1))/BPASS
     $				*(UENER(K+1)-UENER(K))*1.602E-19
     	 ELSE				! Constant dE
     	   TOTPOWER = TOTPOWER + 0.5*(RN2(K)*UENER(K)+RN2(K+1)*UENER(K+1))
     $				*(UENER(K+1)-UENER(K))*1.602E-19
     	 END IF
315     CONTINUE

     	WRITE(6,*)'Total Power emitted in the specified angles is: '
     	WRITE(6,*)totpower
     	WRITE(6,*)'Watts.'
     	WRITE(6,*)' '
     	WRITE(6,*)'Preliminary calculations completed.'
     	WRITE(6,*)' '
d     	WRITE(6,*)'Total CPU time used so far: '
d     	ttime = cputim() - time0
d     	WRITE(6,*) ttime
     	WRITE(6,*)' '
C
	RETURN
	END

