C +++
C
C Source: src/source/gen_source.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	gen_source.F
C Revision 1.9  91/07/06  19:59:04  khan
C Elliptical Undulator by Sylvia Difonzo
C 
C Revision 1.8  91/04/05  14:03:28  cwelnak
C changed quotes on #include
C 
C Revision 1.7  91/03/20  16:46:17  cwelnak
C SUN version -- changes INCLUDE to #include
C 
C Revision 1.6  90/11/09  14:13:23  khan
C Added SAVE statements...
C 
C Revision 1.5  90/07/19  20:53:01  khan
C Put Preprocessor/conditionals to make it work on both VMS and Ultrix.
C 
C Revision 1.4  90/07/14  22:39:13  khan
C All global include files (common.blk, etc) are now in ./../include/ dir.
C 
C Revision 1.3  90/07/11  00:07:20  khan
C Command line arg cleanup.
C 
C Revision 1.2  90/07/11  00:01:46  khan
C Added ASCII option for BEGIN file, optional name to START file, and new
C command line parameters [-a|b] [start_file_name]
C 
C Revision 1.1  90/07/10  16:16:56  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	PROGRAM		GEN_SOURCE
C
C	PURPOSE		Reads in a NAMELIST file and create the specified
C			source
C
C	INPUT		A NAMELIST type file
C
C	OUTPUT		A [BINARY|ASCII] file [BEGIN.DAT|BEGIN.DAT.ASCII]
C
C	COMMAND LINE	[-a|b] [start_file_name]
C		-b:	Create binary output BEGIN.DAT (default)
C		-a:	Create ASCII output BEGIN.DAT.ASCII (for debugging?)
C		start_file_name:
C			Default START.00, unless specified explicitly.
C
C---
     	PROGRAM		GEN_SOURCE
#ifdef MICROSOFT
	USE MSFLIB
#endif
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#	include		<common.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
	INCLUDE		'SHADOW$INC:DATA.BLK/LIST'
#endif
C
#if IEEE_HANDLER
	external	myhandler
#endif
     	CHARACTER*80	INFILE,RSTRING,OUTFILE,BGNFILE,ARG
	INTEGER		IOFORM
     	LOGICAL		STATUS
	DATA		IOFORM 	/ 0 /
	DATA		INFILE  / ' ' /
#ifdef vms
	DATA		BGNFILE / 'BEGIN' /
#else
	DATA		BGNFILE / 'begin.dat' /
#endif
C
C Look at the command line for user parameters. only for unix machines.
C Let's the user choose ASCII option on the output BEGIN file.
C
#ifndef vms
	NUMARG = IARGC ()
 	IF (NUMARG.EQ.0) GOTO 20
 	INDEX = 1
  10	CONTINUE
 	    CALL GETARG (INDEX, ARG)
 	    IF (ARG (1:2) .EQ. '-a' .OR. ARG (1:2) .EQ. '-A') THEN
 		IOFORM = 1
 		BGNFILE = 'begin.dat.ascii'
 	    ELSE 
 		IF (ARG (1:1) .NE. '-') INFILE = ARG
 	    ENDIF
C
 	    INDEX = INDEX + 1
 	    IF (INDEX .LE. NUMARG) GOTO 10
 20	CONTINUE
C
C If the INFILE was not supplied in the command line, ask for it.
C
	IF (INFILE(1:1).EQ.' ') THEN
     	  INFILE  =  
     $	     RSTRING ('SOURCE => File with source specifications ? ')
	ENDIF
C
#elif defined(vms)
C
C Have to ascii command line option. So anything on the command line is
C taken as the INFILE supplied by user.
C
     	STATUS	= LIB$GET_FOREIGN (INFILE,,LEN)
     	IF (LEN.EQ.0) THEN
     	  INFILE  =  
     $	RSTRING ('SOURCE => File with source specifications ? ')
     	END IF
#endif
C
C
C For SunOS, use the abrupt_underflow call to make the results the same
C as that of VAX FORTRAN and also improve performance a bit.
C
#if ABRUPT_UNDERFLOW
	call	abrupt_underflow
#endif
#if IEEE_HANDLER
	call	ieee_handler ('set', 'invalid', myhandler)
	call	ieee_handler ('set', 'division', myhandler)
	call	ieee_handler ('set', 'overflow', myhandler)
	call	ieee_handler ('set', 'underflow', myhandler)
#endif
     	ISTAT = 0
     	IDUMM = 0
     	CALL	RWNAME	( INFILE, 'R_SOUR', IDUMM)
     	IF (IDUMM.EQ.0) THEN
     	  CALL  SOURCE1 (BGNFILE, IOFORM)
	  CALL FNAME	( OUTFILE, 'end', 0, 2)
	  CALL RWNAME	( OUTFILE, 'W_SOUR', IDUMM)
	  IF (IDUMM.NE.0) CALL LEAVE 
     $		('GEN_SOURCE','Error writing out NAMELIST file.',IDUMM)
     	  WRITE(6,*)'SOURCE => Source has been succesfully generated.'
     	ELSE
     	  CALL	LEAVE ( 'GEN_SOURCE: error trying to read', 
     $	                 INFILE, IDUMM)
     	END IF
     	STOP
     	END

	BLOCK DATA
	IMPLICIT        REAL*8          (A-E,G-H,O-Z)
	IMPLICIT        INTEGER*4       (F,I-N)
	COMMON  /MATHBLK/ PI,TWOPI,PIHALF,TODEG,TORAD,ORIGIN(3),
     $			 X_VRS(3),Y_VRS(3),Z_VRS(3),TOCM,TOANGS

        DATA    PI      /  3.1415 92653 58979 32384 62643 D0 /
     	DATA    PIHALF  /  1.5707 96326 79489 66192 31322 D0 / 
	DATA    TWOPI 	/  6.2831 85307 17958 64769 25287 D0 /
      	DATA 	TODEG 	/ 57.2957 79513 08232 08767 98155 D0 /
        DATA 	TORAD 	/  0.0174 53292 51994 32957 69237 D0 /
      	DATA 	TOCM 	/  1.239 852 	D-4                  /
	DATA    TOANGS  /  1.239 852    D+4                  /
	DATA    ORIGIN  /   .0D0, .0D0, .0D0                 /

	DATA    X_VRS   /  1.0D0,  .0D0,  .0D0               /
	DATA    Y_VRS   /   .0D0, 1.0D0,  .0D0               /
	DATA    Z_VRS   /   .0D0,  .0D0, 1.0D0               /

	END

