C +++
C
C Source: src/source/bm/sync_spectra.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	sync_spectra.F
C Revision 1.2  90/07/18  19:36:45  khan
C Added #if vms .. #elif unix to OPEN statements.
C 
C Revision 1.1  90/07/11  10:45:13  khan
C Initial revision
C 
C 
C ---

C+++
C	PROGRAM		SR
C
C	PURPOSE		To compute SR spectra in the form 
C			ener	theta	 n(e)	p(e)
C
C---
	PROGRAM		SYNC_SPECTRA
	IMPLICIT	REAL*8	(A-H,O-Z)
	DATA	PI	/3.141592653589793238D0/
     	CHARACTER*80	RSTRING, OUTFILE
     	REAL*4		OUT (3,101,101),XRN,XPHOT,XTHETA
	RAD	= RNUMBER ('Machine radius  [ m ] : ')
	BENER	= RNUMBER ('        energy  [ GeV ] : ')
     	CURR	= RNUMBER ('        current [ A ] : ')
     	ORBIT	= RNUMBER ('Subtended angle [ mrads ] : ')
	GAMMA	= 1957.0E0*BENER
	R_LAM	= 4*PI*RAD/3/GAMMA**3*1.0E10
	C_PHOT	= 12398.52/R_LAM
     	FACTOR	= 1.013D6*R_LAM*GAMMA
     	COEFF	= 1000*ORBIT*CURR
     	WRITE(6,*) 'Critical energy = ',C_PHOT
     	WRITE(6,*) 'Options:'
     	WRITE(6,*) 'dE = const 		0	[ phot/sec/mrad(V)/ eV ] '
     	WRITE(6,*) 'dL = const 		1	[ phot/sec/mrad(V)/ Angs ] '
     	WRITE(6,*) 'dL/L = const 	2	[ phot/sec/mrad(V)/%bandwidth ]'
     	WRITE(6,*) 'dE/E = const 	3	[ phot/sec/mrad(V)/%bandwidth ]'
     	WRITE(6,*) 'Power dL = const 	4	[ watts/mrad(V)/angs ]'
     	WRITE(6,*) 'Power dE = const 	5	[ watts/mrad(V)/eV ]'
     	ICURVE	= IRINT	('Then ? ')
	IF (ICURVE.EQ.2.OR.ICURVE.EQ.3) THEN
	  BPASS	= RNUMBER	('Bandpass (%) ? ')
	  BPASS	= BPASS/100.0D0
	END IF
	PHOTMAX	= RNUMBER ('Maximum Photon energy [wavelength]: ')
	PHOTMIN	= RNUMBER ('Minimum               : ')
     	NP	= IRINT	  ('Number of points in energy [wavelength]: ')
     	ISCALE	= IYES	  ('Log Scale	[ Y/N ] ? ')
	THEMAX	= RNUMBER ('Maximum vertical angle [ mrad ] : ')
     	THEMIN	= RNUMBER ('Minimum                         : ')
	NT	= IRINT   ('No. of points in THETA : ')
	IPOL	= IRINT   ('Polarization [1,2,3] : ')
     	IENER	= IYES    ('Scale energy to critical energy [ Y/N ] ? ')
     	INPHOT	= IYES    ('Scale flux to beam energy [ Y/N ] ? ')
	IGAMMA	= IYES	  ('Multiply theta by gamma [ Y/N ] ? ')
     	I3D	= IYES	  ('File for 3d Top Drawer ? ')
     	IF (I3D.EQ.0) THEN
     	ITD	= IYES	  ('File for Top Drawer (with embedded JOIN)? ')
     	END IF
     	OUTFILE	= RSTRING ('Output file name: ')
#ifdef vms
     	OPEN (25, FILE=OUTFILE, STATUS='NEW')
#else
     	OPEN (25, FILE=OUTFILE, STATUS='UNKNOWN')
	REWIND(25)
#endif
	THEMAX	= THEMAX * 1.0D-3
	THEMIN	= THEMIN * 1.0D-3
	THESTEP	= (THEMAX-THEMIN)/(NT-1)
     	IF (ISCALE.EQ.0) THEN
     	  PHOTSTEP= (PHOTMAX-PHOTMIN)/(NP-1)
     	ELSE
     	  PHOTSTEP= (LOG10(PHOTMAX) - LOG10(PHOTMIN))/(NP-1)
     	END IF
	IFLAG	= -1
	CALL	BEND_PHOT(RN,THETA,PHOT,GAMMA,C_PHOT,IPOL,IFLAG)
     	DO 99 J= 1, NP
     	 IF (ISCALE.EQ.0) THEN
     	   PHOT = PHOTMIN + (J-1)*PHOTSTEP
     	 ELSE
     	   PHOT = 10.0**( LOG10(PHOTMIN) + (J-1)*PHOTSTEP )
     	 END IF
     	  YVAL = PHOT/C_PHOT
	 DO 199 I = 1, NT
	   IFLAG	= 1
	   THETA	= THEMIN + THESTEP*(I-1)
     	  	IF (ICURVE.EQ.0) THEN
	   CALL	BEND_PHOT(RN,THETA,PHOT,GAMMA,C_PHOT,IPOL,IFLAG)
     	   RN = RN*COEFF
     	  ELSE	IF (ICURVE.EQ.1) THEN
     	   PHOT = 12398.52/PHOT
	   CALL	BEND_PHOT(RN,THETA,PHOT,GAMMA,C_PHOT,IPOL,IFLAG)
     	   RN = RN/FACTOR*2.998D-1*GAMMA**4/RAD*COEFF
     	   RN = RN*YVAL**2
     	  ELSE	IF (ICURVE.EQ.2) THEN
     	   PHOT = 12398.52/PHOT
	   CALL	BEND_PHOT(RN,THETA,PHOT,GAMMA,C_PHOT,IPOL,IFLAG)
     	   RN = RN/FACTOR*1.256D10*BPASS**GAMMA*COEFF
     	   RN = RN*YVAL
     	  ELSE	IF (ICURVE.EQ.3) THEN
	   CALL	BEND_PHOT(RN,THETA,PHOT,GAMMA,C_PHOT,IPOL,IFLAG)
     	   RN = RN/FACTOR*1.256D10*BPASS*GAMMA*COEFF
     	   RN = RN*YVAL
     	  ELSE	IF (ICURVE.EQ.4) THEN
     	   PHOT = 12398.52/PHOT
	   CALL	BEND_PHOT(RN,THETA,PHOT,GAMMA,C_PHOT,IPOL,IFLAG)
     	   RN = RN/FACTOR*1.421d-26*GAMMA**7/RAD**2*COEFF
     	   RN = RN*YVAL**3
     	  ELSE	IF (ICURVE.EQ.5) THEN
	   CALL	BEND_PHOT(RN,THETA,PHOT,GAMMA,C_PHOT,IPOL,IFLAG)
     	   RN = RN/FACTOR*1.641d-13*R_LAM*GAMMA*COEFF
     	   RN = RN*PHOT
     	  END IF
     	   XPHOT = PHOT
     	   XRN = RN
     	   XTHETA = THETA*1.0D3
     	  IF (IENER.EQ.1) XPHOT=PHOT/C_PHOT
     	  IF (INPHOT.EQ.1) XRN = RN/BENER
	  IF (IGAMMA.EQ.1) XTHETA = THETA*GAMMA
     	 IF (I3D.NE.1) THEN
	   WRITE	(25,*)	XPHOT, XTHETA, XRN
     	 ELSE
     	   OUT (1,I,J) = XPHOT
     	   OUT (2,I,J) = XTHETA 
     	   OUT (3,I,J) = XRN
     	 END IF
 199 	 CONTINUE
     	 IF (ITD.EQ.1) WRITE (25,*) 'JOIN 1'
 99	CONTINUE
     	IF (I3D.EQ.1) THEN
     	 DO 299 I=1,NP
     	  DO 399 J=1,NT
     	   WRITE (25,*) OUT(1,I,J) , OUT(2,I,J), OUT(3,I,J)
 399   	  CONTINUE
     	  WRITE (25,*) 'JOIN 1'
 299 	 CONTINUE
     	  WRITE (25,*) '(End of first pass)'
     	 DO 499 J=1,NT
     	  DO 599 I=1,NP
     	   WRITE (25,*) OUT (1,I,J), OUT (2,I,J), OUT (3,I,J)
 599   	  CONTINUE
     	  WRITE (25,*) 'JOIN 1'
 499 	 CONTINUE
     	END IF
     	CLOSE (25)
	END
