C +++
C
C Source: src/source/bm/solve.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	solve.F
C Revision 1.1  90/07/18  16:16:33  khan
C Initial revision
C 
C 
C ---

C+++
C	SUBROUTINE	SOLVE
C
C	PURPOSE		Finds the zero of an equation
C
C---
	SUBROUTINE SOLVE(Y_IN,X_OUT,I_FLAG)

	IMPLICIT 	REAL*8 		(A-H,O-Z)

#if defined(unix) || HAVE_F77_CPP
#       include		"bm.blk"
#elif defined(vms)
	INCLUDE		'bm.blk'
#endif
C
	EXTERNAL POL_PAR,POL_PER,POL_TOT

	R_INPUT = Y_IN
	EPS      = 0.0
	N_DIGITS = 4
	VAR_1	 = - PSIMAX
	VAR_2	 =   PSIMAX
	MAX_CALL = 50

	IF (I_FLAG.EQ.1) THEN
		CALL ZBRENT (POL_PAR,EPS,N_DIGITS,VAR_1,VAR_2,MAX_CALL,IER)
		IF (IER.NE.0) WRITE(6,*)'Err.',IER,'in ZBRENT'
	ELSE IF (I_FLAG.EQ.2) THEN
		CALL ZBRENT (POL_PER,EPS,N_DIGITS,VAR_1,VAR_2,MAX_CALL,IER)
		IF (IER.NE.0) WRITE(6,*)'Err.',IER,'in ZBRENT'
	ELSE IF (I_FLAG.EQ.3) THEN
		CALL ZBRENT (POL_TOT,EPS,N_DIGITS,VAR_1,VAR_2,MAX_CALL,IER)
		IF (IER.NE.0) WRITE(6,*)'Err.',IER,'in ZBRENT'

	ELSE
		CALL LEAVE
     $	 ('ALADDIN','Error in Flag call to ALADDIN',I_FLAG)
	END IF

	X_OUT = VAR_2

	RETURN
	END

***************************************************************************
	FUNCTION POL_PAR(XPAR_IN)

	IMPLICIT	REAL*8 		(A-H,O-Z)

#if defined(unix) || HAVE_F77_CPP
#       include		"bm.blk"
#elif defined(vms)
	INCLUDE		'bm.blk'
#endif
C
	DIMENSION	X_IN(1),Y_OUT(1)

	N_ELEM 		= 1001
	M_VECTOR	= 1
	L_SPLINE	= 1000
	X_IN(1)		= XPAR_IN

	CALL ICSEVU (ANG_ARR,PPAR_INT,N_ELEM,SPLI_1,L_SPLINE,X_IN,Y_OUT,
     $  M_VECTOR,IER)

	IF (IER.NE.0) WRITE(6,*)'Error in ICSEVU = ',IER

	POL_PAR	= R_INPUT - Y_OUT(1)

	RETURN
	END
***************************************************************************
	FUNCTION POL_PER(XPAR_IN)

	IMPLICIT	REAL*8		(A-H,O-Z)

#if defined(unix) || HAVE_F77_CPP
#       include		"bm.blk"
#elif defined(vms)
	INCLUDE		'bm.blk'
#endif
C
	DIMENSION	X_IN(1),Y_OUT(1)

	N_ELEM 		= 1001
	M_VECTOR	= 1
	L_SPLINE	= 1000
	X_IN(1)		= XPAR_IN

	CALL ICSEVU (ANG_ARR,PPER_INT,N_ELEM,SPLI_2,L_SPLINE,X_IN,Y_OUT,
     $  M_VECTOR,IER)

	IF (IER.NE.0) WRITE(6,*)'Error in ICSEVU = ',IER

	POL_PER	= R_INPUT - Y_OUT(1)

	RETURN
	END
***************************************************************************
	FUNCTION POL_TOT(XPAR_IN)

	IMPLICIT	REAL*8		(A-H,O-Z)
C
#if defined(unix) || HAVE_F77_CPP
#       include		"bm.blk"
#elif defined(vms)
	INCLUDE		'bm.blk'
#endif
C
	DIMENSION	X_IN(1),Y_OUT(1)

	N_ELEM 		= 1001
	M_VECTOR	= 1
	L_SPLINE	= 1000
	X_IN(1)		= XPAR_IN

	CALL ICSEVU (ANG_ARR,PTOT_INT,N_ELEM,SPLI_3,L_SPLINE,X_IN,Y_OUT,
     $  M_VECTOR,IER)

	IF (IER.NE.0) WRITE(6,*)'Error in ICSEVU = ',IER

	POL_TOT	= R_INPUT - Y_OUT(1)

	RETURN
	END
