C +++
C
C Source: src/source/bm/cdf.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	icdf.F
C Revision 1.1  90/07/18  16:16:32  khan
C Initial revision
C 
C 
C ---

C+++
C	SUBROUTINE	ICDF
C
C	PURPOSE		To interpolate the photon energy from random 
C			number and then the vertical angle at that 
C			photon energy.
C---
	SUBROUTINE	ICDF	(PE,V_ACCP,RATIO)
	IMPLICIT REAL*8 (A-H,O-Z)
	DIMENSION	WORKG(5,21),WORKP(4),WORKX(5,4)	
	DIMENSION	PSI(5,21,251),XPHOT(251)
C	DIMENSION	VIN,RATIO_TRY,PE8,RATIO8
	COMMON  /CDFINDEX/	IMAX_2,IMIN_2,IINT_2,IST
	COMMON	/ARRAY/		PSI,XPHOT	
C Define some useful data
	NP	= 1001
	EX_UPP	= 1.0D0
	EX_LOW	= -5.0D0
	EX_STEP	= (EX_UPP - EX_LOW)/(NP - 1)
C For the angle, first find the indices of 'neighboring erergy' on XPHOT
	IPE	= IMAX_2 - (EX_UPP - LOG10(PE))/EX_STEP/IST
	IF (IPE-1.LT.1) THEN
	  ISTART = 1
	  IEND   = 4
	ELSE IF (IPE+2.GT.IINT_2) THEN
	  IEND   = IINT_2
	  ISTART = IEND - 3
	ELSE
	  ISTART = IPE - 1
	  IEND   = IPE + 2
	END IF
C Interpolate the angles correspond to the four 'neighboring energy'
	DO 99 I = ISTART, IEND
	  DO 199 J = 1, 21
	    DO 199 K = 1, 5
	      WORKG(K,J) = PSI(K,J,I)
 199	  CONTINUE
	  VIN	= -ABS(V_ACCP)
	  IF (VIN.LT.WORKG(1,1)) THEN
	    RATIO_TRY	= 0.0E0
	  ELSE
	    CALL SPL_INT (WORKG,21,VIN,RATIO_TRY,IER)
	  END IF
	  WORKP(I-ISTART+1)	= 1.0E0 - 2.0E0*RATIO_TRY
	  WORKX(1,I-ISTART+1)	= XPHOT(I)
 99	CONTINUE
C Use the four energy and their corresponding angles to interpolate for 
C the angle at PE
	PE8	= PE
	CALL CUBSPL  (WORKX,WORKP,4,IER)
	CALL SPL_INT (WORKX,4,PE8,RATIO8,IER)
	RATIO	= RATIO8
C
C The next statement is necessary because the spline may do strange things.
C
	IF (RATIO.GT.1)	RATIO = 1.0E0
	RETURN
	END
