C +++
C
C Source: src/source/bm/compute.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	compute.F
C Revision 1.2  91/04/04  11:23:36  khan
C Replaced old one with newer version on VMS
C 
C Revision 1.2  91/04/04  11:14:02  khan
C Replaced old one with the newer one on VMS
C 
C Revision 1.1  90/07/18  16:16:31  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE	COMPUTE
C
C	PURPOSE		Performs actual SR computations.
C
C---
	SUBROUTINE COMPUTE

	IMPLICIT 	REAL*8 		(A-H,O-Z)

#if defined(unix) || HAVE_F77_CPP
#       include		"bm.blk"
#elif defined(vms)
	INCLUDE		'bm.blk'
#endif

	DO 100 IC=1,1001

	 PSI = - PSIMAX + (IC-1)*STEP	
 	 ARG = (1 + GAMM**2*PSI**2)
	 X = ARG**1.5*FCT
	 IQ = 1
	 ORD = 1.0/3.0D0

	CALL BSKM(X,BK,IQ,ORD)

	 ARG2 = BK**2*ARG*CONST*(ARG - 1)
	  PPER(IC,2) = ARG2
	 PPER(IC,1) = PSI*1000
	 IQ = 2
	 ORD = 2/3.0D0

	CALL BSKM(X,BK,IQ,ORD)

	 ARG3 = BK**2*CONST*ARG**2
	 PPAR(IC,2) = ARG3
	 PPAR(IC,1) = PSI*1000
	  PTOT(IC,2) = ARG2 + ARG3
	 PTOT(IC,1) = PSI*1000

100	CONTINUE
** Generates the cumulative distrib. functions by a tapezoidal integration **
 
	 SUM_PAR  	= 0.0
	 SUM_PERP 	= 0.0
	 SUM_PTOT 	= 0.0

	 ANG_ARR(1)	= - PSIMAX

	DO 200 I=2,1001
	 PSI = - PSIMAX + (I-1)*STEP
	 ANG_ARR(I) = PSI
	 SUM_PAR  = SUM_PAR  + (PPAR(I,2) + PPAR(I-1,2))/2*STEP
	 SUM_PERP = SUM_PERP + (PPER(I,2) + PPER(I-1,2))/2*STEP
	 SUM_PTOT = SUM_PTOT + (PTOT(I,2) + PTOT(I-1,2))/2*STEP
	 PPAR_INT(I) = SUM_PAR
	 PPER_INT(I) = SUM_PERP
200	 PTOT_INT(I) = SUM_PTOT
C
C Computes some useful data
C
     	CR_ENER	=   2218*BENER**3/RAD
     	R_LCRIT =   12398.4/CR_ENER
     	TOT_PWR	=   88.5*BENER**4/RAD
     	RING_GAMMA = 1957*BENER
     	SIG_EQ	=   1.54*(CR_ENER/PHOT)**0.38/RING_GAMMA
#ifdef vms
     	OPEN (22,FILE='FLUX',STATUS='NEW')
#else
     	OPEN (22,FILE='FLUX',STATUS='UNKNOWN')
	REWIND (22)
#endif
     	WRITE (22,*) '-----------------------------------------------'
     	WRITE (22,1001) BENER,RING_GAMMA,RAD
     	WRITE (22,1002)	CR_ENER,R_LCRIT
     	WRITE (22,1003) TOT_PWR
     	WRITE (22,*) 'Integrated flux at ',PHOT,' eV'
     	WRITE (22,*) 'within limiting vertical angles (rads): '
     	WRITE (22,*) -PSIMAX,PSIMAX
	WRITE (22,*) 'Units: 	Photons/sec/mrad/ma/eV'
     	WRITE (22,1000) 'parallel      : ',SUM_PAR
     	WRITE (22,1000) 'perpendicular : ',SUM_PERP
     	WRITE (22,1000) 'total         : ',SUM_PTOT
     	WRITE (22,1004) SIG_EQ
     	CLOSE (22)
1000	FORMAT (1X,A,2X,E12.5)
1001	FORMAT (1X,'Machine Energy: ',G12.5,' GeV. GAMMA: ',
     $		G12.5,'    Radius: ',G12.5,' m')
1002	FORMAT (1X,'Critical Energy= ',G12.5,
     $		' eV, Critical Wavelength= ',G12.5,' Angs.')
1003	FORMAT (1X,'Total Radiated Power= ',G12.5,' kW')
1004	FORMAT (1X,'Approximated Gaussian width: ',g12.5,' rads')
** Adjust now the c.d.f. between 0-1

	PPAR_MIN = PPAR_INT(1)
	PPER_MIN = PPER_INT(1)
	PTOT_MIN = PTOT_INT(1)

	DO 250 I=1,1001
	PPAR_INT(I) = PPAR_INT(I) - PPAR_MIN
	PPER_INT(I) = PPER_INT(I) - PPER_MIN
250	PTOT_INT(I) = PTOT_INT(I) - PTOT_MIN

	PAR_MAX  = PPAR_INT(1001)
	PERP_MAX = PPER_INT(1001)
	PTOT_MAX = PTOT_INT(1001)

	DO 300 I=1,1001
	PPAR_INT(I) = PPAR_INT(I)/PAR_MAX
	PPER_INT(I) = PPER_INT(I)/PERP_MAX
300	PTOT_INT(I) = PTOT_INT(I)/PTOT_MAX

	CALL ICSCCU (ANG_ARR,PPAR_INT,1001,SPLI_1,1000,IER1)
	CALL ICSCCU (ANG_ARR,PPER_INT,1001,SPLI_2,1000,IER2)
	CALL ICSCCU (ANG_ARR,PTOT_INT,1001,SPLI_3,1000,IER3)

	IF (IER1.NE.0.OR.IER2.NE.0.OR.IER3.NE.0) 
     $     WRITE(6,*)'Error in ICSCCU ',IER1,IER2,IER3

D     	OPEN (UNIT=20,FILE='SRPAR.CDF',STATUS='NEW')
D		WRITE (20,*) 'PARALLEL'
D		WRITE (20,*) '        '
D     	DO 600 J=1,1001
D600     	WRITE (20,*) ANG_ARR(J),PPAR_INT(J)
D	CLOSE(20)
D     	OPEN (UNIT=20,FILE='SRPERP.CDF',STATUS='NEW')
D		WRITE (20,*) 'PERPENDICULAR'
D		WRITE (20,*) '        '
D     	DO 400 J=1,1001
D400		WRITE (20,*) ANG_ARR(J),PPER_INT(J)
D	CLOSE(20)
D     	OPEN (UNIT=20,FILE='SRTOT.CDF',STATUS='NEW')
D		WRITE (20,*) 'TOTAL'
D		WRITE (20,*) '        '
D     	DO 500 J=1,1001
D500		WRITE (20,*) ANG_ARR(J),PTOT_INT(J)
D	CLOSE (20)
	RETURN
	END
