C +++
C
C progpath.F: get pathname of a SHADOW program file
C
C Source: src/lib/progpath.F
C
C Author: Mumit Khan <khan@xraylith.wisc.edu>
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C
C Copyright(c) 1996 Mumit Khan
C 
C ---

#ifndef SHADOW_BIN_DIR
# define SHADOW_BIN_DIR '/usr/local/shadow/bin'
#endif

#ifndef PATH_SEP
# ifdef unix
#  define PATH_SEP '/'
# elif _WIN32
#  ifdef __CYGWIN32__
#   define PATH_SEP '/'
#  else
#   define PATH_SEP '\\'
#  endif
# else
#  define PATH_SEP '/'
# endif
#endif

#ifndef EXEEXT
# if defined(__CYGWIN32__) || defined(__WIN32)
#  define EXEEXT '.exe'
# endif
#endif

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

	subroutine progpath (file, path, iflag)
c++
c
c progpath -- gets a full pathname for a SHADOW program file
c
c input:
c    file:   the file name to find
c    iflag:  0 don't check for existence
c	     1 do check for existence
c 
c returns: 
c    path:   the returned full path
c    iflag:  0 if ok
c            1 does not exist
c
c--
     	implicit	real*8		(a-e,g-h,o-z)
     	implicit	integer*4	(f,i-n)
	character*(*) file, path
#if defined(unix) || defined(_WIN32)
	character*256 bindir, shadow_root
	logical linited
	logical lexist
	data linited /.false./
	save linited, bindir
#endif
c
c
#ifdef vms
c
c vms is simple. Simply return with SHADOW$BIN prefix and let DCL do
c it's magic.
c
	iflag = 0
	path = 'SHADOW$BIN:' // file
c
#elif defined(unix) || defined(_WIN32)
c
c unix and such OSs with environment variable is trickier, since we want
c better control.
c
c first check SHADOW_BIN_DIR. If not found, check SHADOW_ROOT. Then
c concatenate the filename with the binary directory name.
c
	if (.not.linited) then
	  call getenv ('SHADOW_BIN_DIR', bindir)
	  if (bindir(1:1).eq.' ') then
	    call getenv('SHADOW_ROOT', shadow_root)
	    if (shadow_root(1:1).eq.' ') then
	      bindir = SHADOW_BIN_DIR 
	    else
	      bindir = shadow_root(1:iblank(shadow_root)) //
     $	        PATH_SEP // 'bin'
            endif
	  endif
	  linited = .true.
	endif
	path = bindir(1:iblank(bindir)) // PATH_SEP // file
#ifdef EXEEXT
	path = path(1:iblank(path)) // EXEEXT
#endif
c
c check for existence if the caller wants. Note that this does not check
c for protection violation, only existence.
c
	if (iflag .eq. 1) then
	    inquire (file = path, exist = lexist)
	    if (.not. lexist) then
	        iflag = 1
	    else 
	        iflag = 0
	    endif
	else
	    iflag = 0
	endif
#else /* not a known system */
c # warning UNKNOWN SYSTEM. REPORT TO SHADOW MAINTAINER.
c
c on systems we know nothing about, simply return the filename as path.
c
	iflag = 0
	path = file
#endif
c
	return
	end
