C +++
C
C Source: src/lib/piecespl.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: piecespl.F
C Revision 1.7  1992/01/23  20:30:56  cwelnak
C wiggler bug fix (B. Lai)
C
C Revision 1.6  91/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C 
C Revision 1.5  91/04/05  13:54:32  cwelnak
C changed quotes on #include
C 
C Revision 1.4  91/03/25  10:40:57  cwelnak
C SUN version -- INC to #inc
C 
C Revision 1.3  90/11/13  14:05:00  khan
C Cleanup and SAVE statements
C 
C Revision 1.2  90/07/20  22:05:16  khan
C put #if unix ... to make it work also on vms
C 
C Revision 1.1  90/07/10  14:56:38  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE	PIECESPL
C
C	PURPOSE		Check for large increases in slope of the data.  
C			If found, cubic spline interpolation is used for those
C			data BEFORE the big jump, while linear interpolation 
C			is used for those AFTER the increase, i.e. several
C			segmented splines will be used for the data set.
C			If not found, a single spline will be used for all data.
C---
	SUBROUTINE	PIECESPL (G, Y, N, IER)
	IMPLICIT	REAL*8	(A-H,O-Z)
#if defined(vms)
	INCLUDE		'SHADOW$INC:DIM.PAR/LIST'
#elif defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#endif
	REAL*8		G(5,N), Y(N)
	REAL*8		GTEMP(5,N_DIM), YTEMP(N_DIM), SLOPE(N_DIM)
	INTEGER		MPURGE(2),N,IER

C
C First calculate the slope for each pair of data point.  
C
	DO 11 I = 1, N-1
	  IF (G(1,I).EQ.G(1,I+1)) THEN
	    SLOPE(I)	= 1.0E20
	  ELSE
	    SLOPE(I)	= ABS( (Y(I+1)-Y(I)) / (G(1,I+1)-G(1,I)) )
	  END IF
11	CONTINUE

C
C Check if the slope increase 2.5 times more than adjacent one.
C
	SLOPE1	= SLOPE(1)
	DO 21 I = 2, N-1
	  SLOPE2	= SLOPE(I)
	  IF (SLOPE2.GT.2.5*SLOPE1) THEN
	    IFIRST	= 1
	    IBOTTOM	= I
	    GO TO 25
	  END IF
	  SLOPE1	= SLOPE2
21	CONTINUE
C
C Normal case. Can get by with one single spline.
C
	CALL	CUBSPL	(G, Y, N, IER)
100	CONTINUE

#if defined(vms)
	MPURGE(1)	= %LOC(GTEMP(1,1))
	MPURGE(2)	= %LOC(GTEMP(5,N_DIM))
	CALL	SYS$PURGWS	(MPURGE)
	MPURGE(1)	= %LOC(YTEMP(1))
	MPURGE(2)	= %LOC(YTEMP(N_DIM))
	CALL	SYS$PURGWS	(MPURGE)
	MPURGE(1)	= %LOC(SLOPE(1))
	MPURGE(2)	= %LOC(SLOPE(N_DIM))
	CALL	SYS$PURGWS	(MPURGE)
#endif
	RETURN
C
C Piecewise splines case.
C
C Looks for limit of the spline (IFIRST -> IBOTTOM)
C
20	SLOPE1	= SLOPE(IFIRST)
	DO 31 I = IFIRST+1, N-1		
	  SLOPE2	= SLOPE(I)
	  IF (SLOPE2.GT.2.5*SLOPE1) THEN
	    IBOTTOM = I			! Index at start of slope increase
	    GO TO 25
	  ELSE
	    SLOPE1 = SLOPE2
	  END IF
31	CONTINUE
	IBOTTOM = I

C
C Looks for limit of the linear part (IBOTTOM -> ITOP).
C
25	DO 41 I = IBOTTOM+1, N-1
	  SLOPE2	= SLOPE(I)
	  IF (SLOPE2.LT.SLOPE1) THEN
	    ITOP = I			! Index at finish of slope increase
	    GO TO 30
	  END IF
41	CONTINUE
	ITOP	= N

30	NTEMP	= IBOTTOM - IFIRST + 1
C
C The spline needs at least 4 points.  If less, might as well use linear.
C
	IF (NTEMP.LT.4) THEN
	  IBOTTOM	= IFIRST
	  GO TO 40
	END IF
C
C If at least 4 points, use the spline.
C
	DO 51 I = IFIRST, IBOTTOM
	  GTEMP(1,I-IFIRST+1)	= G(1,I)
	  YTEMP(I-IFIRST+1)	= Y(I)
51	CONTINUE
C
C Build the spline and store it in G.
C
	CALL	CUBSPL	(GTEMP, YTEMP, NTEMP, IER)
	DO 61 I = IFIRST, IBOTTOM-1
	  G(2,I)	= GTEMP(2,I-IFIRST+1)
	  G(3,I)	= GTEMP(3,I-IFIRST+1)
	  G(4,I)	= GTEMP(4,I-IFIRST+1)
	  G(5,I)	= GTEMP(5,I-IFIRST+1)
61	CONTINUE
C
C Build the linear part
C
40	DO 71 I = IBOTTOM, ITOP-1
	  G(2,I)	= Y(I)
	  G(3,I)	= SLOPE(I)
	  G(4,I)	= 0.0D0
	  G(5,I)	= 0.0D0
71	CONTINUE
C
C Move to the next segment of the data
C
	IFIRST	= ITOP
	IF (IBOTTOM.GE.N.OR.ITOP.GE.N) THEN
	  GO TO 100			! Finish
	ELSE
	  GO TO 20			! Continue search
	END IF

	END


