#! /bin/sh -f
#
# makedist.sh --
#
#
#       This program creates the Tix source distribution off the Tix
#       CVS tree. See ../docs/MakeSrcDist.txt for information and
#       instructions.
#
# Copyright (c) 2000-2001 Tix Project Group.
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
# $Id: makedist.sh,v 1.1.1.1 2002/04/02 03:50:26 khan Exp $

if test "$2" == ""; then
    echo "usage: $0 dir_name dist_name"
    echo "e.g."
    echo "       $0 tix8.2.0 tix8.2.0EA"
    echo "       will create tix8.2.0EA.zip and tix8.2.0EA.tar.gz"
    exit
fi

if test ! -f "$1/unix/configure"; then
    echo "$1/unix/configure does not exist. Are you sure?"
    exit
fi

if test -f "$1/unix/config.status"; then
    echo "$1/unix/config.status exists. Are you sure?"
    echo "you should build from a pristine repository."
    exit
fi

if test -f "$1/win/Release"; then
    echo "$1/win/Release. Are you sure?"
    echo "you should build from a pristine repository."
    exit
fi

if test -f "$1/win/Debug"; then
    echo "$1/win/Debug. Are you sure?"
    echo "you should build from a pristine repository."
    exit
fi

rm -f $2.tar
rm -f $2.tar.gz
rm -f $2.zip

chmod a+x $1/unix/configure
FILES=`find $1 -type f | grep -v CVS | grep -v cvs`

echo creating $2.tar.gz
tar cvf $2.tar $FILES > tar.log
gzip $2.tar

echo creating $2.zip
zip $2.zip $FILES > zip.log

ls -l $2.zip
ls -l $2.tar.gz

cat << END

Release check list:
----------------------------------------------------------------------
Announce to
    comp.lang.tcl
    comp.lang.tcl.announce

    tcl_announce@egroups.com
    tix_announce@egroups.com
    tix_developers@egroups.com
    tix@egroups.com

Change web page:

    http://tix.sourceforge.net/download.html
    http://tix.sourceforge.net/early_access/8.2/index.shtml

----------------------------------------------------------------------
END

exit
