'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\" Copyright (c) 2000 Scriptics Corporation.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: scan.n,v 1.1.1.1 2002/04/02 03:49:23 khan Exp $
'\" 
.so man.macros
.TH scan n 8.3 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
scan \- Parse string using conversion specifiers in the style of sscanf
.SH SYNOPSIS
\fBscan \fIstring format \fR?\fIvarName varName ...\fR?
.BE

.SH INTRODUCTION
.PP
This command parses fields from an input string in the same fashion as the
ANSI C \fBsscanf\fR procedure and returns a count of the number of
conversions performed, or -1 if the end of the input string is reached
before any conversions have been performed.  \fIString\fR gives the input
to be parsed and \fIformat\fR indicates how to parse it, using \fB%\fR
conversion specifiers as in \fBsscanf\fR.  Each \fIvarName\fR gives the
name of a variable; when a field is scanned from \fIstring\fR the result is
converted back into a string and assigned to the corresponding variable.
.VS 8.3
If no \fIvarName\fR variables are specified, then \fBscan\fR works in an
inline manner, returning the data that would otherwise be stored in the
variables as a list.  In the inline case, an empty string is returned when
the end of the input string is reached before any conversions have been
performed.
.VE 8.3

.SH "DETAILS ON SCANNING"
.PP
\fBScan\fR operates by scanning \fIstring\fR and \fIformat\fR together.
If the next character in \fIformat\fR is a blank or tab then it
matches any number of white space characters in \fIstring\fR (including
zero).
Otherwise, if it isn't a \fB%\fR character then it 
must match the next character of \fIstring\fR.
When a \fB%\fR is encountered in \fIformat\fR, it indicates
the start of a conversion specifier.
A conversion specifier contains up to four fields after the \fB%\fR:
a \fB*\fR, which indicates that the converted value is to be discarded 
instead of assigned to a variable; a XPG3 position specifier; a number
indicating a maximum field width; and a conversion character.
All of these fields are optional except for the conversion character.
The fields that are present must appear in the order given above.
.PP
When \fBscan\fR finds a conversion specifier in \fIformat\fR, it
first skips any white-space characters in \fIstring\fR (unless the
specifier is \fB[\fR or \fBc\fR).
Then it converts the next input characters according to the 
conversion specifier and stores the result in the variable given
by the next argument to \fBscan\fR.
.PP
If the \fB%\fR is followed by a decimal number and a \fB$\fR, as in
``\fB%2$d\fR'', then the variable to use is not taken from the next
sequential argument.  Instead, it is taken from the argument indicated
by the number, where 1 corresponds to the first \fIvarName\fR.  If
there are any positional specifiers in \fIformat\fR then all of the
specifiers must be positional.  Every \fIvarName\fR on the argument
list must correspond to exactly one conversion specifier or an error
is generated, or in the inline case, any position can be specified
at most once and the empty positions will be filled in with empty strings.
.PP
The following conversion characters are supported:
.TP 10
\fBd\fR
The input field must be a decimal integer.
It is read in and the value is stored in the variable as a decimal string.
.TP 10
\fBo\fR
The input field must be an octal integer. It is read in and the 
value is stored in the variable as a decimal string.
.VS 8.4
If the value exceeds MAX_INT (017777777777 on platforms using 32-bit
integers), it will be truncated to a signed integer.  Hence, 037777777777
will appear as -1 on a 32-bit machine.
.VE 8.4
.TP 10
\fBx\fR
The input field must be a hexadecimal integer. It is read in 
and the value is stored in the variable as a decimal string.
.VS 8.4
If the value exceeds MAX_INT (0x7FFFFFFF on platforms using 32-bit
integers), it will be truncated to a signed integer.  Hence, 0xFFFFFFFF
will appear as -1 on a 32-bit machine.
.VE 8.4
.TP 10
\fBu\fR
The input field must be a decimal integer.  The value is stored in the
variable as an unsigned decimal integer string.
.TP 10
\fBi\fR 
The input field must be an integer.  The base (i.e. decimal, octal, or
hexadecimal) is determined in the same fashion as described in
\fBexpr\fR.  The value is stored in the variable as a decimal string.
.TP 10
\fBc\fR
A single character is read in and its binary value is stored in 
the variable as a decimal string.
Initial white space is not skipped in this case, so the input
field may be a white-space character.
This conversion is different from the ANSI standard in that the
input field always consists of a single character and no field
width may be specified.
.TP 10
\fBs\fR
The input field consists of all the characters up to the next 
white-space character; the characters are copied to the variable.
.TP 10
\fBe\fR or \fBf\fR or \fBg\fR
The input field must be a floating-point number consisting 
of an optional sign, a string of decimal digits possibly
containing a decimal point, and an optional exponent consisting 
of an \fBe\fR or \fBE\fR followed by an optional sign and a string of 
decimal digits.
It is read in and stored in the variable as a floating-point string.
.TP 10
\fB[\fIchars\fB]\fR
The input field consists of any number of characters in 
\fIchars\fR.
The matching string is stored in the variable.
If the first character between the brackets is a \fB]\fR then
it is treated as part of \fIchars\fR rather than the closing
bracket for the set.
If \fIchars\fR
contains a sequence of the form \fIa\fB\-\fIb\fR then any
character between \fIa\fR and \fIb\fR (inclusive) will match.
If the first or last character between the brackets is a \fB\-\fR, then
it is treated as part of \fIchars\fR rather than indicating a range.
.TP 10
\fB[^\fIchars\fB]\fR
The input field consists of any number of characters not in 
\fIchars\fR.
The matching string is stored in the variable.
If the character immediately following the \fB^\fR is a \fB]\fR then it is 
treated as part of the set rather than the closing bracket for 
the set.
If \fIchars\fR
contains a sequence of the form \fIa\fB\-\fIb\fR then any
character between \fIa\fR and \fIb\fR (inclusive) will be excluded
from the set.
If the first or last character between the brackets is a \fB\-\fR, then
it is treated as part of \fIchars\fR rather than indicating a range.
.TP 10
\fBn\fR
No input is consumed from the input string.  Instead, the total number
of chacters scanned from the input string so far is stored in the variable.
.LP
The number of characters read from the input for a conversion is the
largest number that makes sense for that particular conversion (e.g.
as many decimal digits as possible for \fB%d\fR, as 
many octal digits as possible for \fB%o\fR, and so on).
The input field for a given conversion terminates either when a
white-space character is encountered or when the maximum field 
width has been reached, whichever comes first.
If a \fB*\fR is present in the conversion specifier 
then no variable is assigned and the next scan argument is not consumed.

.SH "DIFFERENCES FROM ANSI SSCANF"
.PP
The behavior of the \fBscan\fR command is the same as the behavior of
the ANSI C \fBsscanf\fR procedure except for the following differences:
.IP [1]
\fB%p\fR conversion specifier is not currently supported.
.IP [2]
For \fB%c\fR conversions a single character value is
converted to a decimal string, which is then assigned to the
corresponding \fIvarName\fR;
no field width may be specified for this conversion.
.IP [3]
The \fBl\fR, \fBh\fR, and \fBL\fR modifiers are ignored;  integer
values are always converted as if there were no modifier present
and real values are always converted as if the \fBl\fR modifier
were present (i.e. type \fBdouble\fR is used for the internal
representation).
.IP [4]
.VS 8.3
If the end of the input string is reached before any conversions have been
performed and no variables are given, and empty string is returned.
.VE 8.3

.SH "SEE ALSO"
format(n), sscanf(3)

.SH KEYWORDS
conversion specifier, parse, scan
